/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jsafe;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.jsafe.JSafePrivateKey;
import sun.security.jsafe.JSafePublicKey;
import sun.security.x509.AlgorithmId;

abstract class JSafeSig
extends SignatureSpi {
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;
    protected JSafePrivateKey privateKey;
    private JSafePublicKey publicKey;
    protected AlgorithmId keyAlg;
    protected int keybits = 512;
    protected byte[] seed;
    protected AlgorithmId sigAlg;
    protected int siglimit;
    private long algObj = 0L;
    private long randomizer = 0L;

    static {
        JSafeSig.initIDs();
    }

    protected JSafeSig() {
    }

    abstract boolean checkKeyAlg(AlgorithmId var1);

    private native byte[] doSign(int var1) throws SignatureException;

    private native boolean doVerify(byte[] var1) throws SignatureException;

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("getParameter not supported");
    }

    protected final void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.publicKey = null;
        if (!(privateKey instanceof JSafePrivateKey)) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(privateKey.getAlgorithm(), "SunPlugin");
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
                this.privateKey = (JSafePrivateKey)keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (Exception exception) {
                throw new InvalidKeyException(exception.getMessage());
            }
        } else {
            this.privateKey = (JSafePrivateKey)privateKey;
        }
        this.keyAlg = this.privateKey.getAlgorithmId();
        if (!this.checkKeyAlg(this.keyAlg)) {
            throw new InvalidKeyException("Signature algorithm doesn't support this key type:  " + this.keyAlg);
        }
        this.privateKey.init();
        this.initAlg();
        this.initSign();
        this.state = 2;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof JSafePublicKey)) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(publicKey.getAlgorithm(), "SunPlugin");
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
                this.publicKey = (JSafePublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
            }
            catch (Exception exception) {
                throw new InvalidKeyException(exception.getMessage());
            }
        } else {
            this.publicKey = (JSafePublicKey)publicKey;
        }
        this.keyAlg = this.publicKey.getAlgorithmId();
        if (!this.checkKeyAlg(this.keyAlg)) {
            throw new InvalidKeyException("Signature algorithm doesn't support this key type:  " + this.keyAlg);
        }
        this.publicKey.init();
        this.privateKey = null;
        this.initAlg();
        this.initVerify();
        this.state = 3;
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("setParameter not supported");
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException("illegal Signature state");
        }
        return this.doSign(this.siglimit);
    }

    protected String engineToString() {
        return "[JSAFE " + this.sigAlg.getName() + " Signature engine]";
    }

    protected void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state == 2) {
            this.updateSign(byArray, n, n2);
        } else if (this.state == 3) {
            this.updateVerify(byArray, n, n2);
        } else {
            throw new SignatureException("illegal Signature state, " + this.state);
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException("illegal Signature state");
        }
        return this.doVerify(byArray);
    }

    protected native void finalize();

    private native void initAlg();

    private static native void initIDs();

    abstract void initSign();

    abstract void initVerify();

    private native void updateSign(byte[] var1, int var2, int var3) throws SignatureException;

    private native void updateVerify(byte[] var1, int var2, int var3) throws SignatureException;
}

