/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jsafe;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import sun.security.jsafe.JSafePublicKey;
import sun.security.jsafe.RSAKey;
import sun.security.util.BigInt;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class RSAPublicKey
extends JSafePublicKey
implements RSAKey,
java.security.interfaces.RSAPublicKey {
    private static final AlgorithmId AlgIdRSA = new AlgorithmId(AlgorithmId.RSAEncryption_oid);
    private BigInteger modulus;
    private BigInteger exponent;

    public RSAPublicKey() {
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws InvalidKeyException {
        this.modulus = bigInteger;
        this.exponent = bigInteger2;
        this.algid = new AlgorithmId(AlgorithmId.RSAEncryption_oid);
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(new BigInt(bigInteger.toByteArray()));
            derOutputStream.putInteger(new BigInt(bigInteger2.toByteArray()));
            DerOutputStream derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream);
            this.key = derOutputStream2.toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("could not DER encode y: " + iOException.getMessage());
        }
        this.init();
    }

    RSAPublicKey(AlgorithmId algorithmId, byte[] byArray) throws IOException, InvalidKeyException {
        this.algid = algorithmId;
        this.key = byArray;
        this.encode();
        this.parseKeyBits();
    }

    public RSAPublicKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
        this.init();
    }

    public byte[] getExponent() {
        return this.exponent.toByteArray();
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public int getModulusLen() {
        return this.modulus.toByteArray().length * 8;
    }

    public BigInteger getPublicExponent() {
        return this.exponent;
    }

    public byte[] getXXXModulus() {
        return this.modulus.toByteArray();
    }

    synchronized void init() {
        if (!this.initted) {
            this.native_init(this.modulus.toByteArray(), this.exponent.toByteArray());
            this.initted = true;
        }
    }

    public boolean isSigningOnly() {
        return false;
    }

    private native void native_init(byte[] var1, byte[] var2);

    protected void parseKeyBits() throws IOException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2) {
            throw new IOException("RSA public key parse error");
        }
        this.modulus = derValueArray[0].getInteger().toBigInteger();
        this.exponent = derValueArray[1].getInteger().toBigInteger();
        this.init();
    }

    public String toString() {
        return "algorithm = " + this.algid.toString() + ", exponent = 0x" + new BigInt(this.exponent).toString() + ", modulus = \n" + new BigInt(this.modulus).toString() + "\n";
    }
}

