/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPInputStream;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.IMAPMultipartDataSource;
import com.sun.mail.imap.IMAPNestedMessage;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.Utility;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.BODYSTRUCTURE;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.INTERNALDATE;
import com.sun.mail.imap.protocol.Item;
import com.sun.mail.imap.protocol.MessageSet;
import com.sun.mail.imap.protocol.RFC822DATA;
import com.sun.mail.imap.protocol.RFC822SIZE;
import com.sun.mail.imap.protocol.UID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.FolderClosedException;
import javax.mail.IllegalWriteException;
import javax.mail.Message;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.UIDFolder;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class IMAPMessage
extends MimeMessage {
    protected BODYSTRUCTURE bs;
    protected ENVELOPE envelope;
    private Date receivedDate;
    private int size = -1;
    private int seqnum;
    private long uid = -1L;
    protected String sectionId;
    private String type;
    private String subject;
    private String description;
    private boolean headersLoaded = false;
    private Hashtable loadedHeaders;
    private static String EnvelopeCmd = "ENVELOPE INTERNALDATE RFC822.SIZE";

    protected IMAPMessage(IMAPFolder iMAPFolder, int n, int n2) {
        super(iMAPFolder, n);
        this.seqnum = n2;
        this.flags = null;
    }

    protected IMAPMessage(Session session) {
        super(session);
    }

    protected IMAPProtocol getProtocol() throws FolderClosedException {
        IMAPProtocol iMAPProtocol = ((IMAPFolder)this.folder).protocol;
        if (iMAPProtocol == null) {
            throw new FolderClosedException(this.folder);
        }
        return iMAPProtocol;
    }

    protected Object getMessageCacheLock() {
        return ((IMAPFolder)this.folder).messageCacheLock;
    }

    protected int getSequenceNumber() {
        return this.seqnum;
    }

    protected void setSequenceNumber(int n) {
        this.seqnum = n;
    }

    protected void setMessageNumber(int n) {
        super.setMessageNumber(n);
    }

    protected long getUID() {
        return this.uid;
    }

    protected void setUID(long l) {
        this.uid = l;
    }

    protected void setExpunged(boolean bl) {
        super.setExpunged(bl);
        this.seqnum = -1;
    }

    protected void checkExpunged() throws MessageRemovedException {
        if (this.expunged) {
            throw new MessageRemovedException();
        }
    }

    protected int getFetchBlockSize() {
        return ((IMAPStore)this.folder.getStore()).getFetchBlockSize();
    }

    public Address[] getFrom() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.from;
    }

    public void setFrom(Address address) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addFrom(Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Address[] getRecipients(Message.RecipientType recipientType) throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        if (recipientType == Message.RecipientType.TO) {
            return this.envelope.to;
        }
        if (recipientType == Message.RecipientType.CC) {
            return this.envelope.cc;
        }
        if (recipientType == Message.RecipientType.BCC) {
            return this.envelope.bcc;
        }
        return super.getRecipients(recipientType);
    }

    public void setRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Address[] getReplyTo() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.replyTo;
    }

    public void setReplyTo(Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getSubject() throws MessagingException {
        this.checkExpunged();
        if (this.subject != null) {
            return this.subject;
        }
        this.loadEnvelope();
        if (this.envelope.subject == null) {
            return null;
        }
        try {
            this.subject = MimeUtility.decodeText(this.envelope.subject);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.subject = this.envelope.subject;
        }
        return this.subject;
    }

    public void setSubject(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Date getSentDate() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.date;
    }

    public void setSentDate(Date date) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Date getReceivedDate() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.receivedDate;
    }

    public int getSize() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.size;
    }

    public int getLineCount() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.lines;
    }

    public String getContentType() throws MessagingException {
        this.checkExpunged();
        if (this.type == null) {
            this.loadBODYSTRUCTURE();
            ContentType contentType = new ContentType(this.bs.type, this.bs.subtype, this.bs.cParams);
            this.type = contentType.toString();
        }
        return this.type;
    }

    public String getDisposition() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.disposition;
    }

    public void setDisposition(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getEncoding() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.encoding;
    }

    public String getContentID() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.id;
    }

    public void setContentID(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getContentMD5() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.md5;
    }

    public void setContentMD5(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getDescription() throws MessagingException {
        this.checkExpunged();
        if (this.description != null) {
            return this.description;
        }
        this.loadBODYSTRUCTURE();
        if (this.bs.description == null) {
            return null;
        }
        try {
            this.description = MimeUtility.decodeText(this.bs.description);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.description = this.bs.description;
        }
        return this.description;
    }

    public void setDescription(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getMessageID() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.messageId;
    }

    public String getFileName() throws MessagingException {
        this.checkExpunged();
        String string = null;
        this.loadBODYSTRUCTURE();
        if (this.bs.dParams != null) {
            string = this.bs.dParams.get("filename");
        }
        if (string == null && this.bs.cParams != null) {
            string = this.bs.cParams.get("name");
        }
        return string;
    }

    public void setFileName(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    protected InputStream getContentStream() throws MessagingException {
        IMAPProtocol iMAPProtocol = this.getProtocol();
        if (iMAPProtocol.isREV1() && this.getFetchBlockSize() != -1) {
            return new IMAPInputStream(this, this.toSection("TEXT"), this.bs != null ? this.bs.size : -1);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), "TEXT");
                if (rFC822DATA != null) {
                    byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("No content");
        }
        return byteArrayInputStream;
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        this.checkExpunged();
        if (this.dh == null) {
            this.loadBODYSTRUCTURE();
            if (this.type == null) {
                ContentType contentType = new ContentType(this.bs.type, this.bs.subtype, this.bs.cParams);
                this.type = contentType.toString();
            }
            if (this.bs.isMulti()) {
                this.dh = new DataHandler((DataSource)new IMAPMultipartDataSource(this, this.bs.bodies, this.sectionId, this));
            } else if (this.bs.isNested() && this.getProtocol().isREV1()) {
                this.dh = new DataHandler((Object)new IMAPNestedMessage(this, this.bs.bodies[0], this.bs.envelope, this.sectionId == null ? "1" : String.valueOf(this.sectionId) + ".1"), this.type);
            }
        }
        return super.getDataHandler();
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        int n;
        IMAPProtocol iMAPProtocol = this.getProtocol();
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                Item item;
                if (iMAPProtocol.isREV1()) {
                    item = iMAPProtocol.fetchBody(this.getSequenceNumber(), this.sectionId);
                    if (item != null) {
                        byteArrayInputStream = ((BODY)item).getByteArrayInputStream();
                    }
                } else {
                    item = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), null);
                    if (item != null) {
                        byteArrayInputStream = ((RFC822DATA)item).getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("No content");
        }
        object = new byte[1024];
        while ((n = byteArrayInputStream.read((byte[])object)) != -1) {
            outputStream.write((byte[])object, 0, n);
        }
    }

    public String[] getHeader(String string) throws MessagingException {
        this.checkExpunged();
        if (this.isHeaderLoaded(string)) {
            return this.headers.getHeader(string);
        }
        IMAPProtocol iMAPProtocol = this.getProtocol();
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                if (iMAPProtocol.isREV1()) {
                    BODY bODY = iMAPProtocol.peekBody(this.getSequenceNumber(), this.toSection("HEADER.FIELDS (" + string + ")"));
                    if (bODY != null) {
                        byteArrayInputStream = bODY.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), "HEADER.LINES (" + string + ")");
                    if (rFC822DATA != null) {
                        byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        this.headers.load(byteArrayInputStream);
        this.setHeaderLoaded(string);
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        this.checkExpunged();
        if (this.getHeader(string) == null) {
            return null;
        }
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void removeHeader(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Enumeration getAllHeaders() throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getNonMatchingHeaderLines(stringArray);
    }

    public synchronized Flags getFlags() throws MessagingException {
        this.checkExpunged();
        this.loadFlags();
        return super.getFlags();
    }

    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        this.checkExpunged();
        this.loadFlags();
        return super.isSet(flag);
    }

    public synchronized void setFlags(Flags flags, boolean bl) throws MessagingException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                this.getProtocol().storeFlags(this.getSequenceNumber(), flags, bl);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void fetch(IMAPFolder iMAPFolder, Message[] messageArray, FetchProfile fetchProfile) throws MessagingException {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if (fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            stringBuffer.append(EnvelopeCmd);
            bl = false;
        }
        if (fetchProfile.contains(FetchProfile.Item.FLAGS)) {
            stringBuffer.append(bl ? "FLAGS" : " FLAGS");
            bl = false;
        }
        if (fetchProfile.contains(FetchProfile.Item.CONTENT_INFO)) {
            stringBuffer.append(bl ? "BODYSTRUCTURE" : " BODYSTRUCTURE");
            bl = false;
        }
        if (fetchProfile.contains(UIDFolder.FetchProfileItem.UID)) {
            stringBuffer.append(bl ? "UID" : " UID");
            bl = false;
        }
        if ((stringArray = fetchProfile.getHeaderNames()).length > 0) {
            if (!bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(IMAPMessage.craftHeaderCmd(iMAPFolder.protocol, stringArray));
        }
        1.FetchProfileCondition fetchProfileCondition = new 1.FetchProfileCondition(fetchProfile);
        Object object = iMAPFolder.messageCacheLock;
        synchronized (object) {
            MessageSet[] messageSetArray = Utility.toMessageSet(messageArray, fetchProfileCondition);
            if (messageSetArray == null) {
                return;
            }
            Response[] responseArray = null;
            Vector<Response> vector = new Vector<Response>();
            try {
                responseArray = iMAPFolder.protocol.fetch(messageSetArray, stringBuffer.toString());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(iMAPFolder, connectionException.getMessage());
            }
            catch (CommandFailedException commandFailedException) {
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            if (responseArray == null) {
                return;
            }
            int n = 0;
            while (true) {
                Object object2;
                if (n >= responseArray.length) {
                    int n2 = vector.size();
                    if (n2 == 0) return;
                    object2 = new Response[n2];
                    vector.copyInto((Object[])object2);
                    iMAPFolder.handleResponses((Response[])object2);
                    return;
                }
                if (responseArray[n] != null) {
                    if (!(responseArray[n] instanceof FetchResponse)) {
                        vector.addElement(responseArray[n]);
                    } else {
                        FetchResponse fetchResponse = (FetchResponse)responseArray[n];
                        object2 = iMAPFolder.getMessageBySeqNumber(fetchResponse.getNumber());
                        int n3 = fetchResponse.getItemCount();
                        boolean bl2 = false;
                        int n4 = 0;
                        while (true) {
                            Object object3;
                            if (n4 >= n3) {
                                if (!bl2) break;
                                vector.addElement(fetchResponse);
                                break;
                            }
                            Item item = fetchResponse.getItem(n4);
                            if (item instanceof Flags) {
                                if (!fetchProfile.contains(FetchProfile.Item.FLAGS) || object2 == null) {
                                    bl2 = true;
                                } else {
                                    ((MimeMessage)object2).flags = (Flags)((Object)item);
                                }
                            } else if (item instanceof ENVELOPE) {
                                ((IMAPMessage)object2).envelope = (ENVELOPE)item;
                            } else if (item instanceof INTERNALDATE) {
                                ((IMAPMessage)object2).receivedDate = ((INTERNALDATE)item).getDate();
                            } else if (item instanceof RFC822SIZE) {
                                ((IMAPMessage)object2).size = ((RFC822SIZE)item).size;
                            } else if (item instanceof BODYSTRUCTURE) {
                                ((IMAPMessage)object2).bs = (BODYSTRUCTURE)item;
                            } else if (item instanceof UID) {
                                object3 = (UID)item;
                                ((IMAPMessage)object2).uid = ((UID)object3).uid;
                                if (iMAPFolder.uidTable == null) {
                                    iMAPFolder.uidTable = new Hashtable();
                                }
                                iMAPFolder.uidTable.put(new Long(((UID)object3).uid), object2);
                            } else if (item instanceof RFC822DATA || item instanceof BODY) {
                                object3 = item instanceof RFC822DATA ? ((RFC822DATA)item).getByteArrayInputStream() : ((BODY)item).getByteArrayInputStream();
                                if (((MimeMessage)object2).headers == null) {
                                    ((MimeMessage)object2).headers = new InternetHeaders();
                                }
                                ((MimeMessage)object2).headers.load((InputStream)object3);
                                int n5 = 0;
                                while (n5 < stringArray.length) {
                                    super.setHeaderLoaded(stringArray[n5]);
                                    ++n5;
                                }
                            }
                            ++n4;
                        }
                    }
                }
                ++n;
            }
        }
    }

    private synchronized void loadEnvelope() throws MessagingException {
        if (this.envelope != null) {
            return;
        }
        IMAPProtocol iMAPProtocol = this.getProtocol();
        Response[] responseArray = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            int n = this.getSequenceNumber();
            try {
                responseArray = iMAPProtocol.fetch(n, EnvelopeCmd);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            if (responseArray == null) {
                Object var4_8 = null;
                return;
            }
            int n2 = 0;
            while (n2 < responseArray.length) {
                if (responseArray[n2] != null && responseArray[n2] instanceof FetchResponse && ((FetchResponse)responseArray[n2]).getNumber() == n) {
                    FetchResponse fetchResponse = (FetchResponse)responseArray[n2];
                    int n3 = fetchResponse.getItemCount();
                    int n4 = 0;
                    while (n4 < n3) {
                        Item item = fetchResponse.getItem(n4);
                        if (item instanceof ENVELOPE) {
                            this.envelope = (ENVELOPE)item;
                        } else if (item instanceof INTERNALDATE) {
                            this.receivedDate = ((INTERNALDATE)item).getDate();
                        } else if (item instanceof RFC822SIZE) {
                            this.size = ((RFC822SIZE)item).size;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            ((IMAPFolder)this.folder).handleResponses(responseArray);
            return;
        }
    }

    private static String craftHeaderCmd(IMAPProtocol iMAPProtocol, String[] stringArray) {
        StringBuffer stringBuffer = iMAPProtocol.isREV1() ? new StringBuffer("BODY.PEEK[HEADER.FIELDS (") : new StringBuffer("RFC822.HEADER.LINES (");
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        if (iMAPProtocol.isREV1()) {
            stringBuffer.append(")]");
        } else {
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private synchronized void loadBODYSTRUCTURE() throws MessagingException {
        if (this.bs != null) {
            return;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                this.bs = this.getProtocol().fetchBodyStructure(this.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            return;
        }
    }

    private synchronized void loadHeaders() throws MessagingException {
        if (this.headersLoaded) {
            return;
        }
        IMAPProtocol iMAPProtocol = this.getProtocol();
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                if (iMAPProtocol.isREV1()) {
                    BODY bODY = iMAPProtocol.peekBody(this.getSequenceNumber(), this.toSection("HEADER"));
                    if (bODY != null) {
                        byteArrayInputStream = bODY.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), "HEADER");
                    if (rFC822DATA != null) {
                        byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("Cannot load header");
        }
        this.headers = new InternetHeaders(byteArrayInputStream);
        this.headersLoaded = true;
    }

    private synchronized void loadFlags() throws MessagingException {
        if (this.flags != null) {
            return;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            this.checkExpunged();
            try {
                this.flags = this.getProtocol().fetchFlags(this.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), protocolException);
            }
            return;
        }
    }

    private boolean isHeaderLoaded(String string) {
        if (this.headersLoaded) {
            return true;
        }
        if (this.loadedHeaders != null) {
            return this.loadedHeaders.containsKey(string.toUpperCase());
        }
        return false;
    }

    private void setHeaderLoaded(String string) {
        if (this.loadedHeaders == null) {
            this.loadedHeaders = new Hashtable(1);
        }
        this.loadedHeaders.put(string.toUpperCase(), string);
    }

    private String toSection(String string) {
        if (this.sectionId == null) {
            return string;
        }
        return String.valueOf(this.sectionId) + "." + string;
    }

    void _setFlags(Flags flags) {
        this.flags = flags;
    }

    Flags _getFlags() {
        return this.flags;
    }

    ENVELOPE _getEnvelope() {
        return this.envelope;
    }

    BODYSTRUCTURE _getBodyStructure() {
        return this.bs;
    }

    Session _getSession() {
        return this.session;
    }

    static /* synthetic */ boolean access$0(IMAPMessage iMAPMessage, String string) {
        return iMAPMessage.isHeaderLoaded(string);
    }
}

