/*
 * Decompiled with CFR 0.152.
 */
package com.sun.CORBA.idl;

import com.sun.CORBA.idl.AnyInputStream;
import com.sun.CORBA.idl.AnyOutputStream;
import com.sun.CORBA.idl.TCUtility;
import com.sun.CORBA.idl.TypeCodeImpl;
import com.sun.CORBA.iiop.CDRInputStream;
import com.sun.CORBA.iiop.CDROutputStream;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;

public final class AnyImpl
extends Any {
    private TypeCodeImpl typeCode;
    private ORB orb;
    private CDRInputStream stream;
    private long value;
    private java.lang.Object object;
    private static final int DEFAULT_BUFFER_SIZE = 32;
    static boolean[] isStreamed;

    static {
        boolean[] blArray = new boolean[29];
        blArray[11] = true;
        blArray[13] = true;
        blArray[15] = true;
        blArray[16] = true;
        blArray[17] = true;
        blArray[19] = true;
        blArray[20] = true;
        blArray[21] = true;
        blArray[22] = true;
        isStreamed = blArray;
    }

    public AnyImpl(ORB oRB) {
        this.orb = oRB;
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_null);
    }

    AnyImpl(ORB oRB, Any any) {
        this(oRB);
        if (any instanceof AnyImpl) {
            AnyImpl anyImpl = (AnyImpl)any;
            this.typeCode = anyImpl.typeCode;
            this.value = anyImpl.value;
            this.object = anyImpl.object;
            if (anyImpl.stream != null) {
                this.stream = anyImpl.stream.dup();
            }
        } else {
            this.read_value(any.create_input_stream(), any.type());
        }
    }

    public InputStream create_input_stream() {
        if (this.stream != null) {
            return this.stream.dup();
        }
        CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
        TCUtility.marshalIn(cDROutputStream, this.typeCode.kind().value(), this.value, this.object);
        return cDROutputStream.create_input_stream();
    }

    public OutputStream create_output_stream() {
        return new AnyOutputStream(this.orb, 32);
    }

    public boolean equal(Any any) {
        if (!this.typeCode.equal(any.type())) {
            return false;
        }
        switch (this.typeCode.kind().value()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == any.extract_short();
            }
            case 3: {
                return this.extract_long() == any.extract_long();
            }
            case 4: {
                return this.extract_ushort() == any.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == any.extract_ulong();
            }
            case 6: {
                return this.extract_float() == any.extract_float();
            }
            case 7: {
                return this.extract_double() == any.extract_double();
            }
            case 8: {
                return this.extract_boolean() == any.extract_boolean();
            }
            case 9: {
                return this.extract_char() == any.extract_char();
            }
            case 10: {
                return this.extract_octet() == any.extract_octet();
            }
            case 11: {
                return this.extract_any().equal(any.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(any.extract_TypeCode());
            }
            case 18: {
                return this.extract_string().equals(any.extract_string());
            }
            case 23: {
                return this.extract_longlong() == any.extract_longlong();
            }
            case 24: {
                return this.extract_ulonglong() == any.extract_ulonglong();
            }
            case 17: {
                return this.create_input_stream().read_long() == any.create_input_stream().read_long();
            }
            case 25: 
            case 26: 
            case 27: {
                throw new NO_IMPLEMENT();
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                throw new NO_IMPLEMENT();
            }
        }
        return false;
    }

    public Object extract_Object() {
        Object object = null;
        try {
            object = (Object)this.object;
            if (this.typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") || object._is_a(this.typeCode.id())) {
                return object;
            }
            throw new BAD_OPERATION();
        }
        catch (Exception exception) {
            throw new BAD_OPERATION();
        }
    }

    public Principal extract_Principal() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal))) {
            throw new BAD_OPERATION();
        }
        return this.stream.dup().read_Principal();
    }

    public TypeCode extract_TypeCode() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode))) {
            throw new BAD_OPERATION();
        }
        return (TypeCode)this.object;
    }

    public Any extract_any() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_any))) {
            throw new BAD_OPERATION();
        }
        return this.stream.dup().read_any();
    }

    public boolean extract_boolean() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean))) {
            throw new BAD_OPERATION();
        }
        return this.value != 0L;
    }

    public char extract_char() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_char))) {
            throw new BAD_OPERATION();
        }
        return (char)this.value;
    }

    public double extract_double() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_double))) {
            throw new BAD_OPERATION();
        }
        return Double.longBitsToDouble(this.value);
    }

    public float extract_float() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_float))) {
            throw new BAD_OPERATION();
        }
        return Float.intBitsToFloat((int)this.value);
    }

    public int extract_long() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_long))) {
            throw new BAD_OPERATION();
        }
        return (int)this.value;
    }

    public long extract_longlong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong))) {
            throw new BAD_OPERATION();
        }
        return this.value;
    }

    public byte extract_octet() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_octet))) {
            throw new BAD_OPERATION();
        }
        return (byte)this.value;
    }

    public short extract_short() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_short))) {
            throw new BAD_OPERATION();
        }
        return (short)this.value;
    }

    public String extract_string() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_string))) {
            throw new BAD_OPERATION();
        }
        return (String)this.object;
    }

    public int extract_ulong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong))) {
            throw new BAD_OPERATION();
        }
        return (int)this.value;
    }

    public long extract_ulonglong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong))) {
            throw new BAD_OPERATION();
        }
        return this.value;
    }

    public short extract_ushort() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort))) {
            throw new BAD_OPERATION();
        }
        return (short)this.value;
    }

    public char extract_wchar() {
        throw new NO_IMPLEMENT();
    }

    public String extract_wstring() {
        throw new NO_IMPLEMENT();
    }

    public void insert_Object(Object object) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_objref);
        this.object = object;
    }

    public void insert_Object(Object object, TypeCode typeCode) {
        try {
            if (!typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") && !object._is_a(typeCode.id())) {
                throw new BAD_OPERATION();
            }
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
            this.object = object;
        }
        catch (Exception exception) {
            throw new BAD_OPERATION();
        }
    }

    public void insert_Principal(Principal principal) {
        AnyOutputStream anyOutputStream = new AnyOutputStream(this.orb);
        anyOutputStream.write_Principal(principal);
        this.read_value(anyOutputStream.create_input_stream(), TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal));
    }

    public void insert_Streamable(Streamable streamable) {
        AnyOutputStream anyOutputStream = new AnyOutputStream(this.orb);
        streamable._write(anyOutputStream);
        this.read_value(anyOutputStream.create_input_stream(), streamable._type());
    }

    public void insert_TypeCode(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode);
        this.object = typeCode;
    }

    public void insert_any(Any any) {
        AnyOutputStream anyOutputStream = new AnyOutputStream(this.orb);
        anyOutputStream.write_any(any);
        this.read_value(anyOutputStream.create_input_stream(), TypeCodeImpl.get_primitive_tc(TCKind.tk_any));
    }

    public void insert_boolean(boolean bl) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean);
        this.value = bl ? 1 : 0;
    }

    public void insert_char(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_char);
        this.value = c;
    }

    public void insert_double(double d) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_double);
        this.value = Double.doubleToLongBits(d);
    }

    public void insert_float(float f) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_float);
        this.value = Float.floatToIntBits(f);
    }

    public void insert_long(int n) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_long);
        this.value = n;
    }

    public void insert_longlong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong);
        this.value = l;
    }

    public void insert_octet(byte by) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_octet);
        this.value = by;
    }

    public void insert_short(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_short);
        this.value = s;
    }

    public void insert_string(String string) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_string);
        this.object = string;
    }

    public void insert_ulong(int n) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong);
        this.value = n;
    }

    public void insert_ulonglong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong);
        this.value = l;
    }

    public void insert_ushort(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort);
        this.value = s;
    }

    public void insert_wchar(char c) {
        throw new NO_IMPLEMENT();
    }

    public void insert_wstring(String string) {
        throw new NO_IMPLEMENT();
    }

    public void read_value(InputStream inputStream, TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        int n = this.typeCode.kind().value();
        if (isStreamed[n]) {
            if (inputStream instanceof AnyInputStream) {
                this.stream = (CDRInputStream)inputStream;
                if (this.stream.getORB() == this.orb) {
                    return;
                }
            }
            CDROutputStream cDROutputStream = new CDROutputStream(this.orb);
            this.typeCode.copy(inputStream, cDROutputStream);
            this.stream = (CDRInputStream)cDROutputStream.create_input_stream();
        } else {
            java.lang.Object[] objectArray = new java.lang.Object[]{this.object};
            long[] lArray = new long[1];
            TCUtility.unmarshalIn(inputStream, n, lArray, objectArray);
            this.value = lArray[0];
            this.object = objectArray[0];
            this.stream = null;
        }
    }

    public TypeCode type() {
        return this.typeCode;
    }

    public void type(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        this.stream = null;
        this.value = 0L;
        this.object = null;
    }

    public void write_value(OutputStream outputStream) {
        if (this.stream != null) {
            this.typeCode.copy(this.stream.dup(), outputStream);
        } else {
            TCUtility.marshalIn(outputStream, this.typeCode.kind().value(), this.value, this.object);
        }
    }
}

