/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends BasicComboBoxUI {
    private static final JTextField sizer = new JTextField();

    protected ComboPopup createPopup() {
        return new WindowsComboPopup(this.comboBox);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsComboBoxUI();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        if (this.comboBox.getRenderer() instanceof UIResource) {
            sizer.setFont(this.comboBox.getFont());
            dimension.height = WindowsComboBoxUI.sizer.getPreferredSize().height;
        } else {
            dimension.height += insets.top + insets.bottom;
        }
        int n = dimension.height - (insets.top + insets.bottom);
        dimension.width += insets.left + insets.right + n;
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return dimension;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WindowsComboBoxUI.this.windowsGetComboBox().isEnabled() && (!WindowsComboBoxUI.this.windowsGetComboBox().isEditable() || WindowsComboBoxUI.this.windowsGetComboBox().isEditable() && WindowsComboBoxUI.this.isPopupVisible(WindowsComboBoxUI.this.windowsGetComboBox()))) {
                    WindowsComboBoxUI.this.selectNextPossibleValue();
                }
            }
        };
        this.comboBox.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(40, 0), 1);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WindowsComboBoxUI.this.windowsGetComboBox().isEnabled() && (!WindowsComboBoxUI.this.windowsGetComboBox().isEditable() || WindowsComboBoxUI.this.windowsGetComboBox().isEditable() && WindowsComboBoxUI.this.isPopupVisible(WindowsComboBoxUI.this.windowsGetComboBox()))) {
                    WindowsComboBoxUI.this.selectPreviousPossibleValue();
                }
            }
        };
        this.comboBox.registerKeyboardAction(actionListener2, KeyStroke.getKeyStroke(38, 0), 1);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.setRequestFocusEnabled(true);
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
    }

    JComboBox windowsGetComboBox() {
        return this.comboBox;
    }

    void windowsSetPopupVisible(boolean bl) {
        this.setPopupVisible(this.comboBox, bl);
    }

    public class WindowsComboPopup
    extends BasicComboPopup {
        JComboBox comboBox;

        public WindowsComboPopup(JComboBox jComboBox) {
            super(jComboBox);
            this.comboBox = jComboBox;
        }

        protected KeyListener createKeyListener() {
            return new InvocationKeyHandler();
        }

        public class InvocationKeyHandler
        extends BasicComboPopup.InvocationKeyHandler {
            public InvocationKeyHandler() {
                super(WindowsComboPopup.this);
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 115) {
                    if (WindowsComboPopup.this.isVisible()) {
                        WindowsComboPopup.this.hide();
                    } else {
                        WindowsComboPopup.this.show();
                    }
                } else if (keyEvent.isAltDown() && keyEvent.getKeyCode() != 18) {
                    if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
                        if (WindowsComboPopup.this.isVisible()) {
                            WindowsComboPopup.this.hide();
                        } else {
                            WindowsComboPopup.this.show();
                        }
                    }
                } else if (WindowsComboPopup.this.comboBox.isEditable() && !WindowsComboPopup.this.isVisible() && (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                    WindowsComboPopup.this.show();
                } else if (!WindowsComboPopup.this.comboBox.isEditable() && WindowsComboPopup.this.isVisible()) {
                    super.keyReleased(keyEvent);
                }
            }
        }
    }
}

