/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Conditional;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.peer.DialogPeer;

public class Dialog
extends Window {
    boolean resizable = true;
    boolean modal;
    String title;
    private transient boolean keepBlocking = false;
    private static final String base = "dialog";
    private static int nameCounter;
    private static final long serialVersionUID = 5920926903803293709L;

    static {
        Toolkit.loadLibraries();
        Dialog.initIDs();
        nameCounter = 0;
    }

    public Dialog(Dialog dialog) {
        this(dialog, "", false);
    }

    public Dialog(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public Dialog(Dialog dialog, String string, boolean bl) {
        super(dialog);
        this.title = string;
        this.modal = bl;
    }

    public Dialog(Frame frame) {
        this(frame, "", false);
    }

    public Dialog(Frame frame, String string) {
        this(frame, string, false);
    }

    public Dialog(Frame frame, String string, boolean bl) {
        super(frame);
        this.title = string;
        this.modal = bl;
    }

    public Dialog(Frame frame, boolean bl) {
        this(frame, "", bl);
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.parent != null && this.parent.getPeer() == null) {
                this.parent.addNotify();
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createDialog(this);
            }
            super.addNotify();
        }
    }

    private boolean conditionalShow() {
        boolean bl;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.addNotify();
            }
            this.validate();
            if (this.visible) {
                this.toFront();
                bl = false;
            } else {
                bl = true;
                this.visible = true;
                this.peer.show();
            }
        }
        if (bl && (this.state & 1) == 0) {
            this.postWindowEvent(200);
            this.state |= 1;
        }
        return bl;
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    public void dispose() {
        super.dispose();
        this.hideAndDisposeHandler();
    }

    public String getTitle() {
        return this.title;
    }

    public void hide() {
        super.hide();
        this.hideAndDisposeHandler();
    }

    private void hideAndDisposeHandler() {
        if (this.keepBlocking) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.keepBlocking = false;
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                    }
                });
                this.getTreeLock().notifyAll();
            }
        }
    }

    private static native void initIDs();

    public boolean isModal() {
        return this.modal;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    protected String paramString() {
        String string = String.valueOf(super.paramString()) + (this.modal ? ",modal" : ",modeless");
        if (this.title != null) {
            string = String.valueOf(string) + ",title=" + this.title;
        }
        return string;
    }

    public void setModal(boolean bl) {
        this.modal = bl;
    }

    public void setResizable(boolean bl) {
        boolean bl2 = false;
        Dialog dialog = this;
        synchronized (dialog) {
            this.resizable = bl;
            DialogPeer dialogPeer = (DialogPeer)this.peer;
            if (dialogPeer != null) {
                dialogPeer.setResizable(bl);
                bl2 = true;
            }
        }
        if (bl2 && this.valid) {
            this.invalidate();
        }
    }

    public synchronized void setTitle(String string) {
        this.title = string;
        DialogPeer dialogPeer = (DialogPeer)this.peer;
        if (dialogPeer != null) {
            dialogPeer.setTitle(string);
        }
    }

    public void show() {
        if (!this.isModal()) {
            this.conditionalShow();
        } else {
            this.keepBlocking = true;
            if (this.conditionalShow()) {
                Toolkit.getEventQueue();
                if (EventQueue.isDispatchThread()) {
                    EventDispatchThread eventDispatchThread = (EventDispatchThread)Thread.currentThread();
                    eventDispatchThread.pumpEvents(new Conditional(){

                        public boolean evaluate() {
                            return Dialog.this.keepBlocking;
                        }
                    });
                } else {
                    Object object = this.getTreeLock();
                    synchronized (object) {
                        while (this.keepBlocking) {
                            try {
                                this.getTreeLock().wait();
                            }
                            catch (InterruptedException interruptedException) {
                                break;
                            }
                        }
                    }
                }
            }
        }
    }
}

