/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import java.util.NoSuchElementException;

class RoundRectIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    double aw;
    double ah;
    AffineTransform affine;
    int index;
    private static final double angle = 0.7853981633974483;
    private static final double a = 1.0 - Math.cos(0.7853981633974483);
    private static final double b = Math.tan(0.7853981633974483);
    private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
    private static final double cv = 1.3333333333333333 * a * b / c;
    private static final double acv = (1.0 - cv) / 2.0;
    private static double[][] ctrlpts;
    private static int[] types;

    static {
        double[][] dArrayArray = new double[10][];
        double[] dArray = new double[4];
        dArray[3] = 0.5;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[4];
        dArray2[2] = 1.0;
        dArray2[3] = -0.5;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[12];
        dArray3[2] = 1.0;
        dArray3[3] = -acv;
        dArray3[5] = acv;
        dArray3[6] = 1.0;
        dArray3[9] = 0.5;
        dArray3[10] = 1.0;
        dArrayArray[2] = dArray3;
        double[] dArray4 = new double[4];
        dArray4[0] = 1.0;
        dArray4[1] = -0.5;
        dArray4[2] = 1.0;
        dArrayArray[3] = dArray4;
        double[] dArray5 = new double[12];
        dArray5[0] = 1.0;
        dArray5[1] = -acv;
        dArray5[2] = 1.0;
        dArray5[4] = 1.0;
        dArray5[6] = 1.0;
        dArray5[7] = -acv;
        dArray5[8] = 1.0;
        dArray5[10] = 1.0;
        dArray5[11] = -0.5;
        dArrayArray[4] = dArray5;
        double[] dArray6 = new double[4];
        dArray6[0] = 1.0;
        dArray6[3] = 0.5;
        dArrayArray[5] = dArray6;
        double[] dArray7 = new double[12];
        dArray7[0] = 1.0;
        dArray7[3] = acv;
        dArray7[4] = 1.0;
        dArray7[5] = -acv;
        dArray7[8] = 1.0;
        dArray7[9] = -0.5;
        dArrayArray[6] = dArray7;
        double[] dArray8 = new double[4];
        dArray8[1] = 0.5;
        dArrayArray[7] = dArray8;
        double[] dArray9 = new double[12];
        dArray9[1] = acv;
        dArray9[7] = acv;
        dArray9[11] = 0.5;
        dArrayArray[8] = dArray9;
        dArrayArray[9] = new double[0];
        ctrlpts = dArrayArray;
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 1;
        nArray[4] = 3;
        nArray[5] = 1;
        nArray[6] = 3;
        nArray[7] = 1;
        nArray[8] = 3;
        nArray[9] = 4;
        types = nArray;
    }

    RoundRectIterator(RoundRectangle2D roundRectangle2D, AffineTransform affineTransform) {
        this.x = roundRectangle2D.getX();
        this.y = roundRectangle2D.getY();
        this.w = roundRectangle2D.getWidth();
        this.h = roundRectangle2D.getHeight();
        this.aw = Math.min(this.w, Math.abs(roundRectangle2D.getArcWidth()));
        this.ah = Math.min(this.h, Math.abs(roundRectangle2D.getArcHeight()));
        this.affine = affineTransform;
        if (this.aw < 0.0 || this.ah < 0.0) {
            this.index = ctrlpts.length;
        }
    }

    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("roundrect iterator out of bounds");
        }
        double[] dArray2 = ctrlpts[this.index];
        int n = 0;
        int n2 = 0;
        while (n2 < dArray2.length) {
            dArray[n++] = this.x + dArray2[n2] * this.w + dArray2[n2 + 1] * this.aw;
            dArray[n++] = this.y + dArray2[n2 + 2] * this.h + dArray2[n2 + 3] * this.ah;
            n2 += 4;
        }
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, n / 2);
        }
        return types[this.index];
    }

    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("roundrect iterator out of bounds");
        }
        double[] dArray = ctrlpts[this.index];
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            fArray[n++] = (float)(this.x + dArray[n2] * this.w + dArray[n2 + 1] * this.aw);
            fArray[n++] = (float)(this.y + dArray[n2 + 2] * this.h + dArray[n2 + 3] * this.ah);
            n2 += 4;
        }
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, n / 2);
        }
        return types[this.index];
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.index >= ctrlpts.length;
    }

    public void next() {
        ++this.index;
    }
}

