/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class WritableRaster
extends Raster {
    protected WritableRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected WritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, WritableRaster writableRaster) {
        super(sampleModel, dataBuffer, rectangle, point, writableRaster);
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        SampleModel sampleModel;
        if (n < this.minX) {
            throw new RasterFormatException("parentX lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("parentY lies outside raster");
        }
        if (n + n3 > this.width + this.minX) {
            throw new RasterFormatException("(parentX + width) is outside raster");
        }
        if (n2 + n4 > this.height + this.minY) {
            throw new RasterFormatException("(parentY + height) is outside raster");
        }
        if (nArray != null) {
            sampleModel = this.sampleModel.createCompatibleSampleModel(this.sampleModel.width, this.sampleModel.height);
            sampleModel = sampleModel.createSubsetSampleModel(nArray);
        } else {
            sampleModel = this.sampleModel;
        }
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new WritableRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, this.width, this.height), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public WritableRaster createWritableTranslatedChild(int n, int n2) {
        return this.createWritableChild(this.minX, this.minY, this.width, this.height, n, n2, null);
    }

    public WritableRaster getWritableParent() {
        return (WritableRaster)this.parent;
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        this.sampleModel.setDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, object, this.dataBuffer);
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int n7 = n + raster.getMinX();
        int n8 = n2 + raster.getMinY();
        Object object = null;
        int n9 = 0;
        while (n9 < n4) {
            object = raster.getDataElements(n5, n6 + n9, n3, 1, object);
            this.setDataElements(n7, n8 + n9, n3, 1, object);
            ++n9;
        }
    }

    public void setDataElements(int n, int n2, Object object) {
        this.sampleModel.setDataElements(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, object, this.dataBuffer);
    }

    public void setPixel(int n, int n2, double[] dArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public void setPixel(int n, int n2, float[] fArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public void setPixel(int n, int n2, int[] nArray) {
        this.sampleModel.setPixel(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, nArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, double[] dArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, dArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, float[] fArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, fArray, this.dataBuffer);
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray) {
        this.sampleModel.setPixels(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, nArray, this.dataBuffer);
    }

    public void setRect(int n, int n2, Raster raster) {
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        int[] nArray = null;
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int n7 = n + n5;
        int n8 = n2 + n6;
        if (n7 + n3 > this.minX + this.width) {
            n3 = this.minX + this.width - n7;
        }
        if (n8 + n4 > this.minY + this.height) {
            n4 = this.minY + this.height - n8;
        }
        int n9 = 0;
        while (n9 < n4) {
            nArray = raster.getPixels(n5, n6 + n9, n3, 1, nArray);
            this.setPixels(n7, n8 + n9, n3, 1, nArray);
            ++n9;
        }
    }

    public void setRect(Raster raster) {
        this.setRect(0, 0, raster);
    }

    public void setSample(int n, int n2, int n3, double d) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, d, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, float f) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, f, this.dataBuffer);
    }

    public void setSample(int n, int n2, int n3, int n4) {
        this.sampleModel.setSample(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, dArray, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, fArray, this.dataBuffer);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        this.sampleModel.setSamples(n - this.sampleModelTranslateX, n2 - this.sampleModelTranslateY, n3, n4, n5, nArray, this.dataBuffer);
    }
}

