/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;

    static {
        FileInputStream.initIDs();
    }

    public FileInputStream(File file) throws FileNotFoundException {
        this(file.getPath());
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    public FileInputStream(String string) throws FileNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        this.fd = new FileDescriptor();
        this.open(string);
    }

    public native int available() throws IOException;

    public native void close() throws IOException;

    protected void finalize() throws IOException {
        if (this.fd != null && this.fd != FileDescriptor.in) {
            this.close();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fd != null) {
            return this.fd;
        }
        throw new IOException();
    }

    private static native void initIDs();

    private native void open(String var1) throws FileNotFoundException;

    public native int read() throws IOException;

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public native long skip(long var1) throws IOException;
}

