/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ObjectStreamClass;
import java.lang.reflect.Field;

public class ObjectStreamField
implements Comparable {
    private String name;
    private char type;
    private Field field;
    private String typeString;
    private int bufoffset;
    private Class clazz;
    private static final String OBJECT_TYPESTRING = new String("");
    static /* synthetic */ Class class$java$lang$Object;

    ObjectStreamField() {
    }

    ObjectStreamField(String string, char c, Field field, String string2) {
        this.name = string;
        this.type = c;
        this.field = field;
        this.typeString = string2 != null ? string2.intern() : null;
    }

    public ObjectStreamField(String string, Class clazz) {
        this.name = string;
        this.clazz = clazz;
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.type = (char)73;
            } else if (clazz == Byte.TYPE) {
                this.type = (char)66;
            } else if (clazz == Long.TYPE) {
                this.type = (char)74;
            } else if (clazz == Float.TYPE) {
                this.type = (char)70;
            } else if (clazz == Double.TYPE) {
                this.type = (char)68;
            } else if (clazz == Short.TYPE) {
                this.type = (char)83;
            } else if (clazz == Character.TYPE) {
                this.type = (char)67;
            } else if (clazz == Boolean.TYPE) {
                this.type = (char)90;
            }
        } else if (clazz.isArray()) {
            this.type = (char)91;
            this.typeString = ObjectStreamClass.getSignature(clazz).intern();
        } else {
            this.type = (char)76;
            this.typeString = ObjectStreamClass.getSignature(clazz).intern();
        }
    }

    private ObjectStreamField(String string, boolean bl) {
        this.name = string;
        this.setSearchKeyTypeString(bl);
    }

    ObjectStreamField(Field field) {
        this(field.getName(), field.getType());
        this.field = field;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int compareTo(Object object) {
        boolean bl;
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        boolean bl2 = this.typeString == null;
        boolean bl3 = bl = objectStreamField.typeString == null;
        if (bl2 != bl) {
            return bl2 ? -1 : 1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    static ObjectStreamField constructSearchKey(String string, Class clazz) {
        return new ObjectStreamField(string, clazz.isPrimitive());
    }

    Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public int getOffset() {
        return this.bufoffset;
    }

    public Class getType() {
        if (this.clazz != null) {
            return this.clazz;
        }
        switch (this.type) {
            case 'B': {
                this.clazz = Byte.TYPE;
                break;
            }
            case 'C': {
                this.clazz = Character.TYPE;
                break;
            }
            case 'S': {
                this.clazz = Short.TYPE;
                break;
            }
            case 'I': {
                this.clazz = Integer.TYPE;
                break;
            }
            case 'J': {
                this.clazz = Long.TYPE;
                break;
            }
            case 'F': {
                this.clazz = Float.TYPE;
                break;
            }
            case 'D': {
                this.clazz = Double.TYPE;
                break;
            }
            case 'Z': {
                this.clazz = Boolean.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.clazz = class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = ObjectStreamField.class$("java.lang.Object"));
                break;
            }
        }
        return this.clazz;
    }

    public char getTypeCode() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    public boolean isPrimitive() {
        return this.type != '[' && this.type != 'L';
    }

    void setField(Field field) {
        this.field = field;
    }

    protected void setOffset(int n) {
        this.bufoffset = n;
    }

    void setSearchKeyTypeString(boolean bl) {
        this.typeString = bl ? null : OBJECT_TYPESTRING;
    }

    public String toString() {
        if (this.typeString != null) {
            return String.valueOf(this.typeString) + " " + this.name;
        }
        return String.valueOf(this.type) + " " + this.name;
    }

    boolean typeEquals(ObjectStreamField objectStreamField) {
        if (objectStreamField == null || this.type != objectStreamField.type) {
            return false;
        }
        if (this.typeString == objectStreamField.typeString) {
            return true;
        }
        return ObjectStreamClass.compareClassNames(this.typeString, objectStreamField.typeString, '/');
    }
}

