/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;

public class CertificateFactory {
    private static final Class cl = class$java$security$Security != null ? class$java$security$Security : (class$java$security$Security = CertificateFactory.class$("java.security.Security"));
    private static final Class[] GET_IMPL_PARAMS = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = CertificateFactory.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = CertificateFactory.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = CertificateFactory.class$("java.lang.String"))};
    private static Method implMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            Method method = null;
            try {
                method = cl.getDeclaredMethod("getImpl", GET_IMPL_PARAMS);
                if (method != null) {
                    method.setAccessible(true);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            return method;
        }
    });
    private String type;
    private Provider provider;
    private CertificateFactorySpi certFacSpi;
    static /* synthetic */ Class class$java$security$Security;
    static /* synthetic */ Class class$java$lang$String;

    protected CertificateFactory(CertificateFactorySpi certificateFactorySpi, Provider provider, String string) {
        this.certFacSpi = certificateFactorySpi;
        this.provider = provider;
        this.type = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final CRL generateCRL(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRL(inputStream);
    }

    public final Collection generateCRLs(InputStream inputStream) throws CRLException {
        return this.certFacSpi.engineGenerateCRLs(inputStream);
    }

    public final Certificate generateCertificate(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificate(inputStream);
    }

    public final Collection generateCertificates(InputStream inputStream) throws CertificateException {
        return this.certFacSpi.engineGenerateCertificates(inputStream);
    }

    public static final CertificateFactory getInstance(String string) throws CertificateException {
        try {
            if (implMethod == null) {
                throw new CertificateException(String.valueOf(string) + " not found");
            }
            Object[] objectArray = (Object[])implMethod.invoke(null, new Object[]{string, "CertificateFactory", null});
            return new CertificateFactory((CertificateFactorySpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CertificateException(String.valueOf(string) + " not found");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CertificateException(String.valueOf(string) + " not found");
        }
    }

    public static final CertificateFactory getInstance(String string, String string2) throws CertificateException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        try {
            if (implMethod == null) {
                throw new CertificateException(String.valueOf(string) + " not found");
            }
            Object[] objectArray = (Object[])implMethod.invoke(null, new Object[]{string, "CertificateFactory", string2});
            return new CertificateFactory((CertificateFactorySpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CertificateException(String.valueOf(string) + " not found");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable != null && throwable instanceof NoSuchProviderException) {
                throw (NoSuchProviderException)throwable;
            }
            throw new CertificateException(String.valueOf(string) + " not found");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getType() {
        return this.type;
    }
}

