/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public final class DecimalFormatSymbols
implements Cloneable,
Serializable {
    private char zeroDigit;
    private char groupingSeparator;
    private char decimalSeparator;
    private char perMill;
    private char percent;
    private char digit;
    private char patternSeparator;
    private String infinity;
    private String NaN;
    private char minusSign;
    private String currencySymbol;
    private String intlCurrencySymbol;
    private char monetarySeparator;
    private char exponential;
    static final long serialVersionUID = 5772796243397350300L;
    private static final int currentSerialVersion = 1;
    private int serialVersionOnStream = 1;
    private static final Hashtable cachedLocaleData = new Hashtable(3);

    public DecimalFormatSymbols() {
        this.initialize(Locale.getDefault());
    }

    public DecimalFormatSymbols(Locale locale) {
        this.initialize(locale);
    }

    public Object clone() {
        try {
            return (DecimalFormatSymbols)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DecimalFormatSymbols decimalFormatSymbols = (DecimalFormatSymbols)object;
        return this.zeroDigit == decimalFormatSymbols.zeroDigit && this.groupingSeparator == decimalFormatSymbols.groupingSeparator && this.decimalSeparator == decimalFormatSymbols.decimalSeparator && this.percent == decimalFormatSymbols.percent && this.perMill == decimalFormatSymbols.perMill && this.digit == decimalFormatSymbols.digit && this.minusSign == decimalFormatSymbols.minusSign && this.patternSeparator == decimalFormatSymbols.patternSeparator && this.infinity.equals(decimalFormatSymbols.infinity) && this.NaN.equals(decimalFormatSymbols.NaN) && this.currencySymbol.equals(decimalFormatSymbols.currencySymbol) && this.intlCurrencySymbol.equals(decimalFormatSymbols.intlCurrencySymbol) && this.monetarySeparator == decimalFormatSymbols.monetarySeparator;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public char getDigit() {
        return this.digit;
    }

    char getExponentialSymbol() {
        return this.exponential;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public String getInfinity() {
        return this.infinity;
    }

    public String getInternationalCurrencySymbol() {
        return this.intlCurrencySymbol;
    }

    public char getMinusSign() {
        return this.minusSign;
    }

    public char getMonetaryDecimalSeparator() {
        return this.monetarySeparator;
    }

    public String getNaN() {
        return this.NaN;
    }

    public char getPatternSeparator() {
        return this.patternSeparator;
    }

    public char getPerMill() {
        return this.perMill;
    }

    public char getPercent() {
        return this.percent;
    }

    public char getZeroDigit() {
        return this.zeroDigit;
    }

    public int hashCode() {
        int n = this.zeroDigit;
        n = n * 37 + this.groupingSeparator;
        n = n * 37 + this.decimalSeparator;
        return n;
    }

    private void initialize(Locale locale) {
        String[][] stringArray = (String[][])cachedLocaleData.get(locale);
        if (stringArray == null) {
            stringArray = new String[2][];
            ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
            stringArray[0] = resourceBundle.getStringArray("NumberElements");
            stringArray[1] = resourceBundle.getStringArray("CurrencyElements");
            cachedLocaleData.put(locale, stringArray);
        }
        String[] stringArray2 = stringArray[0];
        String[] stringArray3 = stringArray[1];
        this.decimalSeparator = stringArray2[0].charAt(0);
        this.groupingSeparator = stringArray2[1].charAt(0);
        this.patternSeparator = stringArray2[2].charAt(0);
        this.percent = stringArray2[3].charAt(0);
        this.zeroDigit = stringArray2[4].charAt(0);
        this.digit = stringArray2[5].charAt(0);
        this.minusSign = stringArray2[6].charAt(0);
        this.exponential = stringArray2[7].charAt(0);
        this.perMill = stringArray2[8].charAt(0);
        this.infinity = stringArray2[9];
        this.NaN = stringArray2[10];
        this.currencySymbol = stringArray3[0];
        this.intlCurrencySymbol = stringArray3[1];
        this.monetarySeparator = stringArray3[2].length() == 0 ? this.decimalSeparator : stringArray3[2].charAt(0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.monetarySeparator = this.decimalSeparator;
            this.exponential = (char)69;
        }
        this.serialVersionOnStream = 1;
    }

    public void setCurrencySymbol(String string) {
        this.currencySymbol = string;
    }

    public void setDecimalSeparator(char c) {
        this.decimalSeparator = c;
    }

    public void setDigit(char c) {
        this.digit = c;
    }

    void setExponentialSymbol(char c) {
        this.exponential = c;
    }

    public void setGroupingSeparator(char c) {
        this.groupingSeparator = c;
    }

    public void setInfinity(String string) {
        this.infinity = string;
    }

    public void setInternationalCurrencySymbol(String string) {
        this.intlCurrencySymbol = string;
    }

    public void setMinusSign(char c) {
        this.minusSign = c;
    }

    public void setMonetaryDecimalSeparator(char c) {
        this.monetarySeparator = c;
    }

    public void setNaN(String string) {
        this.NaN = string;
    }

    public void setPatternSeparator(char c) {
        this.patternSeparator = c;
    }

    public void setPerMill(char c) {
        this.perMill = c;
    }

    public void setPercent(char c) {
        this.percent = c;
    }

    public void setZeroDigit(char c) {
        this.zeroDigit = c;
    }
}

