/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private long[] bits;
    private transient int unitsInUse = 0;
    private static final long serialVersionUID = 7997698588986878753L;

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException(Integer.toString(n));
        }
        this.bits = new long[BitSet.unitIndex(n - 1) + 1];
    }

    public void and(BitSet bitSet) {
        if (this == bitSet) {
            return;
        }
        int n = this.unitsInUse;
        this.unitsInUse = Math.min(this.unitsInUse, bitSet.unitsInUse);
        int n2 = 0;
        while (n2 < this.unitsInUse) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & bitSet.bits[n2];
            ++n2;
        }
        while (n2 < n) {
            this.bits[n2] = 0L;
            ++n2;
        }
        if (this.unitsInUse > 0 && this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public void andNot(BitSet bitSet) {
        int n = Math.min(this.unitsInUse, bitSet.unitsInUse);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] & (bitSet.bits[n2] ^ 0xFFFFFFFFFFFFFFFFL);
            ++n2;
        }
        this.recalculateUnitsInUse();
    }

    private static long bit(int n) {
        return 1L << (n & 0x3F);
    }

    public void clear(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = BitSet.unitIndex(n);
        if (n2 >= this.unitsInUse) {
            return;
        }
        int n3 = n2;
        this.bits[n3] = this.bits[n3] & (BitSet.bit(n) ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.bits[this.unitsInUse - 1] == 0L) {
            this.recalculateUnitsInUse();
        }
    }

    public Object clone() {
        BitSet bitSet = null;
        try {
            bitSet = (BitSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        bitSet.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, bitSet.bits, 0, this.unitsInUse);
        return bitSet;
    }

    private void ensureCapacity(int n) {
        if (this.bits.length < n) {
            int n2 = Math.max(2 * this.bits.length, n);
            long[] lArray = new long[n2];
            System.arraycopy(this.bits, 0, lArray, 0, this.unitsInUse);
            this.bits = lArray;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof BitSet)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        BitSet bitSet = (BitSet)object;
        int n = Math.min(this.unitsInUse, bitSet.unitsInUse);
        int n2 = 0;
        while (n2 < n) {
            if (this.bits[n2] != bitSet.bits[n2]) {
                return false;
            }
            ++n2;
        }
        if (this.unitsInUse > n) {
            int n3 = n;
            while (n3 < this.unitsInUse) {
                if (this.bits[n3] != 0L) {
                    return false;
                }
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < bitSet.unitsInUse) {
                if (bitSet.bits[n4] != 0L) {
                    return false;
                }
                ++n4;
            }
        }
        return true;
    }

    public boolean get(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        boolean bl = false;
        int n2 = BitSet.unitIndex(n);
        if (n2 < this.unitsInUse) {
            bl = (this.bits[n2] & BitSet.bit(n)) != 0L;
        }
        return bl;
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)(n + 1);
        }
        return (int)(l >> 32 ^ l);
    }

    public int length() {
        if (this.unitsInUse == 0) {
            return 0;
        }
        int n = (this.unitsInUse - 1) * 64;
        long l = this.bits[this.unitsInUse - 1];
        do {
            ++n;
        } while ((l >>>= 1) > 0L);
        return n;
    }

    public void or(BitSet bitSet) {
        if (this == bitSet) {
            return;
        }
        this.ensureCapacity(bitSet.unitsInUse);
        int n = Math.min(this.unitsInUse, bitSet.unitsInUse);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            this.bits[n3] = this.bits[n3] | bitSet.bits[n2];
            ++n2;
        }
        while (n2 < bitSet.unitsInUse) {
            this.bits[n2] = bitSet.bits[n2];
            ++n2;
        }
        if (this.unitsInUse < bitSet.unitsInUse) {
            this.unitsInUse = bitSet.unitsInUse;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.unitsInUse = this.bits.length;
        this.recalculateUnitsInUse();
    }

    private void recalculateUnitsInUse() {
        int n = this.unitsInUse - 1;
        while (n >= 0) {
            if (this.bits[n] != 0L) break;
            --n;
        }
        this.unitsInUse = n + 1;
    }

    public void set(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        int n2 = BitSet.unitIndex(n);
        int n3 = n2 + 1;
        if (this.unitsInUse < n3) {
            this.ensureCapacity(n3);
            int n4 = n2;
            this.bits[n4] = this.bits[n4] | BitSet.bit(n);
            this.unitsInUse = n3;
        } else {
            int n5 = n2;
            this.bits[n5] = this.bits[n5] | BitSet.bit(n);
        }
    }

    public int size() {
        return this.bits.length << 6;
    }

    public String toString() {
        int n = this.unitsInUse << 6;
        StringBuffer stringBuffer = new StringBuffer(8 * n + 2);
        String string = "";
        stringBuffer.append('{');
        int n2 = 0;
        while (n2 < n) {
            if (this.get(n2)) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(n2);
            }
            ++n2;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    private static int unitIndex(int n) {
        return n >> 6;
    }

    public void xor(BitSet bitSet) {
        int n;
        int n2;
        if (this.unitsInUse >= bitSet.unitsInUse) {
            n2 = bitSet.unitsInUse;
        } else {
            n2 = this.unitsInUse;
            n = bitSet.unitsInUse;
            this.ensureCapacity(n);
            this.unitsInUse = n;
        }
        n = 0;
        while (n < n2) {
            int n3 = n;
            this.bits[n3] = this.bits[n3] ^ bitSet.bits[n];
            ++n;
        }
        while (n < bitSet.unitsInUse) {
            this.bits[n] = bitSet.bits[n];
            ++n;
        }
        this.recalculateUnitsInUse();
    }
}

