/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;

public class Manifest
implements Cloneable {
    private Attributes attr = new Attributes();
    private Map entries = new HashMap();

    public Manifest() {
    }

    public Manifest(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public Manifest(Manifest manifest) {
        this.attr.putAll(manifest.getMainAttributes());
        this.entries.putAll(manifest.getEntries());
    }

    public void clear() {
        this.attr.clear();
        this.entries.clear();
    }

    public Object clone() {
        return new Manifest(this);
    }

    public boolean equals(Object object) {
        if (object instanceof Manifest) {
            Manifest manifest = (Manifest)object;
            return this.attr.equals(manifest.getMainAttributes()) && this.entries.equals(manifest.getEntries());
        }
        return false;
    }

    public Attributes getAttributes(String string) {
        return (Attributes)this.getEntries().get(string);
    }

    public Map getEntries() {
        return this.entries;
    }

    public Attributes getMainAttributes() {
        return this.attr;
    }

    public int hashCode() {
        return this.attr.hashCode() + this.entries.hashCode();
    }

    static void make72Safe(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        if (n > 72) {
            int n2 = 70;
            while (n2 - 1 < n) {
                stringBuffer.insert(n2, "\r\n ");
                n2 += 72;
            }
        }
    }

    private String parseName(byte[] byArray, int n) {
        if (this.toLower(byArray[0]) == 110 && this.toLower(byArray[1]) == 97 && this.toLower(byArray[2]) == 109 && this.toLower(byArray[3]) == 101 && byArray[4] == 58 && byArray[5] == 32) {
            return new String(byArray, 0, 6, n - 6);
        }
        return null;
    }

    public void read(InputStream inputStream) throws IOException {
        int n;
        FastInputStream fastInputStream = new FastInputStream(inputStream);
        byte[] byArray = new byte[512];
        this.attr.read(fastInputStream, byArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = 2;
        String string = null;
        boolean bl = true;
        while ((n = fastInputStream.readLine(byArray)) != -1) {
            if (byArray[--n] != 10) {
                throw new IOException("manifest line too long");
            }
            if (n > 0 && byArray[n - 1] == 13) {
                --n;
            }
            if (n == 0 && bl) continue;
            bl = false;
            if (string == null) {
                string = this.parseName(byArray, n);
                if (string == null) {
                    throw new IOException("invalid manifest format");
                }
            } else {
                string = String.valueOf(string) + new String(byArray, 0, 1, n - 1);
            }
            if (fastInputStream.peek() == 32) continue;
            Attributes attributes = this.getAttributes(string);
            if (attributes == null) {
                attributes = new Attributes(n4);
                this.entries.put(string, attributes);
            }
            attributes.read(fastInputStream, byArray);
            n4 = Math.max(2, (n3 += attributes.size()) / ++n2);
            string = null;
            bl = true;
        }
    }

    private int toLower(int n) {
        return n >= 65 && n <= 90 ? 97 + (n - 65) : n;
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.attr.writeMain(dataOutputStream);
        Iterator iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            StringBuffer stringBuffer = new StringBuffer("Name: ");
            stringBuffer.append((String)entry.getKey());
            stringBuffer.append("\r\n");
            Manifest.make72Safe(stringBuffer);
            dataOutputStream.writeBytes(stringBuffer.toString());
            ((Attributes)entry.getValue()).write(dataOutputStream);
        }
        dataOutputStream.flush();
    }

    static class FastInputStream
    extends FilterInputStream {
        private byte[] buf;
        private int count = 0;
        private int pos = 0;

        FastInputStream(InputStream inputStream) {
            this(inputStream, 8192);
        }

        FastInputStream(InputStream inputStream, int n) {
            super(inputStream);
            this.buf = new byte[n];
        }

        public int available() throws IOException {
            return this.count - this.pos + this.in.available();
        }

        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
                this.in = null;
                this.buf = null;
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int n = this.in.read(this.buf, 0, this.buf.length);
            if (n > 0) {
                this.count = n;
            }
        }

        public byte peek() throws IOException {
            if (this.pos == this.count) {
                this.fill();
            }
            return this.buf[this.pos];
        }

        public int read() throws IOException {
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return this.buf[this.pos++] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.count - this.pos;
            if (n3 <= 0) {
                if (n2 >= this.buf.length) {
                    return this.in.read(byArray, n, n2);
                }
                this.fill();
                n3 = this.count - this.pos;
                if (n3 <= 0) {
                    return -1;
                }
            }
            if (n2 > n3) {
                n2 = n3;
            }
            System.arraycopy(this.buf, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        public int readLine(byte[] byArray) throws IOException {
            return this.readLine(byArray, 0, byArray.length);
        }

        public int readLine(byte[] byArray, int n, int n2) throws IOException {
            byte[] byArray2 = this.buf;
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5 = this.count - this.pos;
                if (n5 <= 0) {
                    this.fill();
                    n5 = this.count - this.pos;
                    if (n5 <= 0) {
                        return -1;
                    }
                }
                if ((n4 = n2 - n3) > n5) {
                    n4 = n5;
                }
                int n6 = this.pos;
                int n7 = n6 + n4;
                while (n6 < n7 && byArray2[n6++] != 10) {
                }
                n4 = n6 - this.pos;
                System.arraycopy(byArray2, this.pos, byArray, n, n4);
                n += n4;
                n3 += n4;
                this.pos = n6;
                if (byArray2[n6 - 1] == 10) break;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            long l2 = this.count - this.pos;
            if (l2 <= 0L) {
                return this.in.skip(l);
            }
            if (l > l2) {
                l = l2;
            }
            this.pos = (int)((long)this.pos + l);
            return l;
        }
    }
}

