/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;
import javax.swing.plaf.DesktopPaneUI;

public class JDesktopPane
extends JLayeredPane
implements Accessible {
    private static final String uiClassID = "DesktopPaneUI";
    transient DesktopManager desktopManager;

    public JDesktopPane() {
        this.updateUI();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDesktopPane();
        }
        return this.accessibleContext;
    }

    public JInternalFrame[] getAllFrames() {
        Vector vector = new Vector(10);
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            JInternalFrame jInternalFrame;
            Component component = this.getComponent(n2);
            if (component instanceof JInternalFrame) {
                vector.addElement(component);
            } else if (component instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame()) != null) {
                vector.addElement(jInternalFrame);
            }
            ++n2;
        }
        Object[] objectArray = new JInternalFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public JInternalFrame[] getAllFramesInLayer(int n) {
        Vector vector = new Vector(10);
        int n2 = this.getComponentCount();
        int n3 = 0;
        while (n3 < n2) {
            Component component = this.getComponent(n3);
            if (component instanceof JInternalFrame) {
                JInternalFrame jInternalFrame;
                if (((JInternalFrame)component).getLayer() == n) {
                    vector.addElement(component);
                } else if (component instanceof JInternalFrame.JDesktopIcon && (jInternalFrame = ((JInternalFrame.JDesktopIcon)component).getInternalFrame()) != null && jInternalFrame.getLayer() == n) {
                    vector.addElement(jInternalFrame);
                }
            }
            ++n3;
        }
        Object[] objectArray = new JInternalFrame[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public DesktopManager getDesktopManager() {
        return this.desktopManager;
    }

    public DesktopPaneUI getUI() {
        return (DesktopPaneUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isOpaque() {
        return true;
    }

    protected String paramString() {
        String string = this.desktopManager != null ? this.desktopManager.toString() : "";
        return String.valueOf(super.paramString()) + ",desktopManager=" + string;
    }

    public void setDesktopManager(DesktopManager desktopManager) {
        this.desktopManager = desktopManager;
    }

    public void setUI(DesktopPaneUI desktopPaneUI) {
        super.setUI(desktopPaneUI);
    }

    public void updateUI() {
        this.setUI((DesktopPaneUI)UIManager.getUI(this));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected class AccessibleJDesktopPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJDesktopPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }
    }
}

