/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    protected DragWindow dragWindow;
    private Container dockingSource;
    private int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    private KeyStroke kpUpKey;
    private KeyStroke kpDownKey;
    private KeyStroke kpLeftKey;
    private KeyStroke kpRightKey;
    private static String FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";

    public boolean canDock(Component component, Point point) {
        boolean bl = false;
        if (component.contains(point)) {
            if (this.dockingSensitivity == 0) {
                this.dockingSensitivity = this.toolBar.getSize().height;
            }
            if (point.y < this.dockingSensitivity) {
                bl = true;
            }
            if (point.y > component.getSize().height - this.dockingSensitivity) {
                bl = true;
            }
            if (point.x < this.dockingSensitivity) {
                bl = true;
            }
            if (point.x > component.getSize().width - this.dockingSensitivity) {
                bl = true;
            }
        }
        return bl;
    }

    protected MouseInputListener createDockingListener() {
        return new DockingListener(this.toolBar);
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        Container container;
        Frame frame = null;
        if (this.toolBar != null) {
            container = this.toolBar.getParent();
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            if (container != null && container instanceof Frame) {
                frame = (Frame)container;
            }
        }
        if (this.floatingFrame == null) {
            this.floatingFrame = this.createFloatingFrame(this.toolBar);
        }
        frame = this.floatingFrame;
        container = new DragWindow(frame);
        return container;
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        JFrame jFrame = new JFrame(jToolBar.getName());
        jFrame.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        jFrame.addWindowListener(windowListener);
        return jFrame;
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener();
    }

    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicToolBarUI();
    }

    protected void dragTo(Point point, Point point2) {
        block8: {
            if (!this.toolBar.isFloatable()) break block8;
            try {
                Object object;
                Cloneable cloneable;
                Point point3;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((point3 = this.dragWindow.getOffset()) == null) {
                    cloneable = this.toolBar.getPreferredSize();
                    point3 = new Point(cloneable.width / 2, cloneable.height / 2);
                    this.dragWindow.setOffset(point3);
                }
                cloneable = new Point(point2.x + point.x, point2.y + point.y);
                Point point4 = new Point(((Point)cloneable).x - point3.x, ((Point)cloneable).y - point3.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                Point point5 = this.dockingSource.getLocationOnScreen();
                Point point6 = new Point(((Point)cloneable).x - point5.x, ((Point)cloneable).y - point5.y);
                if (this.canDock(this.dockingSource, point6)) {
                    this.dragWindow.setBackground(this.getDockingColor());
                    object = this.getDockingConstraint(this.dockingSource, point6);
                    int n = this.mapConstraintToOrientation((String)object);
                    this.dragWindow.setOrientation(n);
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                } else {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setOrientation(0);
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                }
                this.dragWindow.setLocation(point4.x, point4.y);
                if (!this.dragWindow.isVisible()) {
                    object = this.toolBar.getPreferredSize();
                    this.dragWindow.setSize(((Dimension)object).width, ((Dimension)object).height);
                    this.dragWindow.show();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {}
        }
    }

    protected void floatAt(Point point, Point point2) {
        block7: {
            if (!this.toolBar.isFloatable()) break block7;
            try {
                Point point3 = this.dragWindow.getOffset();
                if (point3 == null) {
                    point3 = point;
                    this.dragWindow.setOffset(point3);
                }
                Point point4 = new Point(point2.x + point.x, point2.y + point.y);
                this.setFloatingLocation(point4.x - point3.x, point4.y - point3.y);
                if (this.dockingSource != null) {
                    Point point5 = this.dockingSource.getLocationOnScreen();
                    Point point6 = new Point(point4.x - point5.x, point4.y - point5.y);
                    if (this.canDock(this.dockingSource, point6)) {
                        this.setFloating(false, point6);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {}
        }
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    private String getDockingConstraint(Component component, Point point) {
        String string = "North";
        if (point != null && component.contains(point)) {
            if (this.dockingSensitivity == 0) {
                this.dockingSensitivity = this.toolBar.getSize().height;
            }
            if (point.y > component.getSize().height - this.dockingSensitivity) {
                string = "South";
            }
            if (point.x < this.dockingSensitivity) {
                string = "West";
            }
            if (point.x > component.getSize().width - this.dockingSensitivity) {
                string = "East";
            }
            if (point.y < this.dockingSensitivity) {
                string = "North";
            }
        }
        return string;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void installComponents() {
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
    }

    protected void installKeyboardActions() {
        UpAction upAction = new UpAction();
        DownAction downAction = new DownAction();
        LeftAction leftAction = new LeftAction();
        RightAction rightAction = new RightAction();
        this.upKey = KeyStroke.getKeyStroke(38, 0);
        this.downKey = KeyStroke.getKeyStroke(40, 0);
        this.leftKey = KeyStroke.getKeyStroke(37, 0);
        this.rightKey = KeyStroke.getKeyStroke(39, 0);
        this.kpUpKey = KeyStroke.getKeyStroke("KP_UP");
        this.kpDownKey = KeyStroke.getKeyStroke("KP_DOWN");
        this.kpLeftKey = KeyStroke.getKeyStroke("KP_LEFT");
        this.kpRightKey = KeyStroke.getKeyStroke("KP_RIGHT");
        this.toolBar.registerKeyboardAction(upAction, this.upKey, 1);
        this.toolBar.registerKeyboardAction(downAction, this.downKey, 1);
        this.toolBar.registerKeyboardAction(leftAction, this.leftKey, 1);
        this.toolBar.registerKeyboardAction(rightAction, this.rightKey, 1);
        this.toolBar.registerKeyboardAction(upAction, this.kpUpKey, 1);
        this.toolBar.registerKeyboardAction(downAction, this.kpDownKey, 1);
        this.toolBar.registerKeyboardAction(leftAction, this.kpLeftKey, 1);
        this.toolBar.registerKeyboardAction(rightAction, this.kpRightKey, 1);
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].addFocusListener(this.toolBarFocusListener);
                ++n;
            }
        }
    }

    public void installUI(JComponent jComponent) {
        this.toolBar = (JToolBar)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingFrame = null;
        this.setOrientation(this.toolBar.getOrientation());
        jComponent.setOpaque(true);
        if (jComponent.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)jComponent.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    public boolean isFloating() {
        return this.floating;
    }

    private int mapConstraintToOrientation(String string) {
        int n = this.toolBar.getOrientation();
        if (string != null) {
            if (string.equals("East") || string.equals("West")) {
                n = 1;
            } else if (string.equals("North") || string.equals("South")) {
                n = 0;
            }
        }
        return n;
    }

    protected void navigateFocusedComp(int n) {
        int n2 = this.toolBar.getComponentCount();
        block0 : switch (n) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n3 = this.focusedCompIndex + 1;
                while (n3 != this.focusedCompIndex) {
                    Component component;
                    if (n3 >= n2) {
                        n3 = 0;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n3++)) == null || !component.isFocusTraversable()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n4 = this.focusedCompIndex - 1;
                while (n4 != this.focusedCompIndex) {
                    Component component;
                    if (n4 < 0) {
                        n4 = n2 - 1;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n4--)) == null || !component.isFocusTraversable()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    public void setDockingColor(Color color) {
        this.dockingColor = color;
    }

    public void setFloating(boolean bl, Point point) {
        if (this.toolBar.isFloatable()) {
            Object object;
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            this.floating = bl;
            if (bl) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingFrame == null) {
                    this.floatingFrame = this.createFloatingFrame(this.toolBar);
                }
                this.floatingFrame.getContentPane().add((Component)this.toolBar, "Center");
                this.setOrientation(0);
                this.floatingFrame.pack();
                this.floatingFrame.setLocation(this.floatingX, this.floatingY);
                this.floatingFrame.show();
            } else {
                if (this.floatingFrame == null) {
                    this.floatingFrame = this.createFloatingFrame(this.toolBar);
                }
                this.floatingFrame.setVisible(false);
                this.floatingFrame.getContentPane().remove(this.toolBar);
                object = this.getDockingConstraint(this.dockingSource, point);
                int n = this.mapConstraintToOrientation((String)object);
                this.setOrientation(n);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                this.dockingSource.add((String)object, this.toolBar);
            }
            this.dockingSource.invalidate();
            object = this.dockingSource.getParent();
            if (object != null) {
                ((Container)object).validate();
            }
            this.dockingSource.repaint();
        }
    }

    public void setFloatingColor(Color color) {
        this.floatingColor = color;
    }

    public void setFloatingLocation(int n, int n2) {
        this.floatingX = n;
        this.floatingY = n2;
    }

    public void setOrientation(int n) {
        this.toolBar.setOrientation(n);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(n);
        }
    }

    protected void uninstallComponents() {
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
    }

    protected void uninstallKeyboardActions() {
        this.toolBar.unregisterKeyboardAction(this.upKey);
        this.toolBar.unregisterKeyboardAction(this.downKey);
        this.toolBar.unregisterKeyboardAction(this.leftKey);
        this.toolBar.unregisterKeyboardAction(this.rightKey);
        this.leftKey = null;
        this.rightKey = null;
        this.downKey = null;
        this.upKey = null;
        this.toolBar.unregisterKeyboardAction(this.kpUpKey);
        this.toolBar.unregisterKeyboardAction(this.kpDownKey);
        this.toolBar.unregisterKeyboardAction(this.kpLeftKey);
        this.toolBar.unregisterKeyboardAction(this.kpRightKey);
        this.kpLeftKey = null;
        this.kpRightKey = null;
        this.kpDownKey = null;
        this.kpUpKey = null;
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] componentArray = this.toolBar.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].removeFocusListener(this.toolBarFocusListener);
                ++n;
            }
            this.toolBarFocusListener = null;
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingFrame = null;
        this.dragWindow = null;
        this.dockingSource = null;
        jComponent.putClientProperty(FOCUSED_COMP_INDEX, new Integer(this.focusedCompIndex));
    }

    private abstract class KeyAction
    implements ActionListener {
        KeyAction() {
        }

        public abstract void actionPerformed(ActionEvent var1);

        public boolean isEnabled() {
            return true;
        }
    }

    private class RightAction
    extends KeyAction {
        RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicToolBarUI.this.navigateFocusedComp(3);
        }
    }

    private class LeftAction
    extends KeyAction {
        LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicToolBarUI.this.navigateFocusedComp(7);
        }
    }

    private class UpAction
    extends KeyAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicToolBarUI.this.navigateFocusedComp(1);
        }
    }

    private class DownAction
    extends KeyAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicToolBarUI.this.navigateFocusedComp(5);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            BasicToolBarUI.this.setFloating(false, null);
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                component.addFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                component.removeFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            BasicToolBarUI.this.focusedCompIndex = BasicToolBarUI.this.toolBar.getComponentIndex(component);
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
                BasicToolBarUI.this.toolBar.updateUI();
            }
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;

        public DockingListener(JToolBar jToolBar) {
            this.toolBar = jToolBar;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point point = mouseEvent.getPoint();
            if (this.origin == null) {
                this.origin = mouseEvent.getComponent().getLocationOnScreen();
            }
            BasicToolBarUI.this.dragTo(point, this.origin);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point point = mouseEvent.getPoint();
                if (this.origin == null) {
                    this.origin = mouseEvent.getComponent().getLocationOnScreen();
                }
                BasicToolBarUI.this.floatAt(point, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }
    }

    protected class DragWindow
    extends Window {
        Color borderColor = Color.gray;
        int orientation;
        Point offset;

        DragWindow(Frame frame) {
            super(frame);
            this.orientation = BasicToolBarUI.this.toolBar.getOrientation();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }

        public Point getOffset() {
            return this.offset;
        }

        public void paint(Graphics graphics) {
            Color color = graphics.getColor();
            graphics.setColor(this.getBackground());
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.getBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(color);
            super.paint(graphics);
        }

        public void setBorderColor(Color color) {
            if (this.borderColor == color) {
                return;
            }
            this.borderColor = color;
            this.repaint();
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        public void setOrientation(int n) {
            if (this.isShowing()) {
                if (n == this.orientation) {
                    return;
                }
                this.orientation = n;
                Dimension dimension = this.getSize();
                this.setSize(new Dimension(dimension.height, dimension.width));
                if (this.offset != null) {
                    if (BasicGraphicsUtils.isLeftToRight(BasicToolBarUI.this.toolBar)) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (n == 0) {
                        this.setOffset(new Point(dimension.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, dimension.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }
    }
}

