/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.text.AbstractWriter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.Map;
import javax.swing.text.html.Option;
import javax.swing.text.html.OptionComboBoxModel;
import javax.swing.text.html.OptionListModel;
import javax.swing.text.html.StyleSheet;

public class HTMLWriter
extends AbstractWriter {
    private Stack blockElementStack = new Stack();
    private boolean inContent = false;
    private boolean inPre = false;
    private int preEndOffset;
    private boolean inTextArea = false;
    private boolean newlineOutputed = false;
    private boolean completeDoc;
    private Vector tags = new Vector(10);
    private Vector tagValues = new Vector(10);
    private char[] tempChars;
    private char[] indentChars;
    private Segment segment;
    private Vector tagsToRemove = new Vector(10);
    private boolean wroteHead;
    private Writer out;
    private int maxLineLength = 80;
    private int currLength;
    private int indentLevel = 0;
    private int indentSpace = 2;
    private int offsetIndent = 0;
    private String newline;
    private boolean isLineEmpty;
    private int startOffset;
    private int endOffset;
    private boolean indentNext = false;
    private boolean writeCSS = false;
    private MutableAttributeSet convAttr = new SimpleAttributeSet();
    private MutableAttributeSet oConvAttr = new SimpleAttributeSet();

    public HTMLWriter(Writer writer, HTMLDocument hTMLDocument) {
        this(writer, hTMLDocument, 0, hTMLDocument.getLength());
    }

    public HTMLWriter(Writer writer, HTMLDocument hTMLDocument, int n, int n2) {
        super(writer, hTMLDocument, n, n2);
        this.completeDoc = n == 0 && n2 == hTMLDocument.getLength();
        this.maxLineLength = 80;
        this.out = writer;
        Object object = hTMLDocument.getProperty("__EndOfLine__");
        if (object instanceof String) {
            this.newline = (String)object;
        } else {
            try {
                this.newline = System.getProperty("line.separator");
            }
            catch (SecurityException securityException) {}
            if (this.newline == null) {
                this.newline = "\n";
            }
        }
        this.startOffset = n;
        this.endOffset = n + n2;
    }

    protected void closeOutUnwantedEmbeddedTags(AttributeSet attributeSet) throws IOException {
        HTML.Tag tag;
        this.tagsToRemove.removeAllElements();
        attributeSet = this.convertToHTML(attributeSet, null);
        int n = -1;
        int n2 = this.tags.size();
        int n3 = n2 - 1;
        while (n3 >= 0) {
            tag = (HTML.Tag)this.tags.elementAt(n3);
            Object object = this.tagValues.elementAt(n3);
            if (attributeSet == null || this.noMatchForTagInAttributes(attributeSet, tag, object)) {
                n = n3;
                this.tagsToRemove.addElement(tag);
            }
            --n3;
        }
        if (n != -1) {
            boolean bl = n2 - n == this.tagsToRemove.size();
            int n4 = n2 - 1;
            while (n4 >= n) {
                tag = (HTML.Tag)this.tags.elementAt(n4);
                if (bl || this.tagsToRemove.contains(tag)) {
                    this.tags.removeElementAt(n4);
                    this.tagValues.removeElementAt(n4);
                }
                this.write('<');
                this.write('/');
                this.write(tag.toString());
                this.write('>');
                --n4;
            }
            n2 = this.tags.size();
            int n5 = n;
            while (n5 < n2) {
                tag = (HTML.Tag)this.tags.elementAt(n5);
                this.write('<');
                this.write(tag.toString());
                Object object = this.tagValues.elementAt(n5);
                if (object != null && object instanceof AttributeSet) {
                    this.writeAttributes((AttributeSet)object);
                }
                this.write('>');
                ++n5;
            }
        }
    }

    protected void comment(Element element) throws BadLocationException, IOException {
        AttributeSet attributeSet = element.getAttributes();
        if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
            Object object = attributeSet.getAttribute(HTML.Attribute.COMMENT);
            if (object instanceof String) {
                this.writeComment((String)object);
            } else {
                this.writeComment(null);
            }
        }
    }

    AttributeSet convertToHTML(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        if (mutableAttributeSet == null) {
            mutableAttributeSet = this.convAttr;
        }
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        if (this.writeCSS) {
            HTMLWriter.convertToHTML40(attributeSet, mutableAttributeSet);
        } else {
            HTMLWriter.convertToHTML32(attributeSet, mutableAttributeSet);
        }
        return mutableAttributeSet;
    }

    private static void convertToHTML32(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        if (attributeSet == null) {
            return;
        }
        Enumeration enumeration = attributeSet.getAttributeNames();
        String string = "";
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof CSS.Attribute) {
                Object object2;
                if (object == CSS.Attribute.FONT_FAMILY || object == CSS.Attribute.FONT_SIZE || object == CSS.Attribute.COLOR) {
                    HTMLWriter.createFontAttribute((CSS.Attribute)object, attributeSet, mutableAttributeSet);
                    continue;
                }
                if (object == CSS.Attribute.FONT_WEIGHT) {
                    object2 = (CSS.FontWeight)attributeSet.getAttribute(CSS.Attribute.FONT_WEIGHT);
                    if (object2 == null || ((CSS.FontWeight)object2).getValue() <= 400) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.B, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (object == CSS.Attribute.FONT_STYLE) {
                    object2 = attributeSet.getAttribute(object).toString();
                    if (((String)object2).indexOf("italic") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.I, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (object == CSS.Attribute.TEXT_DECORATION) {
                    object2 = attributeSet.getAttribute(object).toString();
                    if (((String)object2).indexOf("underline") >= 0) {
                        mutableAttributeSet.addAttribute(HTML.Tag.U, SimpleAttributeSet.EMPTY);
                    }
                    if (((String)object2).indexOf("line-through") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.STRIKE, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (object == CSS.Attribute.VERTICAL_ALIGN) {
                    object2 = attributeSet.getAttribute(object).toString();
                    if (((String)object2).indexOf("sup") >= 0) {
                        mutableAttributeSet.addAttribute(HTML.Tag.SUP, SimpleAttributeSet.EMPTY);
                    }
                    if (((String)object2).indexOf("sub") < 0) continue;
                    mutableAttributeSet.addAttribute(HTML.Tag.SUB, SimpleAttributeSet.EMPTY);
                    continue;
                }
                if (object == CSS.Attribute.TEXT_ALIGN) {
                    mutableAttributeSet.addAttribute(HTML.Attribute.ALIGN, attributeSet.getAttribute(object).toString());
                    continue;
                }
                if (string.length() > 0) {
                    string = String.valueOf(string) + "; ";
                }
                string = String.valueOf(string) + object + ": " + attributeSet.getAttribute(object);
                continue;
            }
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
        if (string.length() > 0) {
            mutableAttributeSet.addAttribute(HTML.Attribute.STYLE, string);
        }
    }

    private static void convertToHTML40(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        String string = "";
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof CSS.Attribute) {
                string = String.valueOf(string) + " " + object + "=" + attributeSet.getAttribute(object) + ";";
                continue;
            }
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
        if (string.length() > 0) {
            mutableAttributeSet.addAttribute(HTML.Attribute.STYLE, string);
        }
    }

    private static void createFontAttribute(CSS.Attribute attribute, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        MutableAttributeSet mutableAttributeSet2 = (MutableAttributeSet)mutableAttributeSet.getAttribute(HTML.Tag.FONT);
        if (mutableAttributeSet2 == null) {
            mutableAttributeSet2 = new SimpleAttributeSet();
            mutableAttributeSet.addAttribute(HTML.Tag.FONT, mutableAttributeSet2);
        }
        String string = attributeSet.getAttribute(attribute).toString();
        if (attribute == CSS.Attribute.FONT_FAMILY) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.FACE, string);
        } else if (attribute == CSS.Attribute.FONT_SIZE) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.SIZE, string);
        } else if (attribute == CSS.Attribute.COLOR) {
            mutableAttributeSet2.addAttribute(HTML.Attribute.COLOR, string);
        }
    }

    protected void decrIndent() {
        if (this.offsetIndent > 0) {
            --this.offsetIndent;
        } else {
            --this.indentLevel;
        }
    }

    protected void emptyTag(Element element) throws BadLocationException, IOException {
        if (!this.inContent && !this.inPre) {
            this.indent();
        }
        AttributeSet attributeSet = element.getAttributes();
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        this.writeEmbeddedTags(attributeSet);
        if (this.matchNameAttribute(attributeSet, HTML.Tag.CONTENT)) {
            this.inContent = true;
            this.text(element);
        } else if (this.matchNameAttribute(attributeSet, HTML.Tag.COMMENT)) {
            this.comment(element);
        } else {
            boolean bl = this.isBlockTag(element.getAttributes());
            if (this.inContent && bl) {
                this.writeNewline();
                this.indent();
            }
            Object object = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
            Object object2 = attributeSet != null ? attributeSet.getAttribute(HTML.Attribute.ENDTAG) : null;
            boolean bl2 = false;
            if (object != null && object2 != null && object2 instanceof String && ((String)object2).equals("true")) {
                bl2 = true;
            }
            if (this.completeDoc && this.matchNameAttribute(attributeSet, HTML.Tag.HEAD)) {
                if (bl2) {
                    this.writeStyles(((HTMLDocument)this.getDocument()).getStyleSheet());
                }
                this.wroteHead = true;
            }
            this.write('<');
            if (bl2) {
                this.write('/');
            }
            this.write(element.getName());
            this.writeAttributes(attributeSet);
            this.write('>');
            if (this.matchNameAttribute(attributeSet, HTML.Tag.TITLE) && !bl2) {
                Document document = element.getDocument();
                String string = (String)document.getProperty("title");
                this.write(string);
            } else if (!this.inContent || bl) {
                this.writeNewline();
                if (bl && this.inContent) {
                    this.indent();
                }
            }
        }
    }

    protected void endTag(Element element) throws IOException {
        if (this.synthesizedElement(element)) {
            return;
        }
        if (this.matchNameAttribute(element.getAttributes(), HTML.Tag.PRE)) {
            this.inPre = false;
        }
        this.closeOutUnwantedEmbeddedTags(element.getAttributes());
        if (this.inContent) {
            if (!this.newlineOutputed) {
                this.writeNewline();
            }
            this.newlineOutputed = false;
            this.inContent = false;
        }
        this.indent();
        this.write('<');
        this.write('/');
        this.write(element.getName());
        this.write('>');
        this.writeNewline();
    }

    protected void incrIndent() {
        if (this.offsetIndent > 0) {
            ++this.offsetIndent;
        } else if (++this.indentLevel * this.indentSpace >= this.maxLineLength) {
            ++this.offsetIndent;
            --this.indentLevel;
        }
    }

    protected void indent() throws IOException {
        int n = this.indentLevel * this.indentSpace;
        if (this.indentChars == null || n > this.indentChars.length) {
            this.indentChars = new char[n];
            int n2 = 0;
            while (n2 < n) {
                this.indentChars[n2] = 32;
                ++n2;
            }
        }
        this.out.write(this.indentChars, 0, n);
        this.currLength += n;
    }

    private boolean indentNeedsIncrementing(Element element, Element element2) {
        if (element2.getParentElement() == element && !this.inPre) {
            if (this.indentNext) {
                this.indentNext = false;
                return true;
            }
            if (this.synthesizedElement(element2)) {
                this.indentNext = true;
            } else if (!this.synthesizedElement(element)) {
                return true;
            }
        }
        return false;
    }

    private int indexOf(char[] cArray, char c, int n, int n2) {
        while (n < n2) {
            if (cArray[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected boolean isBlockTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag.isBlock();
        }
        return false;
    }

    private boolean isFormElementWithContent(AttributeSet attributeSet) {
        return this.matchNameAttribute(attributeSet, HTML.Tag.TEXTAREA) || this.matchNameAttribute(attributeSet, HTML.Tag.SELECT);
    }

    protected boolean matchNameAttribute(AttributeSet attributeSet, HTML.Tag tag) {
        HTML.Tag tag2;
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        return object instanceof HTML.Tag && (tag2 = (HTML.Tag)object) == tag;
    }

    private boolean noMatchForTagInAttributes(AttributeSet attributeSet, HTML.Tag tag, Object object) {
        block2: {
            block4: {
                boolean bl;
                block5: {
                    Object object2;
                    block3: {
                        if (attributeSet == null || !attributeSet.isDefined(tag)) break block2;
                        object2 = attributeSet.getAttribute(tag);
                        if (object != null) break block3;
                        if (object2 == null) break block4;
                        bl = false;
                        break block5;
                    }
                    if (object2 != null && object.equals(object2)) break block4;
                    bl = false;
                }
                if (!bl) break block2;
            }
            return false;
        }
        return true;
    }

    protected void selectContent(AttributeSet attributeSet) throws IOException {
        Object object = attributeSet.getAttribute(StyleConstants.ModelAttribute);
        this.incrIndent();
        if (object instanceof OptionListModel) {
            OptionListModel optionListModel = (OptionListModel)object;
            int n = optionListModel.getSize();
            int n2 = 0;
            while (n2 < n) {
                Option option = (Option)optionListModel.getElementAt(n2);
                this.writeOption(option);
                ++n2;
            }
        } else if (object instanceof OptionComboBoxModel) {
            OptionComboBoxModel optionComboBoxModel = (OptionComboBoxModel)object;
            int n = optionComboBoxModel.getSize();
            int n3 = 0;
            while (n3 < n) {
                Option option = (Option)optionComboBoxModel.getElementAt(n3);
                this.writeOption(option);
                ++n3;
            }
        }
        this.decrIndent();
    }

    protected void setIndentSpace(int n) {
        this.indentSpace = n;
    }

    protected void setLineLength(int n) {
        this.maxLineLength = n;
    }

    protected void startTag(Element element) throws IOException, BadLocationException {
        if (this.synthesizedElement(element)) {
            return;
        }
        AttributeSet attributeSet = element.getAttributes();
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        HTML.Tag tag = object instanceof HTML.Tag ? (HTML.Tag)object : null;
        if (tag == HTML.Tag.PRE) {
            this.inPre = true;
            this.preEndOffset = element.getEndOffset();
        }
        this.closeOutUnwantedEmbeddedTags(attributeSet);
        if (this.inContent) {
            this.writeNewline();
            this.inContent = false;
            this.newlineOutputed = false;
        }
        if (this.completeDoc && tag == HTML.Tag.BODY && !this.wroteHead) {
            this.wroteHead = true;
            this.indent();
            this.write("<head>");
            this.writeNewline();
            this.incrIndent();
            this.writeStyles(((HTMLDocument)this.getDocument()).getStyleSheet());
            this.decrIndent();
            this.writeNewline();
            this.indent();
            this.write("</head>");
            this.writeNewline();
        }
        this.indent();
        this.write('<');
        this.write(element.getName());
        this.writeAttributes(attributeSet);
        this.write('>');
        if (tag != HTML.Tag.PRE) {
            this.writeNewline();
        }
        if (tag == HTML.Tag.TEXTAREA) {
            this.textAreaContent(element.getAttributes());
        } else if (tag == HTML.Tag.SELECT) {
            this.selectContent(element.getAttributes());
        } else if (this.completeDoc && tag == HTML.Tag.BODY) {
            this.writeMaps(((HTMLDocument)this.getDocument()).getMaps());
        } else if (tag == HTML.Tag.HEAD) {
            this.wroteHead = true;
        }
    }

    protected boolean synthesizedElement(Element element) {
        return this.matchNameAttribute(element.getAttributes(), HTML.Tag.IMPLIED);
    }

    protected void text(Element element) throws BadLocationException, IOException {
        int n;
        int n2 = Math.max(this.startOffset, element.getStartOffset());
        if (n2 < (n = Math.min(this.endOffset, element.getEndOffset()))) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            this.getDocument().getText(n2, n - n2, this.segment);
            this.newlineOutputed = false;
            if (this.segment.count > 0) {
                if (this.segment.array[this.segment.offset + this.segment.count - 1] == '\n') {
                    this.newlineOutputed = true;
                }
                if (this.inPre && n == this.preEndOffset) {
                    if (this.segment.count > 1) {
                        --this.segment.count;
                    } else {
                        return;
                    }
                }
                this.write(this.segment.array, this.segment.offset, this.segment.count, this.inPre ^ true, true);
            }
        }
    }

    protected void textAreaContent(AttributeSet attributeSet) throws BadLocationException, IOException {
        Document document = (Document)attributeSet.getAttribute(StyleConstants.ModelAttribute);
        if (document != null && document.getLength() > 0) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            document.getText(0, document.getLength(), this.segment);
            if (this.segment.count > 0) {
                this.inTextArea = true;
                this.incrIndent();
                this.indent();
                this.write(this.segment.array, this.segment.offset, this.segment.count, true, true);
                this.writeNewline();
                this.inTextArea = false;
                this.decrIndent();
            }
        }
    }

    public void write() throws IOException, BadLocationException {
        ElementIterator elementIterator = this.getElementIterator();
        Element element = null;
        Element element2 = null;
        this.wroteHead = false;
        this.tempChars = null;
        this.currLength = 0;
        this.isLineEmpty = true;
        if (this.segment == null) {
            this.segment = new Segment();
        }
        this.inPre = false;
        while ((element2 = elementIterator.next()) != null) {
            if (!this.inRange(element2)) continue;
            if (element != null) {
                Element element3;
                if (this.indentNeedsIncrementing(element, element2)) {
                    this.incrIndent();
                } else if (element.getParentElement() != element2.getParentElement()) {
                    element3 = (Element)this.blockElementStack.peek();
                    while (element3 != element2.getParentElement()) {
                        this.blockElementStack.pop();
                        if (!this.synthesizedElement(element3)) {
                            if (!this.matchNameAttribute(element3.getAttributes(), HTML.Tag.PRE)) {
                                this.decrIndent();
                            }
                            this.endTag(element3);
                        }
                        element3 = (Element)this.blockElementStack.peek();
                    }
                } else if (element.getParentElement() == element2.getParentElement() && (element3 = (Element)this.blockElementStack.peek()) == element) {
                    this.blockElementStack.pop();
                    this.endTag(element3);
                }
            }
            if (!element2.isLeaf() || this.isFormElementWithContent(element2.getAttributes())) {
                this.blockElementStack.push(element2);
                this.startTag(element2);
            } else {
                this.emptyTag(element2);
            }
            element = element2;
        }
        this.closeOutUnwantedEmbeddedTags(null);
        while (!this.blockElementStack.empty()) {
            element = (Element)this.blockElementStack.pop();
            if (this.synthesizedElement(element)) continue;
            if (!this.matchNameAttribute(element.getAttributes(), HTML.Tag.PRE)) {
                this.decrIndent();
            }
            this.endTag(element);
        }
        if (this.completeDoc) {
            this.writeAdditionalComments();
        }
        this.segment.array = null;
    }

    protected void write(char c) throws IOException {
        this.write(c, false);
    }

    private void write(char c, boolean bl) throws IOException {
        if (c == '\n') {
            this.currLength = 0;
            this.out.write(this.newline);
            this.isLineEmpty = true;
        } else {
            this.isLineEmpty = false;
            this.out.write(c);
            ++this.currLength;
            if (bl && this.currLength >= this.maxLineLength) {
                this.writeNewline();
            }
        }
    }

    protected void write(String string) throws IOException {
        this.write(string, false);
    }

    private void write(String string, boolean bl) throws IOException {
        int n = string.length();
        if (this.tempChars == null || this.tempChars.length < n) {
            this.tempChars = new char[n];
        }
        string.getChars(0, n, this.tempChars, 0);
        this.write(this.tempChars, 0, n, bl, bl);
    }

    private void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        this.isLineEmpty = false;
        n2 += n;
        int n4 = n;
        while (n4 < n2) {
            switch (cArray[n4]) {
                case '<': {
                    if (n4 > n3) {
                        this.out.write(cArray, n3, n4 - n3);
                    }
                    n3 = n4 + 1;
                    this.out.write("&lt;");
                    break;
                }
                case '>': {
                    if (n4 > n3) {
                        this.out.write(cArray, n3, n4 - n3);
                    }
                    n3 = n4 + 1;
                    this.out.write("&gt;");
                    break;
                }
                case '&': {
                    if (n4 > n3) {
                        this.out.write(cArray, n3, n4 - n3);
                    }
                    n3 = n4 + 1;
                    this.out.write("&amp;");
                    break;
                }
                case '\"': {
                    if (n4 > n3) {
                        this.out.write(cArray, n3, n4 - n3);
                    }
                    n3 = n4 + 1;
                    this.out.write("&quot;");
                    break;
                }
                default: {
                    if (cArray[n4] >= ' ' && cArray[n4] <= '\u007f') break;
                    if (n4 > n3) {
                        this.out.write(cArray, n3, n4 - n3);
                    }
                    n3 = n4 + 1;
                    this.out.write("&#");
                    this.out.write(String.valueOf((int)cArray[n4]));
                    this.out.write(59);
                }
                case '\t': 
                case '\n': 
                case '\r': 
            }
            ++n4;
        }
        if (n3 < n2) {
            this.out.write(cArray, n3, n2 - n3);
        }
    }

    private void write(char[] cArray, int n, int n2, boolean bl, boolean bl2) throws IOException {
        if (!bl) {
            int n3 = n;
            int n4 = n + n2;
            int n5 = this.indexOf(cArray, '\n', n, n4);
            while (n5 != -1) {
                if (n5 > n3) {
                    if (bl2) {
                        this.write(cArray, n3, n5 - n3);
                    } else {
                        this.out.write(cArray, n3, n5 - n3);
                    }
                }
                this.writeNewline();
                n3 = n5 + 1;
                n5 = this.indexOf(cArray, '\n', n3, n4);
            }
            if (n3 < n4) {
                this.currLength += n4 - n3;
                if (bl2) {
                    this.write(cArray, n3, n4 - n3);
                } else {
                    this.out.write(cArray, n3, n4 - n3);
                }
            }
        } else {
            int n6 = n;
            int n7 = n + n2;
            if (this.currLength >= this.maxLineLength && !this.isLineEmpty) {
                this.writeNewline();
            }
            while (n6 < n7) {
                int n8 = this.indexOf(cArray, '\n', n6, n7);
                boolean bl3 = false;
                if (n8 != -1 && this.currLength + (n8 - n6) < this.maxLineLength) {
                    if (n8 > n6) {
                        this.write(cArray, n6, n8 - n6);
                    }
                    n6 = n8 + 1;
                    bl3 = true;
                } else if (n8 == -1 && this.currLength + (n7 - n6) < this.maxLineLength) {
                    if (n7 > n6) {
                        this.write(cArray, n6, n7 - n6);
                    }
                    this.currLength += n7 - n6;
                    n6 = n7;
                } else {
                    int n9 = -1;
                    int n10 = Math.min(n7 - n6, this.maxLineLength - this.currLength - 1);
                    int n11 = 0;
                    while (n11 < n10) {
                        if (Character.isWhitespace(cArray[n11 + n6])) {
                            n9 = n11;
                        }
                        ++n11;
                    }
                    if (n9 != -1) {
                        this.write(cArray, n6, (n9 += n6 + 1) - n6);
                        n6 = n9;
                    } else if (this.isLineEmpty) {
                        n11 = Math.max(0, n10);
                        n10 = n7 - n6;
                        while (n11 < n10) {
                            if (Character.isWhitespace(cArray[n11 + n6])) {
                                n9 = n11;
                                break;
                            }
                            ++n11;
                        }
                        if (n9 == -1) {
                            this.write(cArray, n6, n7 - n6);
                            n9 = n7;
                        } else if (cArray[n9 += n6] == '\n') {
                            this.write(cArray, n6, n9++ - n6);
                        } else {
                            this.write(cArray, n6, ++n9 - n6);
                        }
                        n6 = n9;
                    }
                    bl3 = true;
                }
                if (!bl3 && n6 >= n7) continue;
                this.writeNewline();
                if (n6 >= n7) continue;
                this.indent();
            }
        }
    }

    void writeAdditionalComments() throws IOException {
        Object object = this.getDocument().getProperty("AdditionalComments");
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                this.writeComment(vector.elementAt(n).toString());
                ++n;
            }
        }
    }

    protected void writeAttributes(AttributeSet attributeSet) throws IOException {
        this.convAttr.removeAttributes(this.convAttr);
        HTMLWriter.convertToHTML32(attributeSet, this.convAttr);
        Enumeration enumeration = this.convAttr.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Tag || object instanceof StyleConstants || object == HTML.Attribute.ENDTAG) continue;
            this.write(" " + object + "=\"" + this.convAttr.getAttribute(object) + "\"");
        }
    }

    void writeComment(String string) throws IOException {
        this.write("<!--");
        if (string != null) {
            this.write(string);
        }
        this.write("-->");
        this.writeNewline();
    }

    protected void writeEmbeddedTags(AttributeSet attributeSet) throws IOException {
        attributeSet = this.convertToHTML(attributeSet, this.oConvAttr);
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            HTML.Tag tag;
            Object object = enumeration.nextElement();
            if (!(object instanceof HTML.Tag) || (tag = (HTML.Tag)object) == HTML.Tag.FORM || this.tags.contains(tag)) continue;
            this.write('<');
            this.write(tag.toString());
            Object object2 = attributeSet.getAttribute(tag);
            if (object2 != null && object2 instanceof AttributeSet) {
                this.writeAttributes((AttributeSet)object2);
            }
            this.write('>');
            this.tags.addElement(tag);
            this.tagValues.addElement(object2);
        }
    }

    void writeMaps(Enumeration enumeration) throws IOException {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Map map = (Map)enumeration.nextElement();
                String string = map.getName();
                this.incrIndent();
                this.indent();
                this.write("<map");
                if (string != null) {
                    this.write(" name=\"");
                    this.write(string);
                    this.write("\">");
                } else {
                    this.write('>');
                }
                this.writeNewline();
                this.incrIndent();
                AttributeSet[] attributeSetArray = map.getAreas();
                if (attributeSetArray != null) {
                    int n = 0;
                    int n2 = attributeSetArray.length;
                    while (n < n2) {
                        this.indent();
                        this.write("<area");
                        this.writeAttributes(attributeSetArray[n]);
                        this.write("></area>");
                        this.writeNewline();
                        ++n;
                    }
                }
                this.decrIndent();
                this.indent();
                this.write("</map>");
                this.writeNewline();
                this.decrIndent();
            }
        }
    }

    private void writeNewline() throws IOException {
        this.out.write(this.newline);
        this.isLineEmpty = true;
        this.currLength = 0;
    }

    protected void writeOption(Option option) throws IOException {
        this.indent();
        this.write('<');
        this.write("option ");
        if (option.getValue() != null) {
            this.write("value=" + option.getValue());
        }
        if (option.isSelected()) {
            this.write(" selected");
        }
        this.write('>');
        if (option.getLabel() != null) {
            this.write(option.getLabel());
        }
        this.writeNewline();
    }

    boolean writeStyle(String string, Style style, boolean bl) throws IOException {
        boolean bl2 = false;
        Enumeration enumeration = style.getAttributeNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string2;
                Object object = enumeration.nextElement();
                if (!(object instanceof CSS.Attribute) || (string2 = style.getAttribute(object).toString()) == null) continue;
                if (!bl) {
                    this.writeStyleStartTag();
                    bl = true;
                }
                if (!bl2) {
                    bl2 = true;
                    this.indent();
                    this.write(string);
                    this.write(" {");
                } else {
                    this.write(";");
                }
                this.write(' ');
                this.write(object.toString());
                this.write(": ");
                this.write(string2);
            }
        }
        if (bl2) {
            this.write(" }");
            this.writeNewline();
        }
        return bl2;
    }

    void writeStyleEndTag() throws IOException {
        this.decrIndent();
        this.indent();
        this.write("-->");
        this.writeNewline();
        this.decrIndent();
        this.indent();
        this.write("</style>");
        this.writeNewline();
        this.indent();
    }

    void writeStyleStartTag() throws IOException {
        this.indent();
        this.write("<style type=\"text/css\">");
        this.incrIndent();
        this.writeNewline();
        this.indent();
        this.write("<!--");
        this.incrIndent();
        this.writeNewline();
    }

    void writeStyles(StyleSheet styleSheet) throws IOException {
        Enumeration enumeration;
        if (styleSheet != null && (enumeration = styleSheet.getStyleNames()) != null) {
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if ("default".equals(string) || !this.writeStyle(string, styleSheet.getStyle(string), bl)) continue;
                bl = true;
            }
            if (bl) {
                this.writeStyleEndTag();
            }
        }
    }
}

