/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.audio.AudioAiffInputStream;
import sun.audio.AudioAuInputStream;
import sun.audio.AudioDataStream;
import sun.audio.AudioFormat;
import sun.audio.AudioMidiInputStream;
import sun.audio.AudioRmfInputStream;
import sun.audio.AudioStream;
import sun.audio.AudioWavInputStream;
import sun.audio.BadAudioHeaderException;
import sun.audio.Format;
import sun.audio.HaeDevice;
import sun.audio.HaeException;
import sun.audio.HaeMixer;
import sun.audio.MediaInputStream;
import sun.audio.NativeAudioStream;

class AudioContainerInputStream
extends MediaInputStream {
    protected boolean DEBUG = false;
    static final int MIDI_MAGIC = 1297377380;
    static final int AIFF_MAGIC = 1179603533;
    static final int RMF_MAGIC = 1230128474;
    static final int RIFF_MAGIC = 1380533830;
    static final int WAV_MAGIC = 1463899717;
    static final int AU_SUN_MAGIC = 779316836;
    static final int AU_DEC_MAGIC = 779314176;
    static final int AU_SUN_INV_MAGIC = 1684960046;
    static final int AU_DEC_INV_MAGIC = 6583086;
    static final int[] ULAW_TABH;
    static final int[] ULAW_TABL;
    AudioFormat f;
    AudioFormat fout;
    private boolean streamFinished = false;
    boolean processBytes = false;
    boolean swapBytes = false;
    boolean convertFromUlaw = false;
    boolean convertUnsigned = false;
    boolean mixerBigEndian = false;
    InputStream stream;
    static final int MAX_HEADER_SIZE = 12;
    protected int totalBytes = 0;
    protected int totalFrames = 0;
    protected int currentFrame = 0;
    protected int headerSize = 0;

    static {
        int[] nArray = new int[256];
        nArray[0] = 130;
        nArray[1] = 134;
        nArray[2] = 138;
        nArray[3] = 142;
        nArray[4] = 146;
        nArray[5] = 150;
        nArray[6] = 154;
        nArray[7] = 158;
        nArray[8] = 162;
        nArray[9] = 166;
        nArray[10] = 170;
        nArray[11] = 174;
        nArray[12] = 178;
        nArray[13] = 182;
        nArray[14] = 186;
        nArray[15] = 190;
        nArray[16] = 193;
        nArray[17] = 195;
        nArray[18] = 197;
        nArray[19] = 199;
        nArray[20] = 201;
        nArray[21] = 203;
        nArray[22] = 205;
        nArray[23] = 207;
        nArray[24] = 209;
        nArray[25] = 211;
        nArray[26] = 213;
        nArray[27] = 215;
        nArray[28] = 217;
        nArray[29] = 219;
        nArray[30] = 221;
        nArray[31] = 223;
        nArray[32] = 224;
        nArray[33] = 225;
        nArray[34] = 226;
        nArray[35] = 227;
        nArray[36] = 228;
        nArray[37] = 229;
        nArray[38] = 230;
        nArray[39] = 231;
        nArray[40] = 232;
        nArray[41] = 233;
        nArray[42] = 234;
        nArray[43] = 235;
        nArray[44] = 236;
        nArray[45] = 237;
        nArray[46] = 238;
        nArray[47] = 239;
        nArray[48] = 240;
        nArray[49] = 241;
        nArray[50] = 241;
        nArray[51] = 242;
        nArray[52] = 242;
        nArray[53] = 243;
        nArray[54] = 243;
        nArray[55] = 244;
        nArray[56] = 244;
        nArray[57] = 245;
        nArray[58] = 245;
        nArray[59] = 246;
        nArray[60] = 246;
        nArray[61] = 247;
        nArray[62] = 247;
        nArray[63] = 248;
        nArray[64] = 248;
        nArray[65] = 248;
        nArray[66] = 249;
        nArray[67] = 249;
        nArray[68] = 249;
        nArray[69] = 249;
        nArray[70] = 250;
        nArray[71] = 250;
        nArray[72] = 250;
        nArray[73] = 250;
        nArray[74] = 251;
        nArray[75] = 251;
        nArray[76] = 251;
        nArray[77] = 251;
        nArray[78] = 252;
        nArray[79] = 252;
        nArray[80] = 252;
        nArray[81] = 252;
        nArray[82] = 252;
        nArray[83] = 252;
        nArray[84] = 253;
        nArray[85] = 253;
        nArray[86] = 253;
        nArray[87] = 253;
        nArray[88] = 253;
        nArray[89] = 253;
        nArray[90] = 253;
        nArray[91] = 253;
        nArray[92] = 254;
        nArray[93] = 254;
        nArray[94] = 254;
        nArray[95] = 254;
        nArray[96] = 254;
        nArray[97] = 254;
        nArray[98] = 254;
        nArray[99] = 254;
        nArray[100] = 254;
        nArray[101] = 254;
        nArray[102] = 254;
        nArray[103] = 254;
        nArray[104] = 255;
        nArray[105] = 255;
        nArray[106] = 255;
        nArray[107] = 255;
        nArray[108] = 255;
        nArray[109] = 255;
        nArray[110] = 255;
        nArray[111] = 255;
        nArray[112] = 255;
        nArray[113] = 255;
        nArray[114] = 255;
        nArray[115] = 255;
        nArray[116] = 255;
        nArray[117] = 255;
        nArray[118] = 255;
        nArray[119] = 255;
        nArray[120] = 255;
        nArray[121] = 255;
        nArray[122] = 255;
        nArray[123] = 255;
        nArray[124] = 255;
        nArray[125] = 255;
        nArray[126] = 255;
        nArray[128] = 126;
        nArray[129] = 121;
        nArray[130] = 117;
        nArray[131] = 113;
        nArray[132] = 109;
        nArray[133] = 105;
        nArray[134] = 101;
        nArray[135] = 97;
        nArray[136] = 93;
        nArray[137] = 89;
        nArray[138] = 85;
        nArray[139] = 81;
        nArray[140] = 77;
        nArray[141] = 73;
        nArray[142] = 69;
        nArray[143] = 65;
        nArray[144] = 62;
        nArray[145] = 60;
        nArray[146] = 58;
        nArray[147] = 56;
        nArray[148] = 54;
        nArray[149] = 52;
        nArray[150] = 50;
        nArray[151] = 48;
        nArray[152] = 46;
        nArray[153] = 44;
        nArray[154] = 42;
        nArray[155] = 40;
        nArray[156] = 38;
        nArray[157] = 36;
        nArray[158] = 34;
        nArray[159] = 32;
        nArray[160] = 31;
        nArray[161] = 30;
        nArray[162] = 29;
        nArray[163] = 28;
        nArray[164] = 27;
        nArray[165] = 26;
        nArray[166] = 25;
        nArray[167] = 24;
        nArray[168] = 23;
        nArray[169] = 22;
        nArray[170] = 21;
        nArray[171] = 20;
        nArray[172] = 19;
        nArray[173] = 18;
        nArray[174] = 17;
        nArray[175] = 16;
        nArray[176] = 15;
        nArray[177] = 14;
        nArray[178] = 14;
        nArray[179] = 13;
        nArray[180] = 13;
        nArray[181] = 12;
        nArray[182] = 12;
        nArray[183] = 11;
        nArray[184] = 11;
        nArray[185] = 10;
        nArray[186] = 10;
        nArray[187] = 9;
        nArray[188] = 9;
        nArray[189] = 8;
        nArray[190] = 8;
        nArray[191] = 7;
        nArray[192] = 7;
        nArray[193] = 7;
        nArray[194] = 6;
        nArray[195] = 6;
        nArray[196] = 6;
        nArray[197] = 6;
        nArray[198] = 5;
        nArray[199] = 5;
        nArray[200] = 5;
        nArray[201] = 5;
        nArray[202] = 4;
        nArray[203] = 4;
        nArray[204] = 4;
        nArray[205] = 4;
        nArray[206] = 3;
        nArray[207] = 3;
        nArray[208] = 3;
        nArray[209] = 3;
        nArray[210] = 3;
        nArray[211] = 3;
        nArray[212] = 2;
        nArray[213] = 2;
        nArray[214] = 2;
        nArray[215] = 2;
        nArray[216] = 2;
        nArray[217] = 2;
        nArray[218] = 2;
        nArray[219] = 2;
        nArray[220] = 1;
        nArray[221] = 1;
        nArray[222] = 1;
        nArray[223] = 1;
        nArray[224] = 1;
        nArray[225] = 1;
        nArray[226] = 1;
        nArray[227] = 1;
        nArray[228] = 1;
        nArray[229] = 1;
        nArray[230] = 1;
        nArray[231] = 1;
        ULAW_TABH = nArray;
        int[] nArray2 = new int[256];
        nArray2[1] = 4;
        nArray2[2] = 8;
        nArray2[3] = 12;
        nArray2[4] = 17;
        nArray2[5] = 21;
        nArray2[6] = 25;
        nArray2[7] = 29;
        nArray2[8] = 33;
        nArray2[9] = 38;
        nArray2[10] = 42;
        nArray2[11] = 46;
        nArray2[12] = 50;
        nArray2[13] = 55;
        nArray2[14] = 59;
        nArray2[15] = 63;
        nArray2[16] = 66;
        nArray2[17] = 68;
        nArray2[18] = 71;
        nArray2[19] = 73;
        nArray2[20] = 75;
        nArray2[21] = 77;
        nArray2[22] = 79;
        nArray2[23] = 81;
        nArray2[24] = 83;
        nArray2[25] = 85;
        nArray2[26] = 88;
        nArray2[27] = 90;
        nArray2[28] = 92;
        nArray2[29] = 94;
        nArray2[30] = 96;
        nArray2[31] = 98;
        nArray2[32] = 228;
        nArray2[33] = 229;
        nArray2[34] = 230;
        nArray2[35] = 231;
        nArray2[36] = 232;
        nArray2[37] = 233;
        nArray2[38] = 234;
        nArray2[39] = 235;
        nArray2[40] = 236;
        nArray2[41] = 237;
        nArray2[42] = 238;
        nArray2[43] = 239;
        nArray2[44] = 240;
        nArray2[45] = 241;
        nArray2[46] = 243;
        nArray2[47] = 244;
        nArray2[48] = 180;
        nArray2[49] = 53;
        nArray2[50] = 181;
        nArray2[51] = 54;
        nArray2[52] = 182;
        nArray2[53] = 55;
        nArray2[54] = 184;
        nArray2[55] = 56;
        nArray2[56] = 185;
        nArray2[57] = 57;
        nArray2[58] = 186;
        nArray2[59] = 58;
        nArray2[60] = 187;
        nArray2[61] = 59;
        nArray2[62] = 188;
        nArray2[63] = 60;
        nArray2[64] = 157;
        nArray2[65] = 221;
        nArray2[66] = 29;
        nArray2[67] = 94;
        nArray2[68] = 158;
        nArray2[69] = 222;
        nArray2[70] = 30;
        nArray2[71] = 95;
        nArray2[72] = 159;
        nArray2[73] = 223;
        nArray2[74] = 31;
        nArray2[75] = 96;
        nArray2[76] = 160;
        nArray2[77] = 224;
        nArray2[78] = 32;
        nArray2[79] = 97;
        nArray2[80] = 145;
        nArray2[81] = 177;
        nArray2[82] = 209;
        nArray2[83] = 241;
        nArray2[84] = 17;
        nArray2[85] = 50;
        nArray2[86] = 82;
        nArray2[87] = 114;
        nArray2[88] = 146;
        nArray2[89] = 178;
        nArray2[90] = 210;
        nArray2[91] = 242;
        nArray2[92] = 18;
        nArray2[93] = 51;
        nArray2[94] = 83;
        nArray2[95] = 115;
        nArray2[96] = 139;
        nArray2[97] = 155;
        nArray2[98] = 171;
        nArray2[99] = 187;
        nArray2[100] = 203;
        nArray2[101] = 219;
        nArray2[102] = 235;
        nArray2[103] = 251;
        nArray2[104] = 11;
        nArray2[105] = 28;
        nArray2[106] = 44;
        nArray2[107] = 60;
        nArray2[108] = 76;
        nArray2[109] = 92;
        nArray2[110] = 108;
        nArray2[111] = 124;
        nArray2[112] = 136;
        nArray2[113] = 144;
        nArray2[114] = 152;
        nArray2[115] = 160;
        nArray2[116] = 168;
        nArray2[117] = 176;
        nArray2[118] = 184;
        nArray2[119] = 192;
        nArray2[120] = 200;
        nArray2[121] = 208;
        nArray2[122] = 216;
        nArray2[123] = 224;
        nArray2[124] = 232;
        nArray2[125] = 240;
        nArray2[126] = 248;
        nArray2[129] = 252;
        nArray2[130] = 248;
        nArray2[131] = 244;
        nArray2[132] = 239;
        nArray2[133] = 235;
        nArray2[134] = 231;
        nArray2[135] = 227;
        nArray2[136] = 223;
        nArray2[137] = 218;
        nArray2[138] = 214;
        nArray2[139] = 210;
        nArray2[140] = 206;
        nArray2[141] = 201;
        nArray2[142] = 197;
        nArray2[143] = 193;
        nArray2[144] = 190;
        nArray2[145] = 188;
        nArray2[146] = 185;
        nArray2[147] = 183;
        nArray2[148] = 181;
        nArray2[149] = 179;
        nArray2[150] = 177;
        nArray2[151] = 175;
        nArray2[152] = 173;
        nArray2[153] = 171;
        nArray2[154] = 168;
        nArray2[155] = 166;
        nArray2[156] = 164;
        nArray2[157] = 162;
        nArray2[158] = 160;
        nArray2[159] = 158;
        nArray2[160] = 28;
        nArray2[161] = 27;
        nArray2[162] = 26;
        nArray2[163] = 25;
        nArray2[164] = 24;
        nArray2[165] = 23;
        nArray2[166] = 22;
        nArray2[167] = 21;
        nArray2[168] = 20;
        nArray2[169] = 19;
        nArray2[170] = 18;
        nArray2[171] = 17;
        nArray2[172] = 16;
        nArray2[173] = 15;
        nArray2[174] = 13;
        nArray2[175] = 12;
        nArray2[176] = 76;
        nArray2[177] = 203;
        nArray2[178] = 75;
        nArray2[179] = 202;
        nArray2[180] = 74;
        nArray2[181] = 201;
        nArray2[182] = 72;
        nArray2[183] = 200;
        nArray2[184] = 71;
        nArray2[185] = 199;
        nArray2[186] = 70;
        nArray2[187] = 198;
        nArray2[188] = 69;
        nArray2[189] = 197;
        nArray2[190] = 68;
        nArray2[191] = 196;
        nArray2[192] = 99;
        nArray2[193] = 35;
        nArray2[194] = 227;
        nArray2[195] = 162;
        nArray2[196] = 98;
        nArray2[197] = 34;
        nArray2[198] = 226;
        nArray2[199] = 161;
        nArray2[200] = 97;
        nArray2[201] = 33;
        nArray2[202] = 225;
        nArray2[203] = 160;
        nArray2[204] = 96;
        nArray2[205] = 32;
        nArray2[206] = 224;
        nArray2[207] = 159;
        nArray2[208] = 111;
        nArray2[209] = 79;
        nArray2[210] = 47;
        nArray2[211] = 15;
        nArray2[212] = 239;
        nArray2[213] = 206;
        nArray2[214] = 174;
        nArray2[215] = 142;
        nArray2[216] = 110;
        nArray2[217] = 78;
        nArray2[218] = 46;
        nArray2[219] = 14;
        nArray2[220] = 238;
        nArray2[221] = 205;
        nArray2[222] = 173;
        nArray2[223] = 141;
        nArray2[224] = 117;
        nArray2[225] = 101;
        nArray2[226] = 85;
        nArray2[227] = 69;
        nArray2[228] = 53;
        nArray2[229] = 37;
        nArray2[230] = 21;
        nArray2[231] = 5;
        nArray2[232] = 245;
        nArray2[233] = 228;
        nArray2[234] = 212;
        nArray2[235] = 196;
        nArray2[236] = 180;
        nArray2[237] = 164;
        nArray2[238] = 148;
        nArray2[239] = 132;
        nArray2[240] = 120;
        nArray2[241] = 112;
        nArray2[242] = 104;
        nArray2[243] = 96;
        nArray2[244] = 88;
        nArray2[245] = 80;
        nArray2[246] = 72;
        nArray2[247] = 64;
        nArray2[248] = 56;
        nArray2[249] = 48;
        nArray2[250] = 40;
        nArray2[251] = 32;
        nArray2[252] = 24;
        nArray2[253] = 16;
        nArray2[254] = 8;
        ULAW_TABL = nArray2;
    }

    AudioContainerInputStream(AudioFormat audioFormat, InputStream inputStream) throws BadAudioHeaderException {
        super(inputStream);
        this.stream = inputStream;
        if (audioFormat == null || audioFormat.getEncoding() == null) {
            throw new BadAudioHeaderException("invalid format object");
        }
        this.setFormat(audioFormat);
        this.setupConversions();
    }

    protected AudioContainerInputStream(byte[] byArray, InputStream inputStream) throws IOException, BadAudioHeaderException {
        super(inputStream);
        this.stream = inputStream;
        AudioFormat audioFormat = this.readFormat(byArray);
        this.setFormat(audioFormat);
        this.setupConversions();
    }

    byte[] getBytes() {
        if (!(this.stream instanceof ByteArrayInputStream)) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.stream;
        byte[] byArray = null;
        InputStream inputStream = this.stream;
        synchronized (inputStream) {
            int n = byteArrayInputStream.available();
            byteArrayInputStream.reset();
            int n2 = byteArrayInputStream.available();
            byArray = new byte[n2];
            byteArrayInputStream.read(byArray, 0, byArray.length);
            byteArrayInputStream.reset();
            byteArrayInputStream.skip(n2 - n);
        }
        return byArray;
    }

    int getConvertedData(byte[] byArray, int n) throws IOException {
        int n2;
        int n3;
        if (this.f == null) {
            return 0;
        }
        if (byArray == null || n <= 0) {
            return 0;
        }
        int n4 = this.f.getSampleSize() * this.f.getChannels();
        int n5 = this.fout.getSampleSize() * this.fout.getChannels();
        if (n * n5 > byArray.length) {
            n = byArray.length / n5;
        }
        int n6 = n3 = n * n5;
        int n7 = 0;
        if (this.convertFromUlaw) {
            n7 = n3 / 2;
            n6 /= 2;
        }
        int n8 = 0;
        int n9 = 0;
        while ((n8 = this.stream.read(byArray, n7, n6)) > 0) {
            n9 += n8;
            n7 += n8;
            if ((n6 -= n8) != 0 && this.stream.available() != 0) continue;
        }
        if (n8 == -1) {
            this.streamFinished = true;
        }
        if (n9 == 0) {
            return 0;
        }
        if (this.processBytes) {
            n2 = 0;
            if (this.swapBytes) {
                while (n2 < n3) {
                    byte by = byArray[n2];
                    byte by2 = byArray[n2 + 1];
                    if (this.convertUnsigned) {
                        by = by >= 0 ? (byte)(0x80 | by) : (byte)(0x7F & by);
                        by2 = by2 >= 0 ? (byte)(0x80 | by2) : (byte)(0x7F & by2);
                    }
                    byArray[n2] = by2;
                    byArray[n2 + 1] = by;
                    n2 += 2;
                }
            } else if (this.convertFromUlaw) {
                boolean bl = this.mixerBigEndian;
                int[] nArray = ULAW_TABL;
                int[] nArray2 = ULAW_TABH;
                n7 = n3 / 2;
                while (n7 < n3) {
                    byArray[n2] = bl ? (byte)nArray2[byArray[n7] & 0xFF] : (byte)nArray[byArray[n7] & 0xFF];
                    byArray[n2 + 1] = bl ? (byte)nArray[byArray[n7] & 0xFF] : (byte)nArray2[byArray[n7] & 0xFF];
                    n2 += 2;
                    ++n7;
                }
            } else if (this.convertUnsigned) {
                while (n2 < n3) {
                    byte by = byArray[n2];
                    byArray[n2] = by >= 0 ? (byte)(0x80 | by) : (byte)(0x7F & by);
                    ++n2;
                }
            }
        }
        n2 = n9 / n4;
        this.updateCurrentFrame(n2);
        return n2;
    }

    int getCurrentFrame() {
        return this.currentFrame;
    }

    public long getDataPos() {
        return 0L;
    }

    public Format[] getFormat() {
        Format[] formatArray = new Format[]{this.f};
        return formatArray;
    }

    AudioFormat getInputFormat() {
        return this.f;
    }

    AudioFormat getOutputFormat() {
        return this.fout;
    }

    int getRemainingFrames() {
        return this.totalFrames - this.currentFrame;
    }

    static AudioContainerInputStream getStream(InputStream inputStream) throws IOException, BadAudioHeaderException {
        AudioContainerInputStream audioContainerInputStream;
        if (inputStream instanceof AudioContainerInputStream) {
            return (AudioContainerInputStream)inputStream;
        }
        if (inputStream instanceof AudioStream) {
            return ((AudioStream)inputStream).acis;
        }
        if (inputStream instanceof AudioDataStream) {
            return ((AudioDataStream)inputStream).acis;
        }
        if (inputStream instanceof NativeAudioStream) {
            return ((NativeAudioStream)inputStream).acis;
        }
        inputStream.mark(12);
        byte[] byArray = new byte[4];
        int n = inputStream.read(byArray);
        int n2 = (byArray[0] << 24) + (byArray[1] << 16) + (byArray[2] << 8) + byArray[3];
        switch (n2) {
            case 1297377380: {
                audioContainerInputStream = new AudioMidiInputStream(byArray, inputStream);
                break;
            }
            case 1179603533: {
                audioContainerInputStream = new AudioAiffInputStream(byArray, inputStream);
                break;
            }
            case 1230128474: {
                audioContainerInputStream = new AudioRmfInputStream(byArray, inputStream);
                break;
            }
            case 6583086: 
            case 779314176: 
            case 779316836: 
            case 1684960046: {
                audioContainerInputStream = new AudioAuInputStream(byArray, inputStream);
                break;
            }
            case 1380533830: {
                byte[] byArray2 = new byte[12];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                n += inputStream.read(byArray2, n, 8);
                int n3 = (byArray2[8] << 24) + (byArray2[9] << 16) + (byArray2[10] << 8) + byArray2[11];
                if (n3 == 1463899717) {
                    audioContainerInputStream = new AudioWavInputStream(byArray2, inputStream);
                    break;
                }
                byArray = byArray2;
            }
            default: {
                try {
                    inputStream.reset();
                    throw new BadAudioHeaderException("Unknown header");
                }
                catch (IOException iOException) {
                    throw new BadAudioHeaderException("Unknownheader", byArray);
                }
            }
        }
        return audioContainerInputStream;
    }

    int getTotalBytes() {
        return this.totalBytes;
    }

    int getTotalFrames() {
        return this.totalFrames;
    }

    boolean readAllBytes() throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        int n = 2048;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        int n3 = 0;
        if (this.stream instanceof ByteArrayInputStream) {
            return true;
        }
        try {
            while (true) {
                if ((n3 = this.in.read(byArray2, 0, n)) == -1) {
                    if (n2 != 0) break;
                    this.totalBytes = 0;
                    return false;
                }
                dataOutputStream.write(byArray2, 0, n3);
                n2 += n3;
                Thread.currentThread();
                Thread.yield();
            }
            this.in.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.totalBytes = 0;
            throw new IOException(iOException.getMessage());
        }
        this.totalBytes = n2;
        this.stream = new ByteArrayInputStream(byArray);
        return true;
    }

    protected AudioFormat readFormat(byte[] byArray) throws BadAudioHeaderException, IOException {
        throw new BadAudioHeaderException("cannot read format in ACIS base class");
    }

    boolean readTotalBytes() throws IOException {
        byte[] byArray = new byte[this.totalBytes];
        int n = this.readFully(byArray, 0, byArray.length);
        this.close();
        this.stream = new ByteArrayInputStream(byArray);
        return true;
    }

    protected int rllong(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        n = dataInputStream.readInt();
        int n2 = (n & 0xFF) << 24;
        int n3 = (n & 0xFF00) << 8;
        int n4 = (n & 0xFF0000) >> 8;
        int n5 = (n & 0xFF000000) >>> 24;
        n = n2 | n3 | n4 | n5;
        return n;
    }

    protected short rlshort(DataInputStream dataInputStream) throws IOException {
        short s = 0;
        s = dataInputStream.readShort();
        short s2 = (short)((s & 0xFF) << 8);
        short s3 = (short)((s & 0xFF00) >>> 8);
        s = (short)(s2 | s3);
        return s;
    }

    void setCurrentFrame(int n) {
        this.currentFrame = n;
        if (n < this.getTotalFrames()) {
            this.streamFinished = false;
        }
    }

    boolean setData() throws IOException {
        if (this.totalBytes > 0) {
            return this.readTotalBytes();
        }
        return this.readAllBytes();
    }

    protected void setFormat(Format format) {
        if (format instanceof AudioFormat) {
            this.f = (AudioFormat)format;
            this.totalFrames = this.getTotalBytes() / (this.f.getChannels() * this.f.getSampleSize());
        } else if (format != null) {
            System.out.println("not a valid audio format!");
        }
    }

    void setVerbose(boolean bl) {
        this.DEBUG = bl;
    }

    protected void setupConversions() throws BadAudioHeaderException {
        if (this.f == null) {
            return;
        }
        if (this.f.getEncoding() != "JAUDIO_LINEAR" && this.f.getEncoding() != "JAUDIO_G711_ULAW") {
            throw new BadAudioHeaderException("Unsupported audio encoding: " + this.f.getEncoding());
        }
        try {
            HaeMixer haeMixer = HaeDevice.getSystemMixer();
            if (haeMixer != null) {
                this.mixerBigEndian = haeMixer.isBigEndian();
            }
        }
        catch (HaeException haeException) {
            throw new BadAudioHeaderException("Mixer not initialized");
        }
        if (this.f.isBigEndian() == this.mixerBigEndian) {
            this.swapBytes = false;
        } else {
            boolean bl = this.swapBytes = this.f.getSampleSize() != 1;
        }
        if (!this.f.isSigned() && this.f.getEncoding() == "JAUDIO_LINEAR") {
            this.convertUnsigned = true;
        }
        if (this.f.getEncoding().equals("JAUDIO_G711_ULAW")) {
            if (this.f.getChannels() != 1) {
                throw new BadAudioHeaderException("Stereo ulaw");
            }
            this.convertFromUlaw = true;
        }
        if (this.swapBytes || this.convertUnsigned || this.convertFromUlaw) {
            this.processBytes = true;
            this.fout = new AudioFormat(this.f.getSampleRate(), this.convertFromUlaw ? "JAUDIO_LINEAR" : this.f.getEncoding(), this.convertFromUlaw ? 2 : this.f.getSampleSize(), this.f.getSamplePerUnit(), this.f.getChannels(), this.mixerBigEndian, this.convertUnsigned ? false : this.f.isSigned());
        } else {
            this.fout = this.f;
        }
        if (this.DEBUG) {
            System.out.println("format conversions: processBytes: " + this.processBytes + " swapBytes: " + this.swapBytes + "  convertUnsigned: " + this.convertUnsigned + " convertFromUlaw: " + this.convertFromUlaw);
            System.out.println("input format: " + this.f.toString());
            System.out.println("output format: " + this.fout.toString());
        }
    }

    boolean streamIsFinished() {
        return this.streamFinished;
    }

    byte[] ulawToLinear(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            byArray2[n2] = (byte)ULAW_TABH[byArray[n] & 0xFF];
            byArray2[n2 + 1] = (byte)ULAW_TABL[byArray[n] & 0xFF];
            ++n;
            n2 += 2;
        }
        return byArray2;
    }

    protected void updateCurrentFrame(int n) {
        this.currentFrame += n;
        int n2 = this.getTotalFrames();
        if (n2 > 0 && this.currentFrame >= n2) {
            this.streamFinished = true;
        }
    }
}

