/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.RenderingHints;

public class SunHints {
    private static final int NUM_KEYS = 8;
    private static final int VALS_PER_KEY = 3;
    public static final int INTKEY_RENDERING = 0;
    public static final int INTVAL_RENDER_DEFAULT = 0;
    public static final int INTVAL_RENDER_SPEED = 1;
    public static final int INTVAL_RENDER_QUALITY = 2;
    public static final int INTKEY_ANTIALIASING = 1;
    public static final int INTVAL_ANTIALIAS_DEFAULT = 0;
    public static final int INTVAL_ANTIALIAS_OFF = 1;
    public static final int INTVAL_ANTIALIAS_ON = 2;
    public static final int INTKEY_TEXT_ANTIALIASING = 2;
    public static final int INTVAL_TEXT_ANTIALIAS_DEFAULT = 0;
    public static final int INTVAL_TEXT_ANTIALIAS_OFF = 1;
    public static final int INTVAL_TEXT_ANTIALIAS_ON = 2;
    public static final int INTKEY_FRACTIONALMETRICS = 3;
    public static final int INTVAL_FRACTIONALMETRICS_DEFAULT = 0;
    public static final int INTVAL_FRACTIONALMETRICS_OFF = 1;
    public static final int INTVAL_FRACTIONALMETRICS_ON = 2;
    public static final int INTKEY_DITHERING = 4;
    public static final int INTVAL_DITHER_DEFAULT = 0;
    public static final int INTVAL_DITHER_DISABLE = 1;
    public static final int INTVAL_DITHER_ENABLE = 2;
    public static final int INTKEY_INTERPOLATION = 5;
    public static final int INTVAL_INTERPOLATION_NEAREST_NEIGHBOR = 0;
    public static final int INTVAL_INTERPOLATION_BILINEAR = 1;
    public static final int INTVAL_INTERPOLATION_BICUBIC = 2;
    public static final int INTKEY_ALPHA_INTERPOLATION = 6;
    public static final int INTVAL_ALPHA_INTERPOLATION_DEFAULT = 0;
    public static final int INTVAL_ALPHA_INTERPOLATION_SPEED = 1;
    public static final int INTVAL_ALPHA_INTERPOLATION_QUALITY = 2;
    public static final int INTKEY_COLOR_RENDERING = 7;
    public static final int INTVAL_COLOR_RENDER_DEFAULT = 0;
    public static final int INTVAL_COLOR_RENDER_SPEED = 1;
    public static final int INTVAL_COLOR_RENDER_QUALITY = 2;
    public static final Key KEY_RENDERING = new Key(0, "Global rendering quality key");
    public static final Object VALUE_RENDER_SPEED = new Value(KEY_RENDERING, 1, "Fastest rendering methods");
    public static final Object VALUE_RENDER_QUALITY = new Value(KEY_RENDERING, 2, "Highest quality rendering methods");
    public static final Object VALUE_RENDER_DEFAULT = new Value(KEY_RENDERING, 0, "Default rendering methods");
    public static final Key KEY_ANTIALIASING = new Key(1, "Global antialiasing enable key");
    public static final Object VALUE_ANTIALIAS_ON = new Value(KEY_ANTIALIASING, 2, "Antialiased rendering mode");
    public static final Object VALUE_ANTIALIAS_OFF = new Value(KEY_ANTIALIASING, 1, "Nonantialiased rendering mode");
    public static final Object VALUE_ANTIALIAS_DEFAULT = new Value(KEY_ANTIALIASING, 0, "Default antialiasing rendering mode");
    public static final Key KEY_TEXT_ANTIALIASING = new Key(2, "Text-specific antialiasing enable key");
    public static final Object VALUE_TEXT_ANTIALIAS_ON = new Value(KEY_TEXT_ANTIALIASING, 2, "Antialiased text mode");
    public static final Object VALUE_TEXT_ANTIALIAS_OFF = new Value(KEY_TEXT_ANTIALIASING, 1, "Nonantialiased text mode");
    public static final Object VALUE_TEXT_ANTIALIAS_DEFAULT = new Value(KEY_TEXT_ANTIALIASING, 0, "Default antialiasing text mode");
    public static final Key KEY_FRACTIONALMETRICS = new Key(3, "Fractional metrics enable key");
    public static final Object VALUE_FRACTIONALMETRICS_ON = new Value(KEY_FRACTIONALMETRICS, 2, "Fractional text metrics mode");
    public static final Object VALUE_FRACTIONALMETRICS_OFF = new Value(KEY_FRACTIONALMETRICS, 1, "Integer text metrics mode");
    public static final Object VALUE_FRACTIONALMETRICS_DEFAULT = new Value(KEY_FRACTIONALMETRICS, 0, "Default fractional text metrics mode");
    public static final Key KEY_DITHERING = new Key(4, "Dithering quality key");
    public static final Object VALUE_DITHER_ENABLE = new Value(KEY_DITHERING, 2, "Dithered rendering mode");
    public static final Object VALUE_DITHER_DISABLE = new Value(KEY_DITHERING, 1, "Nondithered rendering mode");
    public static final Object VALUE_DITHER_DEFAULT = new Value(KEY_DITHERING, 0, "Default dithering mode");
    public static final Key KEY_INTERPOLATION = new Key(5, "Image interpolation method key");
    public static final Object VALUE_INTERPOLATION_NEAREST_NEIGHBOR = new Value(KEY_INTERPOLATION, 0, "Nearest Neighbor image interpolation mode");
    public static final Object VALUE_INTERPOLATION_BILINEAR = new Value(KEY_INTERPOLATION, 1, "Bilinear image interpolation mode");
    public static final Object VALUE_INTERPOLATION_BICUBIC = new Value(KEY_INTERPOLATION, 2, "Bicubic image interpolation mode");
    public static final Key KEY_ALPHA_INTERPOLATION = new Key(6, "Alpha blending interpolation method key");
    public static final Object VALUE_ALPHA_INTERPOLATION_SPEED = new Value(KEY_ALPHA_INTERPOLATION, 1, "Fastest alpha blending methods");
    public static final Object VALUE_ALPHA_INTERPOLATION_QUALITY = new Value(KEY_ALPHA_INTERPOLATION, 2, "Highest quality alpha blending methods");
    public static final Object VALUE_ALPHA_INTERPOLATION_DEFAULT = new Value(KEY_ALPHA_INTERPOLATION, 0, "Default alpha blending methods");
    public static final Key KEY_COLOR_RENDERING = new Key(7, "Color rendering quality key");
    public static final Object VALUE_COLOR_RENDER_SPEED = new Value(KEY_COLOR_RENDERING, 1, "Fastest color rendering mode");
    public static final Object VALUE_COLOR_RENDER_QUALITY = new Value(KEY_COLOR_RENDERING, 2, "Highest quality color rendering mode");
    public static final Object VALUE_COLOR_RENDER_DEFAULT = new Value(KEY_COLOR_RENDERING, 0, "Default color rendering mode");

    public static class Key
    extends RenderingHints.Key {
        String description;

        public Key(int n, String string) {
            super(n);
            this.description = string;
        }

        public final int getIndex() {
            return this.intKey();
        }

        public final boolean isCompatibleValue(Object object) {
            if (object instanceof Value) {
                return ((Value)object).isCompatibleKey(this);
            }
            return false;
        }

        public final String toString() {
            return this.description;
        }
    }

    public static class Value {
        private Key myKey;
        private int index;
        private String description;
        private static Value[][] ValueObjects = new Value[8][3];

        public Value(Key key, int n, String string) {
            this.myKey = key;
            this.index = n;
            this.description = string;
            Value.register(key, this);
        }

        public final boolean equals(Object object) {
            return this == object;
        }

        public static Value get(int n, int n2) {
            return ValueObjects[n][n2];
        }

        public final int getIndex() {
            return this.index;
        }

        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final boolean isCompatibleKey(Key key) {
            return this.myKey == key;
        }

        private static synchronized void register(Key key, Value value) {
            int n;
            int n2 = key.getIndex();
            if (ValueObjects[n2][n = value.getIndex()] != null) {
                throw new InternalError("duplicate index: " + n);
            }
            Value.ValueObjects[n2][n] = value;
        }

        public final String toString() {
            return this.description;
        }
    }
}

