/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;
import sun.awt.AppContext;
import sun.awt.MagicEvent;
import sun.awt.PostEventQueue;
import sun.awt.font.FontDesignMetrics;
import sun.awt.font.NativeFontWrapper;
import sun.awt.im.InputMethod;
import sun.awt.im.InputMethodHighlightMapping;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.awt.image.URLImageSource;
import sun.awt.robot.Robot;
import sun.awt.robot.RobotPeer;
import sun.misc.SoftCache;

public abstract class SunToolkit
extends Toolkit {
    private static boolean hotjavaUrlCache = false;
    private static final String POST_EVENT_QUEUE_KEY = "PostEventQueue";
    protected static final Hashtable peerMap = new Hashtable();
    private static final Map appContextMap = Collections.synchronizedMap(new WeakHashMap());
    static SoftCache imgCache = new SoftCache();

    public SunToolkit() {
        EventQueue eventQueue;
        String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Failed loading " + string + ": " + exception);
            eventQueue = new EventQueue();
        }
        AppContext appContext = AppContext.getAppContext();
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
    }

    public Image createImage(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        return this.createImage(new FileImageSource(string));
    }

    public Image createImage(URL uRL) {
        block7: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    Permission permission = uRL.openConnection().getPermission();
                    if (permission == null) break block7;
                    try {
                        securityManager.checkPermission(permission);
                    }
                    catch (SecurityException securityException) {
                        if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                            securityManager.checkRead(permission.getName());
                            break block7;
                        }
                        if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                            securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                            break block7;
                        }
                        throw securityException;
                    }
                }
                catch (IOException iOException) {
                    securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
        }
        return this.createImage(new URLImageSource(uRL));
    }

    public Image createImage(byte[] byArray, int n, int n2) {
        return this.createImage(new ByteArrayImageSource(byArray, n, n2));
    }

    public static AppContext createNewAppContext() {
        EventQueue eventQueue;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        String string = Toolkit.getProperty("AWT.EventQueueClass", "java.awt.EventQueue");
        try {
            eventQueue = (EventQueue)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            System.err.println("Failed loading " + string + ": " + exception);
            eventQueue = new EventQueue();
        }
        AppContext appContext = new AppContext(threadGroup);
        appContext.put(AppContext.EVENT_QUEUE_KEY, eventQueue);
        PostEventQueue postEventQueue = new PostEventQueue(eventQueue);
        appContext.put(POST_EVENT_QUEUE_KEY, postEventQueue);
        return appContext;
    }

    public final Robot createRobot() {
        return new Robot(this.createRobotPeer(), this);
    }

    protected RobotPeer createRobotPeer() {
        throw new RuntimeException("No Robot implemented on this Toolkit.");
    }

    public boolean enableInputMethodsForTextComponent() {
        return false;
    }

    public static void executeOnEventHandlerThread(Object object, Runnable runnable) {
        AppContext appContext = SunToolkit.targetToAppContext(object);
        SunToolkit.postEvent(SunToolkit.targetToAppContext(object), new MagicEvent(Toolkit.getDefaultToolkit(), runnable, 1L));
    }

    public void flushPendingEvents() {
        AppContext appContext = AppContext.getAppContext();
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        postEventQueue.flush();
    }

    public Component getComponentFromNativeWindowHandle(int n) {
        return null;
    }

    public String[] getFontList() {
        String[] stringArray = new String[]{"Dialog", "SansSerif", "Serif", "Monospaced", "DialogInput"};
        return stringArray;
    }

    public FontMetrics getFontMetrics(Font font) {
        float f = font.getSize2D();
        AffineTransform affineTransform = font.getTransform();
        affineTransform.scale(f, f);
        double[] dArray = new double[4];
        affineTransform.getMatrix(dArray);
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics(font, dArray, false, false, fArray);
        return new FontDesignMetrics(font, fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public Image getImage(String string) {
        return SunToolkit.getImageFromHash((Toolkit)this, string);
    }

    public Image getImage(URL uRL) {
        return SunToolkit.getImageFromHash((Toolkit)this, uRL);
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, String string) {
        Image image;
        block3: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(string);
            }
            if ((image = (Image)imgCache.get(string)) != null) break block3;
            try {
                image = toolkit.createImage(new FileImageSource(string));
                imgCache.put(string, image);
            }
            catch (Exception exception) {}
        }
        return image;
    }

    static synchronized Image getImageFromHash(Toolkit toolkit, URL uRL) {
        Object object;
        block10: {
            block9: {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        object = uRL.openConnection().getPermission();
                        if (object == null) break block9;
                        try {
                            securityManager.checkPermission((Permission)object);
                        }
                        catch (SecurityException securityException) {
                            if (object instanceof FilePermission && ((Permission)object).getActions().indexOf("read") != -1) {
                                securityManager.checkRead(((Permission)object).getName());
                                break block9;
                            }
                            if (object instanceof SocketPermission && ((Permission)object).getActions().indexOf("connect") != -1) {
                                securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                                break block9;
                            }
                            throw securityException;
                        }
                    }
                    catch (IOException iOException) {
                        securityManager.checkConnect(uRL.getHost(), uRL.getPort());
                    }
                }
            }
            if ((object = (Image)imgCache.get(uRL)) != null) break block10;
            try {
                object = toolkit.createImage(new URLImageSource(uRL));
                imgCache.put(uRL, object);
            }
            catch (Exception exception) {}
        }
        return object;
    }

    public abstract InputMethod getInputMethodAdapter() throws AWTException;

    public abstract InputMethodHighlightMapping getInputMethodHighlightMapping();

    public static Container getNativeContainer(Component component) {
        return Toolkit.getNativeContainer(component);
    }

    public int getNativeWindowHandleFromComponent(Component component) {
        return 0;
    }

    protected abstract int getScreenHeight();

    public Dimension getScreenSize() {
        return new Dimension(this.getScreenWidth(), this.getScreenHeight());
    }

    protected abstract int getScreenWidth();

    protected EventQueue getSystemEventQueueImpl() {
        AppContext appContext = AppContext.getAppContext();
        EventQueue eventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        return eventQueue;
    }

    public static void insertTargetMapping(Object object, AppContext appContext) {
        appContextMap.put(object, appContext);
    }

    public static void postEvent(AppContext appContext, AWTEvent aWTEvent) {
        PostEventQueue postEventQueue = (PostEventQueue)appContext.get(POST_EVENT_QUEUE_KEY);
        postEventQueue.postEvent(aWTEvent);
    }

    protected static void targetDisposedPeer(Object object, Object object2) {
        if (object != null && object2 != null && peerMap.get(object) == object2) {
            peerMap.remove(object);
        }
    }

    public static AppContext targetToAppContext(Object object) {
        if (object != null) {
            return (AppContext)appContextMap.get(object);
        }
        return null;
    }

    protected static Object targetToPeer(Object object) {
        if (object != null) {
            return peerMap.get(object);
        }
        return null;
    }
}

