/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import sun.awt.font.Underline;
import sun.awt.im.InputMethodHighlightMapping;

public abstract class TextLineComponent {
    private LineMetrics lineMetrics;
    private Paint fgPaint = null;
    private Paint bgPaint = null;
    private boolean swapColors = false;
    private boolean strikethrough = false;
    private Underline stdUnderline = null;
    private Underline imUnderline = null;
    public static final int LEFT_TO_RIGHT = 0;
    public static final int RIGHT_TO_LEFT = 1;
    public static final int UNCHANGED = 2;

    protected TextLineComponent(Map map, LineMetrics lineMetrics) {
        this.lineMetrics = lineMetrics;
        if (map != null) {
            Object object = map.get(TextAttribute.FOREGROUND);
            if (object != null) {
                this.fgPaint = (Paint)object;
            }
            if ((object = map.get(TextAttribute.BACKGROUND)) != null) {
                this.bgPaint = (Paint)object;
            }
            object = map.get(TextAttribute.SWAP_COLORS);
            this.swapColors = TextAttribute.SWAP_COLORS_ON.equals(object);
            object = map.get(TextAttribute.STRIKETHROUGH);
            this.strikethrough = TextAttribute.STRIKETHROUGH_ON.equals(object);
            object = map.get(TextAttribute.UNDERLINE);
            this.stdUnderline = Underline.getUnderline(object);
            object = map.get(InputMethodHighlightMapping.InputMethodHighlightAttribute.INPUT_METHOD_UNDERLINE);
            this.imUnderline = Underline.getUnderline(object);
        }
    }

    protected TextLineComponent(TextLineComponent textLineComponent) {
        this.lineMetrics = textLineComponent.lineMetrics;
        this.fgPaint = textLineComponent.fgPaint;
        this.bgPaint = textLineComponent.bgPaint;
        this.swapColors = textLineComponent.swapColors;
        this.strikethrough = textLineComponent.strikethrough;
        this.stdUnderline = textLineComponent.stdUnderline;
        this.imUnderline = textLineComponent.imUnderline;
    }

    public TextLineComponent applyJustificationDeltas(float[] fArray, int n, boolean[] blArray) {
        return this;
    }

    public abstract boolean caretAtOffsetIsValid(int var1);

    public final void draw(Graphics2D graphics2D, float f, float f2) {
        if (this.fgPaint == null && this.bgPaint == null && !this.swapColors) {
            this.drawTextAndEmbellishments(graphics2D, f, f2);
        } else {
            Paint paint;
            Paint paint2;
            Paint paint3 = graphics2D.getPaint();
            if (this.swapColors) {
                paint2 = this.bgPaint == null ? Color.white : this.bgPaint;
                paint = this.fgPaint == null ? paint3 : this.fgPaint;
            } else {
                paint2 = this.fgPaint == null ? paint3 : this.fgPaint;
                paint = this.bgPaint;
            }
            if (paint != null) {
                Rectangle2D rectangle2D = this.getLogicalBounds();
                rectangle2D = new Rectangle2D.Float(f + (float)rectangle2D.getX(), f2 + (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
                graphics2D.setPaint(paint);
                graphics2D.fill(rectangle2D);
            }
            graphics2D.setPaint(paint2);
            this.drawTextAndEmbellishments(graphics2D, f, f2);
            graphics2D.setPaint(paint3);
        }
    }

    private void drawTextAndEmbellishments(Graphics2D graphics2D, float f, float f2) {
        float f3;
        this.handleDraw(graphics2D, f, f2);
        if (!this.strikethrough && this.stdUnderline == null && this.imUnderline == null) {
            return;
        }
        Rectangle2D rectangle2D = this.getLogicalBounds();
        float f4 = f;
        float f5 = f4 + (float)rectangle2D.getWidth();
        if (this.strikethrough) {
            Stroke stroke = graphics2D.getStroke();
            f3 = f2 + this.lineMetrics.getStrikethroughOffset();
            graphics2D.setStroke(new BasicStroke(this.lineMetrics.getStrikethroughThickness()));
            graphics2D.draw(new Line2D.Float(f4, f3, f5, f3));
            graphics2D.setStroke(stroke);
        }
        float f6 = this.lineMetrics.getUnderlineOffset();
        f3 = this.lineMetrics.getUnderlineThickness();
        if (this.stdUnderline != null) {
            this.stdUnderline.drawUnderline(graphics2D, f3, f4, f5, f2 + f6);
        }
        if (this.imUnderline != null) {
            this.imUnderline.drawUnderline(graphics2D, f3, f4, f5, f2 + f6);
        }
    }

    public abstract float getAdvanceBetween(int var1, int var2);

    public abstract float getCharAdvance(int var1);

    public final Rectangle2D getCharVisualBounds(int n) {
        Rectangle2D rectangle2D = this.handleGetCharVisualBounds(n);
        if (this.swapColors || this.bgPaint != null || this.stdUnderline != null || this.imUnderline != null) {
            float f = this.getCharX(n);
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (this.swapColors || this.bgPaint != null) {
                f2 = -this.lineMetrics.getAscent();
                f3 = f2 + this.lineMetrics.getHeight();
            }
            f3 = Math.max(f3, this.getUnderlineMaxY());
            rectangle2D.add(new Rectangle2D.Float(f, f2, this.getCharAdvance(n), f3 - f2));
        }
        return rectangle2D;
    }

    public abstract float getCharX(int var1);

    public abstract float getCharY(int var1);

    public abstract float getItalicAngle();

    public void getJustificationInfos(GlyphJustificationInfo[] glyphJustificationInfoArray, int n, int n2, int n3) {
    }

    public abstract int getLineBreakIndex(int var1, float var2);

    public final LineMetrics getLineMetrics() {
        return this.lineMetrics;
    }

    public abstract Rectangle2D getLogicalBounds();

    public abstract int getNumCharacters();

    public int getNumJustificationInfos() {
        return 0;
    }

    public final Shape getOutline(float f, float f2) {
        Shape shape;
        if (this.stdUnderline == null && this.imUnderline == null) {
            return this.handleGetOutline(f, f2);
        }
        float f3 = this.lineMetrics.getUnderlineThickness();
        Rectangle2D rectangle2D = this.getLogicalBounds();
        float f4 = f;
        float f5 = f4 + (float)rectangle2D.getWidth();
        Area area = null;
        if (this.stdUnderline != null) {
            shape = this.stdUnderline.getUnderlineShape(f3, f4, f5, f2);
            area = new Area(shape);
        }
        if (this.imUnderline != null) {
            shape = this.imUnderline.getUnderlineShape(f3, f4, f5, f2);
            Area area2 = new Area(shape);
            if (area == null) {
                area = area2;
            } else {
                area.add(area2);
            }
        }
        area.add(new Area(this.handleGetOutline(f, f2)));
        return new GeneralPath(area);
    }

    public abstract TextLineComponent getSubset(int var1, int var2, int var3);

    private float getUnderlineMaxY() {
        float f;
        float f2 = 0.0f;
        if (this.stdUnderline != null) {
            f = this.lineMetrics.getUnderlineOffset();
            f2 = Math.max(f2, f += this.stdUnderline.getLowerDrawLimit(this.lineMetrics.getUnderlineThickness()));
        }
        if (this.imUnderline != null) {
            f = this.lineMetrics.getUnderlineOffset();
            f2 = Math.max(f2, f += this.imUnderline.getLowerDrawLimit(this.lineMetrics.getUnderlineThickness()));
        }
        return f2;
    }

    public final Rectangle2D getVisualBounds() {
        Rectangle2D rectangle2D = this.handleGetVisualBounds();
        if (this.swapColors || this.bgPaint != null || this.stdUnderline != null || this.imUnderline != null) {
            float f = 0.0f;
            Rectangle2D rectangle2D2 = this.getLogicalBounds();
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (this.swapColors || this.bgPaint != null) {
                f2 = (float)rectangle2D2.getY();
                f3 = f2 + (float)rectangle2D2.getHeight();
            }
            f3 = Math.max(f3, this.getUnderlineMaxY());
            rectangle2D.add(new Rectangle2D.Float(f, f2, (float)rectangle2D2.getWidth(), f3 - f2));
        }
        return rectangle2D;
    }

    protected abstract void handleDraw(Graphics2D var1, float var2, float var3);

    protected abstract Rectangle2D handleGetCharVisualBounds(int var1);

    protected abstract Shape handleGetOutline(float var1, float var2);

    protected abstract Rectangle2D handleGetVisualBounds();
}

