/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im;

import java.util.Locale;

class InputMethodDescriptor {
    static final int HOST_ADAPTER = 1;
    static final int IIIMP_ADAPTER = 2;
    static final int JAVA_INPUT_METHOD = 3;
    private int type;
    private Locale locale;
    private String className;
    private String resource;

    InputMethodDescriptor(int n) {
        this(n, Locale.getDefault(), null, null);
    }

    InputMethodDescriptor(int n, Locale locale, String string) {
        this(n, locale, string, null);
    }

    InputMethodDescriptor(int n, Locale locale, String string, String string2) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid input method type value");
        }
        this.type = n;
        this.locale = locale;
        this.className = string;
        this.resource = string2;
    }

    public boolean equals(Object object) {
        InputMethodDescriptor inputMethodDescriptor = (InputMethodDescriptor)object;
        if (this == inputMethodDescriptor) {
            return true;
        }
        if (this.type != inputMethodDescriptor.type) {
            return false;
        }
        if (this.className != null ? !this.className.equals(inputMethodDescriptor.className) : inputMethodDescriptor.className != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(inputMethodDescriptor.locale) : inputMethodDescriptor.locale != null) {
            return false;
        }
        return !(this.resource != null ? !this.resource.equals(inputMethodDescriptor.resource) : inputMethodDescriptor.resource != null);
    }

    String getClassName() {
        return this.className;
    }

    Locale getLocale() {
        return this.locale;
    }

    String getResource() {
        return this.resource;
    }

    int getType() {
        return this.type;
    }

    public String toString() {
        String string;
        switch (this.type) {
            case 1: {
                string = "HOST_ADAPTER";
                break;
            }
            case 2: {
                string = "IIIMP_ADAPTER";
                break;
            }
            case 3: {
                string = "JAVA_INPUT_METHOD";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        String string2 = String.valueOf(string) + ", " + this.locale;
        if (this.className != null) {
            string2 = String.valueOf(string2) + ", classname=" + this.className;
        }
        if (this.resource != null) {
            string2 = String.valueOf(string2) + ", resource=" + this.resource;
        }
        return string2;
    }
}

