/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.NativeLibLoader;

public class BytePackedRaster
extends WritableRaster {
    int dataBitOffset;
    int scanlineStride;
    int pixelBitStride;
    int numberOfBits;
    int bitMask;
    byte[] data;
    int type;

    static {
        NativeLibLoader.loadLibraries();
        BytePackedRaster.initIDs();
    }

    public BytePackedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public BytePackedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public BytePackedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, BytePackedRaster bytePackedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, bytePackedRaster);
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new RasterFormatException("BytePackedRasters must havebyte DataBuffers");
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.data = dataBufferByte.getData();
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            this.type = 11;
            this.scanlineStride = multiPixelPackedSampleModel.getScanlineStride();
            this.pixelBitStride = multiPixelPackedSampleModel.getPixelBitStride();
            this.numberOfBits = multiPixelPackedSampleModel.getPixelBitStride();
            this.dataBitOffset = multiPixelPackedSampleModel.getDataBitOffset();
            int n = rectangle.x - point.x;
            int n2 = rectangle.y - point.y;
            this.dataBitOffset += n * this.pixelBitStride + n2 * this.scanlineStride * 8;
        } else {
            throw new RasterFormatException("BytePackedRasters must haveMultiPixelPackedSampleModel");
        }
        this.bitMask = (1 << this.numberOfBits) - 1;
        this.verify(false);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
        return writableRaster;
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new BytePackedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new BytePackedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        return this.getByteData(n, n2, n3, n4, byArray);
    }

    public byte[] getByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[n3 * n4];
        }
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + (n - this.sampleModelTranslateX) * n5;
        int n7 = (n2 - this.sampleModelTranslateY) * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n6;
            int n11 = 0;
            while (n11 < n3) {
                byArray[n8++] = (byte)(this.bitMask & byArray2[n7 + n10 / 8] >> 8 - (n10 & 7));
                n10 += n5;
                ++n11;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
        return byArray;
    }

    public int getDataBitOffset() {
        return this.dataBitOffset;
    }

    public Object getDataElements(int n, int n2, Object object) {
        byte[] byArray = object == null ? new byte[this.numDataElements] : (byte[])object;
        int n3 = this.dataBitOffset + (n - this.sampleModelTranslateX) * this.pixelBitStride;
        byte by = this.data[(n2 - this.sampleModelTranslateY) * this.scanlineStride + n3 / 8];
        byArray[0] = (byte)(by >> 8 - (n3 & 7) & this.bitMask);
        return byArray;
    }

    public byte[] getDataStorage() {
        return this.data;
    }

    public int getNumberOfBits() {
        return this.numberOfBits;
    }

    public int getPixelBitStride() {
        return this.pixelBitStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    private static native void initIDs();

    public void putByteData(int n, int n2, int n3, int n4, int n5, byte[] byArray) {
        this.putByteData(n, n2, n3, n4, byArray);
    }

    public void putByteData(int n, int n2, int n3, int n4, byte[] byArray) {
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + n * n5;
        int n7 = n2 * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n6;
            int n11 = 0;
            while (n11 < n3) {
                int n12 = 7 - (n10 & 7);
                byte by = byArray2[n7 + n10 / 8];
                by = (byte)(by & ~(this.bitMask << n12));
                byArray2[n7 + n10 / 8] = by = (byte)(by | (byArray[n8++] & this.bitMask) << n12);
                ++n11;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        byte[] byArray = (byte[])object;
        int n5 = this.pixelBitStride;
        int n6 = this.dataBitOffset + n * n5;
        int n7 = n2 * this.scanlineStride;
        int n8 = 0;
        byte[] byArray2 = this.data;
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n6;
            int n11 = 0;
            while (n11 < n3) {
                int n12 = 7 - (n10 & 7);
                byte by = byArray2[n7 + n10 / 8];
                by = (byte)(by & ~(this.bitMask << n12));
                byArray2[n7 + n10 / 8] = by = (byte)(by | (byArray[n8++] & this.bitMask) << n12);
                ++n11;
            }
            n7 += this.scanlineStride;
            ++n9;
        }
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (this.pixelBitStride == this.numberOfBits && raster instanceof BytePackedRaster) {
            BytePackedRaster bytePackedRaster = (BytePackedRaster)raster;
            if (bytePackedRaster.pixelBitStride == this.pixelBitStride && bytePackedRaster.numberOfBits == this.numberOfBits) {
                int n5 = this.scanlineStride;
                int n6 = this.dataBitOffset + 8 * (n2 - this.sampleModelTranslateY) * n5 + (n - this.sampleModelTranslateX) * this.pixelBitStride;
                int n7 = bytePackedRaster.getMinX() - bytePackedRaster.getSampleModelTranslateX();
                int n8 = bytePackedRaster.getMinY() - bytePackedRaster.getSampleModelTranslateY();
                int n9 = bytePackedRaster.dataBitOffset + n8 * bytePackedRaster.scanlineStride + n7 * bytePackedRaster.pixelBitStride;
                if ((n9 & 7) == (n6 & 7)) {
                    int n10;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    byte[] byArray = bytePackedRaster.data;
                    byte[] byArray2 = this.data;
                    int n15 = bytePackedRaster.scanlineStride;
                    int n16 = n3 * this.numberOfBits;
                    int n17 = n9 & 7;
                    if (n17 != 0) {
                        n14 = n9 / 8;
                        n13 = n6 / 8;
                        n12 = 255 >> n17;
                        if (n16 < (n17 = 8 - n17)) {
                            n12 &= n12 << 8 - n16;
                            n17 = n16;
                        }
                        n11 = 0;
                        while (n11 < n4) {
                            n10 = byArray2[n13];
                            n10 &= ~n12;
                            byArray2[n13] = (byte)(n10 |= byArray[n14] & n12);
                            n14 += n15;
                            n13 += n5;
                            ++n11;
                        }
                        n9 += n17;
                        n6 += n17;
                        n16 -= n17;
                    }
                    if (n16 >= 8) {
                        n14 = n9 / 8;
                        n13 = n6 / 8;
                        n12 = n16 / 8;
                        if (n12 == n15 && n15 == n5) {
                            System.arraycopy(byArray, n14, byArray2, n13, n15 * bytePackedRaster.height);
                        } else {
                            n11 = 0;
                            while (n11 < n4) {
                                System.arraycopy(byArray, n14, byArray2, n13, n12);
                                n14 += n15;
                                n13 += n5;
                                ++n11;
                            }
                        }
                        n17 = n12 * 8;
                        n9 += n17;
                        n6 += n17;
                        n16 -= n17;
                    }
                    if (n16 > 0) {
                        n14 = n9 / 8;
                        n13 = n6 / 8;
                        n12 = 65280 >> n16 & 0xFF;
                        n11 = 0;
                        while (n11 < n4) {
                            n10 = byArray2[n13];
                            n10 &= ~n12;
                            byArray2[n13] = (byte)(n10 |= byArray[n14] & n12);
                            n14 += n15;
                            n13 += n5;
                            ++n11;
                        }
                    }
                    return;
                }
            }
        }
        super.setDataElements(n, n2, raster);
    }

    public void setDataElements(int n, int n2, Object object) {
        byte[] byArray = (byte[])object;
        int n3 = this.dataBitOffset + (n - this.sampleModelTranslateX) * this.pixelBitStride;
        int n4 = (n2 - this.sampleModelTranslateY) * this.scanlineStride + n3 / 8;
        int n5 = 7 - (n3 & 7);
        byte by = this.data[n4];
        by = (byte)(by & ~(this.bitMask << n5));
        this.data[n4] = by = (byte)(by | (byArray[0] & this.bitMask) << n5);
    }

    public String toString() {
        return new String("BytePackedRaster: width = " + this.width + " height = " + this.height + " #channels " + this.numBands + " xOff = " + this.sampleModelTranslateX + " yOff = " + this.sampleModelTranslateY);
    }

    private void verify(boolean bl) {
        int n = this.dataBitOffset + (this.height - 1) * this.scanlineStride * 8 + (this.width - 1) * this.pixelBitStride + this.numberOfBits - 1;
        if (n / 8 >= this.data.length) {
            throw new RasterFormatException("raster dimensions overflow array bounds");
        }
        if (bl && this.height > 1 && (n = (this.width - 1) * this.pixelBitStride + this.numberOfBits - 1) / 8 >= this.scanlineStride) {
            throw new RasterFormatException("data for adjacent scanlines overlaps");
        }
    }
}

