/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferShort;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ShortBandedRaster
extends WritableRaster {
    int[] dataOffsets;
    int scanlineStride;
    short[][] data;

    public ShortBandedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ShortBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ShortBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ShortBandedRaster shortBandedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, shortBandedRaster);
        if (!(dataBuffer instanceof DataBufferShort)) {
            throw new RasterFormatException("ShortBandedRaster must haveshort DataBuffers");
        }
        DataBufferShort dataBufferShort = (DataBufferShort)dataBuffer;
        if (sampleModel instanceof BandedSampleModel) {
            BandedSampleModel bandedSampleModel = (BandedSampleModel)sampleModel;
            this.scanlineStride = bandedSampleModel.getScanlineStride();
            int[] nArray = bandedSampleModel.getBankIndices();
            int[] nArray2 = bandedSampleModel.getBandOffsets();
            int[] nArray3 = dataBufferShort.getOffsets();
            this.dataOffsets = new int[nArray.length];
            this.data = new short[nArray.length][];
            int n = rectangle.x - point.x;
            int n2 = rectangle.y - point.y;
            int n3 = 0;
            while (n3 < nArray.length) {
                this.data[n3] = dataBufferShort.getData(nArray[n3]);
                this.dataOffsets[n3] = nArray3[nArray[n3]] + n + n2 * this.scanlineStride + nArray2[n3];
                ++n3;
            }
        } else {
            throw new RasterFormatException("ShortBandedRasters must haveBandedSampleModels");
        }
        this.verify(false);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ShortBandedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n + n3 > this.width + this.minX) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 > this.height + this.minY) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new ShortBandedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        short[] sArray = object == null ? new short[this.numDataElements * n3 * n4] : (short[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n6 = 0;
        while (n6 < this.numDataElements) {
            int n7 = n6;
            short[] sArray2 = this.data[n6];
            int n8 = this.dataOffsets[n6];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n8 + n5;
                int n11 = 0;
                while (n11 < n3) {
                    sArray[n7] = sArray2[n10++];
                    n7 += this.numDataElements;
                    ++n11;
                }
                ++n9;
                n5 += this.scanlineStride;
            }
            ++n6;
        }
        return sArray;
    }

    public Object getDataElements(int n, int n2, Object object) {
        short[] sArray = object == null ? new short[this.numDataElements] : (short[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n4 = 0;
        while (n4 < this.numDataElements) {
            sArray[n4] = this.data[n4][this.dataOffsets[n4] + n3];
            ++n4;
        }
        return sArray;
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public short[][] getDataStorage() {
        return this.data;
    }

    public short[] getDataStorage(int n) {
        return this.data[n];
    }

    public int getPixelStride() {
        return 1;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public short[] getShortData(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        if (sArray == null) {
            sArray = new short[this.scanlineStride * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[n5];
        if (this.scanlineStride == n3) {
            System.arraycopy(this.data[n5], n6, sArray, 0, n3 * n4);
        } else {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                System.arraycopy(this.data[n5], n6, sArray, n7, n3);
                n7 += n3;
                ++n8;
                n6 += this.scanlineStride;
            }
        }
        return sArray;
    }

    public short[] getShortData(int n, int n2, int n3, int n4, short[] sArray) {
        if (sArray == null) {
            sArray = new short[this.numDataElements * this.scanlineStride * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n6 = 0;
        while (n6 < this.numDataElements) {
            int n7 = n6;
            short[] sArray2 = this.data[n6];
            int n8 = this.dataOffsets[n6];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n8 + n5;
                int n11 = 0;
                while (n11 < n3) {
                    sArray[n7] = sArray2[n10++];
                    n7 += this.numDataElements;
                    ++n11;
                }
                ++n9;
                n5 += this.scanlineStride;
            }
            ++n6;
        }
        return sArray;
    }

    public void putShortData(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[n5];
        int n7 = 0;
        if (this.scanlineStride == n3) {
            System.arraycopy(sArray, 0, this.data[n5], n6, n3 * n4);
        } else {
            int n8 = 0;
            while (n8 < n4) {
                System.arraycopy(sArray, n7, this.data[n5], n6, n3);
                n7 += n3;
                ++n8;
                n6 += this.scanlineStride;
            }
        }
    }

    public void putShortData(int n, int n2, int n3, int n4, short[] sArray) {
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n6 = 0;
        while (n6 < this.numDataElements) {
            int n7 = n6;
            short[] sArray2 = this.data[n6];
            int n8 = this.dataOffsets[n6];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n8 + n5;
                int n11 = 0;
                while (n11 < n3) {
                    sArray2[n10++] = sArray[n7];
                    n7 += this.numDataElements;
                    ++n11;
                }
                ++n9;
                n5 += this.scanlineStride;
            }
            ++n6;
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        short[] sArray = (short[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n6 = 0;
        while (n6 < this.numDataElements) {
            int n7 = n6;
            short[] sArray2 = this.data[n6];
            int n8 = this.dataOffsets[n6];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n8 + n5;
                int n11 = 0;
                while (n11 < n3) {
                    sArray2[n10++] = sArray[n7];
                    n7 += this.numDataElements;
                    ++n11;
                }
                ++n9;
                n5 += this.scanlineStride;
            }
            ++n6;
        }
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        Object object = null;
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        int n7 = n + raster.getMinX();
        int n8 = n2 + raster.getMinY();
        int n9 = 0;
        while (n9 < n4) {
            int n10 = 0;
            while (n10 < n3) {
                object = raster.getDataElements(n5 + n10, n6 + n9, object);
                this.setDataElements(n7 + n10, n8 + n9, object);
                ++n10;
            }
            ++n9;
        }
    }

    public void setDataElements(int n, int n2, Object object) {
        short[] sArray = (short[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        int n4 = 0;
        while (n4 < this.numDataElements) {
            this.data[n4][this.dataOffsets[n4] + n3] = sArray[n4];
            ++n4;
        }
    }

    public String toString() {
        return new String("ShortBandedRaster: width = " + this.width + " height = " + this.height + " #numBands " + this.numBands + " #dataElements " + this.numDataElements);
    }

    private void verify(boolean bl) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.numDataElements) {
            int n3 = (this.height - 1) * this.scanlineStride + (this.width - 1) + this.dataOffsets[n2];
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        if (this.data.length < n) {
            throw new RasterFormatException("Data array too small (should be " + n + " )");
        }
    }
}

