/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import sun.awt.windows.WDragSourceContextPeerBuffer;
import sun.awt.windows.WDragSourceContextPeerDispatcher;
import sun.awt.windows.WDropTargetContextPeer;

final class WDragSourceContextPeer
implements DragSourceContextPeer {
    private static WDragSourceContextPeerDispatcher listenerDispatcher = new WDragSourceContextPeerDispatcher();
    DragSource dragSource;
    DragSourceContext dragSourceContext;
    DragGestureEvent trigger;
    Cursor cursor;
    private Component component;
    private int actions;
    private Component nativeCont;
    private int nativeCtxt;
    private boolean dropOccurred = false;
    private int dropOperation = 0;
    private boolean dropSuccess = false;
    private int dropScreenXHint;
    private int dropScreenYHint;
    private boolean droppedInWindowCR;
    private boolean fakeExitDispatched = false;
    static /* synthetic */ Class class$java$lang$String;

    private WDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        this.trigger = dragGestureEvent;
        this.component = dragGestureEvent.getComponent();
        this.dragSource = dragGestureEvent.getDragSource();
    }

    static native void Initialize();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private WDragSourceContextPeerBuffer convertData(String string) {
        Class clazz;
        WDragSourceContextPeerBuffer wDragSourceContextPeerBuffer = null;
        Map map = this.dragSource.getFlavorMap().getFlavorsForNatives(new String[]{string});
        if (map == null || map.isEmpty()) {
            return null;
        }
        DataFlavor dataFlavor = (DataFlavor)map.get(string);
        Object object = null;
        if (dataFlavor == null) {
            return null;
        }
        try {
            object = this.dragSourceContext.getTransferable().getTransferData(dataFlavor);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        if (dataFlavor.isRepresentationClassInputStream()) {
            try {
                wDragSourceContextPeerBuffer = new WDragSourceContextPeerBuffer((InputStream)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (dataFlavor.isRepresentationClassRemote()) {
            try {
                wDragSourceContextPeerBuffer = new WDragSourceContextPeerBuffer(new MarshalledObject(object));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (dataFlavor.isRepresentationClassSerializable()) {
            try {
                wDragSourceContextPeerBuffer = new WDragSourceContextPeerBuffer(object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if ((class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = WDragSourceContextPeer.class$("java.lang.String"))).equals(clazz = dataFlavor.getRepresentationClass())) {
            try {
                wDragSourceContextPeerBuffer = new WDragSourceContextPeerBuffer((String)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return wDragSourceContextPeerBuffer;
    }

    private String[] convertFileList(String string) {
        String[] stringArray;
        List list;
        Map map = this.dragSource.getFlavorMap().getFlavorsForNatives(new String[]{string});
        if (map == null || map.isEmpty()) {
            return null;
        }
        DataFlavor dataFlavor = (DataFlavor)map.get(string);
        if (dataFlavor == null) {
            return null;
        }
        try {
            list = (List)this.dragSourceContext.getTransferable().getTransferData(dataFlavor);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < list.size()) {
            stringArray = list.get(n2);
            if (stringArray instanceof File || stringArray instanceof String) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return null;
        }
        stringArray = new String[n];
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    int n = 0;
                    while (n < list.size()) {
                        Object object = list.get(n);
                        if (object instanceof File) {
                            stringArray[n] = ((File)list.get(n)).getCanonicalPath();
                        } else if (object instanceof String) {
                            stringArray[n] = (String)object;
                        }
                        ++n;
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
        return stringArray;
    }

    native int createDragSource(InputEvent var1, int var2, Object[] var3);

    native void doDragDrop(int var1, Cursor var2);

    void dragDropFinished(boolean bl, int n, int n2, int n3, boolean bl2) {
        DragSourceDropEvent dragSourceDropEvent = new DragSourceDropEvent(this.dragSourceContext, n, bl);
        listenerDispatcher.deliverDropFinish(this.dragSourceContext, dragSourceDropEvent);
        this.dropScreenXHint = n2;
        this.dropScreenYHint = n3;
        this.droppedInWindowCR = bl2;
    }

    private void dragEnter(int n, int n2, int n3) {
        listenerDispatcher.deliverEnter(this.dragSourceContext, new DragSourceDragEvent(this.dragSourceContext, n, n2, n3));
    }

    private void dragExit(int n) {
        listenerDispatcher.deliverExit(this.dragSourceContext, new DragSourceEvent(this.dragSourceContext));
    }

    private void dragMotion(int n, int n2, int n3) {
        listenerDispatcher.deliverMotion(this.dragSourceContext, new DragSourceDragEvent(this.dragSourceContext, n, n2, n3));
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    static DragSourceContextPeer getDragSourceContextPeer(DragGestureEvent dragGestureEvent) {
        return new WDragSourceContextPeer(dragGestureEvent);
    }

    private int getDropXHint() {
        return this.dropScreenXHint;
    }

    private int getDropYHint() {
        return this.dropScreenYHint;
    }

    private boolean getDroppedInWindowCR() {
        return this.droppedInWindowCR;
    }

    private void operationChanged(int n, int n2, int n3) {
        listenerDispatcher.deliverGestureChanged(this.dragSourceContext, new DragSourceDragEvent(this.dragSourceContext, n, n2, n3));
    }

    private native void release(int var1);

    private native void setActions(int var1, int var2);

    public void setCursor(Cursor cursor) throws InvalidDnDOperationException {
        if (this.cursor == null || !this.cursor.equals(cursor)) {
            this.cursor = cursor;
            if (this.nativeCtxt != 0) {
                WDragSourceContextPeer.setNativeCursor(this.nativeCtxt, this.cursor);
            }
        }
    }

    private static native void setNativeCursor(int var0, Cursor var1);

    public void startDrag(DragSourceContext dragSourceContext, Cursor cursor, Image image, Point point) throws InvalidDnDOperationException {
        this.dragSourceContext = dragSourceContext;
        this.cursor = cursor;
        this.actions = this.trigger.getSourceAsDragGestureRecognizer().getSourceActions();
        WDragSourceContextPeer wDragSourceContextPeer = this;
        synchronized (wDragSourceContextPeer) {
            Transferable transferable = this.dragSourceContext.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            Map map = this.dragSource.getFlavorMap().getNativesForFlavors(dataFlavorArray);
            int n = 0;
            while (n < dataFlavorArray.length) {
                if (!(dataFlavorArray[n].isRepresentationClassInputStream() || dataFlavorArray[n].isRepresentationClassSerializable() || dataFlavorArray[n].isRepresentationClassRemote() || DataFlavor.javaFileListFlavor.equals(dataFlavorArray[n]))) {
                    map.remove(dataFlavorArray[n]);
                }
                ++n;
            }
            if (this.nativeCtxt != 0) {
                throw new InvalidDnDOperationException("drag in progress");
            }
            try {
                this.nativeCtxt = this.createDragSource(this.trigger.getTriggerEvent(), this.actions, map.values().toArray());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new InvalidDnDOperationException("failed to create native peer");
            }
            if (this.nativeCtxt == 0) {
                throw new InvalidDnDOperationException("failed to create native peer");
            }
            WDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
            try {
                new Thread(){

                    public void run() {
                        try {
                            try {
                                WDragSourceContextPeer.this.doDragDrop(WDragSourceContextPeer.this.nativeCtxt, WDragSourceContextPeer.this.cursor);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            Object var2_2 = null;
                        }
                        catch (Throwable throwable) {
                            Object var2_3 = null;
                            WDragSourceContextPeer.this.release(WDragSourceContextPeer.this.nativeCtxt);
                            WDragSourceContextPeer.this.nativeCtxt = 0;
                            WDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
                            throw throwable;
                        }
                        WDragSourceContextPeer.this.release(WDragSourceContextPeer.this.nativeCtxt);
                        WDragSourceContextPeer.this.nativeCtxt = 0;
                        WDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(null);
                    }
                }.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.release(this.nativeCtxt);
                this.nativeCtxt = 0;
                throw new InvalidDnDOperationException("failed to start Thread");
            }
        }
    }

    public void transferablesFlavorsChanged() {
    }
}

