/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.security.AccessController;
import sun.awt.image.ImageRepresentation;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WImage;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPrintJob;
import sun.awt.windows.WToolkit;
import sun.java2d.DeviceClipping;
import sun.java2d.OutputManager;
import sun.java2d.SunGraphics2D;
import sun.java2d.loops.ImageData;
import sun.java2d.loops.RasterOutputManager;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.SimpleRenderPipe;
import sun.java2d.pipe.SpanIterator;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.TranslateablePipe;
import sun.security.action.GetPropertyAction;

public class WGraphics
extends SunGraphics2D
implements PixelDrawPipe,
PixelFillPipe,
TranslateablePipe,
SimpleRenderPipe,
TextPipe,
DeviceClipping {
    static String myDevID = "WGraphics";
    int pData;
    WComponentPeer peer;
    private ImageData cachedID;
    private int serialNum = -1;
    private boolean disposed = false;

    static {
        WGraphics.initIDs();
        RasterOutputManager rasterOutputManager = RasterOutputManager.getManager();
    }

    WGraphics(int n) {
        this.createFromHDC(n);
        Rectangle rectangle = new Rectangle();
        this.getVisBounds(n, rectangle);
        this.setDevClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    WGraphics(WComponentPeer wComponentPeer) {
        this.createFromComponent(wComponentPeer);
        this.peer = wComponentPeer;
        Component component = (Component)wComponentPeer.target;
        this.backgroundColor = component.getBackground();
        Dimension dimension = component.getSize();
        this.setDevClip(0, 0, dimension.width, dimension.height);
        if (this.peer instanceof WPanelPeer) {
            Insets insets = ((WPanelPeer)this.peer).getInsets();
            this.translate(-insets.left, -insets.top);
            this.constrainX = -insets.left;
            this.constrainY = -insets.top;
        }
        this.serialNum = wComponentPeer.serialNum;
    }

    WGraphics(WPrintJob wPrintJob) {
        this.createFromPrintJob(wPrintJob);
        Dimension dimension = wPrintJob.getPageDimension();
        this.setDevClip(0, 0, dimension.width, dimension.height);
    }

    private native int W32LockViewResources(ImageData var1, int var2, int var3, int var4, int var5, int var6);

    private native int W32UnLockViewResources(ImageData var1);

    public native void changeClip(int var1, int var2, int var3, int var4, boolean var5);

    private static boolean checkNoDDraw() {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        return string != null;
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.fillpipe == SunGraphics2D.invalidpipe) {
            this.validatePipe();
        }
        if (this.fillpipe == this) {
            this.devClearRect(n, n2, n3, n4);
        } else {
            super.clearRect(n, n2, n3, n4);
        }
    }

    public Object clone() {
        WGraphics wGraphics = (WGraphics)super.clone();
        wGraphics.pData = 0;
        wGraphics.createFromGraphics(this);
        return wGraphics;
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.fillpipe == SunGraphics2D.invalidpipe) {
            this.validatePipe();
        }
        if (this.fillpipe == this) {
            this.devCopyArea(n, n2, n3, n4, n5, n6);
        } else {
            super.copyArea(n, n2, n3, n4, n5, n6);
        }
    }

    private synchronized native void createFromComponent(WComponentPeer var1);

    private synchronized native void createFromGraphics(WGraphics var1);

    private synchronized native void createFromHDC(int var1);

    private synchronized native void createFromPrintJob(WPrintJob var1);

    public native void devClearRect(int var1, int var2, int var3, int var4);

    public native void devCopyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void devDrawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void devDrawLine(int var1, int var2, int var3, int var4);

    public native void devDrawOval(int var1, int var2, int var3, int var4);

    private native void devDrawPolygon(int[] var1, int[] var2, int var3);

    private native void devDrawPolyline(int[] var1, int[] var2, int var3);

    public native void devDrawRect(int var1, int var2, int var3, int var4);

    public native void devDrawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void devFillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void devFillOval(int var1, int var2, int var3, int var4);

    public native void devFillPolygon(int[] var1, int[] var2, int var3, boolean var4);

    public native void devFillRect(int var1, int var2, int var3, int var4);

    public native void devFillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void devFillSpans(SpanIterator var1, long var2);

    native void devPrint(WComponentPeer var1);

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            WGraphics wGraphics = this;
            synchronized (wGraphics) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    protected native void disposeImpl();

    public void drawArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.devDrawArc(n, n2, n3, n4, n5, n6);
    }

    public Object drawBytes(SunGraphics2D sunGraphics2D, byte[] byArray, int n, int n2, int n3, int n4, Object object) {
        this.drawBytesWidth(byArray, n, n2, n3, n4);
        return null;
    }

    public native int drawBytesWidth(byte[] var1, int var2, int var3, int var4, int var5);

    public Object drawChars(SunGraphics2D sunGraphics2D, char[] cArray, int n, int n2, int n3, int n4, Object object) {
        this.drawCharsWidth(cArray, n, n2, n3, n4);
        return null;
    }

    public native int drawCharsWidth(char[] var1, int var2, int var3, int var4, int var5);

    public Object drawGlyphVector(SunGraphics2D sunGraphics2D, GlyphVector glyphVector, float f, float f2, Object object) {
        return super.drawGlyphVector(sunGraphics2D, glyphVector, f, f2, object);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        }
        if (n == n3 || n2 == n4) {
            return true;
        }
        if (n5 == n7 || n6 == n8) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, n3, n4, color, imageObserver);
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        if (n3 == 0 || n4 == 0) {
            return true;
        }
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, n3, n4, null, imageObserver);
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            super.drawImage((BufferedImage)image, n, n2, color, imageObserver);
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            return super.drawImage((BufferedImage)image, n, n2, null, imageObserver);
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, n, n2, null, imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (image instanceof BufferedImage) {
            super.drawImage((BufferedImage)image, affineTransform, 0, 0, null, imageObserver);
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError() && imageObserver != null) {
            imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.drawToBufImage(this, (sun.awt.image.Image)image, affineTransform, imageObserver);
    }

    public void drawLine(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devDrawLine(n, n2, n3, n4);
    }

    public void drawOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devDrawOval(n, n2, n3, n4);
    }

    public void drawPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.devDrawPolygon(nArray, nArray2, n);
    }

    public void drawPolyline(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.devDrawPolyline(nArray, nArray2, n);
    }

    public void drawPolys(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray3[n2];
            if (bl) {
                this.devDrawPolygon(nArray, nArray2, n3);
            } else {
                this.devDrawPolyline(nArray, nArray2, n3);
            }
            System.arraycopy(nArray, n3, nArray, 0, nArray.length - n3);
            System.arraycopy(nArray2, n3, nArray2, 0, nArray2.length - n3);
            ++n2;
        }
    }

    public void drawRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devDrawRect(n, n2, n3, n4);
    }

    public void drawRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.devDrawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public Object drawString(SunGraphics2D sunGraphics2D, String string, float f, float f2, Object object) {
        this.drawStringWidth(string, (int)f, (int)f2);
        return null;
    }

    public native int drawStringWidth(String var1, int var2, int var3);

    public void fillArc(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.devFillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillOval(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devFillOval(n, n2, n3, n4);
    }

    public void fillPolygon(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int n) {
        this.devFillPolygon(nArray, nArray2, n, true);
    }

    public void fillPolys(SunGraphics2D sunGraphics2D, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl) {
        int n2;
        if (n < 1) {
            return;
        }
        if (n > 1) {
            Polygon polygon = new Polygon();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n) {
                n2 = nArray3[n6];
                if (n2 < 2) {
                    n3 += n2;
                } else {
                    polygon.addPoint(0, 0);
                    int n7 = nArray[n3];
                    int n8 = nArray2[n3];
                    int n9 = 0;
                    while (n9 < n2) {
                        n4 = nArray[n3];
                        n5 = nArray2[n3];
                        polygon.addPoint(n4, n5);
                        ++n3;
                        ++n9;
                    }
                    if (n4 != n7 || n5 != n8) {
                        polygon.addPoint(n7, n8);
                    }
                    polygon.addPoint(0, 0);
                }
                ++n6;
            }
            nArray = polygon.xpoints;
            nArray2 = polygon.ypoints;
            n2 = polygon.npoints;
        } else {
            n2 = nArray3[0];
        }
        this.devFillPolygon(nArray, nArray2, n2, bl);
    }

    public void fillRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4) {
        this.devFillRect(n, n2, n3, n4);
    }

    public void fillRoundRect(SunGraphics2D sunGraphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        this.devFillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillSpans(SunGraphics2D sunGraphics2D, SpanIterator spanIterator) {
        this.devFillSpans(spanIterator, spanIterator.getNativeIterator());
    }

    public void finalize() {
        this.dispose();
    }

    public Rectangle getCompBounds() {
        if (this.peer != null && this.serialNum != this.peer.serialNum) {
            Dimension dimension = ((Component)this.peer.target).getSize();
            this.setDevClip(0, 0, dimension.width, dimension.height);
            this.serialNum = this.peer.serialNum;
        }
        return super.getCompBounds();
    }

    public String getDevID() {
        return myDevID;
    }

    public ColorModel getDeviceColorModel() {
        if (this.peer != null) {
            return this.peer.getColorModel();
        }
        return WToolkit.config.getColorModel();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return WToolkit.config;
    }

    public Font getFont() {
        if (this.font == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.textpipe == SunGraphics2D.invalidpipe) {
            this.validatePipe();
        }
        if (this.textpipe == this) {
            return WFontMetrics.getFontMetrics(font);
        }
        return super.getFontMetrics(font);
    }

    public OutputManager getOutputManager() {
        return RasterOutputManager.getManager();
    }

    private native void getVisBounds(int var1, Rectangle var2);

    private static native void initIDs();

    public ImageData lock(int n, int n2, int n3, int n4, int n5) {
        ImageData imageData = this.cachedID;
        if (imageData == null || imageData.amILocked()) {
            imageData = new ImageData();
            imageData.setColorModel(this.getDeviceColorModel());
        }
        imageData.setViewArea(n, n2, n3, n4);
        imageData.setLockMethod(n5);
        int n6 = this.W32LockViewResources(imageData, n, n2, n3, n4, n5);
        if (n6 == 1) {
            this.cachedID = imageData;
            imageData.incLockCount();
            return imageData;
        }
        return null;
    }

    private native void pSetFont(Font var1);

    private native void pSetForeground(int var1);

    public native void pSetPaintMode();

    public native void pSetXORMode(Color var1);

    public void print(WComponentPeer wComponentPeer) {
        this.validatePipe();
        this.devPrint(wComponentPeer);
    }

    public native void removeClip();

    public void setColor(Color color) {
        if (color != null) {
            super.setColor(color);
            this.pSetForeground(color.getRGB());
        }
    }

    public void setFont(Font font) {
        if (font != null && this.font != font) {
            super.setFont(font);
            this.pSetFont(font);
        }
    }

    public native void setOrigin(int var1, int var2);

    public void setPaint(Paint paint) {
        super.setPaint(paint);
        if (paint instanceof Color) {
            this.pSetForeground(((Color)paint).getRGB());
        }
    }

    public void setPaintMode() {
        super.setPaintMode();
        this.pSetPaintMode();
    }

    public void setXORMode(Color color) {
        super.setXORMode(color);
        this.pSetXORMode(color);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public int unlock(ImageData imageData) {
        int n = 5;
        n = 6;
        if (imageData != null && imageData.amILocked() && (n = this.W32UnLockViewResources(imageData)) == 2) {
            imageData.decLockCount();
        }
        return n;
    }

    public void validatePipe() {
        RasterOutputManager.getManager().validatePipe(this);
    }
}

