/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.PathIterator;
import java.awt.print.PrinterJob;
import sun.awt.windows.WPrinterJob;
import sun.java2d.PathGraphics;

class WPathGraphics
extends PathGraphics {
    WPathGraphics(Graphics2D graphics2D, PrinterJob printerJob) {
        super(graphics2D, printerJob);
    }

    private void convertToWPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        int n = pathIterator.getWindingRule() == 0 ? 1 : 2;
        wPrinterJob.setPolyFillMode(n);
        wPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n2 = pathIterator.currentSegment(fArray);
            switch (n2) {
                case 0: {
                    wPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    wPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    int n3 = wPrinterJob.getPenX();
                    int n4 = wPrinterJob.getPenY();
                    float f = (float)n3 + (fArray[0] - (float)n3) * 2.0f / 3.0f;
                    float f2 = (float)n4 + (fArray[1] - (float)n4) * 2.0f / 3.0f;
                    float f3 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f4 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    wPrinterJob.polyBezierTo(f, f2, f3, f4, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    wPrinterJob.polyBezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    wPrinterJob.closeFigure();
                    break;
                }
            }
            pathIterator.next();
        }
        wPrinterJob.endPath();
    }

    public Graphics create() {
        return new WPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob());
    }

    protected void deviceClip(PathIterator pathIterator) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectClipPath();
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectSolidBrush(color);
        wPrinterJob.fillPath();
    }
}

