/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

class Spans {
    private static final int kMaxAddsSinceSort = 256;
    private List mSpans = new Vector(256);
    private int mAddsSinceSort = 0;

    Spans() {
    }

    void add(float f, float f2) {
        if (this.mSpans != null) {
            this.mSpans.add(new Span(f, f2));
            if (++this.mAddsSinceSort >= 256) {
                this.sortAndCollapse();
            }
        }
    }

    void addInfinite() {
        this.mSpans = null;
    }

    boolean intersects(float f, float f2) {
        boolean bl;
        if (this.mSpans != null) {
            int n;
            if (this.mAddsSinceSort > 0) {
                this.sortAndCollapse();
            }
            bl = (n = Collections.binarySearch(this.mSpans, new Span(f, f2), SpanIntersection.instance)) >= 0;
        } else {
            bl = true;
        }
        return bl;
    }

    private void sortAndCollapse() {
        Collections.sort(this.mSpans);
        this.mAddsSinceSort = 0;
        Iterator iterator = this.mSpans.iterator();
        Span span = null;
        if (iterator.hasNext()) {
            span = (Span)iterator.next();
        }
        while (iterator.hasNext()) {
            Span span2 = (Span)iterator.next();
            if (span.subsume(span2)) {
                iterator.remove();
                continue;
            }
            span = span2;
        }
    }

    static class Span
    implements Comparable {
        private float mStart;
        private float mEnd;

        Span(float f, float f2) {
            this.mStart = f;
            this.mEnd = f2;
        }

        public int compareTo(Object object) {
            Span span = (Span)object;
            float f = span.getStart();
            int n = this.mStart < f ? -1 : (this.mStart > f ? 1 : 0);
            return n;
        }

        boolean contains(float f) {
            return this.mStart <= f && f < this.mEnd;
        }

        final float getEnd() {
            return this.mEnd;
        }

        final float getStart() {
            return this.mStart;
        }

        final void setEnd(float f) {
            this.mEnd = f;
        }

        final void setStart(float f) {
            this.mStart = f;
        }

        boolean subsume(Span span) {
            boolean bl = this.contains(span.mStart);
            if (bl && span.mEnd > this.mEnd) {
                this.mEnd = span.mEnd;
            }
            return bl;
        }

        public String toString() {
            return "Span: " + this.mStart + " to " + this.mEnd;
        }
    }

    static class SpanIntersection
    implements Comparator {
        static final SpanIntersection instance = new SpanIntersection();

        private SpanIntersection() {
        }

        public int compare(Object object, Object object2) {
            Span span = (Span)object;
            Span span2 = (Span)object2;
            int n = span.getEnd() <= span2.getStart() ? -1 : (span.getStart() >= span2.getEnd() ? 1 : 0);
            return n;
        }
    }
}

