/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcLimits;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.OdbcDef;

public class JdbcOdbcCallableStatement
extends JdbcOdbcPreparedStatement
implements CallableStatement {
    public byte[] scalez = new byte[200];
    private boolean lastParameterNull = false;

    public JdbcOdbcCallableStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    public synchronized void FreeParams() throws NullPointerException {
        try {
            int n = 1;
            while (n <= this.boundParams.length) {
                if (this.boundParams[n - 1].pA1 != 0) {
                    this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pA1, this.boundParams[n - 1].pA2);
                }
                if (this.boundParams[n - 1].pB1 != 0) {
                    this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pB1, this.boundParams[n - 1].pB2);
                }
                if (this.boundParams[n - 1].pC1 != 0) {
                    this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pC1, this.boundParams[n - 1].pC2);
                }
                if (this.boundParams[n - 1].pS1 != 0) {
                    this.OdbcApi.ReleaseStoredChars(this.boundParams[n - 1].pS1, this.boundParams[n - 1].pS2);
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public synchronized void close() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0;
                this.FreeParams();
            }
        }
        catch (SQLException sQLException) {}
        this.myConnection.deregisterStatement(this);
    }

    public Array getArray(int n) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int n) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(this.getString(n));
        return bigDecimal.setScale(n2, 6);
    }

    public Blob getBlob(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int n) throws SQLException {
        if (this.isNull(n)) {
            return false;
        }
        boolean bl = false;
        if (this.getString(n).equals("1")) {
            bl = true;
        }
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public byte[] getBytes(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        return JdbcOdbcObject.hexStringToByteArray(this.getString(n));
    }

    public Clob getClob(int n) {
        throw new UnsupportedOperationException();
    }

    public Date getDate(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return Date.valueOf(string);
    }

    public Date getDate(int n, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0.0;
        }
        Double d = new Double(this.getString(n));
        return d;
    }

    public float getFloat(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0.0f;
        }
        Float f = new Float(this.getString(n));
        return f.floatValue();
    }

    public int getInt(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0;
        }
        Integer n2 = new Integer(this.getString(n));
        return n2;
    }

    public long getLong(int n) throws SQLException {
        if (this.isNull(n)) {
            return 0L;
        }
        Integer n2 = new Integer(this.getString(n));
        return n2.longValue();
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        int n2 = this.getSqlType(n);
        if (this.isNull(n)) {
            return null;
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                if (n <= 200) {
                    object = this.getBigDecimal(n, this.scalez[n]);
                    break;
                }
                object = this.getBigDecimal(n, JdbcOdbcLimits.DEFAULT_OUT_SCALE);
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: {
                object = new Integer(this.getByte(n));
                break;
            }
            case 5: {
                object = new Integer(this.getShort(n));
                break;
            }
            case 4: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 6: 
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
                break;
            }
        }
        return object;
    }

    public Object getObject(int n, Map map) {
        throw new UnsupportedOperationException();
    }

    public Ref getRef(int n) {
        throw new UnsupportedOperationException();
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    protected int getSqlType(int n) {
        int n2 = 1111;
        if (n >= 1 && n <= this.numParams) {
            n2 = this.boundParams[n - 1].getSqlType();
        }
        return n2;
    }

    public String getString(int n) throws SQLException {
        if (this.isNull(n)) {
            return null;
        }
        int n2 = this.getSqlType(n);
        String string = new String();
        try {
            string = this.BytesToChars(this.OdbcApi.charSet, this.getDataBuf(n));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        string = string.trim();
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("String value for OUT parameter " + n + "=" + string);
        }
        return string;
    }

    public Time getTime(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return Time.valueOf(string);
    }

    public Time getTime(int n, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        if (string.length() == 10) {
            string = String.valueOf(string) + " 00:00:00";
        }
        return Timestamp.valueOf(string);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    protected boolean isNull(int n) throws SQLException {
        if (!this.isOutputParameter(n)) {
            throw new SQLException("Parameter " + n + " is not an OUTPUT parameter");
        }
        boolean bl = false;
        boolean bl2 = bl = this.getParamLength(n) == -1;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Output Parameter " + n + " null: " + bl);
        }
        this.lastParameterNull = bl;
        return bl;
    }

    protected boolean isOutputParameter(int n) {
        boolean bl = false;
        if (n >= 1 && n <= this.numParams) {
            bl = this.boundParams[n - 1].isOutputParameter();
        }
        return bl;
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n, n2, 0);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        int n4;
        this.setSqlType(n, n2);
        if (n <= 200) {
            this.scalez[n] = (byte)n3;
        }
        this.setOutputParameter(n, true);
        switch (n2) {
            case 91: {
                n4 = 10;
                break;
            }
            case 92: {
                n4 = 8;
                break;
            }
            case 93: {
                n4 = 19;
                if (n3 <= 0) break;
                n4 += n3 + 1;
                break;
            }
            case -7: {
                n4 = 1;
                break;
            }
            case -6: {
                n4 = 4;
                break;
            }
            case 5: {
                n4 = 6;
                break;
            }
            case 4: {
                n4 = 11;
                break;
            }
            case -5: {
                n4 = 20;
                break;
            }
            case 7: {
                n4 = 13;
                break;
            }
            case 6: 
            case 8: {
                n4 = 22;
                break;
            }
            case 2: 
            case 3: {
                n4 = 38;
                break;
            }
            default: {
                n4 = this.getPrecision(n2);
                if (n4 > 0 && n4 <= JdbcOdbcLimits.DEFAULT_IN_PRECISION) break;
                n4 = JdbcOdbcLimits.DEFAULT_IN_PRECISION;
            }
        }
        byte[] byArray = this.allocBindBuf(n, n4 + 1);
        byte[] byArray2 = this.getLengthBuf(n);
        n2 = OdbcDef.jdbcTypeToOdbc(n2);
        int[] nArray = new int[]{0, 0, 0, 0};
        this.OdbcApi.SQLBindOutParameterString(this.hStmt, n, n2, n3, byArray, byArray2, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected void setOutputParameter(int n, boolean bl) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setOutputParameter(bl);
        }
    }

    protected void setSqlType(int n, int n2) {
        if (n >= 1 && n <= this.numParams) {
            this.boundParams[n - 1].setSqlType(n2);
        }
    }

    public boolean wasNull() throws SQLException {
        return this.lastParameterNull;
    }
}

