/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SoftCache
extends AbstractMap
implements Map {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();
    private Set entrySet = null;

    public SoftCache() {
        this.hash = new HashMap();
    }

    public SoftCache(int n) {
        this.hash = new HashMap(n);
    }

    public SoftCache(int n, float f) {
        this.hash = new HashMap(n, f);
    }

    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    public boolean containsKey(Object object) {
        return ValueCell.strip(this.hash.get(object), false) != null;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    protected Object fill(Object object) {
        return null;
    }

    public Object get(Object object) {
        this.processQueue();
        Object object2 = this.hash.get(object);
        if (object2 == null && (object2 = this.fill(object)) != null) {
            this.hash.put(object, ValueCell.create(object, object2, this.queue));
            return object2;
        }
        return ValueCell.strip(object2, false);
    }

    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    private void processQueue() {
        ValueCell valueCell;
        while ((valueCell = (ValueCell)this.queue.poll()) != null) {
            if (valueCell.isValid()) {
                this.hash.remove(valueCell.key);
                continue;
            }
            ValueCell.dropped = ValueCell.dropped - 1;
        }
    }

    public Object put(Object object, Object object2) {
        this.processQueue();
        ValueCell valueCell = ValueCell.create(object, object2, this.queue);
        return ValueCell.strip(this.hash.put(object, valueCell), true);
    }

    public Object remove(Object object) {
        this.processQueue();
        return ValueCell.strip(this.hash.remove(object), true);
    }

    public int size() {
        return this.entrySet().size();
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static class ValueCell
    extends SoftReference {
        private static Object INVALID_KEY = new Object();
        private static int dropped = 0;
        private Object key;

        private ValueCell(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        private static ValueCell create(Object object, Object object2, ReferenceQueue referenceQueue) {
            if (object2 == null) {
                return null;
            }
            return new ValueCell(object, object2, referenceQueue);
        }

        private void drop() {
            super.clear();
            this.key = INVALID_KEY;
            ++dropped;
        }

        private boolean isValid() {
            return this.key != INVALID_KEY;
        }

        private static Object strip(Object object, boolean bl) {
            if (object == null) {
                return null;
            }
            ValueCell valueCell = (ValueCell)object;
            Object object2 = valueCell.get();
            if (bl) {
                valueCell.drop();
            }
            return object2;
        }
    }

    private class Entry
    implements Map.Entry {
        private Map.Entry ent;
        private Object value;

        Entry(Map.Entry entry, Object object) {
            this.ent = entry;
            this.value = object;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return SoftCache.valEquals(this.ent.getKey(), entry.getKey()) && SoftCache.valEquals(this.value, entry.getValue());
        }

        public Object getKey() {
            return this.ent.getKey();
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            Object object = this.getKey();
            return (object == null ? 0 : object.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object setValue(Object object) {
            return this.ent.setValue(ValueCell.create(this.ent.getKey(), object, SoftCache.this.queue));
        }
    }

    private class EntrySet
    extends AbstractSet {
        Set hashEntries;

        EntrySet() {
            this.hashEntries = SoftCache.this.hash.entrySet();
        }

        static /* synthetic */ SoftCache access$0(EntrySet entrySet) {
            return entrySet.SoftCache.this;
        }

        public boolean isEmpty() {
            return this.iterator().hasNext() ^ true;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private final /* synthetic */ EntrySet this$1;
                Iterator hashIterator;
                Entry next;
                {
                    this.this$1 = entrySet;
                    this.hashIterator = entrySet.hashEntries.iterator();
                    this.next = null;
                }

                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)this.hashIterator.next();
                        ValueCell valueCell = (ValueCell)entry.getValue();
                        Object object = null;
                        if (valueCell != null && (object = valueCell.get()) == null) continue;
                        SoftCache softCache = EntrySet.access$0(this.this$1);
                        softCache.getClass();
                        this.next = softCache.new Entry(entry, object);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry entry = this.next;
                    this.next = null;
                    return entry;
                }

                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        public boolean remove(Object object) {
            SoftCache.this.processQueue();
            if (object instanceof Entry) {
                return this.hashEntries.remove(((Entry)object).ent);
            }
            return false;
        }

        public int size() {
            int n = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++n;
                iterator.next();
            }
            return n;
        }
    }
}

