/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.UnknownHostException;

public class NetworkClient {
    protected Socket serverSocket = null;
    public PrintStream serverOutput;
    public InputStream serverInput;

    public NetworkClient() {
    }

    public NetworkClient(String string, int n) throws IOException {
        this.openServer(string, n);
    }

    public void closeServer() throws IOException {
        if (!this.serverIsOpen()) {
            return;
        }
        this.serverSocket.close();
        this.serverSocket = null;
        this.serverInput = null;
        this.serverOutput = null;
    }

    protected Socket doConnect(String string, int n) throws IOException, UnknownHostException {
        return new Socket(string, n);
    }

    public void openServer(String string, int n) throws IOException, UnknownHostException {
        if (this.serverSocket != null) {
            this.closeServer();
        }
        this.serverSocket = this.doConnect(string, n);
        this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()), true);
        this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
    }

    public boolean serverIsOpen() {
        return this.serverSocket != null;
    }
}

