/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.mailto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permission;
import sun.net.smtp.SmtpClient;
import sun.net.www.MessageHeader;
import sun.net.www.URLConnection;

public class MailToURLConnection
extends URLConnection {
    InputStream is = null;
    OutputStream os = null;
    SmtpClient client;
    Permission permission;

    MailToURLConnection(URL uRL) {
        super(uRL);
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.add("content-type", "text/html");
        this.setProperties(messageHeader);
    }

    public void connect() throws IOException {
        this.client = new SmtpClient();
    }

    String getFromAddress() {
        String string = System.getProperty("user.fromaddr");
        if (string == null) {
            string = System.getProperty("user.name");
            if (string != null) {
                String string2 = System.getProperty("mail.host");
                if (string2 == null) {
                    try {
                        string2 = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
                string = String.valueOf(string) + "@" + string2;
            } else {
                string = "";
            }
        }
        return string;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.os != null) {
            return this.os;
        }
        if (this.is != null) {
            throw new IOException("Cannot write output after reading input.");
        }
        this.connect();
        String string = this.url.getFile();
        this.client.from(this.getFromAddress());
        this.client.to(string);
        this.os = this.client.startMessage();
        return this.os;
    }

    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            this.connect();
            String string = String.valueOf(this.client.getMailHost()) + ":" + 25;
            this.permission = new SocketPermission(string, "connect");
        }
        return this.permission;
    }
}

