/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationInstantiator;
import java.rmi.activation.ActivationMonitor;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.Activator;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import sun.rmi.log.LogHandler;
import sun.rmi.log.ReliableLog;
import sun.rmi.registry.RegistryImpl;
import sun.rmi.server.MarshalOutputStream;
import sun.rmi.server.PipeWriter;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.RMIThreadAction;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetIntegerAction;

public class Activation
implements Serializable,
Runnable {
    private static final long serialVersionUID = 2921265612698155191L;
    private static Registry registry;
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 0;
    private static int nextRestart;
    private Hashtable idTable = new Hashtable(101);
    private Hashtable groupTable = new Hashtable(53);
    private byte majorVersion = 1;
    private byte minorVersion = 0;
    private transient ReliableLog log;
    private transient int numUpdates = 0;
    private transient String[] command;
    private static final int snapshotInterval;
    private static final long execTimeout;
    private transient Activator activator;
    private transient Activator activatorStub;
    private transient ActivationSystem system;
    private transient ActivationSystem systemStub;
    private transient ActivationMonitor monitor;
    private transient boolean shuttingDown = false;
    private transient Object startupLock;
    private static ResourceBundle resources;
    private static int[] sem_startgroup;

    static {
        nextRestart = 0;
        snapshotInterval = Activation.getInt("sun.rmi.activation.snapshotInterval", 200);
        execTimeout = Activation.getInt("sun.rmi.activation.execTimeout", 30000);
        resources = null;
        Integer n = (Integer)AccessController.doPrivileged(new GetIntegerAction("sun.rmi.rmid.maxstartgroup", 3));
        int[] nArray = new int[]{n};
        sem_startgroup = nArray;
    }

    private Activation() {
    }

    private static void Pstartgroup() throws InterruptedException {
        int[] nArray = sem_startgroup;
        synchronized (nArray) {
            while (sem_startgroup[0] <= 0) {
                sem_startgroup.wait();
            }
            sem_startgroup[0] = sem_startgroup[0] - 1;
        }
    }

    private static void Vstartgroup() {
        int[] nArray = sem_startgroup;
        synchronized (nArray) {
            sem_startgroup[0] = sem_startgroup[0] + 1;
            sem_startgroup.notifyAll();
        }
    }

    private synchronized void addLogRecord(LogRecord logRecord) throws ActivationException {
        try {
            this.log.update(logRecord, true);
            if (++this.numUpdates >= snapshotInterval) {
                this.log.snapshot(this);
                this.numUpdates = 0;
            }
        }
        catch (Exception exception) {
            throw new ActivationException("unable to update log", exception);
        }
    }

    private static void bomb(String string) {
        System.err.println("rmid: " + string);
        System.err.println(Activation.textrsrc("rmid.usage"));
        System.exit(1);
    }

    private void checkShutdown() throws ActivationException {
        Object object = this.startupLock;
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
            }
        }
        if (this.shuttingDown) {
            throw new ActivationException("activation system is shutting down");
        }
    }

    private GroupEntry getGroupEntry(ActivationGroupID activationGroupID) throws UnknownGroupException {
        GroupEntry groupEntry = (GroupEntry)this.groupTable.get(activationGroupID);
        if (groupEntry == null) {
            throw new UnknownGroupException("unknown group: " + activationGroupID);
        }
        return groupEntry;
    }

    private GroupEntry getGroupEntry(ActivationID activationID) throws UnknownGroupException, UnknownObjectException {
        return this.getGroupEntry(this.getGroupID(activationID));
    }

    private ActivationGroupID getGroupID(ActivationID activationID) throws UnknownObjectException {
        ActivationGroupID activationGroupID = (ActivationGroupID)this.idTable.get(activationID);
        if (activationGroupID == null) {
            throw new UnknownObjectException("unknown object: " + activationID);
        }
        return activationGroupID;
    }

    private static int getInt(String string, int n) {
        return (Integer)AccessController.doPrivileged(new GetIntegerAction(string, n));
    }

    private void init(int n, ReliableLog reliableLog, String[] stringArray) throws Exception {
        this.log = reliableLog;
        this.numUpdates = 0;
        Object object = this.startupLock = new Object();
        synchronized (object) {
            this.activator = new ActivatorImpl(n);
            this.activatorStub = (Activator)RemoteObject.toStub(this.activator);
            this.system = new ActivationSystemImpl(n);
            this.systemStub = (ActivationSystem)RemoteObject.toStub(this.system);
            this.monitor = new ActivationMonitorImpl(n);
            this.initCommand(stringArray);
            Naming.rebind("//:" + n + "/java.rmi.activation.ActivationSystem", this.system);
        }
        this.startupLock = null;
    }

    private void initCommand(String[] stringArray) {
        this.command = new String[stringArray.length + 2];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ((Activation)Activation.this).command[0] = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
                }
                catch (Exception exception) {
                    System.err.println(Activation.textrsrc("rmid.unfound.java.home.property"));
                    ((Activation)Activation.this).command[0] = "java";
                }
                return null;
            }
        });
        System.arraycopy(stringArray, 0, this.command, 1, stringArray.length);
        this.command[this.command.length - 1] = "sun.rmi.server.ActivationGroupInit";
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            int n = 1098;
            String string = "log";
            ArrayList arrayList = new ArrayList();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals("-port")) {
                    if (n2 + 1 < stringArray.length) {
                        try {
                            n = Integer.parseInt(stringArray[++n2]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            Activation.bomb(Activation.textrsrc("rmid.syntax.port.badnumber"));
                        }
                    } else {
                        Activation.bomb(Activation.textrsrc("rmid.syntax.port.missing"));
                    }
                } else if (stringArray[n2].equals("-log")) {
                    if (n2 + 1 < stringArray.length) {
                        string = stringArray[++n2];
                    } else {
                        Activation.bomb(Activation.textrsrc("rmid.syntax.log.missing"));
                    }
                } else if (stringArray[n2].equals("-stop")) {
                    bl = true;
                } else if (stringArray[n2].startsWith("-C")) {
                    arrayList.add(stringArray[n2].substring(2));
                } else {
                    Object[] objectArray = new Object[]{stringArray[n2]};
                    Activation.bomb(MessageFormat.format(Activation.textrsrc("rmid.syntax.illegal.option"), objectArray));
                }
                ++n2;
            }
            if (bl) {
                final int n3 = n;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        System.setProperty("java.rmi.activation.port", Integer.toString(n3));
                        return null;
                    }
                });
                ActivationSystem activationSystem = ActivationGroup.getSystem();
                activationSystem.shutdown();
                System.exit(0);
            }
            registry = LocateRegistry.createRegistry(n);
            Activation.startActivation(n, string, (String[])arrayList.toArray(new String[arrayList.size()]));
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{exception.getMessage()};
            System.err.println(MessageFormat.format(Activation.textrsrc("rmid.unexpected.exception"), objectArray));
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void restartServices() {
        Enumeration enumeration = this.groupTable.keys();
        while (enumeration.hasMoreElements()) {
            ActivationGroupID activationGroupID = (ActivationGroupID)enumeration.nextElement();
            try {
                GroupEntry groupEntry = this.getGroupEntry(activationGroupID);
                groupEntry.restartServices();
            }
            catch (UnknownGroupException unknownGroupException) {
                System.err.println("\nrmid: unable to restart services");
                System.err.println("rmid: exception occurred: " + unknownGroupException.getMessage());
                unknownGroupException.printStackTrace(System.err);
            }
        }
    }

    public void run() {
        try {
            Activation.unexport(this.activator);
            Activation.unexport(this.system);
            try {
                this.log.close();
            }
            catch (IOException iOException) {}
            Enumeration enumeration = this.groupTable.elements();
            while (enumeration.hasMoreElements()) {
                GroupEntry groupEntry = (GroupEntry)enumeration.nextElement();
                groupEntry.shutdown();
            }
            Activation.unexport(this.monitor);
        }
        finally {
            Object var2_3 = null;
            System.err.println(Activation.textrsrc("rmid.daemon.shutdown"));
            System.exit(0);
        }
    }

    private synchronized void shutdownAll() {
        Thread thread = null;
        if (this.shuttingDown) {
            return;
        }
        this.shuttingDown = true;
        thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this, "RMID Shutdown", false));
        thread.start();
    }

    private static void startActivation(int n, String string, String[] stringArray) throws Exception {
        ReliableLog reliableLog = new ReliableLog(string, new ActLogHandler());
        Activation activation = (Activation)reliableLog.recover();
        activation.init(n, reliableLog, stringArray);
        activation.restartServices();
    }

    private static String textrsrc(String string) {
        if (resources == null) {
            try {
                resources = ResourceBundle.getBundle("sun.rmi.rmid.resources.rmid");
            }
            catch (MissingResourceException missingResourceException) {}
            if (resources == null) {
                return "[missing resource file: " + string + "]";
            }
        }
        String string2 = null;
        try {
            string2 = resources.getString(string);
        }
        catch (MissingResourceException missingResourceException) {}
        if (string2 == null) {
            return "[missing resource: " + string + "]";
        }
        return string2;
    }

    private static void unexport(Remote remote) {
        while (true) {
            try {
                while (!UnicastRemoteObject.unexportObject(remote, false)) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    class ActivatorImpl
    extends RemoteServer
    implements Activator {
        ActivatorImpl(int n) throws RemoteException {
            LiveRef liveRef = new LiveRef(new ObjID(1), n);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            this.ref = unicastServerRef;
            unicastServerRef.exportObject(this, null);
        }

        public MarshalledObject activate(ActivationID activationID, boolean bl) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            return Activation.this.getGroupEntry(activationID).activate(activationID, bl);
        }
    }

    class ActivationMonitorImpl
    extends UnicastRemoteObject
    implements ActivationMonitor {
        ActivationMonitorImpl(int n) throws RemoteException {
            super(n);
        }

        public void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("ActivationSystem.activeObject");
            try {
                Activation.this.getGroupEntry(activationID).activeObject(activationID, marshalledObject);
            }
            catch (UnknownGroupException unknownGroupException) {
                throw new UnknownObjectException("object's group removed");
            }
        }

        public void inactiveGroup(ActivationGroupID activationGroupID, long l) throws UnknownGroupException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            GroupEntry groupEntry = Activation.this.getGroupEntry(activationGroupID);
            groupEntry.inactiveGroup(l);
        }

        public void inactiveObject(ActivationID activationID) throws UnknownObjectException, RemoteException {
            try {
                Activation.this.checkShutdown();
            }
            catch (ActivationException activationException) {
                return;
            }
            RegistryImpl.checkAccess("Activator.inactiveObject");
            try {
                Activation.this.getGroupEntry(activationID).inactiveObject(activationID);
            }
            catch (UnknownGroupException unknownGroupException) {
                throw new UnknownObjectException("object's group removed");
            }
        }
    }

    class ActivationSystemImpl
    extends RemoteServer
    implements ActivationSystem {
        ActivationSystemImpl(int n) throws RemoteException {
            LiveRef liveRef = new LiveRef(new ObjID(4), n);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            this.ref = unicastServerRef;
            unicastServerRef.exportObject(this, null);
        }

        public ActivationMonitor activeGroup(ActivationGroupID activationGroupID, ActivationInstantiator activationInstantiator, long l) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.activeGroup");
            Activation.this.getGroupEntry(activationGroupID).activeGroup(activationInstantiator, l);
            return Activation.this.monitor;
        }

        public ActivationDesc getActivationDesc(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.getActivationDesc");
            return Activation.this.getGroupEntry(activationID).getActivationDesc(activationID);
        }

        public ActivationGroupDesc getActivationGroupDesc(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.getActivationGroupDesc");
            return ((Activation)Activation.this).getGroupEntry((ActivationGroupID)activationGroupID).desc;
        }

        public ActivationGroupID registerGroup(ActivationGroupDesc activationGroupDesc) throws ActivationException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.registerGroup");
            ActivationGroupID activationGroupID = new ActivationGroupID(Activation.this.systemStub);
            GroupEntry groupEntry = new GroupEntry(activationGroupID, activationGroupDesc);
            Activation.this.groupTable.put(activationGroupID, groupEntry);
            Activation.this.addLogRecord(new LogRegisterGroup(activationGroupID, activationGroupDesc));
            return activationGroupID;
        }

        public ActivationID registerObject(ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.registerObject");
            ActivationGroupID activationGroupID = activationDesc.getGroupID();
            ActivationID activationID = new ActivationID(Activation.this.activatorStub);
            Activation.this.getGroupEntry(activationGroupID).registerObject(activationID, activationDesc, true);
            return activationID;
        }

        public ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc) throws ActivationException, UnknownGroupException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            if (!Activation.this.getGroupID(activationID).equals(activationDesc.getGroupID())) {
                throw new ActivationException("ActivationDesc contains wrong group");
            }
            RegistryImpl.checkAccess("ActivationSystem.setActivationDesc");
            return Activation.this.getGroupEntry(activationID).setActivationDesc(activationID, activationDesc, true);
        }

        public ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.setActivationGroupDesc");
            return Activation.this.getGroupEntry(activationGroupID).setActivationGroupDesc(activationGroupID, activationGroupDesc, true);
        }

        public void shutdown() throws RemoteException {
            Object object = Activation.this.startupLock;
            if (object != null) {
                Object object2 = object;
                synchronized (object2) {
                }
            }
            Activation.this.shutdownAll();
        }

        public void unregisterGroup(ActivationGroupID activationGroupID) throws ActivationException, UnknownGroupException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.unregisterGroup");
            GroupEntry groupEntry = (GroupEntry)Activation.this.groupTable.remove(activationGroupID);
            if (groupEntry == null) {
                throw new UnknownGroupException("unknown group: " + activationGroupID);
            }
            groupEntry.unregisterGroup(true);
        }

        public void unregisterObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
            Activation.this.checkShutdown();
            RegistryImpl.checkAccess("ActivationSystem.unregisterObject");
            ActivationGroupID activationGroupID = (ActivationGroupID)Activation.this.idTable.get(activationID);
            if (activationGroupID == null) {
                throw new UnknownObjectException("object not registered");
            }
            Activation.this.getGroupEntry(activationGroupID).unregisterObject(activationID, true);
        }
    }

    private class GroupEntry
    implements Serializable {
        private static final long serialVersionUID = 7222464070032993304L;
        static final int MAX_TRIES = 2;
        ActivationGroupDesc desc = null;
        ActivationGroupID groupID = null;
        long incarnation = 0L;
        HashMap objects = null;
        HashSet restartSet = null;
        transient ActivationInstantiator group = null;
        transient boolean pendingCreate = false;
        transient Process child = null;
        transient boolean removed = false;
        transient RestartThread restartThread = null;

        GroupEntry(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.groupID = activationGroupID;
            this.desc = activationGroupDesc;
            this.objects = new HashMap(11);
            this.restartSet = new HashSet();
        }

        MarshalledObject activate(ActivationID activationID, boolean bl) throws ActivationException {
            GroupEntry groupEntry;
            ObjectEntry objectEntry;
            Serializable serializable = this;
            synchronized (serializable) {
                objectEntry = (ObjectEntry)this.objects.get(activationID);
            }
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown " + activationID);
            }
            if (!bl) {
                groupEntry = this;
                synchronized (groupEntry) {
                    if (objectEntry.stub != null) {
                        serializable = objectEntry.stub;
                        Object var6_6 = null;
                        return serializable;
                    }
                }
            }
            serializable = null;
            groupEntry = null;
            int n = 2;
            while (n > 0) {
                long l;
                boolean bl2;
                block24: {
                    ActivationInstantiator activationInstantiator;
                    bl2 = false;
                    GroupEntry groupEntry2 = this;
                    synchronized (groupEntry2) {
                        activationInstantiator = this.getInstantiator(this.groupID);
                        l = this.incarnation;
                    }
                    try {
                        return objectEntry.activate(activationID, bl, activationInstantiator);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        bl2 = true;
                        if (serializable == null) {
                            serializable = noSuchObjectException;
                        }
                    }
                    catch (ConnectException connectException) {
                        bl2 = true;
                        if (serializable == null) {
                            serializable = connectException;
                        }
                    }
                    catch (ConnectIOException connectIOException) {
                        bl2 = true;
                        if (serializable == null) {
                            serializable = connectIOException;
                        }
                    }
                    catch (RemoteException remoteException) {
                        if (serializable != null) break block24;
                        serializable = remoteException;
                    }
                }
                if (bl2) {
                    try {
                        bl2 = false;
                        Activation.this.monitor.inactiveGroup(this.groupID, l);
                    }
                    catch (Exception exception) {}
                }
                --n;
            }
            throw new ActivationException("group creation failed after 2 tries", (Throwable)serializable);
        }

        private String[] activationArgs() {
            String[] stringArray;
            Properties properties;
            ActivationGroupDesc.CommandEnvironment commandEnvironment = this.desc.getCommandEnvironment();
            ArrayList arrayList = new ArrayList();
            arrayList.add(commandEnvironment != null && commandEnvironment.getCommandPath() != null ? commandEnvironment.getCommandPath() : Activation.this.command[0]);
            if (commandEnvironment != null && commandEnvironment.getCommandOptions() != null) {
                arrayList.addAll(Arrays.asList(commandEnvironment.getCommandOptions()));
            }
            if ((properties = this.desc.getPropertyOverrides()) != null) {
                Enumeration enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    stringArray = (String[])enumeration.nextElement();
                    arrayList.add("-D" + (String)stringArray + "=" + properties.getProperty((String)stringArray));
                }
            }
            int n = 1;
            while (n < Activation.this.command.length) {
                arrayList.add(Activation.this.command[n]);
                ++n;
            }
            stringArray = new String[arrayList.size()];
            System.arraycopy(arrayList.toArray(), 0, stringArray, 0, stringArray.length);
            return stringArray;
        }

        synchronized void activeGroup(ActivationInstantiator activationInstantiator, long l) throws ActivationException, UnknownGroupException {
            if (this.child != null && !this.pendingCreate) {
                throw new ActivationException("group not being created");
            }
            if (this.incarnation != l) {
                throw new ActivationException("invalid incarnation");
            }
            if (this.group != null) {
                throw new ActivationException("group already active");
            }
            this.group = activationInstantiator;
            this.pendingCreate = false;
            this.notifyAll();
        }

        synchronized void activeObject(ActivationID activationID, MarshalledObject marshalledObject) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            objectEntry.stub = marshalledObject;
        }

        private void checkRemoved() throws UnknownGroupException {
            if (this.removed) {
                throw new UnknownGroupException("Group removed");
            }
        }

        private synchronized void disposeRestartThread() {
            if (this.restartThread != null) {
                this.restartThread.dispose();
                this.restartThread = null;
            }
        }

        private synchronized void ensureRestart() {
            Thread thread = null;
            if (this.restartSet.size() > 0) {
                this.restartThread = new RestartThread(this.child, this.incarnation);
                StringBuffer stringBuffer = new StringBuffer("RMID RestartObjects-");
                int n = nextRestart + 1;
                nextRestart = n;
                thread = (Thread)AccessController.doPrivileged(new RMIThreadAction(this.restartThread, stringBuffer.append(n).toString(), true));
                this.restartThread.setThread(thread);
                thread.start();
            }
        }

        synchronized ActivationDesc getActivationDesc(ActivationID activationID) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            return objectEntry.desc;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private synchronized ActivationInstantiator getInstantiator(ActivationGroupID activationGroupID) throws UnknownGroupException, ActivationException {
            boolean bl;
            block15: {
                this.checkRemoved();
                bl = false;
                boolean bl2 = false;
                if (this.group != null) {
                    return this.group;
                }
                try {
                    if (!this.pendingCreate) {
                        this.resetAll();
                        this.pendingCreate = true;
                        try {
                            Object object;
                            String[] stringArray = this.activationArgs();
                            boolean bl3 = false;
                            Boolean bl4 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.activation.debugExec"));
                            bl3 = bl4;
                            try {
                                Activation.Pstartgroup();
                                bl = true;
                            }
                            catch (InterruptedException interruptedException) {}
                            if (bl3) {
                                object = new StringBuffer(stringArray[0]);
                                int n = 1;
                                while (true) {
                                    if (n >= stringArray.length) {
                                        System.err.println("rmid: debugExec: running \"" + ((StringBuffer)object).toString() + "\"");
                                        break;
                                    }
                                    ((StringBuffer)object).append(' ');
                                    ((StringBuffer)object).append(stringArray[n]);
                                    ++n;
                                }
                            }
                            this.child = Runtime.getRuntime().exec(stringArray);
                            ++this.incarnation;
                            this.ensureRestart();
                            object = this.child.getOutputStream();
                            MarshalOutputStream marshalOutputStream = new MarshalOutputStream((OutputStream)object);
                            marshalOutputStream.writeObject(activationGroupID);
                            marshalOutputStream.writeObject(this.desc);
                            marshalOutputStream.writeLong(this.incarnation);
                            marshalOutputStream.flush();
                            marshalOutputStream.close();
                            PipeWriter.plugTogetherPair(this.child.getInputStream(), System.out, this.child.getErrorStream(), System.err);
                            Activation.this.addLogRecord(new LogGroupIncarnation(activationGroupID, this.incarnation));
                        }
                        catch (IOException iOException) {
                            this.pendingCreate = false;
                            this.resetAll();
                            throw new ActivationException("unable to create activation group", iOException);
                        }
                    }
                    try {
                        this.wait(execTimeout);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.group == null) {
                        this.pendingCreate = false;
                        this.resetAll();
                        throw new ActivationException("timeout creating child process");
                    }
                    Object var5_11 = null;
                    if (!bl) break block15;
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    if (bl) {
                        Activation.Vstartgroup();
                    }
                    bl = false;
                    throw throwable;
                }
                Activation.Vstartgroup();
            }
            bl = false;
            return this.group;
        }

        synchronized void inactiveGroup(long l) throws UnknownGroupException {
            this.checkRemoved();
            if (this.incarnation != l) {
                throw new UnknownGroupException("invalid incarnation");
            }
            this.disposeRestartThread();
            if (!this.pendingCreate) {
                this.reset();
            }
        }

        synchronized void inactiveObject(ActivationID activationID) throws UnknownObjectException, UnknownGroupException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            objectEntry.reset();
        }

        synchronized void registerObject(ActivationID activationID, ActivationDesc activationDesc, boolean bl) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.objects.put(activationID, new ObjectEntry(activationDesc));
            if (activationDesc.getRestartMode()) {
                this.restartSet.add(activationID);
            }
            Activation.this.idTable.put(activationID, this.groupID);
            if (bl) {
                Activation.this.addLogRecord(new LogRegisterObject(activationID, activationDesc));
            }
        }

        private synchronized void reset() {
            this.group = null;
            Iterator iterator = this.objects.values().iterator();
            while (iterator.hasNext()) {
                ((ObjectEntry)iterator.next()).reset();
            }
        }

        private synchronized void resetAll() {
            this.reset();
            if (this.child != null) {
                this.child.destroy();
                this.child = null;
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        void restartServices() {
            var1_1 = null;
            var2_2 /* !! */  = this;
            synchronized (var2_2 /* !! */ ) {
                if (this.restartSet.size() == 0) {
                    var3_3 = null;
                    return;
                }
                var1_1 = ((HashSet)this.restartSet.clone()).iterator();
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2 /* !! */ 
                if (true) ** GOTO lbl24
            }
            do {
                var2_2 /* !! */  = (ActivationID)var1_1.next();
                try {
                    this.activate((ActivationID)var2_2 /* !! */ , true);
                }
                catch (Exception var3_4) {
                    System.err.println("\nrmid: unable to restart service");
                    System.err.println("rmid: exception occurred: " + var3_4.getMessage());
                    var3_4.printStackTrace(System.err);
                }
lbl24:
                // 3 sources

            } while (var1_1.hasNext());
        }

        synchronized ActivationDesc setActivationDesc(ActivationID activationID, ActivationDesc activationDesc, boolean bl) throws UnknownObjectException, UnknownGroupException, ActivationException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
            if (objectEntry == null) {
                throw new UnknownObjectException("object unknown");
            }
            ActivationDesc activationDesc2 = objectEntry.desc;
            objectEntry.desc = activationDesc;
            if (activationDesc.getRestartMode()) {
                this.restartSet.add(activationID);
            } else {
                this.restartSet.remove(activationID);
            }
            if (bl) {
                Activation.this.addLogRecord(new LogUpdateDesc(activationID, activationDesc));
            }
            return activationDesc2;
        }

        synchronized ActivationGroupDesc setActivationGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc, boolean bl) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            ActivationGroupDesc activationGroupDesc2 = this.desc;
            this.desc = activationGroupDesc;
            if (bl) {
                Activation.this.addLogRecord(new LogUpdateGroupDesc(activationGroupID, activationGroupDesc));
            }
            return activationGroupDesc2;
        }

        synchronized void shutdown() {
            this.resetAll();
            this.disposeRestartThread();
        }

        synchronized void unregisterGroup(boolean bl) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            this.removed = true;
            Iterator iterator = this.objects.keySet().iterator();
            while (iterator.hasNext()) {
                ActivationID activationID = (ActivationID)iterator.next();
                Activation.this.idTable.remove(activationID);
                ObjectEntry objectEntry = (ObjectEntry)this.objects.get(activationID);
                objectEntry.removed = true;
            }
            this.objects.clear();
            this.restartSet.clear();
            this.disposeRestartThread();
            if (bl) {
                Activation.this.addLogRecord(new LogUnregisterGroup(this.groupID));
            }
            if (this.pendingCreate) {
                this.notifyAll();
            }
        }

        synchronized void unregisterObject(ActivationID activationID, boolean bl) throws UnknownGroupException, ActivationException {
            this.checkRemoved();
            ObjectEntry objectEntry = (ObjectEntry)this.objects.remove(activationID);
            objectEntry.removed = true;
            if (objectEntry.desc.getRestartMode()) {
                this.restartSet.remove(activationID);
                if (this.restartSet.size() == 0) {
                    this.disposeRestartThread();
                }
            }
            Activation.this.idTable.remove(activationID);
            if (bl) {
                Activation.this.addLogRecord(new LogUnregisterObject(activationID));
            }
        }

        private class RestartThread
        implements Runnable {
            Process groupProcess;
            long groupIncarnation;
            boolean canInterrupt = true;
            boolean shouldQuit = false;
            Thread thread;

            RestartThread(Process process, long l) {
                this.groupProcess = process;
                this.groupIncarnation = l;
            }

            void dispose() {
                this.shouldQuit = true;
                if (this.canInterrupt) {
                    this.thread.interrupt();
                }
            }

            public void run() {
                if (this.shouldQuit) {
                    return;
                }
                try {
                    this.groupProcess.waitFor();
                    if (this.shouldQuit) {
                        return;
                    }
                    this.canInterrupt = false;
                    GroupEntry groupEntry = GroupEntry.this;
                    synchronized (groupEntry) {
                        if (this.groupIncarnation == GroupEntry.this.incarnation) {
                            GroupEntry.this.reset();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                GroupEntry.this.restartServices();
            }

            void setThread(Thread thread) {
                this.thread = thread;
            }
        }
    }

    private static class ObjectEntry
    implements Serializable {
        ActivationDesc desc;
        transient MarshalledObject stub = null;
        transient boolean removed = false;

        ObjectEntry(ActivationDesc activationDesc) {
            this.desc = activationDesc;
        }

        synchronized MarshalledObject activate(ActivationID activationID, boolean bl, ActivationInstantiator activationInstantiator) throws RemoteException, ActivationException {
            MarshalledObject marshalledObject;
            if (this.removed) {
                throw new UnknownObjectException("object removed");
            }
            if (!bl && this.stub != null) {
                return this.stub;
            }
            this.stub = marshalledObject = activationInstantiator.newInstance(activationID, this.desc);
            return marshalledObject;
        }

        void reset() {
            this.stub = null;
        }
    }

    private static class ActLogHandler
    extends LogHandler {
        ActLogHandler() {
        }

        public Object applyUpdate(Object object, Object object2) throws Exception {
            return ((LogRecord)object).apply(object2);
        }

        public Object initialSnapshot() {
            class Sun_rmi_server_Activation$3 {
                /* synthetic */ Sun_rmi_server_Activation$3() {
                }
            }
            return new Activation();
        }
    }

    private static abstract class LogRecord
    implements Serializable {
        private static final long serialVersionUID = 8395140512322687529L;

        LogRecord() {
        }

        abstract Object apply(Object var1) throws Exception;
    }

    private static class LogRegisterObject
    extends LogRecord {
        private static final long serialVersionUID = -6280336276146085143L;
        private ActivationID id;
        private ActivationDesc desc;

        LogRegisterObject(ActivationID activationID, ActivationDesc activationDesc) {
            this.id = activationID;
            this.desc = activationDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.desc.getGroupID()).registerObject(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogRegisterObject: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUnregisterObject
    extends LogRecord {
        private static final long serialVersionUID = 6269824097396935501L;
        private ActivationID id;

        LogUnregisterObject(ActivationID activationID) {
            this.id = activationID;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).unregisterObject(this.id, false);
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterObject: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogRegisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -1966827458515403625L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogRegisterGroup(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }

        Object apply(Object object) {
            Hashtable hashtable = ((Activation)object).groupTable;
            Activation activation = (Activation)object;
            activation.getClass();
            hashtable.put(this.id, activation.new GroupEntry(this.id, this.desc));
            return object;
        }
    }

    private static class LogUpdateDesc
    extends LogRecord {
        private static final long serialVersionUID = 545511539051179885L;
        private ActivationID id;
        private ActivationDesc desc;

        LogUpdateDesc(ActivationID activationID, ActivationDesc activationDesc) {
            this.id = activationID;
            this.desc = activationDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).setActivationDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogUpdateDesc: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUpdateGroupDesc
    extends LogRecord {
        private static final long serialVersionUID = -1271300989218424337L;
        private ActivationGroupID id;
        private ActivationGroupDesc desc;

        LogUpdateGroupDesc(ActivationGroupID activationGroupID, ActivationGroupDesc activationGroupDesc) {
            this.id = activationGroupID;
            this.desc = activationGroupDesc;
        }

        Object apply(Object object) {
            try {
                ((Activation)object).getGroupEntry(this.id).setActivationGroupDesc(this.id, this.desc, false);
            }
            catch (Exception exception) {
                System.err.println("LogUpdateGroupDesc: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogUnregisterGroup
    extends LogRecord {
        private static final long serialVersionUID = -3356306586522147344L;
        private ActivationGroupID id;

        LogUnregisterGroup(ActivationGroupID activationGroupID) {
            this.id = activationGroupID;
        }

        Object apply(Object object) {
            GroupEntry groupEntry = (GroupEntry)((Activation)object).groupTable.remove(this.id);
            try {
                groupEntry.unregisterGroup(false);
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterGroup: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }

    private static class LogGroupIncarnation
    extends LogRecord {
        private static final long serialVersionUID = 4146872747377631897L;
        private ActivationGroupID id;
        private long inc;

        LogGroupIncarnation(ActivationGroupID activationGroupID, long l) {
            this.id = activationGroupID;
            this.inc = l;
        }

        Object apply(Object object) {
            try {
                GroupEntry groupEntry = ((Activation)object).getGroupEntry(this.id);
                groupEntry.incarnation = this.inc;
            }
            catch (Exception exception) {
                System.err.println("LogUnregisterGroup: skipping...");
                exception.printStackTrace();
            }
            return object;
        }
    }
}

