/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.server.LogStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.rmi.transport.Transport;

public class RMIThreadAction
implements PrivilegedAction {
    private Runnable runnable;
    private String name;
    private boolean daemon;
    private boolean nonSystem;
    private static ThreadGroup systemGroup;
    private static ThreadGroup nonSystemGroup;

    public RMIThreadAction(Runnable runnable, String string, boolean bl) {
        this(runnable, string, bl, false);
    }

    public RMIThreadAction(Runnable runnable, String string, boolean bl, boolean bl2) {
        this.runnable = runnable;
        this.name = string;
        this.daemon = bl;
        this.nonSystem = bl2;
    }

    private static synchronized ThreadGroup getNonSystemGroup() {
        if (nonSystemGroup == null) {
            try {
                final ThreadGroup threadGroup = RMIThreadAction.getSystemGroup();
                nonSystemGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return new ThreadGroup(threadGroup, "RMI Runtime");
                    }
                });
            }
            catch (SecurityException securityException) {
                if (Transport.logLevel >= 10) {
                    LogStream logStream = LogStream.log("transport");
                    logStream.println("RMIThread.getThreadGroup: security exception: ");
                    securityException.printStackTrace(logStream);
                }
                nonSystemGroup = new ThreadGroup("RMI runtime (applet)");
            }
            if (Transport.logLevel >= 20) {
                LogStream.log("transport").println("RMIThread.getThreadGroup: created RMI ThreadGroup:" + nonSystemGroup);
            }
        }
        return nonSystemGroup;
    }

    private static synchronized ThreadGroup getSystemGroup() {
        ThreadGroup threadGroup = null;
        if (systemGroup == null) {
            ThreadGroup threadGroup2;
            threadGroup = Thread.currentThread().getThreadGroup();
            while ((threadGroup2 = threadGroup.getParent()) != null) {
                if (Transport.logLevel >= 20) {
                    LogStream.log("transport").println("RMIThread.getThreadGroup: searching up from ThreadGroup: " + threadGroup);
                }
                threadGroup = threadGroup2;
            }
            if (Transport.logLevel >= 20) {
                LogStream.log("transport").println("RMIThread.getThreadGroup: found root ThreadGroup: " + threadGroup);
            }
            systemGroup = threadGroup;
        }
        return systemGroup;
    }

    private ThreadGroup getThreadGroup() {
        if (this.nonSystem) {
            return RMIThreadAction.getNonSystemGroup();
        }
        return RMIThreadAction.getSystemGroup();
    }

    public Object run() {
        Thread thread = new Thread(this.getThreadGroup(), this.runnable, "RMI " + this.name);
        thread.setDaemon(this.daemon);
        return thread;
    }
}

