/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.security.pkcs.PKCS10Attribute;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PKCS10Attributes
implements DerEncoder {
    private Hashtable map = new Hashtable(3);

    public PKCS10Attributes() {
    }

    public PKCS10Attributes(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = derInputStream.getSet(3, true);
        if (derValueArray == null) {
            throw new IOException("Illegal encoding of attributes");
        }
        int n = 0;
        while (n < derValueArray.length) {
            PKCS10Attribute pKCS10Attribute = new PKCS10Attribute(derValueArray[n]);
            this.map.put(pKCS10Attribute.getAttributeId().toString(), pKCS10Attribute);
            ++n;
        }
    }

    public PKCS10Attributes(PKCS10Attribute[] pKCS10AttributeArray) {
        int n = 0;
        while (n < pKCS10AttributeArray.length) {
            this.map.put(pKCS10AttributeArray[n].getAttributeId().toString(), pKCS10AttributeArray[n]);
            ++n;
        }
    }

    public void deleteAttribute(String string) {
        this.map.remove(string);
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        Collection collection = this.map.values();
        DerEncoder[] derEncoderArray = (PKCS10Attribute[])collection.toArray(new PKCS10Attribute[this.map.size()]);
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOrderedSetOf(DerValue.createTag((byte)-128, true, (byte)0), derEncoderArray);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.derEncode(outputStream);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PKCS10Attributes)) {
            return false;
        }
        Collection collection = ((PKCS10Attributes)object).getAttributes();
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        if (n != this.map.size()) {
            return false;
        }
        String string = null;
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] instanceof PKCS10Attribute) {
                PKCS10Attribute pKCS10Attribute = (PKCS10Attribute)objectArray[n2];
                string = pKCS10Attribute.getAttributeId().toString();
                if (string == null) {
                    return false;
                }
                PKCS10Attribute pKCS10Attribute2 = (PKCS10Attribute)this.map.get(string);
                if (pKCS10Attribute2 == null) {
                    return false;
                }
                if (!pKCS10Attribute2.equals(pKCS10Attribute)) {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public Object getAttribute(String string) {
        return this.map.get(string);
    }

    public Collection getAttributes() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public Enumeration getElements() {
        return this.map.elements();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public void setAttribute(String string, Object object) {
        this.map.put(string, object);
    }

    public String toString() {
        String string = String.valueOf(this.map.size()) + "\n" + this.map.toString();
        return string;
    }
}

