/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.security.Identity;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.misc.BASE64Encoder;
import sun.security.pkcs.PKCS10;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.util.DerOutputStream;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class KeyTool {
    private boolean debug = false;
    private String command = null;
    private String sigAlgName = null;
    private String keyAlgName = "DSA";
    private boolean verbose = false;
    private int keysize = 1024;
    private boolean rfc = false;
    private int validity = 90;
    private String alias = null;
    private String dname = null;
    private String keyAlias = "mykey";
    private String dest = null;
    private String filename = null;
    private String storetype = null;
    private char[] storePass = null;
    private char[] storePassNew = null;
    private char[] keyPass = null;
    private char[] keyPassNew = null;
    private char[] oldPass = null;
    private char[] newPass = null;
    private String ksfname = null;
    private File ksfile = null;
    private InputStream ksStream = null;
    private InputStream inStream = null;
    private KeyStore keyStore = null;
    private boolean kssave = false;
    private boolean noprompt = false;
    private boolean trustcacerts = false;
    private CertificateFactory cf = null;

    private KeyTool() {
    }

    private boolean addTrustedCert(String string, InputStream inputStream) throws Exception {
        Certificate[] certificateArray;
        if (string == null) {
            throw new Exception("Must specify alias");
        }
        if (this.keyStore.containsAlias(string)) {
            throw new Exception("Certificate not imported, alias <" + string + "> already exists");
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)this.cf.generateCertificate(inputStream);
        }
        catch (ClassCastException classCastException) {
            throw new Exception("Input not an X.509 certificate");
        }
        catch (CertificateException certificateException) {
            throw new Exception("Input not an X.509 certificate");
        }
        boolean bl = false;
        if (this.isSelfSigned(x509Certificate)) {
            x509Certificate.verify(x509Certificate.getPublicKey());
            bl = true;
        }
        if (this.noprompt) {
            this.keyStore.setCertificateEntry(string, x509Certificate);
            return true;
        }
        String string2 = null;
        String string3 = this.keyStore.getCertificateAlias(x509Certificate);
        if (string3 != null) {
            System.err.println("Certificate already exists in keystore under alias <" + string3 + ">");
            string2 = this.getYesNoReply("Do you still want to add it? [no]:  ");
        } else if (bl) {
            if (this.trustcacerts && (certificateArray = this.getCacertsKeyStore()) != null && (string3 = certificateArray.getCertificateAlias(x509Certificate)) != null) {
                System.err.println("Certificate already exists in system-wide CA keystore under alias <" + string3 + ">");
                string2 = this.getYesNoReply("Do you still want to add it to your own keystore? [no]:  ");
            }
            if (string3 == null) {
                this.printX509Cert(x509Certificate, System.out);
                string2 = this.getYesNoReply("Trust this certificate? [no]:  ");
            }
        }
        if (string2 != null) {
            if (string2.equalsIgnoreCase("YES")) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
            return false;
        }
        try {
            certificateArray = this.establishCertChain(null, x509Certificate);
            if (certificateArray != null) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
        }
        catch (Exception exception) {
            this.printX509Cert(x509Certificate, System.out);
            string2 = this.getYesNoReply("Trust this certificate? [no]:  ");
            if (string2.equalsIgnoreCase("YES")) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean buildChain(X509Certificate x509Certificate, Vector vector, Hashtable hashtable) {
        Principal principal;
        Principal principal2 = x509Certificate.getSubjectDN();
        if (principal2.equals(principal = x509Certificate.getIssuerDN())) {
            vector.addElement(x509Certificate);
            return true;
        }
        Vector vector2 = (Vector)hashtable.get(principal);
        if (vector2 == null) {
            return false;
        }
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate2 = (X509Certificate)enumeration.nextElement();
            PublicKey publicKey = x509Certificate2.getPublicKey();
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception) {
                continue;
            }
            if (!this.buildChain(x509Certificate2, vector, hashtable)) continue;
            vector.addElement(x509Certificate);
            return true;
        }
        return false;
    }

    private void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private void doCertReq(String string, String string2, PrintStream printStream) throws Exception {
        Object object;
        Certificate certificate;
        if (string == null) {
            string = this.keyAlias;
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            throw new Exception(String.valueOf(string) + " has no public key (certificate)");
        }
        PKCS10 pKCS10 = new PKCS10(certificate.getPublicKey());
        if (string2 == null) {
            object = privateKey.getAlgorithm();
            if (((String)object).equalsIgnoreCase("DSA") || ((String)object).equalsIgnoreCase("DSS")) {
                string2 = "SHA1WithDSA";
            } else if (((String)object).equalsIgnoreCase("RSA")) {
                string2 = "MD5WithRSA";
            } else {
                throw new Exception("Cannot derive signature algorithm");
            }
        }
        object = Signature.getInstance(string2);
        ((Signature)object).initSign(privateKey);
        X500Name x500Name = (X500Name)((X509Certificate)certificate).getSubjectDN();
        X500Signer x500Signer = new X500Signer((Signature)object, x500Name);
        pKCS10.encodeAndSign(x500Signer);
        pKCS10.print(printStream);
    }

    private void doChangeKeyPasswd(String string) throws Exception {
        if (string == null) {
            string = this.keyAlias;
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if (this.keyPassNew == null) {
            this.keyPassNew = this.getNewPasswd("key password for <" + string + ">", this.keyPass);
        }
        this.keyStore.setKeyEntry(string, privateKey, this.keyPassNew, this.keyStore.getCertificateChain(string));
    }

    private void doCloneKey(String string, String string2) throws Exception {
        if (string == null) {
            string = this.keyAlias;
        }
        if (this.keyStore.containsAlias(string2)) {
            throw new Exception("Destination alias <" + string2 + "> already exists");
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if (this.keyPassNew == null) {
            int n = 0;
            do {
                this.keyPassNew = this.getKeyPasswd(string2, string, this.keyPass);
                if (this.keyPassNew.length >= 6) continue;
                System.err.println("Password is too short - must be at least 6 characters");
                this.keyPassNew = null;
            } while (this.keyPassNew == null && ++n < 3);
            if (this.keyPassNew == null) {
                throw new Exception("Too many failures. Key entry not cloned");
            }
        }
        this.keyStore.setKeyEntry(string2, privateKey, this.keyPassNew, this.keyStore.getCertificateChain(string));
    }

    void doCommands(PrintStream printStream) throws Exception {
        block63: {
            if (this.command.equals("list") && this.verbose && this.rfc) {
                System.err.println("Must not specify both -v and -rfc with 'list' command");
                this.usage();
            }
            if (this.command.equals("keyclone") && this.dest == null) {
                this.dest = this.getAlias("destination");
                if (this.dest.equals("")) {
                    throw new Exception("Must specify destination alias");
                }
            }
            if (this.command.equals("delete") && this.alias == null) {
                this.alias = this.getAlias(null);
                if (this.alias.equals("")) {
                    throw new Exception("Must specify alias");
                }
            }
            if (this.storePass != null && this.storePass.length < 6) {
                throw new Exception("Keystore password must be at least 6 characters");
            }
            if (this.keyPass != null && this.keyPass.length < 6) {
                throw new Exception("Key password must be at least 6 characters");
            }
            if (this.newPass != null && this.newPass.length < 6) {
                throw new Exception("New password must be at least 6 characters");
            }
            if (!this.command.equals("printcert")) {
                if (this.ksfname == null) {
                    this.ksfname = String.valueOf(System.getProperty("user.home")) + File.separator + ".keystore";
                }
                try {
                    this.ksfile = new File(this.ksfname);
                    if (this.ksfile.exists() && this.ksfile.length() == 0L) {
                        throw new Exception("Keystore file exists, but is empty: " + this.ksfname);
                    }
                    this.ksStream = new FileInputStream(this.ksfile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.command.equals("genkey") || this.command.equals("identitydb") || this.command.equals("import")) break block63;
                    throw new Exception("Keystore file does not exist: " + this.ksfname);
                }
            }
        }
        this.keyStore = this.storetype != null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(KeyStore.getDefaultType());
        this.keyStore.load(this.ksStream, this.storePass);
        if (this.ksStream != null) {
            this.ksStream.close();
        }
        if (this.storePass == null) {
            if (this.command.equals("certreq") || this.command.equals("delete") || this.command.equals("genkey") || this.command.equals("import") || this.command.equals("keyclone") || this.command.equals("selfcert") || this.command.equals("storepasswd") || this.command.equals("keypasswd") || this.command.equals("identitydb")) {
                int n = 0;
                do {
                    System.err.print("Enter keystore password:  ");
                    System.err.flush();
                    this.storePass = this.readPasswd(System.in);
                    if (this.ksStream != null || this.storePass.length >= 6) continue;
                    System.err.println("Keystore password is too short - must be at least 6 characters");
                    this.storePass = null;
                } while (this.storePass == null && ++n < 3);
                if (this.storePass == null) {
                    System.err.println("Too many failures - try later");
                    return;
                }
            } else if (!this.command.equals("printcert")) {
                System.err.print("Enter keystore password:  ");
                System.err.flush();
                this.storePass = this.readPasswd(System.in);
            }
            if (this.ksStream != null) {
                this.ksStream = new FileInputStream(this.ksfile);
                this.keyStore.load(this.ksStream, this.storePass);
                this.ksStream.close();
            }
        }
        if (this.command.equals("printcert") || this.command.equals("import") || this.command.equals("identitydb")) {
            this.cf = CertificateFactory.getInstance("X509");
        }
        if (this.command.equals("certreq")) {
            if (this.filename != null) {
                PrintStream printStream2;
                printStream = printStream2 = new PrintStream(new FileOutputStream(this.filename));
            }
            this.doCertReq(this.alias, this.sigAlgName, printStream);
            if (this.verbose && this.filename != null) {
                System.err.println("Certification request stored in file <" + this.filename + ">");
                System.err.println("Submit this to your CA");
            }
        } else if (this.command.equals("delete")) {
            this.doDeleteEntry(this.alias);
            this.kssave = true;
        } else if (this.command.equals("export")) {
            if (this.filename != null) {
                PrintStream printStream3;
                printStream = printStream3 = new PrintStream(new FileOutputStream(this.filename));
            }
            this.doExportCert(this.alias, printStream);
            if (this.filename != null) {
                System.err.println("Certificate stored in file <" + this.filename + ">");
            }
        } else if (this.command.equals("genkey")) {
            this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
            this.kssave = true;
        } else if (this.command.equals("identitydb")) {
            InputStream inputStream = System.in;
            if (this.filename != null) {
                inputStream = new FileInputStream(this.filename);
            }
            this.doImportIdentityDatabase(inputStream);
        } else if (this.command.equals("import")) {
            String string;
            InputStream inputStream = System.in;
            if (this.filename != null) {
                inputStream = new FileInputStream(this.filename);
            }
            String string2 = string = this.alias != null ? this.alias : this.keyAlias;
            if (this.keyStore.isKeyEntry(string)) {
                this.kssave = this.installReply(string, inputStream);
                if (this.kssave) {
                    System.err.println("Certificate reply was installed in keystore");
                } else {
                    System.err.println("Certificate reply was not installed in keystore");
                }
            } else {
                this.kssave = this.addTrustedCert(string, inputStream);
                if (this.kssave) {
                    System.err.println("Certificate was added to keystore");
                } else {
                    System.err.println("Certificate was not added to keystore");
                }
            }
        } else if (this.command.equals("keyclone")) {
            this.keyPassNew = this.newPass;
            this.doCloneKey(this.alias, this.dest);
            this.kssave = true;
        } else if (this.command.equals("keypasswd")) {
            this.keyPassNew = this.newPass;
            this.doChangeKeyPasswd(this.alias);
            this.kssave = true;
        } else if (this.command.equals("list")) {
            if (this.alias != null) {
                this.doPrintEntry(this.alias, printStream, true);
            } else {
                this.doPrintEntries(printStream);
            }
        } else if (this.command.equals("printcert")) {
            InputStream inputStream = System.in;
            if (this.filename != null) {
                inputStream = new FileInputStream(this.filename);
            }
            this.doPrintCert(inputStream, printStream);
        } else if (this.command.equals("selfcert")) {
            this.doSelfCert(this.alias, this.dname, this.sigAlgName);
            this.kssave = true;
        } else if (this.command.equals("storepasswd")) {
            this.storePassNew = this.newPass;
            if (this.storePassNew == null) {
                this.storePassNew = this.getNewPasswd("keystore password", this.storePass);
            }
            this.kssave = true;
        }
        if (this.kssave) {
            if (this.verbose) {
                System.err.println("[Saving " + this.ksfname + "]");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.ksfname);
            this.keyStore.store(fileOutputStream, this.storePassNew != null ? this.storePassNew : this.storePass);
            fileOutputStream.close();
        }
    }

    private void doDeleteEntry(String string) throws Exception {
        if (!this.keyStore.containsAlias(string)) {
            throw new Exception("Alias <" + string + "> does not exist");
        }
        this.keyStore.deleteEntry(string);
    }

    private void doExportCert(String string, PrintStream printStream) throws Exception {
        if (this.storePass == null) {
            this.printWarning();
        }
        if (string == null) {
            string = this.keyAlias;
        }
        if (!this.keyStore.containsAlias(string)) {
            throw new Exception("Alias <" + string + "> does not exist");
        }
        X509Certificate x509Certificate = (X509Certificate)this.keyStore.getCertificate(string);
        if (x509Certificate == null) {
            throw new Exception("Alias <" + string + "> has no certificate");
        }
        this.dumpCert(x509Certificate, printStream);
    }

    private void doGenKeyPair(String string, String string2, String string3, int n, String string4) throws Exception {
        if (string == null) {
            string = this.keyAlias;
        }
        if (this.keyStore.containsAlias(string)) {
            throw new Exception("Key pair not generated, alias <" + string + "> already exists");
        }
        if (string4 == null) {
            if (string3.equalsIgnoreCase("DSA")) {
                string4 = "SHA1WithDSA";
            } else if (string3.equalsIgnoreCase("RSA")) {
                string4 = "MD5WithRSA";
            } else {
                throw new Exception("Cannot derive signature algorithm");
            }
        }
        CertAndKeyGen certAndKeyGen = new CertAndKeyGen(string3, string4);
        X500Name x500Name = string2 == null ? this.getX500Name() : new X500Name(string2);
        if (this.verbose) {
            System.err.println("Generating " + n + " bit " + string3 + " key pair and " + "self-signed certificate (" + string4 + ")");
            System.err.println("\tfor: " + x500Name);
        }
        certAndKeyGen.generate(n);
        PrivateKey privateKey = certAndKeyGen.getPrivateKey();
        Certificate[] certificateArray = new X509Certificate[]{certAndKeyGen.getSelfCertificate(x500Name, this.validity * 24 * 60 * 60)};
        if (this.keyPass == null) {
            int n2 = 0;
            while (n2 < 3 && this.keyPass == null) {
                System.err.println("Enter key password for <" + string + ">");
                System.err.print("\t(RETURN if same as keystore password):  ");
                System.err.flush();
                this.keyPass = this.readPasswd(System.in);
                if (this.keyPass == null) {
                    this.keyPass = this.storePass;
                } else if (this.keyPass.length < 6) {
                    System.err.println("Key password is too short - must be at least 6 characters");
                    this.keyPass = null;
                }
                ++n2;
            }
            if (n2 == 3) {
                throw new Exception("Too many failures - key not added to keystore");
            }
        }
        this.keyStore.setKeyEntry(string, privateKey, this.keyPass, certificateArray);
    }

    private void doImportIdentityDatabase(InputStream inputStream) throws Exception {
        Certificate[] certificateArray = null;
        boolean bl = false;
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(inputStream);
        Enumeration enumeration = identityDatabase.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            X509Certificate x509Certificate = null;
            if ((!(identity instanceof SystemSigner) || !((SystemSigner)identity).isTrusted()) && (!(identity instanceof SystemIdentity) || !((SystemIdentity)identity).isTrusted())) continue;
            if (this.keyStore.containsAlias(identity.getName())) {
                System.err.println("Keystore entry for <" + identity.getName() + "> already exists");
                continue;
            }
            java.security.Certificate[] certificateArray2 = identity.certificates();
            if (certificateArray2 == null || certificateArray2.length <= 0) continue;
            DerOutputStream derOutputStream = new DerOutputStream();
            certificateArray2[0].encode(derOutputStream);
            byte[] byArray = derOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            x509Certificate = (X509Certificate)this.cf.generateCertificate(byteArrayInputStream);
            byteArrayInputStream.close();
            if (this.isSelfSigned(x509Certificate)) {
                PublicKey publicKey = x509Certificate.getPublicKey();
                try {
                    x509Certificate.verify(publicKey);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (identity instanceof SystemSigner) {
                System.err.println("Creating keystore entry for <" + identity.getName() + "> ...");
                if (certificateArray == null) {
                    certificateArray = new Certificate[]{x509Certificate};
                }
                PrivateKey privateKey = ((SystemSigner)identity).getPrivateKey();
                this.keyStore.setKeyEntry(identity.getName(), privateKey, this.storePass, certificateArray);
            } else {
                this.keyStore.setCertificateEntry(identity.getName(), x509Certificate);
            }
            this.kssave = true;
        }
        if (!this.kssave) {
            System.err.println("No entries from identity database added");
        }
    }

    private void doPrintCert(InputStream inputStream, PrintStream printStream) throws Exception {
        Collection collection = null;
        try {
            collection = this.cf.generateCertificates(inputStream);
        }
        catch (CertificateException certificateException) {
            throw new Exception("Failed to parse input");
        }
        if (collection.isEmpty()) {
            throw new Exception("Empty input");
        }
        Certificate[] certificateArray = (Certificate[])collection.toArray();
        int n = 0;
        while (n < certificateArray.length) {
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = (X509Certificate)certificateArray[n];
            }
            catch (ClassCastException classCastException) {
                throw new Exception("Not X.509 certificate");
            }
            if (certificateArray.length > 1) {
                printStream.println("Certificate[" + (n + 1) + "]:");
            }
            this.printX509Cert(x509Certificate, printStream);
            if (n < certificateArray.length - 1) {
                printStream.println();
            }
            ++n;
        }
    }

    private void doPrintEntries(PrintStream printStream) throws Exception {
        if (this.storePass == null) {
            this.printWarning();
        } else {
            printStream.println();
        }
        printStream.println("Keystore type: " + this.keyStore.getType());
        printStream.println("Keystore provider: " + this.keyStore.getProvider().getName());
        printStream.println();
        printStream.println("Your keystore contains " + this.keyStore.size() + " entr" + (this.keyStore.size() == 1 ? "y:" : "ies:"));
        printStream.println();
        Enumeration enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.doPrintEntry(string, printStream, false);
            if (!this.verbose && !this.rfc) continue;
            printStream.println("\n");
            printStream.println("*******************************************");
            printStream.println("*******************************************\n\n");
        }
    }

    private void doPrintEntry(String string, PrintStream printStream, boolean bl) throws Exception {
        if (this.storePass == null && bl) {
            this.printWarning();
        }
        if (!this.keyStore.containsAlias(string)) {
            throw new Exception("Alias <" + string + "> does not exist");
        }
        if (this.verbose || this.rfc || this.debug) {
            printStream.println("Alias name: " + string);
            printStream.println("Creation date: " + this.keyStore.getCreationDate(string).toString());
        } else {
            printStream.print(String.valueOf(string) + ", " + this.keyStore.getCreationDate(string).toString() + ", ");
        }
        if (this.keyStore.isKeyEntry(string)) {
            if (this.verbose || this.rfc || this.debug) {
                printStream.println("Entry type: keyEntry");
            } else {
                printStream.println("keyEntry,");
            }
            Certificate[] certificateArray = this.keyStore.getCertificateChain(string);
            if (certificateArray != null) {
                if (this.verbose || this.rfc || this.debug) {
                    printStream.println("Certificate chain length: " + certificateArray.length);
                    int n = 0;
                    while (n < certificateArray.length) {
                        printStream.println("Certificate[" + (n + 1) + "]:");
                        if (this.verbose && certificateArray[n] instanceof X509Certificate) {
                            this.printX509Cert((X509Certificate)certificateArray[n], printStream);
                        } else if (this.debug) {
                            printStream.println(certificateArray[n].toString());
                        } else {
                            this.dumpCert(certificateArray[n], printStream);
                        }
                        ++n;
                    }
                } else {
                    printStream.println("Certificate fingerprint (MD5): " + this.getCertFingerPrint("MD5", certificateArray[0]));
                }
            }
        } else {
            Certificate certificate = this.keyStore.getCertificate(string);
            if (this.verbose && certificate instanceof X509Certificate) {
                printStream.println("Entry type: trustedCertEntry\n");
                this.printX509Cert((X509Certificate)certificate, printStream);
            } else if (this.rfc) {
                printStream.println("Entry type: trustedCertEntry\n");
                this.dumpCert(certificate, printStream);
            } else if (this.debug) {
                printStream.println(certificate.toString());
            } else {
                printStream.println("trustedCertEntry,");
                printStream.println("Certificate fingerprint (MD5): " + this.getCertFingerPrint("MD5", certificate));
            }
        }
    }

    private void doSelfCert(String string, String string2, String string3) throws Exception {
        X500Name x500Name;
        Object object;
        if (string == null) {
            string = this.keyAlias;
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if (string3 == null) {
            object = privateKey.getAlgorithm();
            if (((String)object).equalsIgnoreCase("DSA") || ((String)object).equalsIgnoreCase("DSS")) {
                string3 = "SHA1WithDSA";
            } else if (((String)object).equalsIgnoreCase("RSA")) {
                string3 = "MD5WithRSA";
            } else {
                throw new Exception("Cannot derive signature algorithm");
            }
        }
        if ((object = this.keyStore.getCertificate(string)) == null) {
            throw new Exception(String.valueOf(string) + " has no public key");
        }
        if (!(object instanceof X509Certificate)) {
            throw new Exception(String.valueOf(string) + " has no X.509 certificate");
        }
        byte[] byArray = ((Certificate)object).getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
        Date date = new Date();
        Date date2 = new Date();
        date2.setTime(date.getTime() + (long)(this.validity * 1000 * 24 * 60) * 60L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        x509CertInfo.set("validity", certificateValidity);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber((int)(date.getTime() / 1000L)));
        if (string2 == null) {
            x500Name = (X500Name)x509CertInfo.get("subject.dname");
        } else {
            x500Name = new X500Name(string2);
            x509CertInfo.set("subject.dname", x500Name);
        }
        x509CertInfo.set("issuer.dname", x500Name);
        X509CertImpl x509CertImpl2 = new X509CertImpl(x509CertInfo);
        x509CertImpl2.sign(privateKey, string3);
        AlgorithmId algorithmId = (AlgorithmId)x509CertImpl2.get("x509.algorithm");
        x509CertInfo.set("algorithmID.algorithm", algorithmId);
        x509CertImpl2 = new X509CertImpl(x509CertInfo);
        x509CertImpl2.sign(privateKey, string3);
        this.keyStore.setKeyEntry(string, privateKey, this.keyPass != null ? this.keyPass : this.storePass, new Certificate[]{x509CertImpl2});
        if (this.verbose) {
            System.err.println("New certificate (self-signed):");
            System.err.print(x509CertImpl2.toString());
            System.err.println();
        }
    }

    private void dumpCert(Certificate certificate, PrintStream printStream) throws IOException, CertificateException {
        if (this.rfc) {
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            printStream.println("-----BEGIN CERTIFICATE-----");
            bASE64Encoder.encodeBuffer(certificate.getEncoded(), (OutputStream)printStream);
            printStream.println("-----END CERTIFICATE-----");
        } else {
            printStream.write(certificate.getEncoded());
        }
    }

    private Certificate[] establishCertChain(Certificate certificate, Certificate certificate2) throws Exception {
        Object object;
        Serializable serializable;
        if (certificate != null) {
            serializable = certificate.getPublicKey();
            if (!serializable.equals(object = certificate2.getPublicKey())) {
                String string = "Public keys in reply and keystore don't match";
                throw new Exception(string);
            }
            if (certificate2.equals(certificate)) {
                String string = "Certificate reply and certificate in keystore are identical";
                throw new Exception(string);
            }
        }
        serializable = null;
        if (this.keyStore.size() > 0) {
            serializable = new Hashtable(11);
            this.keystorecerts2Hashtable(this.keyStore, (Hashtable)serializable);
        }
        if (this.trustcacerts && (object = this.getCacertsKeyStore()) != null && ((KeyStore)object).size() > 0) {
            if (serializable == null) {
                serializable = new Hashtable(11);
            }
            this.keystorecerts2Hashtable((KeyStore)object, (Hashtable)serializable);
        }
        if (this.buildChain((X509Certificate)certificate2, (Vector)(object = new Vector(2)), (Hashtable)serializable)) {
            Certificate[] certificateArray = new Certificate[((Vector)object).size()];
            int n = 0;
            int n2 = ((Vector)object).size() - 1;
            while (n2 >= 0) {
                certificateArray[n] = (Certificate)((Vector)object).elementAt(n2);
                ++n;
                --n2;
            }
            return certificateArray;
        }
        throw new Exception("Failed to establish chain from reply");
    }

    private String getAlias(String string) throws Exception {
        if (string != null) {
            System.err.print("Enter " + string + " alias name:  ");
        } else {
            System.err.print("Enter alias name:  ");
        }
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private KeyStore getCacertsKeyStore() throws Exception {
        String string = File.separator;
        File file = new File(String.valueOf(System.getProperty("java.home")) + string + "lib" + string + "security" + string + "cacerts");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(fileInputStream, null);
        fileInputStream.close();
        return keyStore;
    }

    private String getCertFingerPrint(String string, Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return this.toHexString(byArray2);
    }

    private char[] getKeyPasswd(String string, String string2, char[] cArray) throws Exception {
        int n = 0;
        char[] cArray2 = null;
        do {
            if (cArray != null) {
                System.err.println("Enter key password for <" + string + ">");
                System.err.print("\t(RETURN if same as for <" + string2 + ">):  ");
            } else {
                System.err.print("Enter key password for <" + string + ">:  ");
            }
            System.err.flush();
            cArray2 = this.readPasswd(System.in);
            if (cArray2 != null) continue;
            cArray2 = cArray;
        } while (cArray2 == null && ++n < 3);
        if (cArray2 == null) {
            throw new Exception("Too many failures - try later");
        }
        return cArray2;
    }

    private char[] getNewPasswd(String string, char[] cArray) throws Exception {
        char[] cArray2 = null;
        char[] cArray3 = null;
        int n = 0;
        while (n < 3) {
            System.err.print("New " + string + ":  ");
            cArray2 = this.readPasswd(System.in);
            if (cArray2.length < 6) {
                System.err.println("Password is too short - must be at least 6 characters");
            } else if (Arrays.equals(cArray2, cArray)) {
                System.err.println("Passwords must differ");
            } else {
                System.err.print("Re-enter new " + string + ":  ");
                cArray3 = this.readPasswd(System.in);
                if (!Arrays.equals(cArray2, cArray3)) {
                    System.err.println("They don't match; try again");
                } else {
                    Arrays.fill(cArray3, ' ');
                    return cArray2;
                }
            }
            if (cArray2 != null) {
                Arrays.fill(cArray2, ' ');
                cArray2 = null;
            }
            if (cArray3 != null) {
                Arrays.fill(cArray3, ' ');
                cArray3 = null;
            }
            ++n;
        }
        throw new Exception("Too many failures - try later");
    }

    private X500Name getX500Name() throws IOException {
        X500Name x500Name;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "Unknown";
        String string2 = "Unknown";
        String string3 = "Unknown";
        String string4 = "Unknown";
        String string5 = "Unknown";
        String string6 = "Unknown";
        String string7 = null;
        while (!(string7 = this.inputString(bufferedReader, "Is <" + (x500Name = new X500Name(string = this.inputString(bufferedReader, "What is your first and last name?", string), string2 = this.inputString(bufferedReader, "What is the name of your organizational unit?", string2), string3 = this.inputString(bufferedReader, "What is the name of your organization?", string3), string4 = this.inputString(bufferedReader, "What is the name of your City or Locality?", string4), string5 = this.inputString(bufferedReader, "What is the name of your State or Province?", string5), string6 = this.inputString(bufferedReader, "What is the two-letter country code for this unit?", string6))) + "> correct?", "no")).equalsIgnoreCase("yes") && !string7.equalsIgnoreCase("y")) {
        }
        System.err.println();
        return x500Name;
    }

    private String getYesNoReply(String string) throws IOException {
        String string2 = null;
        do {
            System.err.print(string);
            System.err.flush();
            string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (string2.equals("") || string2.equalsIgnoreCase("n") || string2.equalsIgnoreCase("no")) {
                string2 = "NO";
                continue;
            }
            if (string2.equalsIgnoreCase("y") || string2.equalsIgnoreCase("yes")) {
                string2 = "YES";
                continue;
            }
            System.err.println("Wrong answer, try again");
            string2 = null;
        } while (string2 == null);
        return string2;
    }

    private String inputString(BufferedReader bufferedReader, String string, String string2) throws IOException {
        System.err.println(string);
        System.err.print("  [" + string2 + "]:  ");
        System.err.flush();
        String string3 = bufferedReader.readLine();
        if (string3 == null || string3.equals("")) {
            string3 = string2;
        }
        return string3;
    }

    private boolean installReply(String string, InputStream inputStream) throws Exception {
        Certificate certificate;
        if (string == null) {
            string = this.keyAlias;
        }
        Object[] objectArray = this.recoverPrivateKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)objectArray[0];
        if (this.keyPass == null) {
            this.keyPass = (char[])objectArray[1];
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            throw new Exception(String.valueOf(string) + " has no public key (certificate)");
        }
        Collection collection = this.cf.generateCertificates(inputStream);
        if (collection.isEmpty()) {
            throw new Exception("Reply has no certificates");
        }
        Certificate[] certificateArray = (Certificate[])collection.toArray();
        Certificate[] certificateArray2 = certificateArray.length == 1 ? this.establishCertChain(certificate, certificateArray[0]) : this.validateReply(string, certificate, certificateArray);
        if (certificateArray2 != null) {
            this.keyStore.setKeyEntry(string, privateKey, this.keyPass != null ? this.keyPass : this.storePass, certificateArray2);
            return true;
        }
        return false;
    }

    private boolean isSelfSigned(X509Certificate x509Certificate) {
        X500Name x500Name = (X500Name)x509Certificate.getSubjectDN();
        X500Name x500Name2 = (X500Name)x509Certificate.getIssuerDN();
        return x500Name.equals(x500Name2);
    }

    private boolean isTrusted(Certificate certificate) throws Exception {
        KeyStore keyStore;
        if (this.keyStore.getCertificateAlias(certificate) != null) {
            return true;
        }
        return this.trustcacerts && (keyStore = this.getCacertsKeyStore()) != null && keyStore.getCertificateAlias(certificate) != null;
    }

    private void keystorecerts2Hashtable(KeyStore keyStore, Hashtable hashtable) throws Exception {
        Enumeration enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate == null) continue;
            Principal principal = ((X509Certificate)certificate).getSubjectDN();
            Vector vector = (Vector)hashtable.get(principal);
            if (vector == null) {
                vector = new Vector();
                vector.addElement(certificate);
            } else if (!vector.contains(certificate)) {
                vector.addElement(certificate);
            }
            hashtable.put(principal, vector);
        }
    }

    public static void main(String[] stringArray) {
        KeyTool keyTool = new KeyTool();
        keyTool.run(stringArray, System.out);
    }

    void parseArgs(String[] stringArray) {
        if (stringArray.length == 0) {
            this.usage();
        }
        int n = 0;
        n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string = stringArray[n];
            if (string.equalsIgnoreCase("-certreq")) {
                this.command = "certreq";
            } else if (string.equalsIgnoreCase("-delete")) {
                this.command = "delete";
            } else if (string.equalsIgnoreCase("-export")) {
                this.command = "export";
            } else if (string.equalsIgnoreCase("-genkey")) {
                this.command = "genkey";
            } else {
                if (string.equalsIgnoreCase("-help")) {
                    this.usage();
                    return;
                }
                if (string.equalsIgnoreCase("-identitydb")) {
                    this.command = "identitydb";
                } else if (string.equalsIgnoreCase("-import")) {
                    this.command = "import";
                } else if (string.equalsIgnoreCase("-keyclone")) {
                    this.command = "keyclone";
                } else if (string.equalsIgnoreCase("-keypasswd")) {
                    this.command = "keypasswd";
                } else if (string.equalsIgnoreCase("-list")) {
                    this.command = "list";
                } else if (string.equalsIgnoreCase("-printcert")) {
                    this.command = "printcert";
                } else if (string.equalsIgnoreCase("-selfcert")) {
                    this.command = "selfcert";
                } else if (string.equalsIgnoreCase("-storepasswd")) {
                    this.command = "storepasswd";
                } else if (string.equalsIgnoreCase("-keystore")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.ksfname = stringArray[n];
                } else if (string.equalsIgnoreCase("-storepass")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.storePass = stringArray[n].toCharArray();
                } else if (string.equalsIgnoreCase("-storetype")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.storetype = stringArray[n];
                } else if (string.equalsIgnoreCase("-keypass")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.keyPass = stringArray[n].toCharArray();
                } else if (string.equalsIgnoreCase("-new")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.newPass = stringArray[n].toCharArray();
                } else if (string.equalsIgnoreCase("-alias")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.alias = stringArray[n];
                } else if (string.equalsIgnoreCase("-dest")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.dest = stringArray[n];
                } else if (string.equalsIgnoreCase("-dname")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.dname = stringArray[n];
                } else if (string.equalsIgnoreCase("-keysize")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.keysize = Integer.parseInt(stringArray[n]);
                } else if (string.equalsIgnoreCase("-keyalg")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.keyAlgName = stringArray[n];
                } else if (string.equalsIgnoreCase("-sigalg")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.sigAlgName = stringArray[n];
                } else if (string.equalsIgnoreCase("-validity")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.validity = Integer.parseInt(stringArray[n]);
                } else if (string.equalsIgnoreCase("-file")) {
                    if (++n == stringArray.length) {
                        this.usage();
                    }
                    this.filename = stringArray[n];
                } else if (string.equalsIgnoreCase("-v")) {
                    this.verbose = true;
                } else if (string.equalsIgnoreCase("-debug")) {
                    this.debug = true;
                } else if (string.equalsIgnoreCase("-rfc")) {
                    this.rfc = true;
                } else if (string.equalsIgnoreCase("-noprompt")) {
                    this.noprompt = true;
                } else if (string.equalsIgnoreCase("-trustcacerts")) {
                    this.trustcacerts = true;
                } else {
                    System.err.println("Illegal option:  " + string);
                    this.usage();
                }
            }
            ++n;
        }
        if (n < stringArray.length || this.command == null) {
            this.usage();
        }
    }

    private void printWarning() {
        System.err.println();
        System.err.print("*****************  ");
        System.err.print("WARNING WARNING WARNING  ");
        System.err.println("*****************");
        System.err.print("* The integrity of the information stored in ");
        System.err.println("your keystore  *");
        System.err.print("* has NOT been verified!  ");
        System.err.println("In order to verify its integrity, *");
        System.err.print("* you must provide your keystore password.");
        System.err.println("                  *");
        System.err.print("*****************  ");
        System.err.print("WARNING WARNING WARNING  ");
        System.err.println("*****************");
        System.err.println();
    }

    private void printX509Cert(X509Certificate x509Certificate, PrintStream printStream) throws Exception {
        printStream.println("Owner: " + (X500Name)x509Certificate.getSubjectDN() + "\n" + "Issuer: " + (X500Name)x509Certificate.getIssuerDN() + "\n" + "Serial number: " + x509Certificate.getSerialNumber().toString(16) + "\n" + "Valid from: " + x509Certificate.getNotBefore().toString() + " until: " + x509Certificate.getNotAfter().toString() + "\n" + "Certificate fingerprints:\n" + "\t MD5:  " + this.getCertFingerPrint("MD5", x509Certificate) + "\n" + "\t SHA1: " + this.getCertFingerPrint("SHA1", x509Certificate));
    }

    private char[] readPasswd(InputStream inputStream) throws IOException {
        char[] cArray;
        char[] cArray2 = cArray = new char[128];
        int n = cArray2.length;
        int n2 = 0;
        block4: while (true) {
            int n3 = inputStream.read();
            switch (n3) {
                case 13: {
                    int n4 = inputStream.read();
                    if (n4 == 10 || n4 == -1) break block4;
                    if (!(inputStream instanceof PushbackInputStream)) {
                        inputStream = new PushbackInputStream(inputStream);
                    }
                    ((PushbackInputStream)inputStream).unread(n4);
                }
                default: {
                    if (--n < 0) {
                        cArray2 = new char[n2 + 128];
                        n = cArray2.length - n2 - 1;
                        System.arraycopy(cArray, 0, cArray2, 0, n2);
                        Arrays.fill(cArray, ' ');
                        cArray = cArray2;
                    }
                    cArray2[n2++] = (char)n3;
                    continue block4;
                }
                case -1: 
                case 10: 
            }
            break;
        }
        if (n2 == 0) {
            return null;
        }
        char[] cArray3 = new char[n2];
        System.arraycopy(cArray2, 0, cArray3, 0, n2);
        Arrays.fill(cArray2, ' ');
        return cArray3;
    }

    private Object[] recoverPrivateKey(String string, char[] cArray, char[] cArray2) throws Exception {
        Key key = null;
        if (!this.keyStore.containsAlias(string)) {
            throw new Exception("Alias <" + string + "> does not exist");
        }
        if (!this.keyStore.isKeyEntry(string)) {
            throw new Exception("Alias <" + string + "> has no (private) key");
        }
        if (cArray2 == null) {
            try {
                key = this.keyStore.getKey(string, cArray);
                cArray2 = cArray;
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                cArray2 = this.getKeyPasswd(string, null, null);
                key = this.keyStore.getKey(string, cArray2);
            }
        } else {
            key = this.keyStore.getKey(string, cArray2);
        }
        if (!(key instanceof PrivateKey)) {
            throw new Exception("Recovered key is not a private key");
        }
        return new Object[]{(PrivateKey)key, cArray2};
    }

    public void run(String[] stringArray, PrintStream printStream) {
        block16: {
            try {
                try {
                    this.parseArgs(stringArray);
                    this.doCommands(printStream);
                }
                catch (Exception exception) {
                    System.out.println("keytool error: " + exception.getMessage());
                    if (this.debug) {
                        exception.printStackTrace();
                    }
                    System.exit(1);
                }
                Object var4_4 = null;
                if (this.storePass == null) break block16;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.storePass != null) {
                    Arrays.fill(this.storePass, ' ');
                    this.storePass = null;
                }
                if (this.storePassNew != null) {
                    Arrays.fill(this.storePassNew, ' ');
                    this.storePassNew = null;
                }
                if (this.keyPass != null) {
                    Arrays.fill(this.keyPass, ' ');
                    this.keyPass = null;
                }
                if (this.keyPassNew != null) {
                    Arrays.fill(this.keyPassNew, ' ');
                    this.keyPassNew = null;
                }
                if (this.oldPass != null) {
                    Arrays.fill(this.oldPass, ' ');
                    this.oldPass = null;
                }
                if (this.newPass != null) {
                    Arrays.fill(this.newPass, ' ');
                    this.newPass = null;
                }
                throw throwable;
            }
            Arrays.fill(this.storePass, ' ');
            this.storePass = null;
        }
        if (this.storePassNew != null) {
            Arrays.fill(this.storePassNew, ' ');
            this.storePassNew = null;
        }
        if (this.keyPass != null) {
            Arrays.fill(this.keyPass, ' ');
            this.keyPass = null;
        }
        if (this.keyPassNew != null) {
            Arrays.fill(this.keyPassNew, ' ');
            this.keyPassNew = null;
        }
        if (this.oldPass != null) {
            Arrays.fill(this.oldPass, ' ');
            this.oldPass = null;
        }
        if (this.newPass != null) {
            Arrays.fill(this.newPass, ' ');
            this.newPass = null;
        }
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.byte2hex(byArray[n2], stringBuffer);
            if (n2 < n - 1) {
                stringBuffer.append(":");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void usage() {
        System.err.println("keytool usage:\n");
        System.err.print("-certreq     [-v] [-alias <alias>] ");
        System.err.println("[-sigalg <sigalg>]");
        System.err.println("\t     [-file <csr_file>] [-keypass <keypass>]");
        System.err.print("\t     [-keystore <keystore>] ");
        System.err.println("[-storepass <storepass>]");
        System.err.println("\t     [-storetype <storetype>]");
        System.err.println();
        System.err.println("-delete      [-v] -alias <alias>");
        System.err.print("\t     [-keystore <keystore>] ");
        System.err.println("[-storepass <storepass>]");
        System.err.println("\t     [-storetype <storetype>]");
        System.err.println();
        System.err.print("-export      [-v] [-rfc] [-alias <alias>] ");
        System.err.println("[-file <cert_file>]");
        System.err.print("\t     [-keystore <keystore>] ");
        System.err.println("[-storepass <storepass>]");
        System.err.println("\t     [-storetype <storetype>]");
        System.err.println();
        System.err.print("-genkey      [-v] [-alias <alias>] ");
        System.err.println("[-keyalg <keyalg>]");
        System.err.println("\t     [-keysize <keysize>] [-sigalg <sigalg>]");
        System.err.print("\t     [-dname <dname>] ");
        System.err.println("[-validity <valDays>]");
        System.err.print("\t     [-keypass <keypass>] ");
        System.err.println("[-keystore <keystore>]");
        System.err.print("\t     [-storepass <storepass>] ");
        System.err.println("[-storetype <storetype>]");
        System.err.println();
        System.err.println("-help");
        System.err.println();
        System.err.print("-identitydb  [-v] [-file <idb_file>] ");
        System.err.println("[-keystore <keystore>]");
        System.err.print("\t     [-storepass <storepass>] ");
        System.err.println("[-storetype <storetype>]");
        System.err.println();
        System.err.print("-import      [-v] [-noprompt] [-trustcacerts] ");
        System.err.println("[-alias <alias>]");
        System.err.print("\t     [-file <cert_file>] ");
        System.err.println("[-keypass <keypass>] ");
        System.err.print("\t     [-keystore <keystore>] ");
        System.err.println("[-storepass <storepass>]");
        System.err.println("\t     [-storetype <storetype>]");
        System.err.println();
        System.err.print("-keyclone    [-v] [-alias <alias>] ");
        System.err.println("-dest <dest_alias>");
        System.err.print("\t     [-keypass <keypass>] ");
        System.err.println("[-new <new_keypass>]");
        System.err.print("\t     [-keystore <keystore>] ");
        System.err.println("[-storepass <storepass>]");
        System.err.println("\t     [-storetype <storetype>]");
        System.err.println();
        System.err.println("-keypasswd   [-v] [-alias <alias>]");
        System.err.print("\t     [-keypass <old_keypass>] ");
        System.err.println("[-new <new_keypass>]");
        System.err.print("\t     [-keystore <keystore>] ");
        System.err.println("[-storepass <storepass>]");
        System.err.println("\t     [-storetype <storetype>]");
        System.err.println();
        System.err.println("-list        [-v | -rfc] [-alias <alias>]");
        System.err.print("\t     [-keystore <keystore>] ");
        System.err.println("[-storepass <storepass>]");
        System.err.println("\t     [-storetype <storetype>]");
        System.err.println();
        System.err.println("-printcert   [-v] [-file <cert_file>]");
        System.err.println();
        System.err.print("-selfcert    [-v] [-alias <alias>] ");
        System.err.println("[-sigalg <sigalg>]");
        System.err.print("\t     [-dname <dname>] ");
        System.err.println("[-validity <valDays>]");
        System.err.print("\t     [-keypass <keypass>] ");
        System.err.println("[-keystore <keystore>]");
        System.err.print("\t     [-storepass <storepass>] ");
        System.err.println("[-storetype <storetype>]");
        System.err.println();
        System.err.println("-storepasswd [-v] [-new <new_storepass>]");
        System.err.print("\t     [-keystore <keystore>] ");
        System.err.println("[-storepass <storepass>]");
        System.err.println("\t     [-storetype <storetype>]");
        System.err.println();
        System.exit(1);
    }

    private Certificate[] validateReply(String string, Certificate certificate, Certificate[] certificateArray) throws Exception {
        Object object;
        Object object2;
        Certificate[] certificateArray2 = new X509Certificate[certificateArray.length];
        Principal principal = null;
        int n = 0;
        while (n < certificateArray.length) {
            if (this.isSelfSigned((X509Certificate)certificateArray[n])) {
                certificateArray2[certificateArray2.length - 1] = (X509Certificate)certificateArray[n];
                principal = ((X509Certificate)certificateArray[n]).getSubjectDN();
                certificateArray[n] = null;
                break;
            }
            ++n;
        }
        if (n == certificateArray.length) {
            throw new Exception("No self-signed certificate in reply");
        }
        n = certificateArray2.length - 2;
        while (n >= 0) {
            int n2 = 0;
            while (n2 < certificateArray.length) {
                if (certificateArray[n2] != null && principal.equals(object2 = ((X509Certificate)certificateArray[n2]).getIssuerDN())) {
                    certificateArray2[n] = (X509Certificate)certificateArray[n2];
                    principal = ((X509Certificate)certificateArray[n2]).getSubjectDN();
                    certificateArray[n2] = null;
                    break;
                }
                ++n2;
            }
            if (n2 == certificateArray.length) {
                throw new Exception("Incomplete certificate chain in reply");
            }
            --n;
        }
        PublicKey publicKey = certificate.getPublicKey();
        if (!publicKey.equals(object2 = certificateArray2[0].getPublicKey())) {
            String string2 = "Public key in certificate reply different from public key for <" + string + ">";
            throw new Exception(string2);
        }
        n = 0;
        while (n < certificateArray2.length - 1) {
            object = certificateArray2[n + 1].getPublicKey();
            try {
                certificateArray2[n].verify((PublicKey)object);
            }
            catch (Exception exception) {
                throw new Exception("Certificate chain in reply does not verify: " + exception.getMessage());
            }
            ++n;
        }
        if (this.noprompt) {
            return certificateArray2;
        }
        if (!this.isTrusted(certificateArray2[certificateArray2.length - 1])) {
            System.err.println();
            System.err.println("Root certificate in reply:\n");
            this.printX509Cert((X509Certificate)certificateArray2[certificateArray2.length - 1], System.out);
            System.err.println();
            System.err.print("... is not trusted. ");
            object = this.getYesNoReply("Install reply anyway? [no]:  ");
            if (((String)object).equalsIgnoreCase("YES")) {
                return certificateArray2;
            }
            return null;
        }
        return certificateArray2;
    }
}

