/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.util.Vector;

class DerIndefLenConverter {
    private static final int TAG_MASK = 31;
    private static final int FORM_MASK = 32;
    private static final int CLASS_MASK = 192;
    private static final int LEN_LONG = 128;
    private static final int LEN_MASK = 127;
    private static final int SKIP_EOC_BYTES = 2;
    private byte[] data;
    private byte[] newData;
    private int newDataPos;
    private int dataPos;
    private int dataSize;
    private int index;
    private int[] sectionLengths = null;
    private Vector ndefsList = new Vector();
    private Vector eocList = new Vector();

    DerIndefLenConverter() {
    }

    private void calcLens(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = n / 2;
        boolean bl = true;
        block0: while (bl) {
            n4 = 0;
            while (n4 < n) {
                n3 = (Integer)this.ndefsList.get(n4);
                if (n3 == 0) {
                    this.eocList.set(n4 - 1, this.eocList.get(n4));
                    this.eocList.remove(n4);
                    this.ndefsList.remove(n4);
                    if (n4 == n5) {
                        bl = false;
                        continue block0;
                    }
                }
                ++n4;
            }
        }
        bl = true;
        block2: while (bl) {
            n4 = 0;
            while (n4 < n5) {
                n3 = (Integer)this.ndefsList.get(n4);
                int n6 = (Integer)this.eocList.get(n4);
                if (n3 != 0 && n6 != 0) {
                    Integer n7 = (Integer)this.eocList.get(n5);
                    this.eocList.remove(n5);
                    this.ndefsList.remove(n5);
                    n2 = n4 - 1;
                    this.eocList.set(n2, n7);
                    if (n2 != 0) continue block2;
                    bl = false;
                    continue block2;
                }
                ++n4;
            }
        }
        int[] nArray = new int[n5];
        n2 = 0;
        while (n2 < n5) {
            nArray[n2] = (Integer)this.ndefsList.get(n2);
            ++n2;
        }
        int[] nArray2 = new int[n5];
        int n8 = 0;
        while (n8 < n5) {
            nArray2[n8] = (Integer)this.eocList.get(n8);
            ++n8;
        }
        this.sectionLengths = new int[n5];
        this.sectionLengths[n5 - 1] = nArray2[n5 - 1] - nArray[n5 - 1];
        int n9 = n5 - 2;
        while (n9 >= 0) {
            int n10 = nArray2[n9] - nArray[n9];
            int n11 = n9 + 1;
            while (n11 < n5) {
                if (nArray2[n9] > nArray2[n11]) {
                    n10 = n10 - 3 + this.getNumOfLenBytes(this.sectionLengths[n11]);
                }
                ++n11;
            }
            this.sectionLengths[n9] = n10;
            --n9;
        }
    }

    byte[] convert(byte[] byArray) throws IOException {
        this.data = byArray;
        this.dataPos = 0;
        this.index = 0;
        this.dataSize = this.data.length;
        int n = 0;
        while (this.dataPos < this.dataSize) {
            this.parseTag();
            n = this.parseLength();
            this.parseValue(n);
        }
        this.calcLens(this.index);
        this.newData = new byte[this.dataSize + this.index];
        this.dataPos = 0;
        this.newDataPos = 0;
        this.index = 0;
        while (this.dataPos < this.dataSize) {
            this.writeTag();
            this.writeLengthAndValue();
        }
        int n2 = 1;
        int n3 = 0;
        int n4 = this.newData[n2] & 0xFF;
        if (DerIndefLenConverter.isLongForm(n4)) {
            n4 &= 0x7F;
            while (n4 > 0) {
                n3 = (n3 << 8) + (this.newData[++n2] & 0xFF);
                --n4;
            }
        } else {
            n3 = n4 & 0x7F;
        }
        byte[] byArray2 = new byte[1 + n2 + n3];
        System.arraycopy(this.newData, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private int getNumOfLenBytes(int n) {
        int n2 = 0;
        n2 = n < 128 ? 1 : (n < 256 ? 2 : (n < 65536 ? 3 : (n < 0x1000000 ? 4 : 5)));
        return n2;
    }

    private boolean isEOC(int n) {
        return (n & 0x1F) == 0 && (n & 0x20) == 0 && (n & 0xC0) == 0;
    }

    static boolean isIndefinite(int n) {
        return DerIndefLenConverter.isLongForm(n) && (n & 0x7F) == 0;
    }

    static boolean isLongForm(int n) {
        return (n & 0x80) == 128;
    }

    private int parseLength() throws IOException {
        int n;
        int n2 = 0;
        if (this.dataPos == this.dataSize) {
            return n2;
        }
        if (DerIndefLenConverter.isIndefinite(n = this.data[this.dataPos++] & 0xFF)) {
            this.ndefsList.add(this.index, new Integer(this.dataPos));
            this.eocList.add(this.index++, new Integer(0));
            return n2;
        }
        if (DerIndefLenConverter.isLongForm(n)) {
            if ((n &= 0x7F) > 4) {
                throw new IOException("Too much data");
            }
            if (this.dataSize - this.dataPos < n + 1) {
                throw new IOException("Too little data");
            }
            int n3 = 0;
            while (n3 < n) {
                n2 = (n2 << 8) + (this.data[this.dataPos++] & 0xFF);
                ++n3;
            }
        } else {
            n2 = n & 0x7F;
        }
        return n2;
    }

    private void parseTag() {
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(this.data[this.dataPos]) && this.data[this.dataPos + 1] == 0) {
            this.eocList.add(this.index, new Integer(this.dataPos));
            this.ndefsList.add(this.index++, new Integer(0));
        }
        ++this.dataPos;
    }

    private void parseValue(int n) {
        this.dataPos += n;
    }

    private void writeLength(int n) {
        if (n < 128) {
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 256) {
            this.newData[this.newDataPos++] = -127;
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 65536) {
            this.newData[this.newDataPos++] = -126;
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 0x1000000) {
            this.newData[this.newDataPos++] = -125;
            this.newData[this.newDataPos++] = (byte)(n >> 16);
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        } else {
            this.newData[this.newDataPos++] = -124;
            this.newData[this.newDataPos++] = (byte)(n >> 24);
            this.newData[this.newDataPos++] = (byte)(n >> 16);
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        }
    }

    private void writeLengthAndValue() throws IOException {
        int n;
        if (this.dataPos == this.dataSize) {
            return;
        }
        int n2 = 0;
        if (DerIndefLenConverter.isIndefinite(n = this.data[this.dataPos++] & 0xFF)) {
            int n3 = (Integer)this.ndefsList.get(this.index);
            if (n3 == this.dataPos) {
                n2 = this.sectionLengths[this.index];
                ++this.index;
                this.writeLength(n2);
                return;
            }
            throw new IOException("Internal corruption, cannot convert to definite length encoding");
        }
        if (DerIndefLenConverter.isLongForm(n)) {
            n &= 0x7F;
            int n4 = 0;
            while (n4 < n) {
                n2 = (n2 << 8) + (this.data[this.dataPos++] & 0xFF);
                ++n4;
            }
        } else {
            n2 = n & 0x7F;
        }
        this.writeLength(n2);
        this.writeValue(n2);
    }

    private void writeTag() {
        byte by;
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(by = this.data[this.dataPos++]) && this.data[this.dataPos] == 0) {
            ++this.dataPos;
            this.writeTag();
        } else {
            this.newData[this.newDataPos++] = by;
        }
    }

    private void writeValue(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.newData[this.newDataPos++] = this.data[this.dataPos++];
            ++n2;
        }
    }
}

