/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;

class RDN {
    protected AVA[] assertion;

    RDN(int n) {
        this.assertion = new AVA[n];
    }

    RDN(DerValue derValue) throws IOException {
        if (derValue.tag != 49) {
            throw new IOException("X500 RDN");
        }
        int n = 1;
        this.assertion = new AVA[n];
        int n2 = 0;
        while (n2 < n) {
            this.assertion[n2] = new AVA(derValue.data);
            ++n2;
        }
    }

    void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putOrderedSetOf((byte)49, this.assertion);
    }

    public boolean equals(Object object) {
        if (object instanceof RDN) {
            return this.equals((RDN)object);
        }
        return false;
    }

    boolean equals(RDN rDN) {
        if (rDN == this) {
            return true;
        }
        if (this.assertion.length != rDN.assertion.length) {
            return false;
        }
        int n = 0;
        while (n < this.assertion.length) {
            if (!this.assertion[n].equals(rDN.assertion[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        int n = 0;
        while (n < this.assertion.length) {
            if (this.assertion[n].oid.equals(objectIdentifier)) {
                return this.assertion[n].value;
            }
            ++n;
        }
        return null;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.assertion.length) {
            if (this.assertion[n3].value != null) {
                n += this.assertion[n3].value.length() * n2++;
            }
            ++n3;
        }
        return n;
    }

    public String toString() {
        String string = null;
        int n = 0;
        while (n < this.assertion.length) {
            string = string == null ? this.assertion[n].toString() : String.valueOf(string) + " + " + this.assertion[n];
            ++n;
        }
        return string;
    }
}

