/*
 * Decompiled with CFR 0.152.
 */
package Sav.Servlet;

import Sav.Processor.Concept;
import Sav.Processor.PList;
import Sav.Servlet.Attributes;
import Sav.Servlet.Code;
import Sav.Servlet.Contents;
import Sav.Servlet.Parameters;
import Sav.Servlet.Records;
import Sav.Servlet.Values;
import Sav.Z.Commutator;
import Sav.Z.DBConnection;
import Sav.Z.Warning;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTTPConnection
extends HttpServlet {
    static final String appPath = "/SavZServer";
    int serviceCounter;
    Commutator comm;
    String dbName;

    public synchronized void destroy() {
        this.setShuttingDown(true);
        while (this.numServices() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = System.getProperty("file.encoding");
        httpServletResponse.setContentType("text/html;CHARSET=" + string);
        String string2 = httpServletRequest.getQueryString();
        if (string2 == null) {
            this.makeContents(httpServletRequest, httpServletResponse);
        } else {
            String string3 = httpServletRequest.getCharacterEncoding();
            Parameters parameters = new Parameters(new Code(string2, string3).getBuf());
            String string4 = parameters.getValue("SOURCE");
            if (string4.equals("Contents")) {
                this.makeAttributes(httpServletRequest, httpServletResponse, parameters);
            } else {
                this.makeError(string2, string, httpServletResponse.getWriter());
            }
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = System.getProperty("file.encoding");
        httpServletResponse.setContentType("text/html;CHARSET=" + string);
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        int n = httpServletRequest.getContentLength();
        byte[] byArray = new byte[n];
        int n2 = servletInputStream.readLine(byArray, 0, n);
        servletInputStream.close();
        Parameters parameters = new Parameters(byArray);
        String string2 = parameters.getValue("SOURCE");
        String string3 = parameters.getValue("SUBMIT");
        if (string2 == null) {
            this.makeError(Code.fromQueryString(byArray), string, httpServletResponse.getWriter());
        } else if (string2.equals("Attributes")) {
            if (string3 == null) {
                this.makeError(Code.fromQueryString(byArray), string, httpServletResponse.getWriter());
            } else if (string3.equals("Values")) {
                this.makeValues(httpServletRequest, httpServletResponse, parameters);
            } else if (string3.equals("Help")) {
                this.makeHelp("/ValuesHelp.html", (OutputStream)httpServletResponse.getOutputStream());
            } else {
                this.makeError(Code.fromQueryString(byArray), string, httpServletResponse.getWriter());
            }
        } else if (string2.equals("Values")) {
            if (string3 == null) {
                this.makeError(Code.fromQueryString(byArray), string, httpServletResponse.getWriter());
            } else if (string3.equals("View")) {
                this.makeRecords(httpServletRequest, httpServletResponse, parameters);
            } else if (string3.equals("Help")) {
                this.makeHelp("/ViewHelp.html", (OutputStream)httpServletResponse.getOutputStream());
            } else {
                this.makeError(Code.fromQueryString(byArray), string, httpServletResponse.getWriter());
            }
        }
    }

    synchronized void entering() {
        ++this.serviceCounter;
    }

    public String getServletInfo() {
        return "Sav Z Server 1.2 00/05, (c) 1999-2000 Sav";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.dbName = this.getInitParameter("dbName");
        this.dbName = this.dbName != null ? servletConfig.getServletContext().getRealPath("/Data/" + this.dbName) : servletConfig.getServletContext().getRealPath("/Data/Common.ass");
        DBConnection.defaultDBPath = this.dbName;
        String string = this.getInitParameter("outLimit");
        if (string != null) {
            DBConnection.defaultOutLimit = Integer.parseInt(string);
        }
        this.comm = new Commutator();
    }

    boolean isShuttingDown() {
        return this.comm.isOff();
    }

    synchronized void leaving() {
        --this.serviceCounter;
    }

    void makeAttributes(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Parameters parameters) throws ServletException, IOException {
        Attributes attributes = new Attributes(this, parameters);
        attributes.fill();
        attributes.write(httpServletRequest, httpServletResponse);
    }

    void makeContents(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Contents contents = new Contents(this);
        contents.fill();
        contents.write(httpServletRequest, httpServletResponse);
    }

    void makeError(String string, String string2, PrintWriter printWriter) {
        printWriter.println("<HTML>");
        printWriter.println("<BODY>");
        printWriter.print("Error: parameters=" + string);
        printWriter.println("<BR>");
        printWriter.println("Possible causes:<BR>");
        printWriter.println("character set != " + string2 + "<BR>");
        printWriter.println("web browser < 4.0<BR>");
        printWriter.println("other ...<BR>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
        printWriter.close();
    }

    void makeHelp(String string, OutputStream outputStream) throws ServletException, IOException {
        int n;
        byte[] byArray;
        ServletContext servletContext = this.getServletContext();
        File file = new File(servletContext.getRealPath(string));
        FileInputStream fileInputStream = new FileInputStream(file);
        if (fileInputStream.read(byArray = new byte[n = (int)file.length()]) > 0) {
            outputStream.write(byArray);
        }
        fileInputStream.close();
    }

    void makeRecords(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Parameters parameters) throws ServletException, IOException {
        Records records = new Records(this, parameters);
        records.fill();
        records.write(httpServletRequest, httpServletResponse);
    }

    void makeValues(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Parameters parameters) throws ServletException, IOException {
        Values values = new Values(this, parameters);
        values.fill();
        values.write(httpServletRequest, httpServletResponse);
    }

    synchronized int numServices() {
        return this.serviceCounter;
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.entering();
        try {
            super.service(httpServletRequest, httpServletResponse);
        }
        finally {
            Object var4_3 = null;
            this.leaving();
        }
    }

    void setShuttingDown(boolean bl) {
        this.comm.setOff(bl);
    }

    void warn(PrintWriter printWriter, PList pList) {
        if (pList == null) {
            return;
        }
        Warning warning = (Warning)pList.getFirst();
        while (warning != null) {
            printWriter.print(warning.getName());
            printWriter.print(": ");
            printWriter.print(warning.getMessage());
            printWriter.println("<BR>");
            warning = (Warning)pList.getNext();
        }
    }

    void writeList(PrintWriter printWriter, String string, String string2, int n) {
        printWriter.print("<SELECT NAME='");
        printWriter.print(Code.toHTMLText(string));
        printWriter.println("' SIZE=" + n + " MULTIPLE>");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                if (this.isShuttingDown()) break;
                String string3 = stringTokenizer.nextToken();
                if (Concept.isSpecific(string3)) continue;
                printWriter.print("<OPTION>");
                printWriter.print(Code.toHTMLText(string3));
                printWriter.println("</OPTION>");
            }
        }
        printWriter.println("</SELECT>");
    }
}

