/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.Long1;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Processor.PromptAssociation;
import Sav.Processor.Trace;
import Sav.Z.Commutator;
import Sav.Z.Expression;
import Sav.Z.Interface;
import Sav.Z.Statement;
import Sav.Z.Status;
import Sav.Z.StatusLine;
import Sav.Z.UndeletedFileException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DBConnection
implements Interface {
    public static int defaultOutLimit = 1000000;
    public static String defaultDBPath = "Common";
    Association base;
    Association mul;
    PromptAssociation spec;
    Statement savedStm;
    Statement curStm;
    PrintWriter pw;
    StringWriter sw;
    int outLimit;
    int outSum;
    Commutator comm = new Commutator();
    StatusLine stLine;
    Status stProcess;
    Status stResult;
    Status stDataBase;
    PList warnings = new PList();

    public DBConnection() throws IOException {
        this.base = new Association(defaultDBPath, true);
        this.construct();
    }

    public DBConnection(File file) throws IOException {
        this.base = new Association(file);
        this.construct();
    }

    public DBConnection(File file, boolean bl) throws IOException {
        this.base = new Association(file, bl);
        this.construct();
    }

    public DBConnection(String string) throws IOException {
        this.base = new Association(string);
        this.construct();
    }

    public DBConnection(String string, String string2) throws IOException {
        this.base = new Association(string, string2);
        this.construct();
    }

    public DBConnection(String string, String string2, boolean bl) throws IOException {
        this.base = new Association(string, string2, bl);
        this.construct();
    }

    public DBConnection(String string, boolean bl) throws IOException {
        this.base = new Association(string, bl);
        this.construct();
    }

    public DBConnection(boolean bl) throws IOException {
        this.base = new Association(defaultDBPath, bl);
        this.construct();
    }

    public void addOutSum(int n) {
        this.outSum += n;
    }

    void changeBase(File file) throws IOException {
        this.savedStm = this.curStm;
        this.base.close();
        this.mul.store();
        this.spec.store();
        this.base = new Association(file);
    }

    void changeBase1(File file) throws IOException {
        this.savedStm = this.curStm;
        this.base.close();
        this.mul.store();
        this.spec.store();
        if (!file.delete() && file.exists()) {
            throw new UndeletedFileException();
        }
        this.base = new Association(file);
    }

    public void clearControlDataBase() {
        this.stDataBase = null;
    }

    public void clearControlLine() {
        this.stLine = null;
    }

    public void clearControlProcess() {
        this.stProcess = null;
    }

    public void clearControlResult() {
        this.stResult = null;
    }

    public void clearOutLimit() {
        this.outLimit = 0;
    }

    public void clearOutSum() {
        this.outSum = 0;
    }

    public void clearPrintWriter() {
        this.sw = null;
        this.pw = null;
    }

    public void clearStatusDataBase() {
        if (this.stDataBase != null) {
            this.stDataBase.clear();
        }
    }

    public void clearStatusLine() {
        if (this.stLine != null) {
            this.stLine.clear();
        }
    }

    public void clearStatusProcess() {
        if (this.stProcess != null) {
            this.stProcess.clear();
        }
    }

    public void clearStatusResult() {
        if (this.stResult != null) {
            this.stResult.clear();
        }
    }

    public void clearStringWriter() {
        if (this.sw == null) {
            return;
        }
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void clearWarnings() {
        this.warnings = new PList();
    }

    public void close() throws IOException {
        this.base.close();
        this.mul.delete();
        this.spec.delete();
        if (this.pw != null) {
            this.pw.close();
        }
        this.savedStm = null;
        this.curStm = null;
        this.stLine = null;
    }

    void construct() {
        Concept concept = new Concept(4);
        try {
            File file = new File("$Multitudes");
            file.delete();
            this.mul = new Association("$Multitudes");
            this.spec = new PromptAssociation();
            this.spec.con(61);
            this.spec.con("print");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("p");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printLine");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pl");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printName");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pn");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printClass");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pc");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printRelation");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pr");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printTable");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pt");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("readTable");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("rt");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("");
            this.spec.setConnect(61, new Concept(2));
            this.spec.regain();
            this.spec.con(57);
            this.spec.con(concept).con(57);
            this.spec.set("print");
            this.spec.set("p");
            this.spec.set("printLine");
            this.spec.set("pl");
            this.spec.set("printName");
            this.spec.set("pn");
            this.spec.set("printClass");
            this.spec.set("pc");
            this.spec.set("printRelation");
            this.spec.set("pr");
            this.spec.set("printTable");
            this.spec.set("pt");
            this.spec.set("readTable");
            this.spec.set("rt");
            this.spec.uncon().uncon();
            this.spec.con(new Concept(2)).con(57);
            this.spec.set("");
            this.spec.regain();
            this.spec.store();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        this.setStringWriter();
    }

    void copyClassRelation(Association association, Association association2) throws IOException {
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(56);
        while (concept != null) {
            this.base.con(concept);
            if (!this.base.hasSign()) {
                this.base.uncon();
            } else {
                association2.con(concept);
                this.base.con(58);
                association2.con(58);
                association2.set(this.base);
                this.base.uncon();
                association2.uncon();
                this.base.con(59);
                association2.con(59);
                association2.set(this.base);
                this.base.uncon();
                association2.uncon();
                this.base.con(62);
                association2.con(62);
                association2.set(this.base);
                this.base.uncon();
                association2.uncon();
                association.con();
                if (association.hasConnect(57)) {
                    association.con(57);
                    this.base.con(57);
                    association2.con(57);
                    this.copyClassRelation(association, association2);
                    association.uncon();
                    this.base.uncon();
                    association2.uncon();
                }
                association.uncon();
                this.base.uncon();
                association2.uncon();
                PN.controlMemory(long1, this.base, association, association2);
            }
            concept = association.getNext(56);
        }
    }

    public Statement createStatement(int n, String string, int n2) {
        Statement statement = new Statement(this, string, n2);
        statement.setLineNumber(n);
        return statement;
    }

    public Statement createStatement(int n, String string, int n2, File file, int n3, int n4) {
        Statement statement = new Statement(this, string, n2, file, n3, n4);
        statement.setLineNumber(n);
        return statement;
    }

    public Statement createStatement(String string) {
        return this.createStatement(string, 0);
    }

    public Statement createStatement(String string, int n) {
        return new Statement(this, string, n);
    }

    public Statement createStatement(String string, int n, File file, int n2, int n3) {
        return new Statement(this, string, n, file, n2, n3);
    }

    void cutClassRelation(Association association) throws IOException {
        Association association2 = null;
        Association association3 = null;
        Association association4 = null;
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(56);
        while (concept != null) {
            association.con();
            if (association.hasConnect(57)) {
                association.con(57);
                this.cutClassRelation(association);
            }
            if (association.hasConnect(58)) {
                association2 = association.getConnect(58);
            }
            if (association.hasConnect(59)) {
                association3 = association.getConnect(59);
            }
            if (association.hasConnect(62)) {
                association4 = association.getConnect(62);
            }
            if (association2 != null || association3 != null || association4 != null) {
                this.deleteRel(concept, association2, association3, association4);
            }
            association2 = null;
            association3 = null;
            association4 = null;
            PN.controlMemory(long1, this.base, association);
            concept = association.getNext(56);
        }
    }

    void deleteClass(Association association) throws IOException {
        this.deleteRelation(association);
        Association association2 = new Association();
        this.deleteClass1(association, association2);
        this.base.clear(association);
    }

    void deleteClass(Association association, Association association2) throws IOException {
        Association association3 = this.selectClass(association, association2);
        this.deleteClass(association3);
    }

    void deleteClass1(Association association, Association association2) throws IOException {
        Concept concept = association.getLast(56);
        if (concept.getNotation() <= 36) {
            return;
        }
        if (association.hasSign(34)) {
            return;
        }
        Long1 long1 = PN.initMemory();
        concept = association.getFirst(56);
        while (concept != null) {
            if (concept.getNotation() > 36) break;
            concept = association.getNext(56);
        }
        while (concept != null) {
            association.con();
            if (association.hasSign(57)) {
                association.con(57);
                if (association2.hasSign()) {
                    association2.con(57);
                }
                association2.con(concept);
                this.deleteClass1(association, association2);
                association.uncon();
                association2.uncon().uncon();
            }
            Trace trace = association2.getConTrace();
            if (trace.next != null && association.hasConcept()) {
                Concept concept2 = new Concept(trace);
                this.base.con(concept);
                this.base.clearConnect(61, concept2);
                this.base.uncon();
            }
            association.uncon();
            PN.controlMemory(long1, this.base, association);
            concept = association.getNext(56);
        }
    }

    void deleteIdentity(Association association, Association association2) throws IOException {
        Association association3;
        PList pList;
        PList pList2 = new PList();
        if (association.getSense0() != 64 || association2.getSense0() != 64) {
            pList2.add(58, null);
            pList2.add(59, null);
            pList2.add(62, null);
        }
        Long1 long1 = PN.initMemory();
        if (association.getSense1() != 57 && association2.getSense1() == 57) {
            pList2.add(57, null);
            pList = this.base.getConnectionList(association2, pList2);
            association3 = (Association)pList.getLast();
            pList.remove();
            this.deleteClass(association, association3);
        } else {
            pList = this.base.getConnectionList(association2, pList2);
        }
        this.deleteRelation(association, pList);
        pList = null;
        PN.controlMemory(long1, this.base, association, association2);
        if (association2.getSense1() != 57) {
            return;
        }
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept);
            if (!this.base.hasConnect(57)) {
                this.base.uncon();
            } else {
                association3 = this.base.getConnect(57);
                this.base.uncon();
                Association association4 = new Association();
                association4.con(concept).con(57);
                Concept concept2 = association2.getFirst(57);
                while (concept2 != null) {
                    this.base.con(concept2);
                    if (!this.base.hasConnect(57)) {
                        this.base.uncon();
                    } else {
                        this.base.con(57);
                        this.copyClassRelation(association3, association4);
                        this.base.uncon();
                        this.base.uncon();
                        PN.controlMemory(long1, this.base, association, association2, association4);
                    }
                    concept2 = association2.getNext(57);
                }
                if (association4.hasSign()) {
                    this.cutClassRelation(association4);
                }
                association4 = null;
                PN.controlMemory(long1, this.base, association, association2);
            }
            concept = association.getNext(57);
        }
    }

    void deleteRel(Association association, Association association2, Association association3, Association association4) throws IOException {
        PList pList = new PList();
        pList.add(58, (Object)association2);
        pList.add(59, (Object)association3);
        pList.add(62, (Object)association4);
        this.deleteRelation(association, pList);
    }

    void deleteRel(Concept concept, Association association, Association association2, Association association3) throws IOException {
        Association association4 = new Association();
        association4.set(concept);
        this.deleteRel(association4, association, association2, association3);
    }

    void deleteRelation(Association association) throws IOException {
        PList pList = new PList();
        pList.add(58, null);
        pList.add(59, null);
        pList.add(62, null);
        Long1 long1 = PN.initMemory();
        PList pList2 = this.base.getConnectionList(association, pList);
        this.base.clearConnection(association, pList);
        Association association2 = (Association)pList2.getFirst();
        while (pList2.hasCurrent()) {
            if (association2 != null && association2.hasSign()) {
                int n = pList2.getType();
                if (n == 62) {
                    n = 58;
                } else if (n == 58) {
                    n = 62;
                }
                PList pList3 = new PList();
                pList3.add(n, (Object)association);
                this.base.clearConnection(association2, pList3);
                PN.controlMemory(long1, association, this.base, pList2);
            }
            association2 = (Association)pList2.getNext();
        }
    }

    void deleteRelation(Association association, PList pList) throws IOException {
        Long1 long1 = PN.initMemory();
        this.base.clearConnection(association, pList);
        Association association2 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association2 != null) {
                Trace trace;
                PList pList2 = new PList();
                Trace trace2 = trace = (Trace)pList.getTypes().clone();
                while (trace2 != null) {
                    if (trace2.sign == 62) {
                        trace2.sign = 58;
                    } else if (trace2.sign == 58) {
                        trace2.sign = 62;
                    }
                    trace2 = trace2.next;
                }
                pList2.add(trace, (Object)association);
                this.base.clearConnection(association2, pList2);
                PN.controlMemory(long1, association, this.base, pList);
            }
            association2 = (Association)pList.getNext();
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public Association getBase() {
        return this.base;
    }

    public Commutator getCommutator() {
        return this.comm;
    }

    public Status getControlLine() {
        return this.stLine;
    }

    public int getOutLimit() {
        return this.outLimit;
    }

    public int getOutSum() {
        return this.outSum;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public String getStatusLine() {
        if (this.stLine != null) {
            return this.stLine.get();
        }
        return null;
    }

    public int getStatusLineCount() {
        if (this.stLine != null) {
            return this.stLine.getCount();
        }
        return 0;
    }

    public int getStatusLineInterval() {
        if (this.stLine != null) {
            return this.stLine.getInterval();
        }
        return 0;
    }

    public String getStatusProcess() {
        if (this.stProcess != null) {
            return this.stProcess.get();
        }
        return null;
    }

    public String getStatusResult() {
        if (this.stResult != null) {
            return this.stResult.get();
        }
        return null;
    }

    public StringWriter getStringWriter() {
        return this.sw;
    }

    public Association getVar() {
        return this.mul;
    }

    public PList getWarnings() {
        return this.warnings;
    }

    public boolean hasWarning() {
        return this.warnings.isEmpty() ^ true;
    }

    Association insertClass(Association association, Association association2) throws IOException {
        Association association3 = null;
        Long1 long1 = PN.initMemory();
        Concept concept = association2.getFirst(56);
        while (concept != null) {
            Association association4 = this.insertClass1(association, concept);
            if (association4 != null) {
                association2.con(concept);
                if (association2.hasConnect(57)) {
                    association2.con(57);
                    association4 = this.insertClass(association4, association2);
                    association2.uncon();
                }
                association2.uncon();
                if (association3 == null) {
                    association3 = association4;
                } else {
                    association3.set(association4);
                }
            }
            association4 = null;
            PN.controlMemory(long1, this.base, association, association2, association3);
            concept = association2.getNext(56);
        }
        if (association3 == null) {
            return new Association();
        }
        return association3;
    }

    Association insertClass1(Association association, Concept concept) throws IOException {
        if (association == null || association == PN.aNull) {
            Association association2 = this.selectClass1(association, concept);
            if (association2.hasSign()) {
                return association2;
            }
            this.base.set(concept);
            return new Association().set(concept);
        }
        Association association3 = new Association();
        association3.set(association);
        int n = concept.getNotation();
        if (n == 36 || n == 35 || association != null && association.hasSign(34)) {
            association3.appendClassMean(concept, true, false);
            this.base.set(association3);
            return association3;
        }
        Association association4 = new Association();
        if (association3.appendClassMean(concept, true, true, association4)) {
            this.base.con(concept);
            if (this.base.setConnect(61, association4)) {
                this.base.regain();
                this.base.set(association3);
            } else {
                this.base.regain();
            }
            return association3;
        }
        if (association.getSense() == 121) {
            return association3;
        }
        return null;
    }

    void insertContent(Association association, PList pList) throws IOException {
        Association association2 = association.get(56);
        PList pList2 = new PList();
        Association association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association3 != null) {
                pList2.add(pList.getType(), (Object)association3.get(56));
            }
            association3 = (Association)pList.getNext();
        }
        this.insertRelation(association2, pList2);
        Association association4 = new Association();
        association4.set("$Content");
        Association association5 = this.insertClass(association4, association);
        this.base.con("$Content").con(57);
        association5.con("$Content").con(57);
        association5.setResolution(-1);
        this.base.setConnection(association5, pList);
        this.base.regain();
        association5 = null;
    }

    void insertContent0(Association association, PList pList) throws IOException {
        Association association2 = association.get(56);
        PList pList2 = new PList();
        Association association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association3 != null) {
                pList2.add(pList.getType(), (Object)association3.get(56));
            }
            association3 = (Association)pList.getNext();
        }
        this.insertRelation(association2, pList2);
        Association association4 = new Association();
        association4.set("$Content");
        this.insertClass(association4, association2);
        this.base.con("$Content").con(57);
        this.base.setConnection(association2, pList2);
        this.base.regain();
    }

    void insertContentByIdentity(Association association, Association association2) throws IOException {
        PList pList;
        Association association3 = association.get(56);
        Association association4 = association2.get(56);
        PList pList2 = new PList();
        pList2.add(58, null);
        pList2.add(59, null);
        pList2.add(62, null);
        this.base.con("$Content");
        if (this.base.hasConnect(57, association4)) {
            this.base.uncon();
            Association association5 = new Association();
            association5.set("$Content");
            this.insertClass(association5, association3);
            this.base.con("$Content").con(57);
            pList = this.base.getConnectionList(association4, pList2);
            this.base.setConnection(association3, pList);
            this.base.regain();
        } else {
            this.base.uncon();
        }
        pList = this.base.getConnectionList(association4, pList2);
        this.insertRelation(association3, pList);
    }

    void insertIdentity(Association association, Association association2) throws IOException {
        Association association3;
        PList pList;
        PList pList2 = new PList();
        if (association.getSense0() == 64 || association2.getSense0() == 64) {
            pList2.add(58, null);
            pList2.add(59, null);
            pList2.add(62, null);
        }
        Long1 long1 = PN.initMemory();
        if (association.getSense1() != 57 && association2.getSense1() == 57) {
            pList2.add(57, null);
            pList = this.base.getConnectionList(association2, 57, 64, pList2);
            association3 = (Association)pList.getLast();
            pList.remove();
            this.insertClass(association, association3);
        } else {
            pList = this.base.getConnectionList(association2, 57, 64, pList2);
        }
        this.insertRelation(association, pList);
        pList = null;
        PN.controlMemory(long1, this.base, association, association2);
        if (association2.getSense1() != 57) {
            return;
        }
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept);
            if (!this.base.hasConnect(57)) {
                this.base.uncon();
            } else {
                association3 = this.base.getConnect(57);
                this.base.uncon();
                Association association4 = new Association();
                association4.con(concept).con(57);
                Concept concept2 = association2.getFirst(57);
                while (concept2 != null) {
                    this.base.con(concept2);
                    if (!this.base.hasConnect(57)) {
                        this.base.uncon();
                    } else {
                        this.base.con(57);
                        this.copyClassRelation(association3, association4);
                        this.base.uncon();
                        this.base.uncon();
                        PN.controlMemory(long1, this.base, association, association2, association4);
                    }
                    concept2 = association2.getNext(57);
                }
                if (association4.hasSign()) {
                    this.pasteClassRelation(association4);
                }
                association4 = null;
                PN.controlMemory(long1, this.base, association, association2);
            }
            concept = association.getNext(57);
        }
    }

    Association insertName(Association association, Concept concept, boolean bl) throws IOException {
        Association association2 = new Association();
        if (association == null || association == PN.aNull) {
            if (concept == null && !bl) {
                this.insertName1(concept, association2);
            }
            if (!this.selectName1(concept, bl, association2)) {
                this.insertName1(concept, association2);
            }
            return association2;
        }
        Long1 long1 = PN.initMemory();
        Concept concept2 = association.getFirst(57);
        while (concept2 != null) {
            this.base.con(concept2);
            this.base.con(57);
            association2.con(concept2).con(57);
            if (concept == null && !bl) {
                this.insertName1(concept, association2);
            }
            if (!this.selectName1(concept, bl, association2)) {
                this.insertName1(concept, association2);
            }
            this.base.regain();
            association2.regain();
            PN.controlMemory(long1, this.base, association, association2);
            concept2 = association.getNext(57);
        }
        return association2;
    }

    Association insertName(Association association, PList pList) throws IOException {
        Expression expression = (Expression)pList.getFirst();
        boolean bl = pList.hasNext();
        return this.insertName(association, expression.cnc, bl);
    }

    void insertName1(Concept concept, Association association) throws IOException {
        Concept concept2;
        if (concept == null) {
            this.base.see(36);
            concept2 = this.base.getLast(56);
            int n = concept2 == null ? 1 : concept2.toNumber() + 1;
            concept2 = new Concept(n);
        } else {
            concept2 = concept;
        }
        this.base.set(concept2);
        association.set(concept2);
    }

    boolean insertNewObject(Association association, Association association2) throws IOException {
        if (association == null) {
            Concept concept = this.base.createNewConcept();
            association2.set(concept);
            return true;
        }
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept).con(57);
            Concept concept2 = this.base.createNewConcept();
            this.base.uncon().uncon();
            association2.setConnect(57, concept2);
            PN.controlMemory(long1, this.base, association2, association);
            concept = association.getNext(57);
        }
        return true;
    }

    Association insertObject(Association association, Concept concept) throws IOException {
        Association association2 = new Association();
        association2.set(concept);
        return this.insertClass(association, association2);
    }

    Association insertObject(Association association, PList pList) throws IOException {
        Concept concept = null;
        Association association2 = new Association();
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            if (expression.index == 1) {
                association2.con(concept);
                this.base.con(concept);
                association2.set(this.base, 56);
                association2.uncon();
                this.base.uncon();
                return this.insertClass(association, association2);
            }
            Concept concept2 = expression.cnc;
            if (concept2 == null) {
                association2.con(concept);
                this.base.con(concept);
                this.base.see(36);
                if (this.base.hasSign() && pList.hasNext()) {
                    association2.set(this.base, 56);
                } else {
                    int n = 1;
                    concept2 = this.base.getLast(56);
                    if (concept2 != null) {
                        n = concept2.toNumber() + 1;
                    }
                    concept2 = new Concept(n);
                    association2.set(concept2);
                }
                association2.uncon();
                this.base.uncon();
                return this.insertClass(association, association2);
            }
            concept = concept == null ? concept2 : new Concept(concept, 56, concept2);
            expression = (Expression)pList.getNext();
        }
        association2.set(concept);
        return this.insertClass(association, association2);
    }

    void insertRel(Association association, Association association2, Association association3, Association association4) throws IOException {
        PList pList = new PList();
        if (association2 != null) {
            pList.add(58, (Object)association2);
        }
        if (association3 != null) {
            pList.add(59, (Object)association3);
        }
        if (association4 != null) {
            pList.add(62, (Object)association4);
        }
        this.insertRelation(association, pList);
    }

    void insertRel(Concept concept, Association association, Association association2, Association association3) throws IOException {
        Association association4 = new Association();
        association4.set(concept);
        this.insertRel(association4, association, association2, association3);
    }

    void insertRelation(Association association, PList pList) throws IOException {
        PList pList2 = new PList();
        this.base.setConnection(association, pList);
        Long1 long1 = PN.initMemory();
        Association association2 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association2 != null && association2.hasSign()) {
                int n = pList.getType();
                int n2 = n == 62 ? 58 : (n == 59 ? 59 : 62);
                pList2.add(n2, (Object)association);
                this.base.setConnection(association2, pList2);
                PN.controlMemory(long1, association, this.base, pList);
            }
            association2 = (Association)pList.getNext();
        }
    }

    PList insertSchema(Association association, Association association2) throws IOException {
        PList pList = new PList();
        Association association3 = new Association();
        association3.setCategory(56);
        pList.add(58, (Object)association3);
        pList.add(59, (Object)association3);
        pList.add(62, (Object)association3);
        pList = this.base.getConnectionList(association2, 56, 64, pList);
        Association association4 = null;
        Association association5 = null;
        Association association6 = null;
        association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (!association3.hasSign()) {
                pList.remove();
            } else {
                int n = pList.getType();
                if (n == 58) {
                    association5 = association3;
                    association6 = association3;
                } else if (n == 59) {
                    association4 = association3;
                    if (association6 == null) {
                        association6 = association3;
                    } else {
                        association6.set(association3);
                    }
                } else {
                    if (association4 == null) {
                        association4 = association3;
                    } else {
                        association4.set(association3);
                    }
                    if (association5 == null) {
                        association5 = association3;
                    } else {
                        association5.set(association3);
                    }
                }
            }
            association3 = (Association)pList.getNext();
        }
        if (pList.isEmpty()) {
            return null;
        }
        PList pList2 = new PList();
        if (association4 != null) {
            pList2.add(58, association4);
        }
        if (association5 != null) {
            pList2.add(59, (Object)association5);
        }
        if (association6 != null) {
            pList2.add(62, (Object)association6);
        }
        pList2 = this.base.getConnectionList(association, 56, 64, pList2);
        Association association7 = (Association)pList2.getFirst();
        while (pList2.hasCurrent()) {
            if (!association7.hasSign()) {
                pList2.remove();
            }
            association7 = (Association)pList2.getNext();
        }
        if (pList2.isEmpty()) {
            return pList;
        }
        return null;
    }

    PList insertSchema(Association association, PList pList) throws IOException {
        return this.insertSchema(association, pList, null);
    }

    PList insertSchema(Association association, PList pList, PList pList2) throws IOException {
        Association association2 = association.get(56);
        PList pList3 = new PList();
        if (pList2 != null) {
            pList2.init();
        }
        Long1 long1 = PN.initMemory();
        Association association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            block26: {
                block30: {
                    int n;
                    block32: {
                        Association association4;
                        block31: {
                            PList pList4;
                            block27: {
                                int n2;
                                Trace trace;
                                block29: {
                                    block28: {
                                        block25: {
                                            if (pList2 != null) {
                                                pList2.getNext();
                                            }
                                            if (association3 != null) break block25;
                                            if (pList2 != null) {
                                                pList2.remove();
                                            }
                                            pList3.add(pList.getTypes(), null);
                                            break block26;
                                        }
                                        n = pList.getType();
                                        pList4 = new PList();
                                        if (n != 0) break block27;
                                        pList4.add(62, (Object)association2);
                                        pList4.add(59, (Object)association2);
                                        pList4.add(58, (Object)association2);
                                        PList pList5 = this.base.getConnectionList(association3, 56, 64, pList4);
                                        trace = null;
                                        Trace trace2 = null;
                                        n2 = 0;
                                        association4 = (Association)pList5.getFirst();
                                        while (pList5.hasCurrent()) {
                                            if (association4 != null && association4.hasSign()) {
                                                n2 = pList5.getType();
                                                if (n2 == 62) {
                                                    n2 = 58;
                                                } else if (n2 == 58) {
                                                    n2 = 62;
                                                }
                                                trace2 = trace == null ? (trace = new Trace(n2)) : (trace2.next = new Trace(n2));
                                            }
                                            association4 = (Association)pList5.getNext();
                                        }
                                        if (pList2 != null) break block28;
                                        if (trace != null && trace.next != null) {
                                            return null;
                                        }
                                        break block29;
                                    }
                                    if (trace != null && trace.next != null) break block26;
                                    pList2.remove();
                                }
                                if (trace == null) {
                                    n = 59;
                                } else {
                                    n = n2;
                                    if (n == 62) {
                                        n = 58;
                                    } else if (n == 58) {
                                        n = 62;
                                    }
                                }
                                pList3.add(n, (Object)association3);
                                break block30;
                            }
                            if (n == 62) {
                                pList4.add(62, (Object)association2);
                                pList4.add(59, (Object)association2);
                            } else if (n == 59) {
                                pList4.add(62, (Object)association2);
                                pList4.add(58, (Object)association2);
                            } else {
                                pList4.add(58, (Object)association2);
                                pList4.add(59, (Object)association2);
                            }
                            association4 = this.base.getConnection(association3, 56, 64, pList4);
                            if (pList2 != null) break block31;
                            if (association4.hasSign()) {
                                return null;
                            }
                            break block32;
                        }
                        if (association4.hasSign()) break block26;
                        pList2.remove();
                    }
                    pList3.add(n, (Object)association3);
                }
                PN.controlMemory(long1, this.base, pList);
            }
            association3 = (Association)pList.getNext();
        }
        if (pList3.isEmpty()) {
            return null;
        }
        return pList3;
    }

    void instancing(PList pList) {
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            association.setSense(57);
            association = (Association)pList.getNext();
        }
    }

    public boolean isInterrupted() {
        return this.comm.isOff();
    }

    PList orderRels(PList pList) throws IOException {
        Cloneable cloneable;
        int n;
        int n2;
        if (pList.isEmpty()) {
            return pList;
        }
        int[] nArray = new int[4];
        Trace[][] traceArray = new Trace[4][];
        Association[][] associationArray = new Association[4][];
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association != null) {
                if (association.has("$Content", 56)) {
                    nArray[0] = nArray[0] + 1;
                } else {
                    n2 = (int)association.getPower();
                    if (association.getSense1() == 57) {
                        if (n2 > 1) {
                            nArray[3] = nArray[3] + 1;
                        } else {
                            nArray[2] = nArray[2] + 1;
                        }
                    } else if (n2 > 1) {
                        nArray[1] = nArray[1] + 1;
                    } else {
                        nArray[0] = nArray[0] + 1;
                    }
                }
            }
            association = (Association)pList.getNext();
        }
        if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0) {
            return new PList();
        }
        if (nArray[0] > 0) {
            traceArray[0] = new Trace[nArray[0]];
            associationArray[0] = new Association[nArray[0]];
        }
        if (nArray[1] > 0) {
            traceArray[1] = new Trace[nArray[1]];
            associationArray[1] = new Association[nArray[1]];
        }
        if (nArray[2] > 0) {
            traceArray[2] = new Trace[nArray[2]];
            associationArray[2] = new Association[nArray[2]];
        }
        if (nArray[3] > 0) {
            traceArray[3] = new Trace[nArray[3]];
            associationArray[3] = new Association[nArray[3]];
        }
        Association association2 = new Association();
        Concept[] conceptArray = new Concept[]{new Concept(0), new Concept(1), new Concept(2), new Concept(3)};
        nArray = new int[4];
        association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association != null) {
                Trace trace = pList.getTypes();
                n2 = (int)association.getPower();
                if (association.has("$Content", 56)) {
                    n = 0;
                    association2.con(conceptArray[n]).con(59).con(new Concept(0));
                    association2.setConnect(59, new Concept(nArray[n]));
                    association2.regain();
                    traceArray[n][nArray[n]] = trace;
                    associationArray[n][nArray[n]] = association;
                    int n3 = n;
                    nArray[n3] = nArray[n3] + 1;
                } else {
                    if (association.getSense1() == 57) {
                        if (n2 > 1) {
                            n = 3;
                        } else {
                            n = 2;
                            n2 = (int)this.base.getPower(association);
                        }
                    } else if (n2 > 1) {
                        n = 1;
                    } else {
                        n = 0;
                        Concept concept = association.getIfOne(57);
                        this.base.con(concept);
                        n2 = 0;
                        cloneable = trace;
                        while (cloneable != null) {
                            if (((Trace)cloneable).sign == 62) {
                                this.base.con(58);
                            } else if (((Trace)cloneable).sign == 59) {
                                this.base.con(59);
                            } else {
                                this.base.con(62);
                            }
                            n2 += (int)this.base.getPower();
                            this.base.uncon();
                            cloneable = ((Trace)cloneable).next;
                        }
                        this.base.uncon();
                    }
                    association2.con(conceptArray[n]).con(59).con(new Concept(n2));
                    association2.setConnect(59, new Concept(nArray[n]));
                    association2.regain();
                    traceArray[n][nArray[n]] = trace;
                    associationArray[n][nArray[n]] = association;
                    int n4 = n;
                    nArray[n4] = nArray[n4] + 1;
                }
            }
            association = (Association)pList.getNext();
        }
        PList pList2 = new PList();
        n = 0;
        while (n < 4) {
            if (nArray[n] != 0) {
                association2.con(conceptArray[n]).con(59);
                cloneable = association2.getFirst(56);
                while (cloneable != null) {
                    association2.con();
                    Association association3 = association2.getConnect(59);
                    Concept concept = association3.getFirst(56);
                    while (concept != null) {
                        pList2.add(traceArray[n][concept.toNumber()], (Object)associationArray[n][concept.toNumber()]);
                        concept = association3.getNext(56);
                    }
                    association2.uncon();
                    cloneable = association2.getNext(56);
                }
                association2.regain();
            }
            ++n;
        }
        return pList2;
    }

    void pasteClassRelation(Association association) throws IOException {
        Association association2 = null;
        Association association3 = null;
        Association association4 = null;
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(56);
        while (concept != null) {
            association.con();
            if (association.hasConnect(57)) {
                association.con(57);
                this.pasteClassRelation(association);
                association.uncon();
            }
            if (association.hasConnect(58)) {
                association2 = association.getConnect(58);
            }
            if (association.hasConnect(59)) {
                association3 = association.getConnect(59);
            }
            if (association.hasConnect(62)) {
                association4 = association.getConnect(62);
            }
            if (association2 != null || association3 != null || association4 != null) {
                Trace trace = association.getConTrace();
                Concept concept2 = new Concept(trace);
                this.insertRel(concept2, association2, association3, association4);
            }
            association.uncon();
            association2 = null;
            association3 = null;
            association4 = null;
            PN.controlMemory(long1, this.base, association);
            concept = association.getNext(56);
        }
    }

    public void restore() throws IOException {
        this.base.restore();
        this.mul.restore();
        this.spec.restore();
    }

    public void restoreSpecification() {
        this.spec.restore();
    }

    public void save(Statement statement) throws IOException {
        this.savedStm = statement;
        this.base.save();
        this.mul.save();
        this.spec.store();
    }

    Association selectClass(Association association) throws IOException {
        return this.base.get(association);
    }

    Association selectClass(Association association, Association association2) throws IOException {
        Association association3 = null;
        Long1 long1 = PN.initMemory();
        Concept concept = association2.getFirst(56);
        while (concept != null) {
            Association association4 = this.selectClass1(association, concept);
            if (association4.hasSign()) {
                association2.con(concept);
                if (association2.hasConnect(57)) {
                    association2.con(57);
                    association4 = this.selectClass(association4, association2);
                    association2.uncon();
                }
                association2.uncon();
                if (association3 == null) {
                    association3 = association4;
                } else {
                    association3.set(association4);
                }
                association4 = null;
                PN.controlMemory(long1, this.base, association, association2, association3);
            }
            concept = association2.getNext(56);
        }
        if (association3 == null) {
            return new Association();
        }
        return association3;
    }

    Association selectClass1(Association association, Concept concept) throws IOException {
        Association association2 = new Association();
        int n = concept.getNotation();
        if (n == 36 || n == 35 || association != null && association.hasSign(34)) {
            if (association != null) {
                association2.set(association);
            }
            association2.appendClassMean(concept, true, false);
            return this.base.get(association2);
        }
        if (association == null) {
            this.base.con(concept);
            if (this.base.hasConcept(56)) {
                association2.set(concept);
            }
            this.base.uncon();
            return association2;
        }
        this.base.con(concept);
        if (this.base.hasConnect(61)) {
            this.base.con(61);
            association2.set(this.base);
            this.base.uncon();
            association2.appendClassMean(concept, true, false);
        }
        if (this.base.hasConcept()) {
            association2.set(concept);
        }
        this.base.uncon();
        if (association == PN.aNull) {
            return association2;
        }
        return association2.get(association, 57, 121);
    }

    Association selectInstance(Association association, Association association2) throws IOException {
        PList pList = new PList();
        pList.add(57, (Object)association2);
        return this.base.getConnection(association, 57, pList);
    }

    Association selectInterval(Association association, Association association2, Association association3) throws IOException {
        Association association4 = new Association();
        Long1 long1 = PN.initMemory();
        if (association2 != null && association3 != null) {
            association4.set(association2).set(association3);
            Concept concept = association2.getLast(57);
            Concept concept2 = association3.getFirst(57);
            concept = this.base.get(concept);
            concept = this.base.getNext(57);
            while (!concept.equals(concept2)) {
                association4.set(concept);
                PN.controlMemory(long1, this.base, association4, association2, association3);
                concept = this.base.getNext(57);
            }
            return association4;
        }
        if (association2 != null) {
            association4.set(association2);
            if (association == null || association == PN.aNull) {
                Concept concept = association2.getLast(57);
                this.selectInterval0(concept, association4);
                return association4;
            }
            Concept concept = association.getFirst(57);
            while (concept != null) {
                this.base.con(concept);
                if (this.base.hasConnect(57)) {
                    this.base.con(57);
                    association2.con(concept).con(57);
                    Concept concept3 = association2.getLast(57);
                    if (concept3 != null) {
                        association4.con(concept).con(57);
                        this.selectInterval0(concept3, association4);
                    }
                }
                this.base.regain();
                association2.regain();
                association4.regain();
                PN.controlMemory(long1, this.base, association4, association2);
                concept = association.getNext(57);
            }
            return association4;
        }
        association4.set(association3);
        if (association == null || association == PN.aNull) {
            Concept concept = association3.getFirst(57);
            this.selectInterval1(concept, association4);
            return association4;
        }
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept);
            if (this.base.hasConnect(57)) {
                this.base.con(57);
                association3.con(concept).con(57);
                Concept concept4 = association3.getFirst(57);
                association4.con(concept).con(57);
                this.selectInterval1(concept4, association4);
            }
            this.base.regain();
            association3.regain();
            association4.regain();
            PN.controlMemory(long1, this.base, association4, association3);
            concept = association.getNext(57);
        }
        return association4;
    }

    void selectInterval0(Concept concept, Association association) throws IOException {
        concept = this.base.get(concept, 57);
        Long1 long1 = PN.initMemory();
        concept = this.base.getNext(57);
        while (concept != null) {
            association.set(concept);
            PN.controlMemory(long1, this.base, association);
            concept = this.base.getNext(57);
        }
    }

    void selectInterval1(Concept concept, Association association) throws IOException {
        Concept concept2 = this.base.get(concept, 57);
        Long1 long1 = PN.initMemory();
        concept2 = this.base.getFirst(57);
        while (concept2 != null) {
            if (concept2.equals(concept)) {
                return;
            }
            association.set(concept2);
            PN.controlMemory(long1, this.base, association);
            concept2 = this.base.getNext(57);
        }
    }

    Association selectName(Association association, Concept concept, boolean bl) throws IOException {
        Association association2 = new Association();
        if (association == null || association == PN.aNull) {
            this.selectName1(concept, bl, association2);
            return association2;
        }
        Long1 long1 = PN.initMemory();
        Concept concept2 = association.getFirst(57);
        while (concept2 != null) {
            this.base.con(concept2).con(57);
            association2.con(concept2).con(57);
            this.selectName1(concept, bl, association2);
            PN.controlMemory(long1, this.base, association, association2);
            this.base.regain();
            association2.regain();
            concept2 = association.getNext(57);
        }
        return association2;
    }

    Association selectName(Association association, PList pList) throws IOException {
        Expression expression = (Expression)pList.getFirst();
        boolean bl = pList.hasNext();
        return this.selectName(association, expression.cnc, bl);
    }

    boolean selectName1(Concept concept, boolean bl, Association association) throws IOException {
        Concept concept2;
        if (bl) {
            if (concept == null) {
                this.base.see(36);
            } else {
                this.base.see(concept);
            }
            association.set(this.base, 56);
            return this.base.hasSign();
        }
        if (concept == null) {
            this.base.see(36);
            concept2 = this.base.getLast(56);
        } else {
            concept2 = this.base.get(concept);
        }
        if (concept2 != null) {
            association.set(concept2);
        }
        return concept2 != null;
    }

    Association selectObject(Association association, Concept concept) throws IOException {
        Association association2 = new Association();
        association2.set(concept);
        return this.selectClass(association, association2);
    }

    Association selectObject(Association association, PList pList) throws IOException {
        Concept concept = null;
        Association association2 = new Association();
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            if (expression.index == 1) {
                association2.con(concept);
                this.base.con(concept);
                association2.set(this.base, 56);
                association2.uncon();
                this.base.uncon();
                return this.selectClass(association, association2);
            }
            Concept concept2 = expression.cnc;
            if (concept2 == null) {
                association2.con(concept);
                this.base.con(concept);
                this.base.see(36);
                if (pList.hasNext()) {
                    association2.set(this.base, 56);
                } else {
                    concept2 = this.base.getLast(56);
                    if (concept2 == null) {
                        association2.uncon();
                        this.base.uncon();
                        return association2;
                    }
                    association2.set(concept2);
                }
                association2.uncon();
                this.base.uncon();
                return this.selectClass(association, association2);
            }
            concept = concept == null ? concept2 : new Concept(concept, 56, concept2);
            expression = (Expression)pList.getNext();
        }
        association2.set(concept);
        return this.selectClass(association, association2);
    }

    Association selectObjects(Association association) throws IOException {
        PList pList = new PList();
        if (association == null) {
            pList.add(63, null);
            Association association2 = this.base.getBy(56, pList);
            return association2;
        }
        if (association == PN.aNull) {
            return this.base.get(56);
        }
        Association association3 = new Association();
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept);
            association3.con(concept);
            if (!this.base.hasConnect(57)) {
                this.base.uncon();
                association3.setConcept();
            } else {
                this.base.con(57);
                association3.setConnect(57, this.base.get(56));
                this.base.regain();
                association3.uncon();
            }
            concept = association.getNext(57);
        }
        return association3;
    }

    Association selectRel(Association association, Trace trace, Association association2) throws IOException {
        Trace trace2;
        Trace trace3 = trace2 = (Trace)trace.clone();
        while (trace3 != null) {
            if (trace3.sign == 62) {
                trace3.sign = 58;
            } else if (trace3.sign == 58) {
                trace3.sign = 62;
            }
            trace3 = trace3.next;
        }
        PList pList = new PList();
        pList.add(trace2, (Object)association);
        Association association3 = this.base.getConnection(association2, pList);
        return association3;
    }

    /*
     * Unable to fully structure code
     */
    Association selectRelation(Association var1_1, PList var2_2) throws IOException {
        var3_3 = 0L;
        var2_2 = this.orderRels(var2_2);
        var10_4 = PN.initMemory();
        if (var1_1 == null) {
            var8_5 = (Association)var2_2.getFirst();
            var9_6 = var2_2.getTypes();
            var7_7 = this.selectRel(null, var9_6, var8_5);
            if (!var7_7.hasSign() || !var2_2.hasNext()) {
                return var7_7;
            }
            PN.controlMemory(var10_4, var7_7, this.base, var2_2);
        } else {
            var7_7 = var1_1;
            var2_2.init();
        }
        var3_3 = var7_7.getPower();
        if (var7_7.getSense1() == 57) {
            var3_3 = var3_3 < 100L ? this.base.getPower(var7_7, 57) : (var3_3 *= 10L);
        }
        var8_5 = (Association)var2_2.getNext();
        if (var3_3 >= 1000L && var8_5 != null && !var8_5.has("$Content", 56)) ** GOTO lbl38
        var2_2.getBack();
        var7_7 = this.base.getBy(var7_7, var2_2.cloneNext());
        PN.controlMemory(var10_4, var7_7, this.base, var2_2);
        return var7_7;
lbl-1000:
        // 1 sources

        {
            if (var8_5 != null) {
                var9_6 = var2_2.getTypes();
                var5_8 = var8_5.getPower();
                if (var8_5.getSense1() == 57) {
                    var5_8 = var5_8 < 100L ? this.base.getPower(var8_5) : (var5_8 *= 10L);
                }
                if (var5_8 > var3_3) {
                    if (var2_2.hasNext()) {
                        var7_7 = this.base.getBy(var7_7, var2_2.cloneNext());
                    }
                    PN.controlMemory(var10_4, var7_7, this.base, var2_2);
                    return var7_7;
                }
                if (!(var7_7 = this.selectRel(var7_7, var9_6, var8_5)).hasSign()) {
                    return var7_7;
                }
                PN.controlMemory(var10_4, var7_7, this.base, var2_2);
            }
            var8_5 = (Association)var2_2.getNext();
lbl38:
            // 2 sources

            ** while (var2_2.hasCurrent())
        }
lbl39:
        // 1 sources

        return var7_7;
    }

    PList selectSchema(Association association, Association association2) throws IOException {
        PList pList = new PList();
        Association association3 = new Association();
        association3.setCategory(56);
        pList.add(58, (Object)association3);
        pList.add(59, (Object)association3);
        pList.add(62, (Object)association3);
        pList = this.base.getConnectionList(association2, 56, 64, pList);
        association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (!association3.hasSign()) {
                pList.remove();
            }
            association3 = (Association)pList.getNext();
        }
        if (pList.isEmpty()) {
            return null;
        }
        PList pList2 = this.base.getConnectionList(association, 56, 64, pList);
        Association association4 = (Association)pList2.getFirst();
        while (association4 != null) {
            if (!association4.hasSign()) {
                pList2.remove();
            }
            association4 = (Association)pList2.getNext();
        }
        if (pList2.isEmpty()) {
            return null;
        }
        return pList2;
    }

    PList selectSchema(Association association, PList pList) throws IOException {
        return this.selectSchema(association, pList, null);
    }

    PList selectSchema(Association association, PList pList, PList pList2) throws IOException {
        Association association2;
        if (association == null) {
            association2 = new Association();
            association2.setCategory(56);
        } else {
            association2 = association.get(56);
        }
        PList pList3 = new PList();
        if (pList2 != null) {
            pList2.init();
        }
        Long1 long1 = PN.initMemory();
        Association association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            block28: {
                block33: {
                    int n;
                    block35: {
                        block34: {
                            PList pList4;
                            block30: {
                                Trace trace;
                                block32: {
                                    block31: {
                                        block29: {
                                            block27: {
                                                if (pList2 != null) {
                                                    pList2.getNext();
                                                }
                                                if (association3 != null) break block27;
                                                if (pList2 != null) {
                                                    pList2.remove();
                                                }
                                                pList3.add(pList.getTypes(), null);
                                                break block28;
                                            }
                                            if (!association3.has("$Content", 56)) break block29;
                                            if (pList2 != null) {
                                                pList2.remove();
                                            }
                                            if ((n = pList.getType()) == 0) {
                                                trace = new Trace(58);
                                                trace.next = new Trace(59);
                                                trace.next.next = new Trace(62);
                                                pList3.add(trace, (Object)association3);
                                            } else {
                                                pList3.add(n, (Object)association3);
                                            }
                                            break block28;
                                        }
                                        n = pList.getType();
                                        pList4 = new PList();
                                        if (n != 0) break block30;
                                        pList4.add(62, (Object)association2);
                                        pList4.add(59, (Object)association2);
                                        pList4.add(58, (Object)association2);
                                        PList pList5 = this.base.getConnectionList(association3, 56, 64, pList4);
                                        association2 = null;
                                        trace = null;
                                        Trace trace2 = null;
                                        Association association4 = (Association)pList5.getFirst();
                                        while (pList5.hasCurrent()) {
                                            if (association4 != null && association4.hasSign()) {
                                                int n2 = pList5.getType();
                                                if (n2 == 62) {
                                                    n2 = 58;
                                                } else if (n2 == 58) {
                                                    n2 = 62;
                                                }
                                                if (trace == null) {
                                                    association2 = association4;
                                                    trace2 = trace = new Trace(n2);
                                                } else {
                                                    association2.set(association4);
                                                    trace2 = trace2.next = new Trace(n2);
                                                }
                                            }
                                            association4 = (Association)pList5.getNext();
                                        }
                                        if (pList2 != null) break block31;
                                        if (trace == null) {
                                            return null;
                                        }
                                        break block32;
                                    }
                                    if (trace == null) break block28;
                                    pList2.remove();
                                }
                                pList3.add(trace, (Object)association3);
                                break block33;
                            }
                            if (n == 62) {
                                pList4.add(58, (Object)association2);
                            } else if (n == 59) {
                                pList4.add(59, (Object)association2);
                            } else {
                                pList4.add(62, (Object)association2);
                            }
                            association2 = this.base.getConnection(association3, 56, 64, pList4);
                            if (pList2 != null) break block34;
                            if (!association2.hasSign()) {
                                return null;
                            }
                            break block35;
                        }
                        if (!association2.hasSign()) break block28;
                        pList2.remove();
                    }
                    pList3.add(n, (Object)association3);
                }
                PN.controlMemory(long1, this.base, pList);
            }
            association3 = (Association)pList.getNext();
        }
        if (pList3.isEmpty()) {
            return null;
        }
        return pList3;
    }

    public void setCommutator(Commutator commutator) {
        this.comm = commutator;
    }

    public void setControlDataBase(Status status) {
        this.stDataBase = status;
    }

    public void setControlLine(StatusLine statusLine) {
        this.stLine = statusLine;
    }

    public void setControlProcess(Status status) {
        this.stProcess = status;
    }

    public void setControlResult(Status status) {
        this.stResult = status;
    }

    public void setCurrentStm(Statement statement) {
        this.curStm = statement;
    }

    public void setOutLimit() {
        this.outLimit = defaultOutLimit;
    }

    public void setOutLimit(int n) {
        this.outLimit = n;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.sw = null;
        this.pw = printWriter;
    }

    public void setStatusDataBase(String string) {
        if (this.stDataBase == null) {
            return;
        }
        if (string.length() > 40) {
            int n = string.length() - 40 + 3;
            this.stDataBase.set("..." + string.substring(n));
        } else {
            this.stDataBase.set(string);
        }
    }

    public void setStatusLine(String string) {
        if (this.stLine != null) {
            this.stLine.set(string);
        }
    }

    public void setStatusLineCount(int n) {
        if (this.stLine != null) {
            this.stLine.setCount(n);
        }
    }

    public void setStatusLineInterval(int n) {
        if (this.stLine != null) {
            this.stLine.setInterval(n);
        }
    }

    public void setStatusProcess(String string) {
        if (this.stProcess != null) {
            this.stProcess.set(string);
        }
    }

    public void setStatusResult(String string) {
        if (this.stResult != null) {
            this.stResult.set(string);
        }
    }

    public void setStringWriter() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void setStringWriter(StringWriter stringWriter) {
        this.sw = stringWriter;
        this.pw = new PrintWriter(stringWriter);
    }

    public void store(Statement statement) throws IOException {
        this.savedStm = statement;
        this.base.store();
        this.mul.store();
        this.spec.store();
    }
}

