/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.Long1;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Z.ConsoleLine;
import Sav.Z.ConsoleProcess;
import Sav.Z.ConsoleResult;
import Sav.Z.DBConnection;
import Sav.Z.Expression;
import Sav.Z.Fielder;
import Sav.Z.Interface;
import Sav.Z.Procedure;
import Sav.Z.Statement;
import Sav.Z.Warning;
import Sav.Z.ZException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.StringReader;

public class Table
implements Interface {
    static int LINE_NUM = 1000;
    static int B_LENGTH = 131072;
    Procedure proc;
    LineNumberReader r;
    DBConnection dbc;
    File fMedium;
    int pSource;
    int pMedium0;
    int pMedium;
    String sInput;
    Expression expr;
    String line;
    Expression e0;
    PList list0;
    PList list;
    int iLine0;
    int iLine;
    int pos0;
    int pos;
    Statement stm;
    int iCol0;
    int colNum;
    boolean[] bCol;
    int rowNum;
    int iRow;
    Expression[] eLine;
    String process0;
    int warnCount;

    public Table(Procedure procedure) throws IOException {
        int n;
        int n2;
        this.proc = procedure;
        this.dbc = procedure.expr.stm.dbc;
        this.expr = procedure.expr;
        if (procedure.file != null) {
            this.fMedium = procedure.file;
            this.pSource = this.expr.begin;
            this.iLine0 = 1;
            return;
        }
        String string = procedure.expr.stm.text;
        int n3 = string.length();
        int n4 = 0;
        int n5 = procedure.expr.stm.getEnd();
        while (n5 < n3) {
            n4 = string.charAt(n5);
            if (n4 > 32) break;
            ++n5;
        }
        if (n4 == 60) {
            n2 = n5 + 1;
            procedure.expr.stm.end = n5 = Statement.passQuote(string, n5, '>');
            n = n5 < n3 ? n5 - 1 : n5;
        } else {
            n = n2 = n5;
        }
        this.iLine0 = procedure.expr.stm.getLineNumber();
        n5 = procedure.expr.stm.getBegin();
        while (n5 < n2) {
            n4 = string.charAt(n5);
            if (n4 == 10) {
                ++this.iLine0;
            }
            ++n5;
        }
        this.pMedium = this.pMedium0 = n2;
        this.sInput = string.substring(n2, n);
    }

    public boolean analyse() {
        this.warnCount = 0;
        this.pMedium = this.pMedium0;
        this.iLine = 0;
        this.pos = 0;
        Exception exception = null;
        ZException zException = null;
        if (this.fMedium != null && !this.fMedium.exists()) {
            return false;
        }
        try {
            if (this.r == null) {
                if (this.fMedium != null) {
                    this.r = new LineNumberReader(new FileReader(this.fMedium), B_LENGTH);
                    this.r.mark(B_LENGTH);
                } else {
                    this.r = new LineNumberReader(new StringReader(this.sInput));
                }
            } else {
                this.r.reset();
            }
            this.analyse1();
        }
        catch (ZException zException2) {
            zException = zException2;
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
            new Warning(exception2, this.dbc, this.iLine, this.pos + 1, this.fMedium, this.pMedium, this.pSource);
            exception = exception2;
        }
        try {
            if (this.fMedium == null || this.fMedium.length() > (long)B_LENGTH) {
                this.r.close();
                this.r = null;
            }
        }
        catch (IOException iOException) {}
        if (this.dbc.getStatusLineCount() != 0) {
            this.dbc.setStatusLineCount(this.dbc.getStatusLineInterval());
            this.dbc.setStatusLine(String.valueOf(this.iLine));
        }
        this.dbc.clearStatusLine();
        this.dbc.clearStatusProcess();
        if (this.process0 != null) {
            this.dbc.setStatusProcess(this.process0);
        }
        if (exception != null) {
            throw new ZException(exception.toString());
        }
        if (zException != null) {
            throw zException;
        }
        if (!this.proc.expr.stm.executable && this.warnCount == this.dbc.getWarnings().count()) {
            this.dbc.setStatusResult("Table analysis successful!");
            return true;
        }
        return false;
    }

    void analyse1() throws IOException {
        this.iLine = this.iLine0 - 1;
        this.analyseSchema();
        if (this.dbc.hasWarning()) {
            throw new ZException();
        }
        if (this.line == null) {
            return;
        }
        if (!this.proc.expr.stm.executable) {
            this.process0 = this.dbc.getStatusProcess();
            this.dbc.setStatusProcess("Analysing table...");
            this.warnCount = this.dbc.getWarnings().count();
            this.nextLine();
            while (this.line != null) {
                this.dbc.setStatusLine(String.valueOf(this.iLine));
                this.analyseLine();
                this.nextLine();
            }
        }
    }

    void analyseLine() {
        Expression expression;
        int n = 129;
        this.list = new PList();
        this.list0.init();
        int n2 = this.line.length();
        int n3 = 0;
        this.pos = this.pos0;
        while (this.pos < n2) {
            Expression expression2 = (Expression)this.list0.getNext();
            ++n3;
            this.stm = this.dbc.createStatement(this.iLine, this.line, this.pos, this.fMedium, this.pMedium, this.pSource);
            if (!this.list0.hasCurrent()) {
                new Warning("Error", "Indefinite attribute name", this.stm, this.stm.getBegin());
            } else if (expression2 == null) {
                this.list.add(null);
            } else {
                this.stm.analyse(expression2, n);
                expression = this.stm.expression;
                if (expression2 == this.e0) {
                    if (expression.index == -10) {
                        this.list = null;
                        break;
                    }
                    this.list.add(expression);
                } else if (expression.index == -10) {
                    this.list.add(null);
                } else {
                    this.list.add(expression);
                }
            }
            this.pos = this.stm.getEnd();
        }
        if (this.list != null) {
            expression = (Expression)this.list.getFirst();
            while (expression == null) {
                expression = (Expression)this.list.getNext();
            }
            if (expression == null) {
                this.list = null;
            }
        }
    }

    void analyseLine0() {
        Expression expression;
        boolean bl = false;
        boolean bl2 = false;
        int n = 129;
        this.list0 = new PList();
        int n2 = this.line.length();
        int n3 = 0;
        this.pos = this.pos0;
        while (this.pos < n2) {
            this.stm = this.dbc.createStatement(this.iLine, this.line, this.pos, this.fMedium, this.pMedium, this.pSource);
            if (!this.bCol[++n3]) {
                this.list0.add(null);
            } else {
                this.stm.analyse(null, n);
                expression = this.stm.expression;
                if (n3 == this.iCol0) {
                    if (expression.index == -10) {
                        expression.warnErr0("Indefinite key attribute name");
                        this.list0.add(null);
                    } else {
                        this.e0 = expression;
                        this.list0.add(expression);
                    }
                } else if (expression.index == -10) {
                    this.bCol[n3] = false;
                    this.list0.add(null);
                } else {
                    if (expression.index == 15) {
                        expression.list.getFirst();
                        bl = false;
                        bl2 = false;
                        expression.list.getNext();
                        while (true) {
                            char c;
                            if ((c = (char)expression.list.getType()) == '/') {
                                bl = true;
                            } else if (c == '\\') {
                                bl2 = true;
                            }
                            if (!expression.list.hasNext()) break;
                            expression.list.getNext();
                        }
                        expression = (Expression)expression.list.getCurrent();
                    }
                    if (bl && bl2) {
                        this.list0.add(0, (Object)expression);
                    } else if (bl) {
                        this.list0.add(58, (Object)expression);
                    } else if (bl2) {
                        this.list0.add(62, (Object)expression);
                    } else {
                        this.list0.add(59, (Object)expression);
                    }
                }
            }
            this.pos = this.stm.getEnd();
        }
        expression = (Expression)this.list0.getFirst();
        while (expression == null) {
            expression = (Expression)this.list0.getNext();
        }
        if (expression == null) {
            this.list0 = null;
            new Warning("Error", "Missing attribute names", this.dbc, this.iLine, this.pos + 1, this.fMedium, this.pMedium, this.pSource);
        }
    }

    boolean analyseList() throws IOException {
        if (this.list == null) {
            return false;
        }
        int n = 0;
        this.list.init();
        Expression expression = (Expression)this.list0.getFirst();
        while (this.list0.hasCurrent()) {
            Expression expression2 = (Expression)this.list.getNext();
            ++n;
            if (expression != null) {
                int n2 = expression == this.e0 ? 0 : n;
                if (expression2 == null) {
                    if (n2 == 0) {
                        return false;
                    }
                    this.eLine[n2] = null;
                } else {
                    Expression expression3 = this.eLine[n2];
                    if (expression3 == null) {
                        this.eLine[n2] = expression2;
                    } else if (expression3.index > 5) {
                        this.eLine[n2] = expression2;
                    } else if (expression3.index != expression2.index || expression3.end - expression3.begin != expression2.end - expression2.begin) {
                        this.eLine[n2] = expression2;
                    } else if (expression3.cnc == null || expression2.cnc == null || !expression3.cnc.equals(expression2.cnc)) {
                        this.eLine[n2] = expression2;
                    }
                }
            }
            expression = (Expression)this.list0.getNext();
        }
        return true;
    }

    void analyseSchema() throws IOException {
        int n;
        this.nextLine();
        if (this.line == null) {
            this.expr.warnErr0("Empty table file");
            this.expr.index = -10;
            return;
        }
        this.colNum = 1;
        Fielder fielder = new Fielder(this.line.substring(this.pos0));
        while (fielder.hasNext()) {
            fielder.nextPos();
            ++this.colNum;
        }
        this.bCol = new boolean[this.colNum];
        this.eLine = new Expression[this.colNum];
        if (this.proc.eAttr0 != null) {
            this.iCol0 = this.proc.eAttr0.cnc.toNumber();
            if (this.iCol0 >= this.colNum || this.iCol0 == 0) {
                this.proc.eAttr0.warnErr0("Key attribute number is beyond");
                return;
            }
        } else {
            this.iCol0 = 1;
        }
        this.bCol[this.iCol0] = true;
        Expression expression = (Expression)this.proc.attrList.getFirst();
        if (expression == null && this.proc.eAttr0 == null) {
            n = 1;
            while (n < this.colNum) {
                this.bCol[n] = true;
                ++n;
            }
        }
        while (expression != null) {
            n = expression.cnc.toNumber();
            if (n >= this.colNum || n == 0 || n == this.iCol0) {
                expression.warnErr0("Attribute number is beyond");
            } else {
                this.bCol[n] = true;
            }
            expression = (Expression)this.proc.attrList.getNext();
        }
        this.analyseLine0();
    }

    void close() throws IOException {
        if (this.r != null) {
            this.r.close();
            this.r = null;
        }
    }

    public void execute() {
        this.warnCount = 0;
        this.pMedium = this.pMedium0;
        this.iLine = 0;
        this.pos = 0;
        Throwable throwable = null;
        ZException zException = null;
        try {
            this.execute1();
        }
        catch (ZException zException2) {
            zException = zException2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Warning(exception, this.dbc, this.iLine, this.pos + 1, this.fMedium, this.pMedium, this.pSource);
            throwable = exception;
        }
        if (this.dbc.getStatusLineCount() != 0) {
            this.dbc.setStatusLineCount(this.dbc.getStatusLineInterval());
            this.dbc.setStatusLine(String.valueOf(this.iLine));
        }
        this.dbc.clearStatusLine();
        this.dbc.clearStatusProcess();
        if (this.process0 != null) {
            this.dbc.setStatusProcess(this.process0);
        }
        if (throwable != null) {
            throw new ZException(throwable.toString());
        }
        if (zException != null) {
            throw zException;
        }
        if (this.warnCount == this.dbc.getWarnings().count()) {
            this.dbc.setStatusResult("Table reading successful!");
        }
    }

    void execute1() throws IOException {
        if (this.fMedium != null && !this.fMedium.exists()) {
            Expression expression = (Expression)this.expr.list.getFirst();
            expression.warnFail("is not found");
            return;
        }
        if (this.r == null) {
            if (this.fMedium != null) {
                this.r = new LineNumberReader(new FileReader(this.fMedium), B_LENGTH);
                this.r.mark(B_LENGTH);
            } else {
                this.r = new LineNumberReader(new StringReader(this.sInput));
            }
        } else {
            this.r.reset();
        }
        this.iLine = this.iLine0 - 1;
        this.executeSchema();
        if (this.line == null) {
            this.r.close();
            return;
        }
        this.process0 = this.dbc.getStatusProcess();
        this.dbc.setStatusProcess("Reading table...");
        this.warnCount = this.dbc.getWarnings().count();
        this.execute2();
        this.r.close();
        this.r = null;
    }

    void execute2() throws IOException {
        Long1 long1 = PN.initMemory();
        this.nextLine();
        while (this.line != null) {
            this.dbc.setStatusLine(String.valueOf(this.iLine));
            this.analyseLine();
            if (this.dbc.isInterrupted() || this.dbc.hasWarning()) {
                return;
            }
            if (this.analyseList()) {
                Expression expression = this.eLine[0];
                if (expression.ass != null || expression.execute(this.e0.ass)) {
                    this.execute21();
                    this.execute22();
                    this.execute23();
                    PN.controlMemory(long1, this.dbc.base);
                }
            }
            this.nextLine();
        }
        if (this.dbc.getStatusLineCount() != 0) {
            this.dbc.setStatusLineCount(this.dbc.getStatusLineInterval());
            this.dbc.setStatusLine(String.valueOf(this.iLine));
        }
    }

    void execute21() throws IOException {
        int n = 0;
        Expression expression = (Expression)this.list0.getFirst();
        while (this.list0.hasCurrent()) {
            Expression expression2;
            if ((expression2 = this.eLine[++n]) != null && (expression2.ass == null || expression2.index == -3)) {
                expression2.execute(expression.ass);
            }
            expression = (Expression)this.list0.getNext();
        }
    }

    void execute22() throws IOException {
        Concept concept = null;
        Expression expression = this.eLine[0];
        Association association = expression.ass;
        PList pList = new PList();
        pList.add(59, (Object)association);
        concept = expression.cnc != null ? new Concept(this.e0.cnc, 57, expression.cnc) : null;
        int n = 0;
        Expression expression2 = (Expression)this.list0.getFirst();
        while (this.list0.hasCurrent()) {
            Expression expression3;
            if ((expression3 = this.eLine[++n]) != null && expression3.ass != null) {
                int n2 = this.list0.getType();
                int n3 = n2 == 58 ? 62 : (n2 == 62 ? 58 : n2);
                if (expression3.cnc != null) {
                    this.dbc.base.con(expression2.cnc);
                    this.dbc.base.con(57);
                    this.dbc.base.con(expression3.cnc);
                    if (concept != null) {
                        this.dbc.base.setConnect(n3, concept);
                    } else {
                        this.dbc.base.setConnect(n3, association);
                    }
                    this.dbc.base.regain();
                } else {
                    pList.getFirst();
                    pList.setType(n3);
                    this.dbc.base.setConnection(expression3.ass, pList);
                }
            }
            expression2 = (Expression)this.list0.getNext();
        }
        pList = null;
    }

    void execute23() throws IOException {
        int n;
        Expression expression;
        Expression expression2;
        int n2;
        PList pList = null;
        Expression expression3 = this.eLine[0];
        if (expression3.cnc != null) {
            this.dbc.base.con(this.e0.cnc);
            this.dbc.base.con(57);
            this.dbc.base.con(expression3.cnc);
            n2 = 0;
            expression2 = (Expression)this.list0.getFirst();
            while (this.list0.hasCurrent()) {
                if ((expression = this.eLine[++n2]) != null && expression.ass != null) {
                    n = this.list0.getType();
                    if (expression.cnc != null) {
                        Concept concept = new Concept(expression2.cnc, 57, expression.cnc);
                        this.dbc.base.setConnect(n, concept);
                    } else if (pList == null) {
                        pList = new PList();
                    }
                }
                expression2 = (Expression)this.list0.getNext();
            }
            this.dbc.base.regain();
        } else {
            pList = new PList();
        }
        if (pList != null) {
            n2 = 0;
            expression2 = (Expression)this.list0.getFirst();
            while (this.list0.hasCurrent()) {
                if ((expression = this.eLine[++n2]) != null && expression.ass != null && (expression.cnc == null || expression3.cnc == null)) {
                    n = this.list0.getType();
                    pList.add(n, (Object)expression.ass);
                }
                expression2 = (Expression)this.list0.getNext();
            }
            this.dbc.base.setConnection(expression3.ass, pList);
            pList = null;
        }
    }

    void executeSchema() throws IOException {
        this.analyseSchema();
        if (this.dbc.hasWarning()) {
            throw new ZException();
        }
        if (!this.e0.execute(null)) {
            throw new ZException();
        }
        this.e0.deriveClass();
        this.e0.cnc = this.e0.ass.getIfOne();
        if (this.e0.cnc == null) {
            this.e0.warnFail("Ambiguous key attribute name");
            throw new ZException();
        }
        this.e0.ass.setSense(57);
        PList pList = new PList();
        PList pList2 = new PList();
        int n = 0;
        Expression expression = (Expression)this.list0.getFirst();
        while (this.list0.hasCurrent()) {
            ++n;
            if (expression != null && expression != this.e0) {
                if (!expression.execute(null)) {
                    throw new ZException();
                }
                expression.deriveClass();
                if (expression.cnc == null) {
                    expression.cnc = expression.ass.getIfOne();
                    if (expression.cnc == null) {
                        expression.warnFail("Ambiguous attribute name");
                        throw new ZException();
                    }
                }
                expression.ass.setSense(57);
                int n2 = this.list0.getType();
                pList2.add(expression);
                pList.add(n2, (Object)expression.ass);
            }
            expression = (Expression)this.list0.getNext();
        }
        pList = this.dbc.insertSchema(this.e0.ass, pList, pList2);
        if (!pList2.isEmpty()) {
            this.e0.warnFail("", pList2, "Conflicting schema");
            throw new ZException();
        }
        Association association = this.e0.ass.get();
        association.setResolution(-1);
        if (pList != null) {
            pList.init();
            expression = (Expression)this.list0.getFirst();
            while (this.list0.hasCurrent()) {
                if (expression != null && expression != this.e0) {
                    pList.getNext();
                    this.list0.setType(pList.getType());
                    Association association2 = expression.ass.get();
                    association2.setResolution(-1);
                    pList.update(association2);
                }
                expression = (Expression)this.list0.getNext();
            }
            this.dbc.insertContent(association, pList);
        }
    }

    public static void main(String[] stringArray) {
        DBConnection dBConnection = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        PrintStream printStream = System.out;
        int n = stringArray.length;
        int n2 = 0;
        if (n < 2 || stringArray[0].charAt(0) == '-' && n < 3) {
            printStream.println("Error: missing argument");
            bl3 = true;
        } else if (stringArray[n2].charAt(0) == '-') {
            String string = stringArray[n2].substring(1);
            if (string.equals("a") || string.equals("analyse")) {
                bl2 = false;
            } else if (string.equals("r") || string.equals("read")) {
                bl = false;
            } else {
                printStream.println("Error: unrecognized table options");
                bl3 = true;
            }
            ++n2;
        }
        if (bl3) {
            printStream.println("Usage: ");
            printStream.println("java [<options>] Sav.Z.Table [<table_options>] <database> <table_file> [<key_colon_number> [<colon_number> ...]]");
            printStream.println("Where:");
            printStream.println("<table_options> ::= -a[nalyse] | -r[ead]");
            printStream.println();
            printStream.println("Example: ");
            printStream.println("java Sav.Z.Table -r Ex/Basic/Common Ex/Basic/DS.tab");
            printStream.println("or");
            printStream.println("java Sav.Z.Table Ex/Basic/Common.ass Ex/Basic/DS.tab #1 #2 #3 #4 #5 #6");
            System.exit(0);
        }
        try {
            dBConnection = new DBConnection(stringArray[n2++]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(0);
        }
        dBConnection.setControlProcess(new ConsoleProcess());
        dBConnection.setControlLine(new ConsoleLine());
        dBConnection.setControlResult(new ConsoleResult());
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray[n2].charAt(0) != '$') {
            stringBuffer.append("$file ");
            char c = stringArray[n2].charAt(0);
            if (c == '\"' || c == '\'') {
                stringBuffer.append(stringArray[n2]);
            } else {
                stringBuffer.append('\"').append(stringArray[n2]).append('\"');
            }
        } else {
            stringBuffer.append(stringArray[n2]);
        }
        ++n2;
        while (n2 < stringArray.length) {
            stringBuffer.append(",");
            try {
                int n3 = Integer.parseInt(stringArray[n2]);
                if (n3 < 0) {
                    throw new NumberFormatException();
                }
                stringBuffer.append('#').append(n3);
            }
            catch (NumberFormatException numberFormatException) {
                stringBuffer.append(stringArray[n2]);
            }
            ++n2;
        }
        String string = "$rt(" + stringBuffer + ")";
        printStream.print("Statement: ");
        printStream.println(string);
        Statement statement = new Statement(dBConnection, string);
        try {
            if (bl) {
                printStream.println("Analysing statement...");
                statement.analyse();
                if (!dBConnection.hasWarning()) {
                    printStream.println("Statement analysis successful!");
                }
            }
            if (!dBConnection.hasWarning() && bl2) {
                printStream.println("Executing statement...");
                statement.execute();
                printStream.println("Statement execution successful!");
            }
        }
        catch (ZException zException) {}
        PList pList = dBConnection.getWarnings();
        int n4 = 0;
        Warning warning = (Warning)pList.getFirst();
        while (warning != null) {
            if (n4++ == 20) {
                int n5;
                do {
                    printStream.println("More? (y/n)");
                    printStream.close();
                    try {
                        n5 = System.in.read();
                        System.in.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        n5 = 110;
                    }
                } while (n5 != 121 && n5 != 110);
                if (n5 == 110) break;
                n4 = 0;
            }
            printStream.println(warning.toString());
            warning = (Warning)pList.getNext();
        }
        try {
            dBConnection.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    void nextLine() throws IOException {
        if (this.line != null) {
            this.pMedium += this.line.length();
            ++this.pMedium;
            this.pos = 0;
        }
        ++this.iLine;
        this.line = this.r.readLine();
        if (this.line == null) {
            return;
        }
        this.pos = this.pos0 = Statement.passSpace(this.line, 0, this.line.length());
        if (this.pos0 < this.line.length()) {
            return;
        }
        this.nextLine();
    }
}

