/* This code (C) 1998,1999 Sean Dwyer <ewe2@cvis.com.au> under GPL */

#ifndef __mdate_h
#define __mdate_h

#include "config.h"

#include <stdio.h>

#ifdef HAVE_MATH_H
#  include <math.h>
#endif


typedef enum {FALSE, TRUE} BOOL;

/* decided to change to the 285 correlation because astronomical data supports
 * it much better
 */

#define JD_CORRELATION 584285.0L

/* the safer integer mod */
#define AMOD(x,y) (1 + (((x) - 1) % (y)))

#define GREGORIAN_EPOCH 1

/* defines for setting date format */
#define DATE_GREGOK (0x0001)
#define DATE_JDNOK  (0x0002)
#define DATE_LONGOK (0x0004)

/* structures to turn all that pesky data into one variable */

typedef struct longdate
{
	int bak,kat,tun,uin,kin;
} longdate;

typedef struct gregdate
{
	int day, month, year;
} gregdate;

/* nice simple structure for everything */

typedef struct mydate
{
	unsigned int set;
	gregdate gdate;
	longdate ldate;
	double jdn;
} mydate;

#endif /* __mdate_h */

/*
 * $Id: mdate.h,v 1.7 1999/10/20 02:53:28 ewe2 Exp $
 * $Log: mdate.h,v $
 * Revision 1.7  1999/10/20 02:53:28  ewe2
 * More config fixes and slight info changes
 *
 * Revision 1.6  1999/09/21 03:53:25  ewe2
 * Final changes to Mdate for a while.
 *
 * Revision 1.5  1999/05/04 16:38:31  ewe2
 * New Mdate version 1.0.0.beta1
 *
 * Revision 1.4  1999/04/13 01:26:18  ewe2
 * GPL'ed code, ready for distribution
 *
 * Revision 1.3  1999/04/07 12:53:12  ewe2
 * updating to current revision
 *
 * Revision 1.2  1999/04/07 09:33:47  ewe2
 * Adding keywords on some source files
 * 
 * $State: Exp $
 */
