/*
 * Copyright (C) 1998,1999 Sean Dwyer <ewe2@cvis.com.au> All Rights Reserved.
 * This code is distributed under the terms of the GPL
 */

/* i also gratefully acknowledge the implementation of the much-loved ddate(1)
 * program, which gave me a valuable basic structure to work from.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

/* our own special things */
#include "mdate.h"
#include "mtools.h"


#include <stdio.h>

#ifdef STDC_HEADERS
#  include <stdlib.h>
#  include <string.h>
#endif

#include <time.h>

#ifdef HAVE_MATH_H
#  include <math.h>
#endif

void display_usage (void);
void display_version (void);
BOOL set_all_date_values (mydate *thedate);
BOOL parse_args (int argc, char **argv, mydate *thedate);

#ifdef PROG_OUTPUT
#	include "prog-output.h"
#endif

#ifdef CMD_OUTPUT
#	include "cmdln-output.h"
#endif

int main (int argc, char **argv)
{
    mydate thedate;

    if ( parse_args (argc, argv, &thedate) == FALSE )
	return -1;
    set_all_date_values (&thedate);

/* these ifdef's should also include whatever other output formats the user
 * has defined, for instance, at present only tkmdate actually *requires* the
 * parsing format, other interfaces could do ok without it.
 */

#ifdef PROG_OUTPUT
	display_prog_results(&thedate);
#endif
#ifdef CMD_OUTPUT
	display_cmd_results(&thedate);
#endif 
	return 0;
}

void display_usage (void)
{
    printf("Usage: mdate  gives today's Mayan date,\n");
    printf("or mdate -d d m [-]y , where:\n");
    printf("      d = day (1 - 31),\n");
    printf("      m = month (1 - 12),\n");
    printf("      y = year (BC or AD Gregorian),\n");
    printf("or mdate -j [julian day number].\n");
    printf("or mdate -l [long count].\n");
    printf("-h, -? gives this help message.\n");
    printf("-v displays version and exits.\n");
	printf("\nReport bugs to ewe2@cvis.com.au\n\n");
}


void display_version (void)
{
    printf ("Mdate %s (%s-%s-%s)\n", VERSION, T_CPU, T_VENDOR, T_OS);
	printf ("Copyright (C) 1998,1999 Sean Dwyer <ewe2@cvis.com.au>\n");
	exit(0);
}


BOOL set_all_date_values (mydate *thedate)
{
    if ( thedate->set == 0 )
	return FALSE;     /* Need at least one field set to calc others */
    
    if ( thedate->set & DATE_GREGOK )  /* Cool, got a gregorian date */
    {
	thedate->jdn = gregtojdn (thedate->gdate.day, thedate->gdate.month, thedate->gdate.year);
	jdntolong (thedate->jdn, &thedate->ldate);
    }
    else if ( thedate->set & DATE_JDNOK )
    {
	date_from_jul (thedate->jdn, &thedate->gdate);
	jdntolong (thedate->jdn, &thedate->ldate);
    }
    else if ( thedate->set & DATE_LONGOK )
    {
	thedate->jdn = longtojdn (&thedate->ldate);
	date_from_jul (thedate->jdn, &thedate->gdate);
    }
    
    return TRUE;
}


/* add a set for the type of output we want: 
 * arguments after -p are set  cargz->arg = COM_PROG
 * arguments otherwise are set cargz->arg = COM_PRETTY
 */

BOOL parse_args (int argc, char **argv, mydate *thedate)
{
    int curr;
    long t;	
    struct tm *today;

    if ( argc == 1 )   /* No args given, use todays date */
    {
	t = time(NULL);
	today = localtime(&t);
	thedate->gdate.day = today->tm_mday;
	thedate->gdate.month = today->tm_mon+1;
	thedate->gdate.year = today->tm_year + 1900;
	thedate->set = DATE_GREGOK;
	return TRUE;
    }

    /* Well, we have args ... parse them */
    for (curr = 1; curr < argc ; curr++ )
    {
	switch ( argv[curr][0] )
	{
	case ' ':
	case '+':
	    break;
	case '-':
	    switch ( argv[curr][1] )
	    {
	    case 'h':
	    case '?':
		display_usage ();
		return FALSE;
	    case 'j':
		if ( curr == argc - 1 )
		{
		    display_usage ();
		    return FALSE;
		}
		thedate->jdn = strtod (argv[curr+1], NULL);
		thedate->set = DATE_JDNOK;
		return TRUE;
	    case 'l':
		if ( argc < curr + 6 )
		{
		    display_usage ();
		    return FALSE;
		}
		thedate->ldate.bak = atoi(argv[curr + 1]);
		thedate->ldate.kat = atoi(argv[curr + 2]);
		thedate->ldate.tun = atoi(argv[curr + 3]);
		thedate->ldate.uin = atoi(argv[curr + 4]);
		thedate->ldate.kin = atoi(argv[curr + 5]);		
		thedate->set = DATE_LONGOK;
		return TRUE;
	    case 'd':
		if ( argc < curr + 4 )
		{
		    display_usage ();
		    return FALSE;
		}
		thedate->gdate.day = atoi(argv[curr + 1]);
		thedate->gdate.month = atoi(argv[curr + 2]);
		thedate->gdate.year = atoi(argv[curr + 3]);
		if ( !isvalid_gdate (thedate->gdate.day, thedate->gdate.month, thedate->gdate.year) )
		{
		     fprintf (stderr, "Invalid date specified\n");
		     return FALSE;
		}
		thedate->set = DATE_GREGOK;
		return TRUE;
		case 'v':
		display_version();
		return FALSE;
	    default:
		display_usage ();
		return FALSE;
	    }
	}
    }
    display_usage ();
    return FALSE;
}

