/*
 * Copyright (C) 1998,1999 Sean Dwyer <ewe2@cvis.com.au>. All Rights Reserved.
 * This code is distributed under the terms of the GPL.
 */

/* main decls and macros */
#include "mdate.h"
#include "mtools.h"

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>

#ifdef STDC_HEADERS
#  include <stdlib.h>
#  include <string.h>
#endif

#ifdef HAVE_UNISTD_H
#  include <sys/types.h>
#endif

#include <time.h>


#ifdef HAVE_MATH_H
#  include <math.h>
#endif

#ifdef CMD_OUTPUT


void display_cmd_results (mydate *thedate)
{
    const char *haabmonth, *tzolkinmonth;
    int haabday, tzolkinday;

    haabmonth = get_haab_date (thedate->jdn, &haabday);
    tzolkinmonth = get_tzolkin_date (thedate->jdn, &tzolkinday);

    printf ("\n");
    printf ("Gregorian Date    : %d-%s-%d  (%d/%d/%d)\n", thedate->gdate.day, 
	                                      gmonth_str(thedate->gdate.month),
	                                      thedate->gdate.year,
	                                      thedate->gdate.day,
	                                      thedate->gdate.month,
	                                      thedate->gdate.year);
    printf ("Julian Day Number : %.1f\n", thedate->jdn);
    printf ("Long Count        : %.2d.%.2d.%.2d.%.2d.%.2d\n", 
	                            thedate->ldate.bak, thedate->ldate.kat,
	                            thedate->ldate.tun, thedate->ldate.uin,
	                            thedate->ldate.kin); 
    printf ("Tzolkin Date      : %d %s\n", tzolkinday, tzolkinmonth);
	printf ("Haab Date         : %d %s\n", haabday, haabmonth);
    printf ("\n");
}

#endif

/*
 * $Id: cmdln-output.c,v 1.2 1999/09/21 03:53:25 ewe2 Exp $
 * $Log: cmdln-output.c,v $
 * Revision 1.2  1999/09/21 03:53:25  ewe2
 * Final changes to Mdate for a while.
 *
 * Revision 1.1  1999/05/23 05:42:12  ewe2
 * new cmdln modules
 *
 * $State: Exp $
 */

