/* 
 * Simple program-parsing oriented output module:
 * 
 * this is the best output for interpreters to use, eg Tcl/Tk, Perl or Python
 * you could even split output to an xterm
 */

/*
 * Copyright (C) 1998,1999 Sean Dwyer <ewe2@cvis.com.au>. All Rights Reserved.
 * This code is distributed under the terms of the GPL.
 */

/* main decls and macros */
#include "mdate.h"
#include "mtools.h"

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>

#ifdef STDC_HEADERS
#  include <stdlib.h>
#  include <string.h>
#endif

#include <time.h>

#ifdef HAVE_MATH_H
#  include <math.h>
#endif

#ifdef PROG_OUTPUT

void display_prog_results (mydate *thedate)
{
	const char *haabmonth, *tzolkinmonth;
	int haabday, tzolkinday;

	haabmonth = get_haab_date (thedate->jdn, &haabday);
	tzolkinmonth = get_tzolkin_date (thedate->jdn, &tzolkinday);

	printf("JDN: %9.1f ", thedate->jdn);
	printf("date: % .2d % .2d % d ",thedate->gdate.day, thedate->gdate.month, thedate->gdate.year);
	printf("%.2d.%.2d.%.2d.%.2d.%.2d ", 
					thedate->ldate.bak, thedate->ldate.kat,
					thedate->ldate.tun, thedate->ldate.uin,
					thedate->ldate.kin);
	printf(" %.2d %-6.8s ", tzolkinday, tzolkinmonth);
	printf(" %.2d %-6.6s ", haabday, haabmonth);
	printf("\n");
}

#endif

/*
 * $Id: prog-output.c,v 1.3 1999/09/21 03:53:25 ewe2 Exp $
 * $Log: prog-output.c,v $
 * Revision 1.3  1999/09/21 03:53:25  ewe2
 * Final changes to Mdate for a while.
 *
 * Revision 1.2  1999/05/05 06:52:21  ewe2
 * Stupid mistake with copyrights
 *
 * Revision 1.1  1999/05/04 16:43:41  ewe2
 * New Mdate version 1.0.0.beta1
 *
 * $State: Exp $
 */
