// WinMdate version 1.1.1.8

// yay! finally got the tray component updated/installed
// and WinMdate updated for BCB 3.0 standard!

//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "wm.h"
#include "about.h"
#include "mtools.h"
#include "SplashSource.h"
#include <dos.h>
//---------------------------------------------------------------------------
#pragma link "TrayIcon"
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
 // run default as minimised and work out the details later
 WindowState = wsMinimized;
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::FileExit(TObject */* Sender */)
{
	Close();
}
//----------------------------------------------------------------------------
// help stuff - we dont use the contents page, first ID is simpler.
void __fastcall TMainForm::HelpContents(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_CONTENTS, 1);
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::HelpSearch(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_PARTIALKEY, Longint(""));
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::HelpHowToUse(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_HELPONHELP, 0);
}
//----------------------------------------------------------------------------
// main window about
void __fastcall TMainForm::HelpAboutItemClick(TObject */* Sender */)
{
     Form1 = new TForm1(Application);
     Form1->ShowModal();
     delete Form1;
}
//---------------------------------------------------------------------------
// main window quit
void __fastcall TMainForm::Exit1Click(TObject */*Sender*/)
{
	  Close();
}
//---------------------------------------------------------------------------
// heart of the thing - a truncated version of Mdate.c
void __fastcall TMainForm::Timer1Timer(TObject * /*Sender*/)
{
    mydate thedate;
    // called from mtools.dll
    set_date(&thedate);
    display_results(&thedate);
}
//---------------------------------------------------------------------------

// Uses standard doubleclick to restore app
// from system tray - note we are deriving a method
// from the parent class - it may need adding to
// the header!!
void __fastcall TMainForm::IconDblClick(TObject *Sender)
{
    // might want to change this to only restore TMainForm
    // ie make another form the default and keep it invisible
	Application->Restore();
}
//---------------------------------------------------------------------------
// exit from the tray icon
void __fastcall TMainForm::Exit2Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
// get version info from the tray icon popup menu
void __fastcall TMainForm::About1Click(TObject *Sender)
{
     Form1 = new TForm1(Application);
     Form1->ShowModal();
     delete Form1;
}
//---------------------------------------------------------------------------
// tray icon popup help
void __fastcall TMainForm::Help1Click(TObject *Sender)
{
    Application->HelpFile = "winmdate.hlp";
   	Application->HelpCommand(HELP_CONTENTS, 0);
}
//---------------------------------------------------------
// Here we want to use calls to mtools.dll to grab the system date,
// process into a mayan count, and make display it in
// TMainForm::Timer1Timer.

void __fastcall TMainForm::display_results(mydate *thedate)
{
    const char *haabmonth, *tzolkinmonth;
    int haabday, tzolkinday;

    // we get the strings from the DLL without having to muck
    // about with AnsiString objects etc.
    haabmonth = get_haab_date (thedate->jdn, &haabday);
    tzolkinmonth = get_tzolkin_date (thedate->jdn, &tzolkinday);

    char buf[256];
    // the actual work is done here, pretty straightforward
    sprintf(buf," Date                               :  %d-%s-%d (%.2d/%.2d/%.2d)",
        thedate->gdate.day, gmonth_str(thedate->gdate.month),
        thedate->gdate.year,
        thedate->gdate.day,
        thedate->gdate.month,
        thedate->gdate.year);
    Label1->Caption = buf;

    sprintf(buf," Julian Day Number   : % 9.1f", thedate->jdn);
    Label2->Caption = buf;

    sprintf(buf," Long Count                   : % .2d.%.2d.%.2d.%.2d.%.2d",
					thedate->ldate.bak, thedate->ldate.kat,
					thedate->ldate.tun, thedate->ldate.uin,
					thedate->ldate.kin);
    Label3->Caption = buf;
    sprintf(buf," Tzolkin Date                : % .2d %-6.8s", tzolkinday, tzolkinmonth);
    Label4->Caption = buf;
    sprintf(buf," Haab Date                   : % .2d %-6.6s ",  haabday, haabmonth);
    Label5->Caption = buf;
    // This is actually pretty simple, just do another buffer
    // and make that the hint when in the tray.
    sprintf(buf,"%.2d.%2d.%.2d.%2d.%.2d  % .2d %-6.8s % .2d %-6.6s",
               thedate->ldate.bak, thedate->ldate.kat,
               thedate->ldate.tun, thedate->ldate.uin,
               thedate->ldate.kin, tzolkinday, tzolkinmonth, haabday, haabmonth);
    TrayIcon1->Hint = buf;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormShow(TObject *Sender)
{
 if(Splash)
 {// check to see if the pointer is valid
     delete Splash;      // Delete the splash form
     Splash = NULL;      // set the pointer so we don't do it again
 }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormCreate(TObject *Sender)
{
     if (Splash)
        {
        sleep(3);
        }
}
//---------------------------------------------------------------------------

