/****************************************************************************
 *  This file is part of PPMD project                                       *
 *  Contents: inlined Schindler`s range coder routines                      *
 *  Comments: WARNOVERFLOW was removed, see                                 *
 *  http://www.compressconsult.com/rangecoder/ for further information      *
 ****************************************************************************/
/*
  rangecod.c     range encoding

  (c) Michael Schindler
  1997, 1998
  http://www.compressconsult.com/ or http://eiunix.tuwien.ac.at/~michael
  michael@compressconsult.com        michael@eiunix.tuwien.ac.at

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.  It may be that this
  program violates local patents in your country, however it is
  belived (NO WARRANTY!) to be patent-free here in Austria.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA.

  Range encoding is based on an article by G.N.N. Martin, submitted
  March 1979 and presented on the Video & Data Recording Conference,
  Southampton, July 24-27, 1979. If anyone can name the original
  copyright holder of that article or locate G.N.N. Martin please
  contact me; this might allow me to make that article available on
  the net for general public.

  Range coding is closely related to arithmetic coding, except that
  it does renormalisation in larger units than bits and is thus
  faster. An earlier version of this code was distributed as byte
  oriented arithmetic coding, but then I had no knowledge of Martin's
  paper from seventy-nine.

  The input and output is done by the INBYTE and OUTBYTE macros
  defined in the .c file; change them as needed; the first parameter
  passed to them is a pointer to the rangecoder structure; extend that
  structure as needed (and don't forget to initialize the values in
  start_encoding resp. start_decoding). This distribution writes to
  stdout and reads from stdin.

  There are no global or static var's, so if the IO is thread save the
  whole rangecoder is.

  For error recovery the last 3 bytes written contain the total number
  of bytes written since starting the encoder. This can be used to
  locate the beginning of a block if you have only the end.

  There is a supplementary file called renorm95.c available at the
  website (www.compressconsult.com/rangecoder/) that changes the range
  coder to an arithmetic coder for speed comparisons.
*/

#include <stdlib.h>

static struct SUBRANGE {
    DWORD LowCount, HighCount, scale;
} SubRange;

const DWORD CODE_VALUE_BITS=32, TOP_VALUE=1U << 31, BOTTOM_VALUE=TOP_VALUE >> 8;
const int SHIFT_BITS=CODE_VALUE_BITS-9, EXTRA_BITS=(CODE_VALUE_BITS-2)%8+1, CTRL_BYTE=0x79;
static DWORD low, range, AriVar, StreamStart;
static BYTE ByteBuffer;
inline void ariInitEncoder(FILE* stream)
{
    StreamStart=ftell(stream);
    AriVar = low = 0;                       range = TOP_VALUE;
    ByteBuffer=CTRL_BYTE;
}
#define ARI_ENC_NORMALIZE(stream) {                                         \
    while (range <= BOTTOM_VALUE) {                                         \
        if (low < (0xFF << SHIFT_BITS)) {                                   \
            for (putc(ByteBuffer,stream);AriVar != 0;AriVar--)              \
                    putc(0xFF,stream);                                      \
            ByteBuffer = BYTE(low >> SHIFT_BITS);                           \
        } else if ((low & TOP_VALUE) != 0) {                                \
            for (putc(ByteBuffer+1,stream);AriVar != 0;AriVar--)            \
                    putc(0,stream);                                         \
            ByteBuffer = BYTE(low >> SHIFT_BITS);                           \
        } else                              AriVar++;                       \
        range <<= 8;                        low=(low << 8) & (TOP_VALUE-1); \
    }                                                                       \
}
inline void ariEncodeSymbol()
{
    DWORD r = range / SubRange.scale;
    DWORD tmp = r * SubRange.LowCount;
    if (SubRange.HighCount < SubRange.scale)
            range = r * (SubRange.HighCount-SubRange.LowCount);
    else                                    range -= tmp;
    low += tmp;
}
inline void ariShiftEncodeSymbol(int SHIFT)
{
    DWORD r = range >> SHIFT;
    DWORD tmp = r * SubRange.LowCount;
    if (SubRange.HighCount < (1 << SHIFT))
            range = r * (SubRange.HighCount-SubRange.LowCount);
    else                                    range -= tmp;
    low += tmp;
}
#define ARI_FLUSH_ENCODER(stream) {                                         \
    UINT ByteCount=ftell(stream)-StreamStart+5;                             \
    UINT tmp=(low >> SHIFT_BITS)+                                           \
            ((low & (BOTTOM_VALUE-1)) >= (ByteCount >> 1));                 \
    UINT tmp1=(tmp > 0xFF);                                                 \
    for (putc(ByteBuffer+tmp1,stream);AriVar != 0;AriVar--)                 \
            putc(tmp1-1,stream);                                            \
    putc(            tmp,stream);                                           \
    putc(ByteCount >> 16,stream);                                           \
    putc(ByteCount >>  8,stream);                                           \
    putc(ByteCount >>  0,stream);                                           \
}
inline void ariInitDecoder(FILE* stream)
{
    if (getc(stream) != CTRL_BYTE)          exit(-1);
    ByteBuffer=getc(stream);
    low = ByteBuffer >> (8-EXTRA_BITS);
    range = 1 << EXTRA_BITS;
}
#define ARI_DEC_NORMALIZE(stream) {                                         \
    while (range <= BOTTOM_VALUE) {                                         \
        low = (low << 8) | ((ByteBuffer << EXTRA_BITS) & 0xFF);             \
        low |= (ByteBuffer = getc(stream)) >> (8-EXTRA_BITS);               \
        range <<= 8;                                                        \
    }                                                                       \
}
inline int ariGetCurrentCount()
{
    AriVar = range/SubRange.scale;
    DWORD tmp = low/AriVar;
    return (tmp >= SubRange.scale)?(SubRange.scale-1):tmp;
}
inline int ariGetCurrentShiftCount(int SHIFT)
{
    SubRange.scale = 1 << SHIFT;
    AriVar = range >> SHIFT;
    DWORD tmp = low/AriVar;
    return (tmp >= (1 << SHIFT))?((1 << SHIFT)-1):tmp;
}
inline void ariRemoveSubrange()
{
    DWORD tmp = AriVar * SubRange.LowCount;
    low -= tmp;
    if (SubRange.HighCount < SubRange.scale)
            range=AriVar*(SubRange.HighCount-SubRange.LowCount);
    else                                    range -= tmp;
}
