/****************************************************************************
 *  This file is part of PPMD project                                       *
 *  Written and distributed to public domain by Dmitry Shkarin 97, 99       *
 *  Contents: main routine                                                  *
 *  Comments: system & compiler dependent file                              *
 ****************************************************************************/
#pragma option -O1
#include <io.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "model.h"
#include "suballoc.h"
#pragma hdrstop

const DWORD PPMDSignature=0x84ACAF8F, Variant='E';
static const char* const MTxt[] = { "Can`t open file %s\n",
    "read/write error for files %s/%s\n" };
static const char* pFName;
#pragma pack(1)
static struct ARC_INFO { // FileLength & CRC? Hmm, maybe in another times...
    DWORD signature,attrib;
    WORD  info,FNLen,time,date;
} ai;
#pragma pack()
void PrintInfo(FILE* DecodedFile,FILE* EncodedFile,int NCont,int RunTime)
{
    UINT NDec=ftell(DecodedFile);
    UINT NEnc=ftell(EncodedFile)-sizeof(ARC_INFO)-ai.FNLen;
    UINT n1=(8*NEnc)/NDec;
    UINT n2=(800*NEnc-100*NDec*n1+NDec/2)/NDec;
    if (n2 == 100) { n1++;                  n2=0; }
    printf("%13s: %ld/%ld, %1d.%02d bpb, conts: %ld, speed: %d KB/sec \r",
        pFName,NDec,NEnc,n1,n2,NCont,NDec/(RunTime+1));
}
char* ChangeExt(const char* In,char* Out,const char* Ext)
{
    char* RetVal=Out;
    const char* p=strrchr(In,'.');
    if (!p || strrchr(In,'\\') > p)         p=In+strlen(In);
    while (In != p)                         *Out++ = *In++;
    *Out++='.';
    while(*Ext)                             *Out++=*Ext++;
    *Out=0;
    return RetVal;
}

#if defined(__WIN32_ENVIRONMENT)
#include <conio.h>
static BOOL TestAccess(const char* FName)
{
static BOOL YesToAll=FALSE;
    if (access(FName,0) != 0)               return TRUE;
    if ( YesToAll ) {
        SetFileAttributes(FName,FILE_ATTRIBUTE_NORMAL);
        return TRUE;
    }
    printf("%s already exists, overwrite?: <Y>es, <N>o, <A>ll, <Q>uit?",FName);
    for ( ; ; )
        switch ( toupper(getch()) ) {
            case 'A':   YesToAll=TRUE;
            case '\r':  case 'Y':   SetFileAttributes(FName,FILE_ATTRIBUTE_NORMAL);
                        return TRUE;
            case 0x1B:  case 'Q':   printf("User break!");
                        exit(-1);
            case 'N':   return FALSE;
        }
}
inline void EncodeFile(WIN32_FIND_DATA& fdata,int MaxOrder,int SASize)
{
    char WrkStr[256];
    ChangeExt(fdata.cFileName,WrkStr,"PMD");
    if ( !TestAccess(WrkStr) )              return;
    FILE * fpIn = fopen(fdata.cFileName,"rb"), * fpOut = fopen(WrkStr,"wb");
    if (!fpIn || !fpOut) {
        printf(MTxt[0],fdata.cFileName);    exit(-1);
    }
    setvbuf(fpIn,NULL,_IOFBF,64*1024);      setvbuf(fpOut,NULL,_IOFBF,64*1024);
    const char* pFName=strrchr(fdata.cFileName,'\\');
    pFName=( pFName )?(pFName+1):(fdata.cFileName);
    ai.signature=PPMDSignature;             ai.attrib=fdata.dwFileAttributes;
    ai.info=(MaxOrder-1) | ((SASize-1) << 4) | ((Variant-'A') << 12);
    ai.FNLen=strlen(pFName);
    FileTimeToDosDateTime(&fdata.ftLastWriteTime,&ai.date,&ai.time);
    fwrite(&ai,sizeof(ai),1,fpOut);         fwrite(pFName,ai.FNLen,1,fpOut);
    StartSubAllocator(SASize);              EncodeFile(fpOut,fpIn,MaxOrder);
    if (ferror(fpOut) || ferror(fpIn)) {
        printf(MTxt[1],fdata.cFileName,WrkStr);  exit(-1);
    }
    fclose(fpIn);                           fclose(fpOut);
}
inline void DecodeFile(WIN32_FIND_DATA& fdata)
{
    char WrkStr[256];
    int MaxOrder,SASize;
    FILE * fpIn, * fpOut;
    fpIn = fopen(fdata.cFileName,"rb");     setvbuf(fpIn,NULL,_IOFBF,64*1024);
    fread(&ai,sizeof(ai),1,fpIn);           fread(WrkStr,ai.FNLen,1,fpIn);
    WrkStr[ai.FNLen]=0;
    if ( !TestAccess(WrkStr) )              return;
    fpOut = fopen(WrkStr,"wb");             setvbuf(fpOut,NULL,_IOFBF,64*1024);
    MaxOrder=(ai.info & 0x0F)+1;            SASize=((ai.info >> 4) & 0xFF)+1;
    DWORD Variant=(ai.info >> 12)+'A';
    if (!fpIn || !fpOut || ai.signature != PPMDSignature || Variant != ::Variant) {
        printf(MTxt[0],fdata.cFileName);         exit(-1);
    }
    StartSubAllocator(SASize);              DecodeFile(fpOut,fpIn,MaxOrder);
    fflush(fpOut);
    if (ferror(fpOut) || ferror(fpIn)) {
        printf(MTxt[1],fdata.cFileName,WrkStr);  exit(-1);
    }
    fclose(fpIn);                           fclose(fpOut);
    FILETIME ft;
    DosDateTimeToFileTime(ai.date,ai.time,&ft);
    HANDLE hndl=CreateFile(WrkStr,GENERIC_WRITE,0,NULL,OPEN_EXISTING,0,0);
    SetFileTime(hndl,&ft,NULL,&ft);
    CloseHandle(hndl);
    SetFileAttributes(WrkStr,ai.attrib);
}
int main(int argc, char *argv[])
{
    BOOL Encode,DeleteFile=FALSE;
    int i,MaxOrder=4,SASize=10;
    HANDLE hndl;
    printf("Fast PPM compressor for textual data, variant %c, %s\n",Variant,__DATE__);
    if (argc < 2) {
        printf("written and distributed to public domain by Dmitry Shkarin(shkarin@arstel.ru)\n");
        printf("Usage: ppmd <e|d> [switches] <FileName[s] | Wildcard[s]>\n");
        printf("Switches (for encoding only):\n");
        printf("\t-mN - use N MB memory - [1,256], default: %d\n",SASize);
        printf("\t-oN - set model order to N - [1,%d], default: %d\n",MAX_O,MaxOrder);
        printf("\t-d  - delete file[s] after processing, default: %s\n",
                ( DeleteFile )?"enabled":"disabled");
        return -1;
    }
    switch ( toupper(argv[1][0]) ) {
        case 'E':   Encode=TRUE;                                break;
        case 'D':   Encode=FALSE;                               break;
        default :   printf("unknown command: %s\n",argv[1]);    return -1;
    }
    for (i=2;i < argc && (argv[i][0] == '-' || argv[i][0] == '/');i++)
        switch ( toupper(argv[i][1]) ) {
            case 'M':   SASize=CLAMP(atoi(argv[i]+2),1,256);    break;
            case 'O':   MaxOrder=CLAMP(atoi(argv[i]+2),1,MAX_O);break;
            case 'D':   DeleteFile=TRUE;                        break;
            default :   printf("unknown switch: %s\n",argv[i]); return -1;
        }
    for (WIN32_FIND_DATA fdata;i < argc;i++)
        if ((hndl=FindFirstFile(argv[i],&fdata)) != INVALID_HANDLE_VALUE) {
            do {
            	 if ((fdata.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != 0)
                		continue;
                pFName=fdata.cFileName;
                (Encode)?EncodeFile(fdata,MaxOrder,SASize):DecodeFile(fdata);
                putchar('\n');
                if ( DeleteFile )           remove(fdata.cFileName);
            } while ( FindNextFile(hndl,&fdata) );
        }
    return 0;
}

#elif defined(__DOS32_ENVIRONMENT)
#include <conio.h>
#include <dos.h>
static BOOL TestAccess(const char* FName)
{
static BOOL YesToAll=FALSE;
    if (access(FName,0) != 0)               return TRUE;
    if ( YesToAll ) {
        _dos_setfileattr(FName,_A_NORMAL);  return TRUE;
    }
    printf("%s already exists, overwrite?: <Y>es, <N>o, <A>ll, <Q>uit?",FName);
    for ( ; ; )
        switch ( toupper(getch()) ) {
            case 'A':   YesToAll=TRUE;
            case '\r':  case 'Y':   _dos_setfileattr(FName,_A_NORMAL);
                        return TRUE;
            case 0x1B:  case 'Q':   printf("User break!");
                        exit(-1);
            case 'N':   return FALSE;
        }
}
inline void EncodeFile(find_t ffblk,int MaxOrder,int SASize)
{
    char WrkStr[256];
    ChangeExt(ffblk.name,WrkStr,"PMD");
    if ( !TestAccess(WrkStr) )              return;
    FILE * fpIn = fopen(ffblk.name,"rb"), * fpOut = fopen(WrkStr,"wb");
    if (!fpIn || !fpOut) {
        printf(MTxt[0],ffblk.name);         exit(-1);
    }
    setvbuf(fpIn,NULL,_IOFBF,64*1024);      setvbuf(fpOut,NULL,_IOFBF,64*1024);
    const char* pFName=strrchr(ffblk.name,'\\');
    pFName=( pFName )?(pFName+1):(ffblk.name);
    ai.signature=PPMDSignature;             ai.attrib=ffblk.attrib;
    ai.info=(MaxOrder-1) | ((SASize-1) << 4) | ((Variant-'A') << 12);
    ai.FNLen=strlen(pFName);
    ai.time=ffblk.wr_time;                  ai.date=ffblk.wr_date;
    fwrite(&ai,sizeof(ai),1,fpOut);         fwrite(pFName,ai.FNLen,1,fpOut);
    StartSubAllocator(SASize);              EncodeFile(fpOut,fpIn,MaxOrder);
    if (ferror(fpOut) || ferror(fpIn)) {
        printf(MTxt[1],ffblk.name,WrkStr);  exit(-1);
    }
    fclose(fpIn);                           fclose(fpOut);
}
inline void DecodeFile(find_t ffblk)
{
    char WrkStr[256];
    int MaxOrder,SASize;
    FILE * fpIn, * fpOut;
    fpIn = fopen(ffblk.name,"rb");          setvbuf(fpIn,NULL,_IOFBF,64*1024);
    fread(&ai,sizeof(ai),1,fpIn);           fread(WrkStr,ai.FNLen,1,fpIn);
    WrkStr[ai.FNLen]=0;
    if ( !TestAccess(WrkStr) )              return;
    fpOut = fopen(WrkStr,"wb");             setvbuf(fpOut,NULL,_IOFBF,64*1024);
    MaxOrder=(ai.info & 0x0F)+1;            SASize=((ai.info >> 4) & 0xFF)+1;
    DWORD Variant=(ai.info >> 12)+'A';
    if (!fpIn || !fpOut || ai.signature != PPMDSignature || Variant != ::Variant) {
        printf(MTxt[0],ffblk.name);         exit(-1);
    }
    StartSubAllocator(SASize);              DecodeFile(fpOut,fpIn,MaxOrder);
    fflush(fpOut);
    _dos_setftime(fileno(fpOut),ai.date,ai.time);
    if (ferror(fpOut) || ferror(fpIn)) {
        printf(MTxt[1],ffblk.name,WrkStr);  exit(-1);
    }
    fclose(fpIn);                           fclose(fpOut);
    _dos_setfileattr(WrkStr,ai.attrib);
}
int main(int argc, char *argv[])
{
    BOOL Encode,DeleteFile=FALSE;
    int i,MaxOrder=4,SASize=10;
    printf("Fast PPM compressor for textual data, variant %c, %s\n",Variant,__DATE__);
    if (argc < 2) {
        printf("written and distributed to public domain by Dmitry Shkarin(shkarin@arstel.ru)\n");
        printf("Usage: ppmd <e|d> [switches] <FileName[s] | Wildcard[s]>\n");
        printf("Switches (for encoding only):\n");
        printf("\t-mN - use N MB memory - [1,256], default: %d\n",SASize);
        printf("\t-oN - set model order to N - [1,%d], default: %d\n",MAX_O,MaxOrder);
        printf("\t-d  - delete file[s] after processing, default: %s\n",
                ( DeleteFile )?"enabled":"disabled");
        return -1;
    }
    switch ( toupper(argv[1][0]) ) {
        case 'E':   Encode=TRUE;                                break;
        case 'D':   Encode=FALSE;                               break;
        default :   printf("unknown command: %s\n",argv[1]);    return -1;
    }
    for (i=2;i < argc && (argv[i][0] == '-' || argv[i][0] == '/');i++)
        switch ( toupper(argv[i][1]) ) {
            case 'M':   SASize=CLAMP(atoi(argv[i]+2),1,256);    break;
            case 'O':   MaxOrder=CLAMP(atoi(argv[i]+2),1,MAX_O);break;
            case 'D':   DeleteFile=TRUE;                        break;
            default :   printf("unknown switch: %s\n",argv[i]); return -1;
        }
    for (find_t ffblk;i < argc;i++)
        if (_dos_findfirst(argv[i],_A_RDONLY | _A_HIDDEN | _A_SYSTEM | _A_ARCH,&ffblk) == 0) {
            do {
                pFName=ffblk.name;
                (Encode)?EncodeFile(ffblk,MaxOrder,SASize):DecodeFile(ffblk);
                putchar('\n');
                if ( DeleteFile )           remove(ffblk.name);
            } while (_dos_findnext(&ffblk) == 0);
        }
    return 0;
}

#else /* __UNKNOWN_ENVIRONMENT */
#pragma message ("unknown environment:")
#pragma message ("    1. _fastcall and _stdcall keywords are disabled")
#pragma message ("    2. wildcards and file attributes are disabled")
inline void EncodeFile(const char* FName,int MaxOrder,int SASize)
{
    char WrkStr[256];
    ChangeExt(FName,WrkStr,"PMD");
    FILE * fpIn = fopen(FName,"rb"), * fpOut = fopen(WrkStr,"wb");
    if (!fpIn || !fpOut) {
        printf(MTxt[0],FName);              exit(-1);
    }
    setvbuf(fpIn,NULL,_IOFBF,64*1024);      setvbuf(fpOut,NULL,_IOFBF,64*1024);
    ai.signature=PPMDSignature;             ai.attrib=0;
    ai.info=(MaxOrder-1) | ((SASize-1) << 4) | ((Variant-'A') << 12);
    ai.FNLen=strlen(FName);                 ai.time=ai.date=0;
    fwrite(&ai,sizeof(ai),1,fpOut);         fwrite(FName,ai.FNLen,1,fpOut);
    StartSubAllocator(SASize);              EncodeFile(fpOut,fpIn,MaxOrder);
    if (ferror(fpOut) || ferror(fpIn)) {
        printf(MTxt[1],FName,WrkStr);       exit(-1);
    }
    fclose(fpIn);                           fclose(fpOut);
}
inline void DecodeFile(const char* FName)
{
    char WrkStr[256];
    int MaxOrder,SASize;
    FILE * fpIn, * fpOut;
    fpIn = fopen(FName,"rb");               setvbuf(fpIn,NULL,_IOFBF,64*1024);
    fread(&ai,sizeof(ai),1,fpIn);           fread(WrkStr,ai.FNLen,1,fpIn);
    WrkStr[ai.FNLen]=0;
    fpOut = fopen(WrkStr,"wb");             setvbuf(fpOut,NULL,_IOFBF,64*1024);
    MaxOrder=(ai.info & 0x0F)+1;            SASize=((ai.info >> 4) & 0xFF)+1;
    DWORD Variant=(ai.info >> 12)+'A';
    if (!fpIn || !fpOut || ai.signature != PPMDSignature || Variant != ::Variant) {
        printf(MTxt[0],FName);              exit(-1);
    }
    StartSubAllocator(SASize);              DecodeFile(fpOut,fpIn,MaxOrder);
    if (ferror(fpOut) || ferror(fpIn)) {
        printf(MTxt[1],FName,WrkStr);       exit(-1);
    }
    fclose(fpIn);                           fclose(fpOut);
}
int main(int argc, char *argv[])
{
    BOOL Encode,DeleteFile=FALSE;
    int i,MaxOrder=4,SASize=10;
    printf("Fast PPM compressor for textual data, variant %c, %s\n",Variant,__DATE__);
    if (argc < 2) {
        printf("written and distributed to public domain by Dmitry Shkarin(shkarin@arstel.ru)\n");
        printf("Usage: ppmd <e|d> [switches] FileName[s]\n");
        printf("Switches (for encoding only):\n");
        printf("\t-mN - use N MB memory - [1,256], default: %d\n",SASize);
        printf("\t-oN - set model order to N - [1,%d], default: %d\n",MAX_O,MaxOrder);
        printf("\t-d  - delete file[s] after processing, default: %s\n",
                ( DeleteFile )?"enabled":"disabled");
        return -1;
    }
    switch (toupper(argv[1][0])) {
        case 'E':   Encode=TRUE;                                break;
        case 'D':   Encode=FALSE;                               break;
        default :   printf("unknown command: %s\n",argv[1]);    return -1;
    }
    for (i=2;i < argc && (argv[i][0] == '-' || argv[i][0] == '/');i++)
        switch (toupper(argv[i][1])) {
            case 'M':   SASize=CLAMP(atoi(argv[i]+2),1,256);    break;
            case 'O':   MaxOrder=CLAMP(atoi(argv[i]+2),1,MAX_O);break;
            case 'D':   DeleteFile=TRUE;                        break;
            default :   printf("unknown switch: %s\n",argv[i]); return -1;
        }
    for ( ;i < argc;i++) {
        pFName=argv[i];
        (Encode)?EncodeFile(argv[i],MaxOrder,SASize):DecodeFile(argv[i]);
        putchar('\n');
        if ( DeleteFile )                   remove(argv[i]);
    }
    return 0;
}
#endif /* defined(__WIN32_ENVIRONMENT) */
#pragma option -O.
