/****************************************************************************
 *  This file is part of PPMD project                                       *
 *  Written and distributed to public domain by Dmitry Shkarin 97, 99       *
 *  Contents: compilation parameters and miscelaneous definitions           *
 *  Comments: system & compiler dependent file                              *
 ****************************************************************************/
#if !defined(__PPMDTYPE_H)
#define __PPMDTYPE_H

const int MAX_O=16;
#define MAX_FREQ 62 /* MAX_FREQ < 254 */

#define __WIN32_ENVIRONMENT
//#define __DOS32_ENVIRONMENT

#if defined(__WIN32_ENVIRONMENT)
#include <wtypes.h>
#else /* __DOS32_ENVIRONMENT || __UNKNOWN_ENVIRONMENT */
typedef int   BOOL;
#define FALSE 0
#define TRUE  1
typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;
typedef unsigned int   UINT;
typedef signed long    LONG;
#endif /* defined(__WIN32_ENVIRONMENT)  */

#if defined(__WIN32_ENVIRONMENT) || defined(__DOS32_ENVIRONMENT)
#define _FASTCALL __fastcall
#define _STDCALL  __stdcall
#else /* __UNKNOWN_ENVIRONMENT */
#define _FASTCALL
#define _STDCALL
#endif /* defined(__WIN32_ENVIRONMENT) || defined(__DOS32_ENVIRONMENT) */

template <class TMP_TYPE>
inline TMP_TYPE MIN(const TMP_TYPE& x,const TMP_TYPE& y) { return ((x < y)? x : y ); }
template <class TMP_TYPE>
inline TMP_TYPE MAX(const TMP_TYPE& x,const TMP_TYPE& y) { return ((x > y)? x : y ); }
template <class TMP_TYPE>
inline TMP_TYPE* MIN1(TMP_TYPE* x,const TMP_TYPE& y) { if (y < *x) *x=y; return x; }
template <class TMP_TYPE>
inline TMP_TYPE* MAX1(TMP_TYPE* x,const TMP_TYPE& y) { if (y > *x) *x=y; return x; }
template <class TMP_TYPE>
inline TMP_TYPE SQR(const TMP_TYPE& x)          { return (x*x); }
template <class TMP_TYPE>
inline TMP_TYPE CUBE(const TMP_TYPE& x)         { return (x*x*x); }
template <class TMP_TYPE>
inline int IN_LIMITS(const TMP_TYPE& X,const TMP_TYPE& LoX,const TMP_TYPE& HiX) { return (LoX <= X && X <= HiX); }
template <class TMP_TYPE>
inline TMP_TYPE CLAMP(const TMP_TYPE& X,const TMP_TYPE& LoX,const TMP_TYPE& HiX) { return (X >= LoX)?((X <= HiX)?(X):(HiX)):(LoX); }
template <class TMP_TYPE>
inline void SWAP(TMP_TYPE& t1,TMP_TYPE& t2) { TMP_TYPE tmp=t1; t1=t2; t2=tmp; }

#endif /* !defined(__PPMDTYPE_H) */
