#UTILITY FOR UPGRADING FROM WEBDATA VERSION 2.27 OR ABOVE TO VERSION 2.3xx
#TO USE, PLACE THIS upgrade.pl AND webdata.cgi IN THE SAME DIRECTORY AS
#THE LIVE webdata_[dbname].cgi SCRIPT (for example, webdata_cars.cgi)
#THEN OPEN A COMMAND LINE PROMPT IN THAT DIRECTORY AND TYPE:
#    perl upgrade.pl scriptname
#FOR EXAMPLE: perl upgrade.pl webdata_cars.cgi
#

if (length($ARGV[0])==0) {
  print "\n\n********* USAGE *********\n\n";
  print "perl upgrade.pl scriptname\n\n";
  print "EXAMPLE:  perl upgrade.pl webdata_cars.cgi\n\n";
  print qq(DESCRIPTION:\nUTILITY FOR UPGRADING FROM WEBDATA VERSION 2.27 OR ABOVE TO VERSION 2.3xx
TO USE, PLACE THIS upgrade.pl AND webdata.cgi IN THE SAME DIRECTORY AS
THE LIVE webdata_[dbname].cgi SCRIPT (for example, webdata_cars.cgi)
THEN OPEN A COMMAND LINE PROMPT IN THAT DIRECTORY AND TYPE:
    perl upgrade.pl scriptname\n\n\n\n);
  exit;
}

print "\n\n\n\n\nWelcome to the upgrade utility for Webdata version 2.3.\n\n";

#**DETERMINE LOCAL OR REMOTE**
$isRemote=0;
while ($isRemote!~/^[12]$/) {
	print qq(Are you running this upgrade program on your web server, or on your PC?
1. I am running this script on my web server.
2. I have downloaded the script to be upgraded, and I am 
   running this program on my PC or other local machine.\n);
	
	$isRemote=<STDIN>;
	chomp($isRemote);
	if ($isRemote!~/^[12]$/) {print "\nPlease enter 1 or 2\n\n"};
}
print "\n\n";
if ($isRemote==2) {$isRemote=1} else {$isRemote=0};

if ($^O=~/Win/i) {
  $slash="\\";
  $isUnix=0;
} else {
  $slash="/";
  $isUnix=1;
}

if ($isUnix) {
  $path = `pwd`;
} else {
  $path = `chdir`;
} 
chop($path);

open (OLDFILE,"<$ARGV[0]") or die "Could not open $ARGV[0]";
@oldfile=<OLDFILE>;
close OLDFILE;
open (BACKUP,">${ARGV[0]}.bak") or die "Could not write backup file ${ARGV[0]}.bak to current directory";
print BACKUP (@oldfile);
close BACKUP;
open (NEWFILE, "<webdata.cgi") or die "Could not open webdata.cgi";
@newfile=<NEWFILE>;
close NEWFILE;

for ($i=1;$i<18;$i++) {
  $_=$oldfile[$i];
  if (/^ *\# *version ([\d\.]+)/i) {$version=$1};
  if (/^\$password=[\'\"](.+)[\'\"]/) {$password=$1};
  if (/^\$cgilocation=[\'\"](.+)[\'\"]/) {$cgilocation=$1};
  if (/^\$logfile=[\'\"](.+)[\'\"]/) {$logfile=$1};
  if (/^\$code=[\'\"](.+)[\'\"]/) {$code=$1};
  if (/^\$homepage=[\'\"](.+)[\'\"]/) {$homepage=$1};
  if (/^\$searchpage=[\'\"](.+)[\'\"]/) {$searchpage=$1};
}

@keys=grep /^\$key=\d+\;/, @oldfile;
if ($keys[0]=~/(\d+)/) {$key=$1};
$key=$key*307 if $version < 2.33;

if ($version>= 2.3) {
  for ($i=0;$i<18;$i++) {
    $newfile[$i]=$oldfile[$i];
  }
  foreach (@newfile) {
    if (/^\$key=\d+/) {
      $_="\$key=$key\; #<!--FLAG5-->\n";
    }
  }
  $newfile[1]="#version 2.35a\n";
  &replace;
  print "All Done.\n\n\n\n";
  exit;
}

if (($isRemote)&&($logfile=~/([\\\/])/)) {$slash=$1};
@logpath=split(/[\\\/]/,$logfile);
$filename=pop(@logpath);
($dbname,$type)=split('_',$filename);
$logdir=join($slash,@logpath);
$logdir.=$slash if length($logdir)>0;

if ($isRemote) {
	print "An ABSOLUTE SERVER PATH begins with a slash on Unix, or a drive 
letter on Windows.\n\n"
} else {
	print "\nThe ABSOLUTE SERVER PATH to the current directory is $path\n\n"; 
}
print "Please enter the ABSOLUTE SERVER PATH to the directory which contains \n";
print "the html files: ${dbname}_form.html,  ${dbname}_admin.html,  
and ${dbname}_members.html\nPress ENTER to use the current directory.\n";
$homepath=<STDIN>;
chop($homepath);
if (length($homepath)==0) {$homepath=$path};
if ($slash eq "/") {$uploadspath="${homepath}/uploads"} else {$uploadspath="${homepath}\\uploads"};

print "\n\The ABSOLUTE SERVER PATH to the directory you 
entered is $homepath.\n ";
print "What is the URL to that same directory?\n";  
print "(start with http://)\n"; 
$pathurl=<STDIN>;
chop($pathurl);
chop($pathurl) if $pathurl=~/\/$/;
if ((!(-e $uploadspath))&&(!$isRemote)) {
  if (!mkdir($uploadspath,0777)) { 
    print "ERROR! Could not create uploads directory in $path \n";
    print "Check that you have write permission to this directory.\n\n";
    exit;
  }
}
$cmd=`chmod 777 $uploadspath` if (($isUnix)&&(!$isRemote));
$uploadsdir="$uploadspath";
$uploadsdir.="$slash";
$uploadsURL="${pathurl}/uploads/";


$newfile[0]=$oldfile[0];
$newfile[5]="\$uploadsdir=\'$uploadsdir\'\; \#Must end with a $slash\n";
$newfile[5]=~s/\\/\\\\/g;
$newfile[6]="\$uploadsURL=\'$uploadsURL\'\; \#Must end with a /\n";
$newfile[7]="\$password=\"$password\"\;\n";
$newfile[8]="\$cgilocation=\"$cgilocation\"\;\n";
$newfile[9]="\$logdir=\'$logdir\'\; \#Must end sith a $slash\n";
$newfile[9]=~s/\\/\\\\/g;

$newfile[11]="\$logfile=\"\$\{logdir\}${dbname}_data.log\"\;\n";
$newfile[12]="\$fieldnames=\"\$\{logdir\}${dbname}_fields.log\"\;\n";
$newfile[13]="\$members=\"\$\{logdir\}${dbname}_members.log\"\;\n";
$newfile[14]="\$reportdata=\"\$\{logdir\}${dbname}_report.log\"\;\n";
$newfile[15]="\$code=\'$code\'\;\n";

foreach (@newfile) {
  if (/\<\!--FLAG5--\>/) {$_="\$key=$key\; #<!--FLAG5-->\n"};
}

&replace;

sub replace {
open (REPLACE,">$ARGV[0]") or die "Could not replace $ARGV[0]";
print REPLACE (@newfile);
close REPLACE;
$tmp=`chmod 755 $ARGV[0]` if $isUnix;
}

if (!$isRemote) {
	open (REPORT,">>${logdir}${dbname}_report.log") or die "Could not open ${logdir}${dbname}_report.log for appending";
	print REPORT ("\n\n\n\n\n1\n$homepage\n\n1\n1\n\n\n\n\n\nEnglish\n");
	close REPORT;
}
print "\n\nAll done\n\n";

if ($isRemote) {
print "Now, you must create a directory named \"uploads\" in the 
$homepath directory, and if your server is a Unix system, make
sure the privilages are set to 777 so the script can write
to the uploads directory.\n\n\n\n";
};

print "Press [ENTER] to finish\n\n";
$tmp=<STDIN>;

